package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueFieldsService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueGroupService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueService;
import com.geoway.landteam.landcloud.servface.patrolclue.cluelibrary.MJcClueSourceService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.geoway.landteam.landcloud.service.dto.ClueInfoDto;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRelService;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueTaskRelService;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class ClueService {

    private final GiLoger logger = GwLoger.getLoger(ClueService.class);

    @Autowired
    JcClueImportRecordService jcClueImportRecordService;
    @Autowired
    JcClueImportRelService jcClueImportRelService;

    @Autowired
    JcClueTaskRelService jcClueTaskRelService;

    @Autowired
    MTaskRecordService taskRecordService;

    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    LandUserRepository landUserDao;

    @Autowired
    MJcClueService jcClueService;

    @Autowired
    AppMediaRepository appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    MJcClueSourceService jcClueSourceService;
    @Autowired
    MJcClueFieldsService jcClueFieldsService;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    MJcClueGroupService jcClueGroupService;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Value("${system.regionCode:}")
    protected String systemRegionCode;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    AppMediaService appMediaService;

    @Value("${project.uploadDir:}")
    protected String uploadDir;

    @Autowired
    RegionVillageRepository regionVillageRepository;

    @Autowired
    SysConfigService sysConfigService;


    public void importClueToTaskByDatas( Long userId,String sourceId,String recordId,String
            importRel,String taskId,String clueIds)
    {
        JcClueSource jcClueSource = jcClueSourceService.findOne(sourceId);
        if(jcClueSource == null){
            throw new GwValidateException("线索表不存在");
        }
        String tableNameByBizId = tskTaskBizService.getTableNameByBizId(taskId);
        if(StringUtils.isBlank(tableNameByBizId)){
            throw new GwValidateException("任务表不存在");
        }

        List<String> clueIdList = Arrays.asList(clueIds.split(","));
        if(clueIdList.size() > 0){
            // int count =  jcClueTaskRelService.getCuleTaskCountByClue( taskId, sourceId, recordId,clueIds);
            int count =  jcClueTaskRelService.getCuleTaskCountByClues( taskId, sourceId, recordId,clueIdList);
            if(count >= clueIdList.size()){
                throw new GwValidateException("数据已导入，不用重复导入！");
            }
        }
        String tablename = jcClueSource.getfTablename();
        String where = " clue.f_sourceid='"+sourceId+"'";
        if(StringUtils.isNotBlank(recordId)){
            where += " and clue.f_import_recordid = '"+recordId+"'";
        }
        if(clueIdList.size() > 0){
            where += " and clue.f_id in ( ";
            for(String s : clueIdList){
                where += "'" + s +"',";
            }
            where = where.substring(0,where.length()-1) +  ") and  not exists (select null from jc_clue_task_rel " +
                    "r where r.f_clueid= clue.f_id and r.f_type='1'  and r.f_taskid = '"+taskId+"')";
        }
        //插入关联数据
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO jc_clue_task_rel(\"f_id\", \"f_sourceid\", \"f_importid\", \"f_clueid\"," +
                " \"f_taskid\", \"f_tbid\", \"f_createtime\", \"f_desc\", \"f_type\") ");
        stringBuffer.append(" select uuid_generate_v1(),'"+sourceId+"','"+recordId+"',clue.f_id,'"+taskId+"', " +
                "uuid_generate_v1(),now(),null,'1' from " +tablename+" clue  where "+ where);

        dataBizMapper.excuteSql(stringBuffer.toString());
        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("sourceId", sourceId);
        params.put("recordId", recordId);
        params.put("importRel", importRel);
        params.put("taskId", taskId);
        params.put("userId", userId);
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        //线索数据导入到核查任务
        record.setTaskName("线索数据导入到核查任务");
        record.setTasktype(JobConstants.JOB_TYPE_CULETASK_IMPORT);
        record.setStarttime(new Date());
        record.setBizId(sourceId);
        record.setRead(0);
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);
    }


    public JSONObject saveClue(ClueInfoDto clueInfoDto) throws Exception{

        JSONObject object = new JSONObject();
//        String taskId = "85b004e1-2f69-46ab-a108-a47ca715ce9a";

//      获取任务
        TskTaskBiz task = tskTaskBizService.findByTaskId(clueInfoDto.getTaskId());

        String sql = "select f_tablename from tbtsk_objectinfo where f_id  in (select f_tableid  from tbtsk_task_biz where f_id = ? )";
        String fTablename = jdbcTemplate.queryForObject(sql,String.class,clueInfoDto.getTaskId());
        if(ObjectUtils.isNotEmpty(fTablename)){

//           主键(系统) 图斑Id tbId
            String tbId = UUID.randomUUID().toString();
            String shapeSql = " SELECT  ST_Transform(ST_Buffer(ST_Transform(ST_SetSRID(ST_MakePoint(" + clueInfoDto.getGjdwjd() + "," + clueInfoDto.getGjdwwd() + "), 4490), 3857), 50), 4490) as shape";
            Map<String, Object> map = jdbcTemplate.queryForMap(shapeSql);
            String fShape = "";
            if(ObjectUtils.isNotEmpty(map)){
                String temp = String.valueOf(map.get("shape"));
                fShape = temp.replaceFirst("SRID=4490;", "");
            }

            Long fUserid = clueInfoDto.getUserId();

            shapeSql = ""
                    + "select f_xzqdm as xzqdm, f_xzqmc as xzqmc, f_level as level "
                    + "from tb_region "
                    + "where ST_Contains( "
                    + "    shape, "
                    + "    ST_SetSRID(ST_MakePoint("+clueInfoDto.getGjdwjd()+", "+clueInfoDto.getGjdwwd()+"), 4490) "
                    + ") "
                    + "union all "
                    + "select xzqdm, xzqmc, f_level as level "
                    + "from tb_region_town "
                    + "where ST_Contains( "
                    + "    ST_Transform(geom, 4490), "
                    + "    ST_SetSRID(ST_MakePoint("+clueInfoDto.getGjdwjd()+", "+clueInfoDto.getGjdwwd()+"), 4490) "
                    + ") "
                    + "union all "
                    + "select xzqdm, xzqmc, f_level as level "
                    + "from tb_region_village "
                    + "where ST_Contains( "
                    + "    ST_Transform(geom, 4490), "
                    + "    ST_SetSRID(ST_MakePoint("+clueInfoDto.getGjdwjd()+", "+clueInfoDto.getGjdwwd()+"), 4490) "
                    + ")";
            List<Map<String, Object>> mapList = jdbcTemplate.queryForList(shapeSql);

            String fXzqmc = "";
            String fXzqdm = ""; //行政区代码 村
            String fXzqdmcity = ""; //行政区代码 市
            String fXzqdmcounty = "";
            String fXzqdmvillage = "";
            String flocation = "";
            String fXzqdmtown = ""; //行政区代码 乡镇
            String fXzqmctown = "";   //行政区名称 乡镇
            String xjxzqmc = ""; //县级行政区名称
            String xjxzqdm = ""; //县级行政区代码
            if(ObjectUtils.isNotEmpty(mapList)){
                for (Map<String, Object> xzqMap : mapList){
                    if(ObjectUtils.isNotEmpty(xzqMap)){
                        String level =  String.valueOf(xzqMap.get("level"));

                        if(level.equals("1")){ // 省
                            flocation += String.valueOf(xzqMap.get("xzqmc"));
                        } else if(level.equals("2")) { // 市
                            fXzqdmcity = String.valueOf(xzqMap.get("xzqdm"));
                            flocation += String.valueOf(xzqMap.get("xzqmc"));
                        } else if(level.equals("3")) { // 区县
                            fXzqdmcounty = String.valueOf(xzqMap.get("xzqdm"));
                            xjxzqdm =  fXzqdmcounty;
                            xjxzqmc = String.valueOf(xzqMap.get("xzqmc"));
                            flocation += xjxzqmc;
                        } else if(level.equals("4")) {  // 乡镇 街道
                            fXzqdmtown = String.valueOf(xzqMap.get("xzqdm"));
                            fXzqmctown = String.valueOf(xzqMap.get("xzqmc"));
                            flocation += fXzqmctown;
                        } else if(level.equals("5")) {  // 村
                            fXzqmc = String.valueOf(xzqMap.get("xzqmc"));
                            fXzqdm = String.valueOf(xzqMap.get("xzqdm"));
                            fXzqdmvillage = fXzqdm;
                            flocation += fXzqmc;
                        }
                    }
                }
            }


            // 确保tbtsk_fields表查询结果的字段顺序与数据Map中的键顺序一致，或Map包含所有必需字段。
            if (StringUtils.isNotBlank(fTablename)) {
                Map<String, Object> dataRow = new HashMap<>();

                Date date = new Date(); // 当前时间
                long currentTimestampMillis = System.currentTimeMillis(); // 获取当前时间戳
////                f_approvetime	审核时间(系统)
//                dataRow.put("f_approvetime", "");
////                f_clfnjswf	存量非农建设违法用地类型
//                dataRow.put("f_clfnjswf", "");
////                f_committime	提交时间(系统)
//                dataRow.put("f_committime", getCurrentDayTime(date));
////                f_createtime	创建时间(系统)
//                dataRow.put("f_createtime", getCurrentDayTime(date));
////                f_flhwfwgy	非粮化违法违规用地类型
//                dataRow.put("f_flhwfwgy", "");
////                f_fnhwfydl	非农化违法类型
//                dataRow.put("f_fnhwfydl", "");
////                f_gjbh	告警编号
//                dataRow.put("f_gjbh", clueInfoDto.getGjbh());
////                f_gjdwjd	告警点位经度
//                dataRow.put("f_gjdwjd", clueInfoDto.getGjdwjd());
////                f_gjdwwd	告警点位纬度
//                dataRow.put("f_gjdwwd", clueInfoDto.getGjdwwd());
////                f_gjlx	告警类型
//                dataRow.put("f_gjlx", clueInfoDto.getGjlx());
////                f_gjsj	告警时间
//                dataRow.put("f_gjsj", clueInfoDto.getGjsj());
////                f_hflx	合法类型
//                dataRow.put("f_hflx", "");
////                f_hfydpw	合法用地批文
//                dataRow.put("f_hfydpw", "");
////                f_hfydsjyt	合法用地实际用途
//                dataRow.put("f_hfydsjyt", "");
////                f_id	主键
//                dataRow.put("f_id", tbId);
////                f_ismy	是否自己图斑（app端使用）
//                dataRow.put("f_ismy", 0);
////                f_ismycreate	是否自己创建(系统)
//                dataRow.put("f_ismycreate", null);
////                f_jhid	计划id(系统)
//                dataRow.put("f_jhid", null);
////                f_jkdw	监控点位
//                dataRow.put("f_jkdw", clueInfoDto.getJkdw());
////                f_jkmc	监控名称
//                dataRow.put("f_jkmc", clueInfoDto.getJkmc());
////                f_lat	中心点Y坐标(系统)
//                dataRow.put("f_lat", clueInfoDto.getGjdwwd());
////                f_lat_b	百度中心点Y坐标(系统)
//                dataRow.put("f_lat_b", clueInfoDto.getGjdwwd());
////                f_lat_g	谷歌中心点Y坐标(系统)
//                dataRow.put("f_lat_g", clueInfoDto.getGjdwwd());
////                f_lon	中心点X坐标(系统)
//                dataRow.put("f_lon", clueInfoDto.getGjdwjd());
////                f_lon_b	百度中心点X坐标(系统)
//                dataRow.put("f_lon_b", clueInfoDto.getGjdwjd());
////                f_lon_g	谷歌中心点X坐标(系统)
//                dataRow.put("f_lon_g", clueInfoDto.getGjdwjd());
////                f_nyssjswf	农业设施建设违法违规用地类型
//                dataRow.put("f_nyssjswf", null);
////                f_pdlx	判定类型
//                dataRow.put("f_pdlx", null);
////                f_pdyjsm	判定依据说明
//                dataRow.put("f_pdyjsm", null);
////                f_pzsj	批准时间
//                dataRow.put("f_pzsj", null);
////                f_qtlx	其他类型
//                dataRow.put("f_qtlx", null);
////                f_qtydpw	其他用地批文
//                dataRow.put("f_qtydpw", null);
////                f_reject_count	打回次数(系统)
//                dataRow.put("f_reject_count", null);
////                f_reject_status	打回状态(系统)
//                dataRow.put("f_reject_status", null);
////                f_requestid	云查询id(系统)
//                dataRow.put("f_requestid", null);
////                f_review_stage	审核阶段(系统)
//                dataRow.put("f_review_stage", null);
////                f_sdwbhlx	实地未变化类型
//                dataRow.put("f_sdwbhlx", null);
////                f_sfbzxajz	是否保障性安居住房
//                dataRow.put("f_sfbzxajz", null);
////                f_sfdpf	是否大棚房
//                dataRow.put("f_sfdpf", null);
////                f_sfgefqc	是否高尔夫球场
//                dataRow.put("f_sfgefqc", null);
////                f_sfjjxm	是否“基金项目”
//                dataRow.put("f_sfjjxm", null);
////                f_sfwhzj	是否挖湖造景
//                dataRow.put("f_sfwhzj", null);
////                f_sfwjbs	是否违建别墅
//                dataRow.put("f_sfwjbs", null);
////                f_sfxzlzgd	是否新增乱占耕地建房
//                dataRow.put("f_sfxzlzgd", null);
////                f_sfyfyhfz	是否因防疫和防治重大疫情需要建设
//                dataRow.put("f_sfyfyhfz", null);
////                f_sfzdsx	是否重大事项(系统)
//                dataRow.put("f_sfzdsx", null);
////                f_shape	shape(系统)
//                dataRow.put("f_shape", fShape);
////                f_shape1	shape1(系统)
//                dataRow.put("f_shape1", fShape);
////                f_shape_b	百度shape(系统)
//                dataRow.put("f_shape_b", null);
////                f_shape_g	谷歌shape(系统)
//                dataRow.put("f_shape_g", null);
////                f_sjfzlgyw	涉及发展林果业挖塘养鱼等违法用地
//                dataRow.put("f_sjfzlgyw", null);
////                f_status	状态(系统)
//                dataRow.put("f_status", null);
//                // f_submittime	提报时间(系统)
//                dataRow.put("f_submittime", null);
////                f_submit_userid	提交人员(系统)
//                dataRow.put("f_submit_userid", fUserid);
////                f_tbbh	图斑编号
//                dataRow.put("f_tbbh", null);
////                f_tbmc	图斑名称
//                dataRow.put("f_tbmc", null);
////                f_tbmj	图形面积(亩)
//                dataRow.put("f_tbmj", null);
////                f_tbpdfj	图斑判定附件
//                dataRow.put("f_tbpdfj", null);
////                f_typical	典型问题(系统)
//                dataRow.put("f_typical", null);
////                f_updatetime	更新时间(系统)
//                dataRow.put("f_updatetime", null);
////                f_upload_userid	执行人员(系统)
//                dataRow.put("f_upload_userid", null);
////                f_userid	操作人(系统)
//                dataRow.put("f_userid", fUserid);
////                f_wfgdlx	违法供地类型
//                dataRow.put("f_wfgdlx", null);
////                f_wflx	违法类型
//                dataRow.put("f_wflx", null);
////                f_wfpzzylx	违法批准占用类型
//                dataRow.put("f_wfpzzylx", null);
////                f_wfydsjyt	违法用地实际用途
//                dataRow.put("f_wfydsjyt", null);
////                f_wfzdlx	违法占地类型
//                dataRow.put("f_wfzdlx", null);
////                f_wgjylx	未供即用类型
//                dataRow.put("f_wgjylx", null);
////                f_wyjl	外业核实记录
//                dataRow.put("f_wyjl", null);
////                f_xjxzqdm	县级行政区代码
//                dataRow.put("f_xjxzqdm", xjxzqdm);
////                f_xjxzqmc	县级行政区名称
//                dataRow.put("f_xjxzqmc", xjxzqmc);
////                f_xmid	项目id(系统)
//                dataRow.put("f_xmid", null);
////                f_xsrwid	线索任务id(系统)
//                dataRow.put("f_xsrwid", null);
////                f_xzfnjswf	新增非农建设违法用地类型
//                dataRow.put("f_xzfnjswf", null);
////                f_xzqdm	行政区代码
//                dataRow.put("f_xzqdm", fXzqdmtown);
////                f_xzqdmcity	行政区代码市(系统)
//                dataRow.put("f_xzqdmcity", fXzqdmcity);
////                f_xzqdmcounty	行政区代码县(系统)
//                dataRow.put("f_xzqdmcounty", xjxzqdm);
////                f_xzqdmsys	行政区代码村(系统)
//                dataRow.put("f_xzqdmsys", fXzqdm);
////                f_xzqdmtown	行政区代码镇(系统)
//                dataRow.put("f_xzqdmtown", fXzqdmtown);
////                f_xzqmc	行政区名称
//                dataRow.put("f_xzqmc", fXzqmctown);
////                f_xzqmc1	行政区名称(系统)
//                dataRow.put("f_xzqmc1", fXzqmctown);
////                f_xzwfpdyj	新增违法判定依据
//                dataRow.put("f_xzwfpdyj", null);
////                f_yblqthfy	已办理其他合法用地手续类型
//                dataRow.put("f_yblqthfy", null);
////                f_zlwz	 坐落位置
//                dataRow.put("f_zlwz", clueInfoDto.getZlwz());

                // 获取字段列表
                List<String> fields = getFieldsForTable(fTablename);
                for(String field : fields) {
                    field = field.trim();
                    if(field.equalsIgnoreCase("f_committime")){
                        //  f_committime	提交时间(系统)
//                        dataRow.put(field, getCurrentDayTime(date));
//                        当前时间戳
                        dataRow.put(field, currentTimestampMillis);
                    } else if(field.equalsIgnoreCase("f_createtime")) {
                        //                f_createtime	创建时间(系统)
//                        dataRow.put(field, getCurrentDayTime(date));
//                        当前时间戳
                        dataRow.put(field, currentTimestampMillis);
                    } else if(field.equalsIgnoreCase("f_gjbh")) {
                        //                f_gjbh	告警编号 f_dkbh
                        dataRow.put(field, clueInfoDto.getGjbh());
                    } else if(field.equalsIgnoreCase("f_gjdwjd")) {
                        //                	告警点位经度
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                    } else if(field.equalsIgnoreCase("f_gjdwwd")) {
                        //                f_gjdwwd	告警点位纬度
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                    } else if(field.equalsIgnoreCase("f_gjlx")) {
                        //                f_gjlx	告警类型
                        dataRow.put(field, clueInfoDto.getGjlx());
                    } else if(field.equalsIgnoreCase("f_gjsj")) {
                        //                f_gjsj	告警时间
                        dataRow.put(field, clueInfoDto.getGjsj());
                    } else if(field.equalsIgnoreCase("f_jkdw")) {
                        //                f_jkdw	监控点位
                        dataRow.put(field, clueInfoDto.getJkdw());
                    } else if(field.equalsIgnoreCase("f_jkmc")) {
                        //                f_jkmc	监控名称
                        dataRow.put(field, clueInfoDto.getJkmc());
                    } else if(field.equalsIgnoreCase("f_lat")) {
                        //                f_lat	中心点Y坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                    } else if(field.equalsIgnoreCase("f_lat_b")) {
                        //                f_lat_b	百度中心点Y坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                    } else if(field.equalsIgnoreCase("f_lat_g")) {
                        //                f_lat_g	谷歌中心点Y坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwwd());
                    } else if(field.equalsIgnoreCase("f_lon")) {
                        //                f_lon	中心点X坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                    } else if(field.equalsIgnoreCase("f_lon_b")) {
                        //                f_lon_b	百度中心点X坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                    } else if(field.equalsIgnoreCase("f_lon_g")) {
                        //                f_lon_g	谷歌中心点X坐标(系统)
                        dataRow.put(field, clueInfoDto.getGjdwjd());
                    } else if(field.equalsIgnoreCase("f_shape")) {
                        //                f_shape	shape(系统)
                        dataRow.put(field, fShape);
                    } else if(field.equalsIgnoreCase("f_shape1")) {
                        //                f_shape1	shape1(系统)
                        dataRow.put(field, fShape);
                    } else if(field.equalsIgnoreCase("f_submit_userid")) {
                        //                f_submit_userid	提交人员(系统)
                        dataRow.put(field, fUserid);
                    } else if(field.equalsIgnoreCase("f_userid")) {
                        //                f_userid	操作人(系统)
                        dataRow.put(field, fUserid);
                    } else if(field.equalsIgnoreCase("f_xjxzqdm")) {
                        //                f_xjxzqdm	县级行政区代码
                        dataRow.put(field, xjxzqdm);
                    } else if(field.equalsIgnoreCase("f_xjxzqmc")) {
                        //                f_xjxzqmc	县级行政区名称
                        dataRow.put(field, xjxzqmc);
                    } else if(field.equalsIgnoreCase("f_xzqdm")) {
                        //                f_xzqdm	行政区代码
                        dataRow.put(field, fXzqdmtown);
                    } else if(field.equalsIgnoreCase("f_xzqdmcity")) {
                        //                f_xzqdmcity	行政区代码市(系统)
                        dataRow.put(field, fXzqdmcity);
                    } else if(field.equalsIgnoreCase("f_xzqdmcounty")) {
                        //                f_xzqdmcounty	行政区代码县(系统)
                        dataRow.put(field, xjxzqdm);
                    } else if(field.equalsIgnoreCase("f_xzqdmsys")) {
                        //                f_xzqdmsys	行政区代码村(系统)
                        dataRow.put(field, fXzqdm);
                    } else if(field.equalsIgnoreCase("f_xzqdmtown")) {
                        //                f_xzqdmtown	行政区代码镇(系统)
                        dataRow.put(field, fXzqdmtown);
                    } else if(field.equalsIgnoreCase("f_xzqmc")) {
                        //                f_xzqmc	行政区名称
                        dataRow.put(field, fXzqmctown);
                    } else if(field.equalsIgnoreCase("f_xzqmc1")) {
                        //                f_xzqmc1	行政区名称(系统)
                        dataRow.put(field, fXzqmctown);
                    } else if(field.equalsIgnoreCase("f_zlwz")) {
                        //                f_zlwz	 坐落位置
                        dataRow.put(field, clueInfoDto.getZlwz());
                    } else if(field.equalsIgnoreCase("f_id")) {
                        //                f_id	主键
                        dataRow.put(field, tbId);
                    } else if(field.equalsIgnoreCase("f_jzrq")) {
                        //               f_jzrq	截至日期
                        dataRow.put(field, clueInfoDto.getJzrq());
                    } else if(field.equalsIgnoreCase("f_status")) {
                        //               f_status	状态(系统)
                        dataRow.put(field, 1);
                    } else {
                        dataRow.put(field, null);
                    }
                }

//                      保存数据
                insertData(fTablename, dataRow, fields);

                List<MultipartFile> files = clueInfoDto.getFiles();
//                        MultipartFile file = clueInfoDto.getFiles();
//                        LandUser one = landUserDao.findById(fUserid).orElse(null);

//               获取上传附件typeType分组类型
                Integer typeType = this.getGroupTypeType(clueInfoDto.getTaskId());

                if(ObjectUtils.isNotEmpty(files)){
                    for(MultipartFile file : files){
                        // ttgjxscz = 铁塔告警线索处置
                        String ossPath = "clueInfo/ttgjxscz/" + System.currentTimeMillis() + "/" + file.getOriginalFilename();
                        String url = ossOperatorService.sendObject2Oss(ossPath, file.getInputStream());
                        AppMedia appMedia = new AppMedia();
                        appMedia.setServerpath(url);
                        appMedia.setId(UUID.randomUUID().toString());
                        appMedia.setType(getMediaType(file.getOriginalFilename()));
                        DecimalFormat df = new DecimalFormat("0.00");
                        String ret = df.format(file.getSize()/(1024*1.0));
                        appMedia.setMediasize(Double.valueOf(ret));
                        appMedia.setMark(0);
                        appMedia.setGalleryid(tbId);
                        appMedia.setBizId(clueInfoDto.getTaskId());
                        appMedia.setDeviceSource(2);
                        appMedia.setUsername("告警线索数据导入");
//                          appMedia.setUsername(one.getName());
//                          appMedia.setUsername(fUserid);
                        //2判断材料
//                        appMedia.setTypetype(105);
//                        appMedia.setTypetype(1);
                        appMedia.setTypetype(typeType);
                        appMedia.setTime(String.valueOf(System.currentTimeMillis()));

//                           保存附件到tb_app_media表中
                        appMediaService.saveOne(appMedia);
                    }
                }

                // 创建下发任务功能
                String recordId = UUID.randomUUID().toString();
                //推送图斑信息到app
                JSONObject additionJson = new JSONObject();
                additionJson.put("count", 1);
                additionJson.put("addOrUpdate", "ADD");
                additionJson.put("taskMode", task.getMode());
                additionJson.put("curMode", "receive");

                TaskDataDbParameter parameter = new TaskDataDbParameter();
                parameter.setRecordId(recordId);
                parameter.setTaskId(clueInfoDto.getTaskId());
                parameter.setGroups(new JSONArray());
                parameter.setOrgs(new JSONArray());
                parameter.setAddition(additionJson);
                parameter.setDate(String.valueOf(System.currentTimeMillis()));
                parameter.setMode(task.getMode().toString());

                TaskRecord record = new TaskRecord();
                record.setId(recordId);
                record.setParam(JSONObject.toJSONString(parameter));
                record.setTasktype(JobConstants.JOB_TYPE_DATA_PACKAGE);
                record.setStarttime(new Date());
                record.setState(1);
                Long userId = 520031475L;
                record.setUserid(userId);
                taskRecordService.save(record);

                //保存进入临时记录
                TaskRecordTemp temp = new TaskRecordTemp();
                temp.setId(UUID.randomUUID().toString());
                temp.setRecordid(recordId);
                temp.setDataid(tbId);
                taskRecordService.saveTaskRecordTemp(Arrays.asList(temp));

                object.put("info",clueInfoDto.getJkmc()+"数据入库");
                object.put("status","数据入库成功！");
            }
        } else {
            object.put("info","告警线索业务表不存在,请联系业务人员创建告警线索业务表");
            object.put("status","数据入库失败！");
        }

        return object;
    }

    //    执行保存操作数据
    public void insertData(String tableName, Map<String, Object> data, List<String> fields) {
        // 获取字段列表
//        List<String> fields = getFieldsForTable(tableName);

        // 构建SQL
        String sql = buildInsertSql(tableName, fields);

        // 准备参数数组
        Object[] params = fields.stream()
                .map(field -> data.get(field))
                .toArray();
        // 执行插入
        jdbcTemplate.update(sql, params);
    }

    // 辅助方法：获取字段列表
    private List<String> getFieldsForTable(String tableName) {
        return jdbcTemplate.queryForList(
                "SELECT f_fieldname FROM tbtsk_fields WHERE f_tablename = ? order by f_fieldname ",
                String.class,
                tableName
        );
    }

    // 辅助方法：构建INSERT SQL
    private String buildInsertSql(String tableName, List<String> fields) {
//        String columns = String.join(", ", fields);
//        String placeholders = String.join(", ", Collections.nCopies(fields.size(), "?"));
//        return String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, columns, placeholders);
        StringBuilder columns = new StringBuilder();
        StringBuilder placeholders = new StringBuilder();

        for (String field : fields) {
            if (columns.length() > 0) {
                columns.append(", ");
                placeholders.append(", ");
            }
            columns.append(field);

            // 对几何字段特殊处理
            if ("f_shape".equalsIgnoreCase(field)) {
                placeholders.append("ST_GeomFromText(?, 4490)");
            } else {
                placeholders.append("?");
            }
        }

        return String.format("INSERT INTO %s (%s) VALUES (%s)",
                tableName, columns.toString(), placeholders.toString());
    }


    public Integer getMediaType(String fileName){
        Integer result = null;
        //1-jpg/png 2-mp4 3-mp3 4-osgb 5-pdf 6-txt 7-word 8-excel 9-ppt
        if(fileName.endsWith(".jpg") || fileName.endsWith(".png")|| fileName.endsWith(".jpeg")){
            result = 1;
        }else if(fileName.endsWith(".mp4")){
            result = 2;
        }else if(fileName.endsWith(".mp3")){
            result = 3;
        }else if(fileName.endsWith(".osgb")){
            result = 4;
        }else if(fileName.endsWith(".pdf")){
            result = 5;
        }else if(fileName.endsWith(".txt")){
            result = 6;
        }else if(fileName.endsWith(".docx") || fileName.endsWith(".doc") ){
            result = 7;
        }else if(fileName.endsWith(".xls") || fileName.endsWith(".xlsx")){
            result = 8;
        }else if(fileName.endsWith(".ppt")){
            result = 9;
        }
        return result;
    }


    // 获取当前时间
    private String getCurrentDayTime(Date date){
        String formattedDate = "";
        if(ObjectUtils.isNotEmpty(date)){
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formattedDate = formatter.format(date);
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formattedDate = formatter.format(new Date());
        }
        return formattedDate;
    }

//  获取上传附件分组类型typeType值
    private Integer getGroupTypeType(String taskId){
        Integer typeType = 1; //默认值为1
        SysConfig sysConfig =  sysConfigService.findOne("GroupTypeType");
        try {
            if(ObjectUtils.isNotEmpty(sysConfig) && StringUtils.isNotBlank(sysConfig.getValue())){
                JSONArray jsonArray = JSONArray.parseArray(sysConfig.getValue());
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    if (ObjectUtils.isNotEmpty(jsonObject)) {
                        String taskIdVal = jsonObject.getString("taskId");
                        String typeTypeVal = jsonObject.getString("typeType");
                        if(StringUtils.isNotBlank(taskIdVal) && taskIdVal.equalsIgnoreCase(taskId)){
                            typeType = Integer.valueOf(typeTypeVal);
                            break;
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("获取附件分组类型typeType值失败：{}",  e.getMessage());
            System.err.println("Error 附件分组类型typeType值出错 : " + e.getMessage());
        }
        return  typeType;
    }
}
