package com.geoway.landteam.landcloud.service.pub;

import com.aliyuncs.exceptions.ClientException;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.Doc;
import com.geoway.landteam.landcloud.repository.pub.DocRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Service
@Transactional(rollbackFor = Exception.class)
public class DocService {

	@Autowired
	DefaultOssOperatorService stsService;

	@Autowired
	DocRepository docRepository;
	
	public Page<Doc> queryByFilter(String filterParam, String sortParam, int start, int limit) {
		Page<Doc> results = docRepository.findAll(new QuerySpecification<Doc>(filterParam),
				PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

		return results;
	}

	public Doc findOne(String id) {
		return docRepository.gwSearchByPK(id);
	}

	public void deleteOne(String id){
		docRepository.gwDeleteByPK(id);
	}
	
	public void save2db(Doc doc, String fileName, byte[] docFile) throws ClientException {

		if (docRepository.gwExistsWithPK(doc.getId())) {
			Doc oldDoc = docRepository.gwSearchByPK(doc.getId());
			//doc.setCreateTime(oldDoc.getCreateTime());
			doc.setEditTime(new Date());
			doc.setPath(oldDoc.getPath());
			doc.setFlength(docFile.length);
		} else {
			if (docFile != null) {
				InputStream input = new ByteArrayInputStream(docFile);
				try {
					// String apkFilePath = saveApk2TempFile(input);
					// String version = acquireAPKVersion(apkFilePath);
					String path = uploadFile2Oss(fileName, input);
					doc.setPath(path);
					doc.setFlength(docFile.length);
					input.close();
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
			}

			Date now = new Date();
			doc.setEditTime(now);
		}

		docRepository.gwAccess(doc);
	}
	
	private String uploadFile2Oss(String fileName, InputStream input) throws ClientException {

		String key = "pdf/" + fileName;
		// 先移动
		String domain = stsService.getDomain();
		List<Doc> docs = docRepository.queryByPath(domain + key);
		SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
		String lastKey = key.substring(key.lastIndexOf("/") + 1);
		String guid = UUID.randomUUID().toString().substring(0, 8);
		String hisKey = String.format("doc/%s/%s/%s", df.format(new Date()), guid, lastKey);
		stsService.renameObjectInOss(key, hisKey);

		for (Doc doc : docs) {
			String sdfStr = df.format(new Date());
			String path = domain + "/" + hisKey;
			doc.setPath(path);
			docRepository.gwAccess(doc);
		}
		String path = stsService.sendObject2Oss(key, input);

		return path;
	}
}
