package com.geoway.landteam.landcloud.service.pub;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.BizCustomConfigRepository;
import com.geoway.landteam.customtask.repository.task.BizCustomFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import jxl.Cell;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service
public class ExcelService {

    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    BizCustomConfigRepository bizCustomConfigRepository;
    @Autowired
    BizCustomFieldsRepository bizCustomFieldsRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    MTskTaskBizService tskTaskBizService;

    @Autowired
    MTbtskFieldsService fieldsService;

    public void customExcel(List<BizCustomConfig> list, String bizId, String xzqdm , HttpServletResponse response, String customFilter, String tempId) throws UnsupportedEncodingException {
            //获取自定义导出excel配置
            BizCustomConfig config = list.get(0);
            String viewName = config.getViewName();
            String url = config.getUrl();
            //防止中文转码
            url = URLDecoder.decode(url,"UTF-8");
            String sql = config.getSQL();
            Integer enableSql = config.getEnableSQL();
                TskTaskBiz one = tskTaskBizRepository.findById(bizId).orElse(null);
                if(one==null){
                    throw new RuntimeException("参数错误");
                }
                TbtskObjectinfo tbtskObjectinfo = objectinfoRepository.findById(one.getTableId()).orElse(null);
                String exportSql = "";
            //不启用自定义sql
            if (!Integer.valueOf(1).equals(enableSql)) {
                exportSql = "select * from " + viewName;
            } else {
                exportSql = sql +" ";
                if(StringUtils.isNotBlank(xzqdm)) {
                    if (xzqdm.endsWith("0000")) {
                        xzqdm = xzqdm.substring(0, 2) + "%";
                    } else if (xzqdm.endsWith("00")) {
                        xzqdm = xzqdm.substring(0, 4) + "%";
                    } else {
                        if (xzqdm.equals("1")) {
                            xzqdm = "";
                        } else {
                            xzqdm = xzqdm + "%";
                        }
                    }
                }
                if(StringUtils.isNotBlank(xzqdm)){
                    exportSql += " and f_xzqdmsys like '"+xzqdm+"' ";
                }
            }
            exportSql += parseFilterParam(customFilter,tbtskObjectinfo.getfTablename(),"tb");
            //查询视图结果
            List<Map<String, Object>> result = jdbcTemplate.queryForList(exportSql);
            //查询导出顺序
            List<BizCustomFields> fields = bizCustomFieldsRepository.getFieldsByBizId(bizId,tempId);

            //获取excel模板
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", url, null);
            // 统一资源
            HttpURLConnection httpURLConnection = null;
            Workbook book = null;
            WritableWorkbook workbook = null;
            try {
                URL url1 = new URL(uploadurl);
                // 连接类的父类，抽象类
                URLConnection urlConnection = url1.openConnection();
                // http的连接类
                httpURLConnection = (HttpURLConnection) urlConnection;
                //设置超时
                httpURLConnection.setConnectTimeout(1000 * 60 * 10);
                //设置请求方式，默认是GET
                httpURLConnection.setRequestMethod("GET");
                // 设置字符编码
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
                httpURLConnection.connect();
                book = Workbook.getWorkbook(httpURLConnection.getInputStream());
                workbook = Workbook.createWorkbook(response.getOutputStream(), book);
                WritableSheet sheet = workbook.getSheet(0);
                int lastRow = sheet.getRows();
                int nullRow = 0;
                //空行数量
                for (int i = 0; i < lastRow; i++) {
                    Cell[] row = sheet.getRow(i);
                    if (row.length == 0) {
                        nullRow = nullRow + 1;
                    }
                }
                //去除空行数量
                lastRow = lastRow - nullRow;
                for (Map<String, Object> map : result) {
                    int lastCol = 0;
                    for (BizCustomFields field : fields) {
                        if (map.containsKey(field.getName())) {
                            sheet.addCell(new Label(lastCol, lastRow, map.get(field.getName()).toString()));
                            lastCol++;
                        } else {
                            throw new RuntimeException("导出失败，配置有误");
                        }
                    }
                    lastRow++;
                }
                workbook.write();
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (ProtocolException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (RowsExceededException e) {
                e.printStackTrace();
            } catch (WriteException e) {
                e.printStackTrace();
            } catch (BiffException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (workbook != null) {
                        workbook.close();
                    }
                    if (book != null) {
                        book.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                } catch (WriteException e) {
                    e.printStackTrace();
                }
            }

    }

    public String parseFilterParam(String filterParam, String tableName, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(filterParam)) {
            JSONArray filterArray = JSONArray.parseArray(filterParam);
            //101代表筛选配置
            List<TbtskFields> allFields = fieldsService.getAllFieldsByTables(tableName);
            for (int i = 0; i < filterArray.size(); i++) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if (!"".equals(val)) {
                    Optional<TbtskFields> optional = allFields.stream().filter(r -> r.getfId().equals(field)).findFirst();
                    if (optional.isPresent()) {
                        TbtskFields one = optional.get();
                        switch (one.getfFieldtype()) {
//                            文本型的
                            case "1":
                            case "2": {
                                switch (ref) {
                                    case "LK": {
                                        /*  filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";*/
                                        String[] tem = val.split(",");
                                        if (tem.length > 1) {
                                            filterStr += "( ";
                                            for (String s : tem) {
                                                filterStr += tableAlias + "." + one.getfFieldname() + " LIKE '%" +
                                                        s + "%'  or ";
                                            }
                                            filterStr = filterStr.substring(0, filterStr.length() - 3) + ") ";
                                        } else {
                                            filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";
                                        }
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "IN": {

                                        List<String> inValues = new ArrayList<>();
                                        for (String s : val.split(",")) {
                                            inValues.add("'" + s + "'");
                                        }
                                        filterStr = tableAlias + "." + one.getfFieldname() + " IN (" + StringUtils.join(inValues, ",") + ") ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case "3":
                            case "4":
                            case "5": {
                                switch (ref) {
                                    case "GT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " > " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "LT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " < " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            default:
                                break;
                        }
                    }
                    if (!StringUtils.isEmpty(filterStr)) {
                        where += " AND " + filterStr;
                    }
                }
            }
        }
        return where;
    }

}
