package com.geoway.landteam.landcloud.service.pub;//package com.geoway.land.core.service;

import com.alibaba.fastjson.JSONObject;

import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.DeviceTrack;
import com.geoway.landteam.landcloud.core.model.pub.entity.DeviceTrackUpload;
import com.geoway.landteam.landcloud.core.repository.pub.DeviceTrackRepository;
import com.geoway.landteam.landcloud.core.repository.pub.DeviceTrackUploadRepository;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.*;


@Service
@Transactional(rollbackFor = Exception.class)
public class MDeviceTrackService {

	@Value("${project.uploadDir}")
	protected String uploadDir;
	@Autowired
	DeviceTrackRepository deviceTrackDao;
    @Autowired
	TaskRecordService taskRecordService;
	@Autowired
	DeviceTrackUploadRepository deviceTrackUploadRepository;

	public List<DeviceTrack> queryByTime(String deviceId, Long startMillion, Long endMillion){

		String sortParam = "SORT_updateTime_ASC";
		String filterParam = "Q_deviceId_S_EQ=" + deviceId;
		if(startMillion != null){
			filterParam += "Q_updateTime_D_GT=" + startMillion;
		}

		if(endMillion != null){
			filterParam += ";Q_updateTime_D_LT=" + endMillion;
		}

		List<DeviceTrack> results = deviceTrackDao.findAll(
				new QuerySpecification<DeviceTrack>(filterParam),
				QueryParamUtil.parseSortParams(sortParam));

		return results;

	}

	/*public DeviceTrack save(DeviceTrack track,boolean isFirst){

		if(isFirst){
			return deviceTrackDao.save(track);
		}

		String filterParam = "Q_deviceId_S_EQ=" + track.getDeviceId();
		String sortParam = "SORT_updateTime_DESC";

		List<DeviceTrack> tracks = deviceTrackDao.findAll(
				new QuerySpecification<DeviceTrack>(filterParam),
				new PageRequest(0, 1, QueryParamUtil
						.parseSortParams(sortParam))).getContent();

		if(tracks != null && tracks.size() > 0){
			DeviceTrack oldTrack = tracks.get(0);
			double dist = distance(oldTrack.getLon(),oldTrack.getLat(),track.getLon(),track.getLat());
			if(Math.abs(dist) < 20){
				return track;
			}

		}

		return deviceTrackDao.save(track);
	}*/
	public DeviceTrack save(DeviceTrack track,boolean isFirst) {
		/*if(isFirst){
			return deviceTrackDao.save(track);
		}*/
		Date date=new Date();
		String filterParam = "Q_deviceId_S_EQ=" + track.getDeviceId()+ ";Q_updateTime_D_GT=" + new Date(date.getYear(),date.getMonth(),date.getDate()).getTime();
		String sortParam = "SORT_updateTime_DESC";

		List<DeviceTrack> tracks = deviceTrackDao.findAll(
				new QuerySpecification<DeviceTrack>(filterParam), PageRequest.of(0, 1, QueryParamUtil.parseSortParams(sortParam))).getContent();

		/*if (tracks != null && tracks.size() > 0) {
			DeviceTrack oldTrack = tracks.get(0);
			// 请求时间在时效内
			Date reqDate = DateUtils.addMinutes(oldTrack.getUpdateTime(), 5);
			if (reqDate.getTime() >= new Date().getTime()) {
				double dist = distance(oldTrack.getLon(), oldTrack.getLat(), track.getLon(), track.getLat());
				if (Math.abs(dist) < 20) {
					oldTrack.setUpdateTime(date);
					return deviceTrackDao.save(oldTrack);
				}
			}
		}*/

		return deviceTrackDao.save(track);
	}

	/**
	 * 计算地球上任意两点(经纬度)距离
	 *
	 * @param lon1
	 *            第一点经度
	 * @param lat1
	 *            第一点纬度
	 * @param lon2
	 *            第二点经度
	 * @param lat2
	 *            第二点纬度
	 * @return 返回距离 单位：米
	 */
	private  double distance(double lon1, double lat1, double lon2,
	        double lat2) {

		  double radLat1 = lat1 * Math.PI / 180.0;
		  double radLat2 = lat2 * Math.PI / 180.0;
		  double a = radLat1 - radLat2;
		  double b = (lon1 - lon2) * Math.PI / 180.0;
		  double earthRadius = 6378137.0;

		  double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2)
		    + Math.cos(radLat1) * Math.cos(radLat2)
		    * Math.pow(Math.sin(b / 2), 2)));
		  s = s * earthRadius;
		  s = Math.round(s * 10000) / 10000;

		  return s;
	}

    public String saveUploadReport(HttpServletRequest request, Long userId) throws Exception{
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
		List<String> recordId = new ArrayList<>();
		if(multipartResolver.isMultipart(request)){

			MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
			Iterator<String> iter = multiRequest.getFileNames();
			while (iter.hasNext()){
				MultipartFile multipartFile = multiRequest.getFile(iter.next());
				if(multipartFile != null){


                    String parentDir = "locfile";
					File reportFile = getFileFromMultipartFile(multipartFile, ".txt", parentDir);

                    JSONObject additionJson = new JSONObject();
                    additionJson.put("file", parentDir + File.separator + reportFile.getName());

                    TaskRecord record = new TaskRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setParam(JSONObject.toJSONString(additionJson));
                    record.setTasktype(JobConstants.JOB_TYPE_DEVICE_TRACK_UPDATE);
                    record.setStarttime(new Date());
                    record.setState(JobConstants.JOB_STATE_CREATE);
                    record.setUserid(userId);
                    taskRecordService.save(record);
					recordId.add(record.getId());

				}
			}
		}
		return StringUtils.join(recordId, ",");
    }


    public boolean readLocFile(TaskRecord record) throws Exception{
		boolean flag = false;
		String paramater = record.getParam();
		if(StringUtils.isNotBlank(paramater)){
			JSONObject param = JSONObject.parseObject(paramater);
			File locFile = new File(uploadDir + File.separator + param.getString("file"));
			if(locFile.exists()){
				Long userid = record.getUserid();
				List<DeviceTrackUpload> list = new ArrayList<>();
				List<String> ids = new ArrayList<>();

				BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(locFile), "UTF-8"));
				String lineTxt = null;
				while ((lineTxt = br.readLine()) != null){
					DeviceTrackUpload temp = convertTxtToTrack(lineTxt, userid);
					if(StringUtils.isNotBlank(temp.getId()) && !deviceTrackUploadRepository.exists((Specification<DeviceTrackUpload>) temp) && !ids.contains(temp.getId())){
						//deviceTrackUploadRepository.save(temp);
						list.add(temp);
						ids.add(temp.getId());
					}
					if(list.size()>100){
						deviceTrackUploadRepository.saveAll(list);
						list.clear();
						ids.clear();
					}
				}
				if(list.size()>0){
					deviceTrackUploadRepository.saveAll(list);
					list.clear();
					ids.clear();
				}
				flag = true;
			}
		}
		return flag;
	}



	public Boolean checkId(String id) {
		boolean tag = false;
		List<DeviceTrackUpload> list = deviceTrackUploadRepository.findDeviceTrackUploadById(id);
		if (list != null && list.size() > 0) {
			tag = true;
		}
		return tag;
	}

	private DeviceTrackUpload convertTxtToTrack(String lineTxt, Long userId) {
		DeviceTrackUpload track = new DeviceTrackUpload();

		Map<String, String> map = new HashMap<>();
		String[] strings = lineTxt.split(",");
		for (String string : strings) {
			map.put(string.split(":")[0],string.split(":")[1]);
		}
		track.setLat(Double.valueOf(map.get("lat")));
		track.setLon(Double.valueOf(map.get("lon")));
		track.setUpdateTime(new Date(Long.parseLong(map.get("timestamp"))));
		track.setUserId(userId);
		track.setDeviceId(String.valueOf(userId));
		track.setId(map.get("timestamp") + "-" + userId);
		if(map.containsKey("type")){
			track.setType(map.get("type"));
		}
		return track;
	}


	/**
	 * 将MultipartFile转成File
	 *
	 * @param file
	 * @return
	 */
	private File getFileFromMultipartFile(MultipartFile file, String suffix, String parentDir) {
		File f = null;
		InputStream is = null;
		OutputStream os = null;
		File dir = new File(this.uploadDir + File.separator + parentDir);
		if (!dir.exists()) {
			dir.mkdirs();
		}
		try {
			f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
			is = file.getInputStream();
			os = new FileOutputStream(f);
			IOUtils.copy(is, os);
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				os.close();
				is.close();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return f;
	}

}

