package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterUserTrackTranService;
import com.geoway.landteam.landcloud.service.networkTransmission.outer.OuterZeroReportTransmitDataService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.*;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.*;
/*import com.gw.base.data.GwValidateException;*/
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service
 * @date 2022/3/5 16:05
 */
@Service
public class MPatrolService {

    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    OuterUserTrackTranService userTrackTranService;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanAreaMapper patrolPlanAreaRepository;
    @Autowired
    PatrolPlanTaskMapper patrolPlanTaskMapper;
    @Autowired
    TbsysSignRecordRepository tbsysSignRecordRepository;
    @Autowired
    TbsysInspectionRecordRepository tbsysInspectionRecordRepository;
    @Autowired
    OuterZeroReportTransmitDataService zeroReportTransmitDataService;
    @Autowired
    RegionService regionService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Resource
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbsysUserTrackRecordRepository tbsysUserTrackRecordRepository;
    @Autowired
    PatrolPlanContentMapper patrolPlanContentMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Autowired
    PatrolPlanScopeServiceMapper patrolPlanScopeServiceMapper;
    @Autowired
    PatrolProgramMapper patrolProgramMapper;
    @Autowired
    TbPatrolGzqkMapper tbPatrolGzqkMapper;

    /**
     * app获取任务列表
     *
     * @param userId
     * @return
     */
    public Map<String, Object> findPlanList(Long userId,String classId, int page, int rows) {
        Map<String, Object> result = new HashMap<>();
        int start = (page - 1) * rows;
        List<PatrolPlan> list = new ArrayList<>();
        int count = 0;
        if(StringUtils.isNotBlank(classId)){
            list = patrolPlanMapper.findLeftAreaByFUseridAndClassIdlimit(userId, classId,start, rows);
            count = patrolPlanMapper.findLeftAreaByFUseridAndClassIdcount(userId,classId);
        }else{
            list = patrolPlanMapper.findLeftAreaByFUseridlimit(userId,start, rows);
            count = patrolPlanMapper.findLeftAreaByFUseridcount(userId);
        }
        if (!list.isEmpty()) {
            List<PatrolPlan> resultList = list.stream().filter(distinctByKey(PatrolPlan::getfId)).collect(Collectors.toList());
            for (PatrolPlan patrolPlan : resultList) {
                patrolPlan.setTaskCount(patrolPlanTaskMapper.taskCount(patrolPlan.getfId()));
                patrolPlan.setCompleteCount(patrolPlanTaskMapper.completeCount(patrolPlan.getfId(), 2));
            }
            result.put("data", resultList);
            result.put("totalCount", count);
        }
        result.put("data", list);
        result.put("totalCount", count);
        return result;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    /**
     * 获取任务列表
     *
     * @param userId
     * @param planId
     * @return
     */
    public Map<String, Object> findPlanTaskList(Long userId, String planId, int page, int rows) throws Exception {
        Map<String, Object> result = new HashMap<>();
          PatrolPlan one = patrolPlanMapper.selectByPrimaryKey(planId);
       /* PatrolProgram one1 = patrolProgramMapper.gwSearchByPK(one.getfRelprogram());*/
        int start = (page - 1) * rows;
        List<PatrolPlanTask> list = patrolPlanTaskMapper.findByFPlanidLimit(planId, start, rows);
        int totalCount = patrolPlanTaskMapper.findByFPlanidCount(planId);
        if (!list.isEmpty()) {
            List<PatrolPlanTask> distinctList = list.stream().filter(distinctByKey(PatrolPlanTask::getfId)).collect(Collectors.toList());
            //获取对应巡查任务
          /*  SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findOne(sysConfig.getValue());
            TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findOne(tskTaskBiz.getTableId());*/
            List<TskTaskBiz> tskTaskBizs  =   tskTaskBizService.getTskTaskBizByClassId(Long.parseLong(one.getfPatrolbusiness()));
            String tableName = "";
            if(!tskTaskBizs.isEmpty()){
                TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBizs.get(0).getTableId()).orElse(null);
                tableName = tableInfo.getfTablename();
            }else{
                throw new RuntimeException("任务表不存在");
            }
            for (PatrolPlanTask planTask : distinctList) {
                planTask.setSignCount(tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, planTask.getfId()));
               // planTask.setZeroReportCount(tbsysInspectionRecordRepository.findByUserIdAndXsrwId(userId, planTask .getfId()));
                planTask.setWorkReportCount(tbPatrolGzqkMapper.findByFUseridAndFPlanidAndFXsrwidCount(userId.intValue(), planId,planTask .getfId()));
                String sql = "select count(1) from " + tableName + " where f_xsrwid = '" + planTask.getfId() + "' and f_userid ='" + userId + "'";
                Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
                planTask.setXsCount(count);
            }
            result.put("data", distinctList);
            result.put("totalCount", totalCount);
            return result;
        }
        result.put("data", list);
        result.put("totalCount", totalCount);
        return result;
    }

    /**
     * 用户签到
     *
     * @param userId
     * @param lon
     * @param lat
     */
    public int userClockIn(Long userId, String lon, String lat, String planId, String xsrwId) {
        int signCount = 1;
        String wkt = "POINT(" + lon + " " + lat + ")";
        try {
            Geometry geometry = WKTUtil.wktToGeom(wkt);
            String code = "";
            String codeName = "";
            RegionVillage regionVillage = regionService.queryRegionVillageByCoor(geometry);
            if (regionVillage != null) {
                code = regionVillage.getCode();
                codeName = regionVillage.getName();
            } else {
                RegionTown regionTown = regionService.queryRegionTownCotain(geometry);
                if (regionTown != null) {
                    code = regionTown.getCode();
                    codeName = regionTown.getName();
                } else {
                    RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
                    if (region != null) {
                        code = region.getCode();
                        codeName = region.getName();
                    }
                }
            }
                /*  boolean patrolArea = false;
            //获取用户巡查区域
            List<PatrolPlanArea> byFPlanidAndFUserid = patrolPlanAreaRepository.findByFPlanidAndFUserid(planId, userId);
            if(!byFPlanidAndFUserid.isEmpty()){
                for(PatrolPlanArea patrolPlanArea : byFPlanidAndFUserid){
                    if(code.length() >= patrolPlanArea.getfArea().length()
                       &&  patrolPlanArea.getfArea().equals(code .substring(0,patrolPlanArea.getfArea().length()))){
                        patrolArea = true;
                        break;
                    }
                }
            }else{
                throw new Exception("用户没有分配巡查区域，请检查数据！");
            }
            if(!patrolArea){
                throw new Exception("未到达巡查区域,请稍后签到！");
            }*/
            TbsysSignRecord bean = new TbsysSignRecord();
            bean.setUserId(userId);
            bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
            bean.setRegionCode(code);
            bean.setAddr(codeName);
            bean.setLat(Double.parseDouble(lat));
            bean.setLon(Double.parseDouble(lon));
            bean.setPlanId(planId);
            bean.setXsrwId(xsrwId);
            tbsysSignRecordRepository.save(bean);
            signCount = tbsysSignRecordRepository.findByUserIdAndXsrwId(userId, xsrwId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return signCount;
    }


    /**
     * 保存巡查记录
     *
     * @param regionCode
     * @param userId
     * @return
     */
    public TbsysInspectionRecord submitInspection(String regionCode, Long userId, String planId, String xsrwId) throws Exception {
        TbsysInspectionRecord bean = new TbsysInspectionRecord();
        bean.setUserId(userId);
        bean.setRegionCode(regionCode);
        bean.setState(0);
        bean.setRemark("本次巡查无问题");
        bean.setPlanId(planId);
        bean.setXsrwId(xsrwId);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        TbsysInspectionRecord save = tbsysInspectionRecordRepository.save(bean);
        //同步零报告到内网
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", "zeroReport");
        jsonObject.put("operUserId", userId);
        jsonObject.put("TbsysInspectionRecord", JSONObject.toJSONString(save, SerializerFeature.WriteMapNullValue));
        zeroReportTransmitDataService.zeroReportData(jsonObject);
        return save;
    }

    /**
     * 获取签到列表数据
     *
     * @param userId
     * @param xsrwId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public JSONArray findUserClockInDatas(Long userId, String xsrwId, int pageIndex, int pageSize) {
        JSONArray jsonArray = new JSONArray();
        int start = (pageIndex - 1) * pageSize;
        //获取签到数据
        String sql = "SELECT\n" +
                "\tto_char( f_createtime, 'yyyy-MM-dd' ) AS d,\n" +
                "\tCOUNT ( 1 ) AS signCount \n" +
                "FROM\n" +
                "\ttbsys_sign_record \n" +
                "WHERE\n" +
                "\tf_xsrwid = '" + xsrwId + "' \n" +
                "\tAND f_userid = '" + userId + "' GROUP BY d order by d desc limit " + pageSize + " offset " + start;
        ;
        //List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
        List<Map> maps = dataBizService.queryDataBySql(sql);
        if (!maps.isEmpty()) {
            for (Map<String, Object> map : maps) {
                String date = map.get("d").toString();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("date", date);
                jsonObject.put("count", map.get("signcount").toString());
                String sql1 = "select f_regioncode,f_addr,f_lat,f_lon,f_createtime from tbsys_sign_record  where " +
                        " f_userid = '" + userId + "'  and to_char( f_createtime, 'yyyy-MM-dd' ) ='" + date + "' order by f_createtime desc";
                List<Map<String, Object>> map1s = jdbcTemplate.queryForList(sql1);
                jsonObject.put("signs", map1s);
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }

    /**
     * 获取零报告列表
     *
     * @param userId
     * @param xsrwId
     * @param pageIndex
     * @param pageSize
     * @return
     */
    public List<TbsysInspectionRecord> findUserZeroReports(Long userId, String xsrwId, int pageIndex, int pageSize) {
        int start = (pageIndex - 1) * pageSize;
        List<TbsysInspectionRecord> recordList = tbsysInspectionRecordRepository.findByUserIdAndXsrwIdLimt(userId, xsrwId, start, pageSize);
        return recordList;
    }

    /**
     * 保存用户记录
     *
     * @param request
     */
    public void saveUserTracks(HttpServletRequest request, Long userId) throws Exception {
        MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");
        String name = fileOfDB.getOriginalFilename();
        String key = String.format("userTrackdData/%s/%s", userId, name);
       /* String url = ossOperatorService.sendObject2OssByExpires(key, fileOfDB.getInputStream(),3);*/
        String url = ossOperatorService.sendObject2Oss(key, fileOfDB.getInputStream());
        if (url == null || "".equals(url)) {
            throw new RuntimeException("文件上传失败");
        }
        JSONObject params = new JSONObject();
        params.put("userId", userId);
        params.put("url", url);
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_USER_TRACK);
        record.setStarttime(new Date());
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);
        //同步至内网
      /*  userTrackTranService.syscUserTrack(userId, fileOfDB);*/
    }


    /**
     * 处理上传用户轨迹数据
     *
     * @param record
     */
    public void handleUserTracks(TaskRecord record) {
        HttpURLConnection conn = null;
        try {
            //解析参数，执行数据加载
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            Long userId = paramsObject.getLongValue("userId");
            String dataUrl = paramsObject.getString("url");
            String uploadurl = temporarySignedUrlService.getTemporarySignedUrl("", dataUrl, null);
            URL url = new URL(uploadurl);
            if (url != null) {
                conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(3 * 1000);
                conn.setRequestProperty("Charset", "UTF-8");
                File tempUploadFile = buildTempUploadFile(userId.toString());
                FileUtils.copyInputStreamToFile(conn.getInputStream(), tempUploadFile);
                // 获取DB文件数据库连接
                SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
                Connection connection = connPool.getConnection();
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(" select * from track");
                List<TbsysUserTrackRecord> tbsysUserTrackRecordList = new ArrayList<>();
                while (rs.next()) {
                    TbsysUserTrackRecord bean = new TbsysUserTrackRecord();
                    bean.setId(rs.getString("f_id"));
                    bean.setLat(rs.getDouble("f_lat"));
                    bean.setLon(rs.getDouble("f_lon"));
                    bean.setPlanId(rs.getString("f_jhid"));
                    bean.setXsrwId(rs.getString("f_xsrwid"));
                    if (rs.findColumn("f_batch") > 0) {
                        bean.setBatch(rs.getString("f_batch"));
                    }
                    bean.setUserId(userId);
                    bean.setCreateTime(new Timestamp(Long.valueOf(rs.getString("f_createtime"))));
                    tbsysUserTrackRecordList.add(bean);
                    if (tbsysUserTrackRecordList.size() >= 500) {
                        tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                        tbsysUserTrackRecordList.clear();
                    }
                }
                if (tbsysUserTrackRecordList.size() > 0) {
                    tbsysUserTrackRecordRepository.saveAll(tbsysUserTrackRecordList);
                }
                // 关闭连接并删除缓存文件
                connPool.closeAll(connection, statement, rs);
                tempUploadFile.delete();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("track-%s-%s-%s.db", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        // 临时数据存放文件夹
        if(uploadDir == null){
            uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        }
        return new File(uploadDir, fileName);
    }

    /**
     * 获取计划详情
     * @param userId
     * @param planId
     * @return
     */
    public  Map<String,Object> getPlanDetails(Long userId,String planId){
        Map<String,Object> result = new HashMap<>();
        PatrolPlan patrolPlan = patrolPlanMapper.selectByPrimaryKey(planId);
        PatrolProgram patrolProgram = patrolProgramMapper.gwSearchByPK(patrolPlan.getfRelprogram());
        List<PatrolPlanContent> patrolPlanContents = patrolPlanContentMapper.getListByPlanId(planId);
        List<PatrolPlanScopeService> patrolPlanScopeServices = patrolPlanScopeServiceMapper.findByPlanId(planId);
        List<PatrolPlanScope> patrolPlanScopes = new ArrayList<>();
        if(!patrolPlanScopeServices.isEmpty()){
            List<String> ids = patrolPlanScopeServices.stream().map(p -> p.getfScopeid()).collect(Collectors.toList());
            patrolPlanScopes = patrolPlanScopeMapper.selectByIds(ids);
        }
        String sql = " select area.f_area regioncode,case \n" +
                "        when length(area.f_area)=6 then (select f_xzqmc from tb_region where f_xzqdm = area.f_area)\n" +
                "        when length(area.f_area)=9 then (select xzqmc from tb_region_town where xzqdm = area.f_area)\n" +
                "        when length(area.f_area)=12 then (select xzqmc from tb_region_village where xzqdm = area.f_area)\n" +
                "        end as regionName\n" +
                "from  tb_patrol_plan_area area where area.f_role ='3' and area.f_planid ='"+planId+"' and area" +
                ".f_userid ='"+userId+"' ";
        List<Map> maps = dataBizService.queryDataBySql(sql);
        result.put("patrolPlan",patrolPlan);
        result.put("patrolPlanContents",patrolPlanContents);
        result.put("patrolPlanScopes",patrolPlanScopes);
        result.put("regionScopes",maps);
        result.put("patrolProgram",patrolProgram);
        return result;
    }

    /**
     * 巡查工作情况填报
     * @param userId
     * @param patrolGzqk
     */
    public void patrolCaseSubmit(Long userId,TbPatrolGzqk patrolGzqk){
         if(patrolGzqk != null){
             patrolGzqk.setfCreatetime(new Date());
             patrolGzqk.setfUserid(userId.intValue());
             patrolGzqk.setfId(UUID.randomUUID().toString());
             tbPatrolGzqkMapper.insert(patrolGzqk);

             //同步巡查工作情况到内网
             JSONObject jsonObject = new JSONObject();
             jsonObject.put("type", "patrolCase");
             jsonObject.put("operUserId", userId);
             jsonObject.put("PatrolGzqk", JSONObject.toJSONString(patrolGzqk, SerializerFeature.WriteMapNullValue));
             try {
                 zeroReportTransmitDataService.zeroReportData(jsonObject);
             } catch (Exception e) {
                 e.printStackTrace();
             }
         }
    }

    public TbPatrolGzqk getPatrolCase(Long userId, String planId, String xsrwId){
        TbPatrolGzqk patrolGzqk = tbPatrolGzqkMapper.findByFUseridAndFPlanidAndFXsrwid(userId.intValue(),planId, xsrwId);
        return patrolGzqk;
    }


}
