package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.dto.ShareTarget;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.model.pub.entity.SyncLog;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroup;
import com.geoway.landteam.landcloud.core.model.user.entity.WorkGroupMember;
import com.geoway.landteam.landcloud.core.model.user.entity.YXUser;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.*;
import com.geoway.landteam.landcloud.core.repository.user.*;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.CloudMsgUtil;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.servface.suishoupai.JctbService;
import com.geoway.landteam.suishoupai.model.pub.entity.APicShare;
import com.geoway.landteam.suishoupai.repository.pub.APicShareRepository;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.net.URL;
import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class MShareService {

    @Autowired
    APicShareRepository aPicShareRepository;

    @Autowired
    AppBasicRepository appBasicRepository;

    @Autowired
    AppMediaRepository appMediaRepository;

    @Autowired
    APicShareRepository picShareDao;

    @Autowired
    YXUserRepository yxUserRepository;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    AppBasicService appBasicService;

    @Autowired
    JctbService jctbService;

    @Autowired
    WorkGroupRepository workGroupRepository;

    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;

    @Autowired
    Organization2UserRepository organization2UserDao;

    @Autowired
    OrganizationRepository OrganizationDao;

    @Autowired
    LandUserRoleinfoRepository landUserRoleDao;

    @Autowired
    DefaultOssOperatorService ossService;

    @Autowired
    CloudDiskOfPersonRepository cloudDiskOfPersonDao;

    @Autowired
    SyncLogRepository syncLogDao;



    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;



    protected String innerImgUrl;

    @Autowired
    OssConfigRepository ossConfigRepository;

    // 分享随手拍
    public List<APicShare> launchShare(Long userId, String id, String targetUsers, boolean sm, String message, String appBasicInfo, String title)
            throws Exception {
        if (StringUtils.isBlank(targetUsers)) {
            throw new RuntimeException("接收分享的用户不能为空");
        }


        appBasicInfo = completeAppBasicInfo(id, appBasicInfo);

        // 生成分享记录列表
        List<APicShare> list = new ArrayList<APicShare>();
        String[] targetUsersArr = targetUsers.split(",");
        for (String targetUser : targetUsersArr) {
            // 用户是否有云信账号
            boolean flag = hasYXAccount(targetUser);
            // 分享记录
            APicShare share = generateShareRecord(userId, id, targetUser, flag, 1, appBasicInfo);
            share.setTargetHasYXAccount(flag);

            if (sm && flag) {
                // 发送云信消息
                sendYXMessage(userId, id, share.getId(), targetUser, message,title);
            }
            String userTargetName = landUserRepository.findById(Long.valueOf(targetUser)).orElse(null).getName();
            share.setUserTargetName(userTargetName);
            list.add(share);
        }
        return list;
    }

    private String completeAppBasicInfo(String id, String appBasicInfo) throws Exception{
        if (StringUtils.isBlank(appBasicInfo)){
            // web端分享
            AppBasic appBasic = appBasicService.getDetailById(id);

            if (appBasic == null) {
                throw new RuntimeException("随手拍不存在");
            }

            // 分享的appbasic信息中的downloadurl和fileid不能有值
            AppBasic basic = new AppBasic();
            BeanUtils.copyProperties(appBasic,basic);

            List<AppMedia> mediaList = new ArrayList<>();

            List<AppMedia> appMediaList = appBasic.getList();
            for (AppMedia appMedia : appMediaList){
                // 随手拍未上传obs
                String serverPath = appMedia.getServerpath();
                String downloadUrl = appMedia.getDownloadUrl();
                if (StringUtils.isBlank(serverPath)
                        && StringUtils.isNotBlank(downloadUrl)){
                    String suffix;
                    switch (appMedia.getType()){
                        case 1:
                            suffix = ".jpg";
                            break;
                        case 2:
                            suffix = ".mp4";
                            break;
                        case 3:
                            suffix = ".mp3";
                            break;
                        default:
                            suffix = ".jpg";
                            break;
                    }
                    String fileName = appMedia.getId() +suffix;
                    File tempFile = new File(System.getProperty("java.io.tmpdir") + "/" + fileName);
                    FileUtils.copyURLToFile(new URL(downloadUrl), tempFile);
                    // 上传obs
                    String url = ossService.sendObject2Oss(fileName, tempFile);

                    AppMedia tempMedia = new AppMedia();
                    BeanUtils.copyProperties(appMedia,tempMedia);
                    tempMedia.setFileId("");
                    tempMedia.setDownloadUrl("");
                    tempMedia.setServerpath(url);
                    mediaList.add(tempMedia);

                    //appMedia.setServerpath(url);
                    tempFile.delete();
                }
            }

            basic.setList(mediaList);

            appBasicInfo = JSON.toJSONString(basic, SerializerFeature.DisableCircularReferenceDetect);
        } else {
            //appBasicInfo = appBasicInfo.replace("\\", "");
        }
        return appBasicInfo;
    }

    public List<APicShare> launchShares(Long userId, String ids, String targetUsers, boolean sm, String message, String appBasicInfo) throws Exception {
        if (StringUtils.isBlank(ids)) {
            throw new RuntimeException("分享的随手拍不能为空");
        }
        List<APicShare> list = new ArrayList<APicShare>();
        String[] idArr = ids.split(",");
        for (String id : idArr) {
            List<APicShare> aPicShares = launchShare(userId, id, targetUsers, sm, message, appBasicInfo,"随手拍分享");
            list.addAll(aPicShares);
        }
        return list;
    }


    // 根据随手拍id创建分享的消息内容
    private Map<String, String> createYXMessageMap(String id) throws Exception {
        AppBasic appBasic = appBasicRepository.findById(id).orElse(null);
        if (appBasic == null) {
            throw new RuntimeException("提交到单位云的随手拍暂时不支持分享功能");
        }
        Map<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String heading = appBasic.getHeading();
        if (heading == null) {
            heading = "";
        }
        map.put("heading", heading);
        map.put("loc", appBasic.getName());
        map.put("type", appBasic.getType());
        map.put("username_from", appBasic.getUsername());
        map.put("image_url", getFirstImageUrl(id));
        return map;
    }

    // 创建外层消息内容
    private String createOuterMap(YXUser sharer, String id, YXUser receiver, String shareId, String shareType) throws Exception {
        // 消息体
        Map<String, String> map = createYXMessageMap(id);
        Map<String, String> outerMap = new HashMap<String, String>();
        outerMap.put("shareJson", JSON.toJSONString(map));
        outerMap.put("shareType", shareType);
        outerMap.put("userName", sharer.getName());
        outerMap.put("name", sharer.getName());
        outerMap.put("userId", sharer.getId().toString());
        outerMap.put("receiverName", receiver.getName());
        outerMap.put("shareId", shareId);
        LandUser landUser = landUserRepository.findById(sharer.getId()).orElse(null);
        innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        outerMap.put("userIconUrl", innerImgUrl + landUser.getImgUrl());
        return JSON.toJSONString(outerMap);
    }

    // 创建外层消息内容
    private String createOuterMapForWorkGroup(YXUser sharer, String id, WorkGroup receiver, String shareId, String shareType) throws Exception {
        // 消息体
        Map<String, String> map = createYXMessageMap(id);
        Map<String, String> outerMap = new HashMap<String, String>();
        outerMap.put("shareJson", JSON.toJSONString(map));
        outerMap.put("shareType", shareType);
        outerMap.put("userName", sharer.getName());
        outerMap.put("userId", sharer.getId().toString());
        outerMap.put("name", receiver.getName());
        outerMap.put("workId", receiver.getId());
        outerMap.put("shareId", shareId);
        LandUser landUser = landUserRepository.findById(sharer.getId()).orElse(null);
        innerImgUrl = (String)ProjectConfig.getConfig(ProjectConfigEnum.OSS_INNER_IMAGEURL.getKey());
        outerMap.put("userIconUrl", innerImgUrl + landUser.getImgUrl());
        return JSON.toJSONString(outerMap);
    }

    // 获取随手拍的第一张图片
    private String getFirstImageUrl(String id) {
        List<AppMedia> appMedias = appMediaRepository.queryOfPhoto(id,  PageRequest.of(0, 1));
        if (!appMedias.isEmpty()) {
            String downLoadUrl = appMedias.get(0).getDownloadUrl();
            if (StringUtils.isNotBlank(downLoadUrl)) {
                return downLoadUrl;
            }
            String serverPath = appMedias.get(0).getServerpath();
            if (StringUtils.isNotBlank(serverPath)) {
                return serverPath;
            }
        }
        return "";
    }

    // 获取随手拍的第一张图片
    private String getFirstImage(AppBasic appBasic) {
        List<AppMedia> appMedias = appBasic.getList();
        for (AppMedia appMedia : appMedias){
            if (appMedia.getType() == 1 || appMedia.getType() == 2){
                return appMedia.getServerpath();
            }
        }
        return "";
    }

    // 获取随手拍的第一张图片
    private String getFirstImage(JSONArray arrList) {
        for (int i = 0; i < arrList.size(); i++) {
            JSONObject jsonObject = arrList.getJSONObject(i);
            Integer type = jsonObject.getInteger("type");
            if(type==2 || type==1){
                return jsonObject.getString("serverpath");
            }
        }
        return "";
    }


    // 生成分享单个随手拍到单个用户的记录
    private APicShare generateShareRecord(Long userId, String id, String targetUser, boolean flag, int shareType, String appBaiscInfo) {
        APicShare share = new APicShare();
        share.setId(UUID.randomUUID().toString());
        share.setOldId(id);
        share.setUserShare(userId);
        share.setShareTime(new Date());
        share.setUserTarget(targetUser);
        share.setStatus(0);
        share.setShareType(shareType);
        //String replace = appBaiscInfo.replace("\\\\\"", "\\\"");
        JSONObject jsonObject = JSONObject.parseObject(appBaiscInfo);
        JSONArray list = jsonObject.getJSONArray("list");
        //判断是否是工作组
        if(workGroupRepository.findById(targetUser).orElse(null)==null) {
            //获取appbasic的对象
            AppBasic appBasic = JSON.parseObject(appBaiscInfo, AppBasic.class);
            // TODO tuowei  禅道 http://zentao.geoway.net:8081/test/bug-view-91787.html
            appBasic.setUserid(targetUser);
            appBasic.setTime(new Date());
            appBasicRepository.save(appBasic);
        }else{
            List<Long> usersIdinWorkGroup=workGroupMemberRepository.queryMembersId(targetUser);
            List<AppBasic> appBasics=new ArrayList<>();
            Date date=new Date();
            for (Long uId : usersIdinWorkGroup) {
                AppBasic appBasic = JSON.parseObject(appBaiscInfo, AppBasic.class);
                appBasic.setId(UUID.randomUUID().toString());
                appBasic.setUserid(uId.toString());
                appBasic.setTime(date);
                appBasics.add(appBasic);
            }
            appBasicRepository.saveAll(appBasics);
        }
//        if (appBasic != null && appBasic.getList() != null && !appBasic.getList().isEmpty()){
//            share.setImage(getFirstImage(appBasic));
//        }
        if(list!=null && list.size()>0){
            share.setImage(getFirstImage(list));
        }
        share.setAppBasicInfo(appBaiscInfo);
        if (flag) {
            picShareDao.save(share);
        }
        return share;
    }

    private boolean hasYXAccount(String userId) {
        YXUser yxUser = yxUserRepository.findOneByUserId(Long.parseLong(userId));
        if (yxUser == null) {
            return false;
        }
        return true;
    }

    private void sendYXMessage(Long userId, String id, String shareId, String targetUser, String message,String title) throws Exception {
        // 消息发送者
        YXUser sharer = yxUserRepository.findOneByUserId(userId);
        // 消息接受者
        YXUser receiver = yxUserRepository.findOneByUserId(Long.parseLong(targetUser));
        // 0为点对点个人消息,1为点对群消息
        String ope = "0";
        // 0消息类型为普通自定义消息
        String type = "0";

        // 发送分享消息  shareType 为 1
        String ext = createOuterMap(sharer, id, receiver, shareId, "1");
        String body = "{'msg':'"+title+"'}";
        CloudMsgUtil.sendMsg(sharer.getAccid(), ope, receiver.getAccid(), type, body, ext);

        if (StringUtils.isNotBlank(message)) {
            // 发送附言消息
            String ext2 = createOuterMap(sharer, id, receiver, shareId, "0");
            String body2 = "{'msg':'" + message + "'}";
            CloudMsgUtil.sendMsg(sharer.getAccid(), ope, receiver.getAccid(), type, body2, ext2);
        }
    }


    // 接收分享的随手拍
    public AppBasic acceptShare(Long userId, String id) throws Exception {

        // 找到接收最近的随手拍
        List<APicShare> list = picShareDao.getNewestShare(userId + "", id,  PageRequest.of(0, 1));
        if (list.size() == 0) {
            throw new RuntimeException("该随手拍分享已被取消,不支持查看/下载");
        }
        APicShare share = list.get(0);
        if (share.getStatus() == 1) {
            throw new RuntimeException("已接收该分享，无法重复接收");
        }

        LandUser user = landUserRepository.findById(userId).orElse(null);

        AppBasic appBasic = appBasicRepository.findById(share.getOldId()).orElse(null);
        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties(appBasic, newbasic);

        newbasic.setMj(appBasic.getMj());
        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(Long.valueOf(appBasic.getUserid()));
        newbasic.setUserid(userId + "");
        newbasic.setUsername(user.getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(1);
        newbasic.setOri("907");

        appBasicRepository.save(newbasic);

        share.setStatus(1);
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        picShareDao.save(share);

        // 获取其原始随手拍的List<AppMedia>
        List<AppMedia> mds = appMediaRepository.queryByGid(appBasic.getId());

        List<AppMedia> newMedias = new ArrayList<AppMedia>();
        // 修改对应关联id为分享产生的新id
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties(appMedia, appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());
            appMediaShare.setUsername(user.getName());

            newMedias.add(appMediaShare);
        }
        appMediaRepository.saveAll(newMedias);

        newbasic.setList(newMedias);
        return newbasic;
    }

    // 接收分享的随手拍
    public AppBasic acceptShareNew(Long userId, String shareId) throws Exception {

        // 找到接收最近的随手拍
        // List<APicShare> list = picShareDao.getNewestShare(userId + "", id, new
        // PageRequest(0, 1));
        // if (list.size() == 0) {
        // throw new RuntimeException("该随手拍分享已被取消,不支持查看/下载");
        // }
        APicShare share = picShareDao.findById(shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("该分享已被取消或删除");
        }
        if (!share.getUserTarget().equals(userId.toString())) {
            throw new RuntimeException("无法接收");
        }
        if (share.getStatus() == 1) {
            throw new RuntimeException("已接收该分享，无法重复接收");
        }
        AppBasic appBasic = completeAppBasic(share);

        LandUser user = landUserRepository.findById(userId).orElse(null);

        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties(appBasic, newbasic);

        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(share.getUserShare());
        newbasic.setIsDeleted(0);
        newbasic.setTime(new Date());
        newbasic.setUserid(userId + "");
        newbasic.setUsername(user.getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(1);
        newbasic.setOri("907");

        share.setStatus(1);
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        picShareDao.save(share);

        // 获取其原始随手拍的List<AppMedia>
        List<AppMedia> mds = newbasic.getList() == null ?
                new ArrayList<AppMedia>() : newbasic.getList();

        List<AppMedia> newMedias = new ArrayList<AppMedia>();
        // 修改对应关联id为分享产生的新id
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties(appMedia, appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());
            appMediaShare.setUsername(user.getName());

            newMedias.add(appMediaShare);
        }

        // 国家级用户保存新随手拍媒体文件并上传至个人云盘
        //if (isNationalLevel(userId)){
            saveNewAppMediasAndLogs(userId, newMedias);
        //}

        newbasic.setList(newMedias);

        // 国家级用户保存新随手拍
        //if (isNationalLevel(userId)){
            appBasicRepository.save(newbasic);
            saveAppBasicLog(userId, newbasic);
        //}

        return newbasic;
    }

    // 接收分享的任务
    public String acceptShareTask(Long userId, String shareId) throws Exception {

        APicShare share = picShareDao.findById(shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("该分享已被取消或删除");
        }
        if (!share.getUserTarget().equals(userId.toString())) {
            throw new RuntimeException("无法接收");
        }
        if (share.getStatus() == 1) {
            throw new RuntimeException("已接收该分享，无法重复接收");
        }

        //String prjIdNew = UUID.randomUUID().toString();
        //String tbIdNew = UUID.randomUUID().toString();

        share.setStatus(1);
        share.setAcceptTime(new Date());
        share.setNewId("");
        picShareDao.save(share);
        //saveAppBasicLog(userId, newbasic);

        return share.getAppBasicInfo();
    }

    private void saveAppBasicLog(Long userId, AppBasic newbasic) {
        SyncLog syncLog = new SyncLog();
        syncLog.setId(UUID.randomUUID().toString());
        syncLog.setObjtype(1);
        syncLog.setObjid(newbasic.getId());
        syncLog.setOpttype(1);
        syncLog.setOpttime(new Date());
        syncLog.setOptori(2);
        syncLog.setState(2);
        syncLog.setData(JSONObject.toJSONString(newbasic));
        syncLog.setOptuserid(userId);
        syncLogDao.save(syncLog);
    }


    private void saveNewAppMediasAndLogs(Long userId, List<AppMedia> newMedias) throws Exception{
//        Long cloudDiskUserId = -1L;
//        if (!isNationalLevel(userId)){
//            // 非国家级用户，用管理员云盘
//            cloudDiskUserId = Long.valueOf(adminLoginName);
//        }
//        else{
//            cloudDiskUserId = userId;
//        }
//        CloudDiskOfPerson cloudDiskOfPerson = cloudDiskOfPersonDao.findOne(cloudDiskUserId);
//        if (cloudDiskOfPerson == null || cloudDiskOfPerson.getIsDeleted() != 0){
//            return;
//        }
//        JFunBoxLoginUtil.login(cloudDiskOfPerson.getEmail(), cloudDiskOfPerson.getPassword());
//        // 获取文件上传地址
//        String result = JFunBoxFolderUtil.makeDir(cloudDiskOfPerson.getCloudUserId(), 0, "AppBasicFiles", "true");
//        HashMap<String, Object> resultMap = new Gson().fromJson(result, new HashMap<String, Object>().getClass());
//        Long destOwnerId = ((Double) resultMap.get("ownedBy")).longValue();
//        Long destFoldId = ((Double) resultMap.get("id")).longValue();
//
          List<SyncLog> syncLogs = new ArrayList<SyncLog>();
//
//        String str = "";
//        List<OssConfig> ossConfigs = ossConfigRepository.queryDefault();
//        if(ossConfigs.size()>0){
//            str = ossConfigs.get(0).getEndPoint();
//        }

        for (AppMedia appMedia : newMedias){

            String fileId = appMedia.getFileId();
            String serverPath = appMedia.getServerpath();

            Long newSimpleFileId = null;
//            if (StringUtils.isNotBlank(fileId)){
//                String[] split = fileId.split("-");
//                Long ownerId = Long.valueOf(split[0]);
//                Long simpleFileId = Long.valueOf(split[1]);
//                String copyResult = JFunBoxFileUtil.copyFile(ownerId, simpleFileId, destOwnerId, destFoldId, "true");
//                newSimpleFileId = ((Double)(new Gson().fromJson(copyResult, new HashMap<String, Object>().getClass()).get("fileId"))).longValue();
//
//            } else if (StringUtils.isNotBlank(serverPath)){
//                serverPath = temporarySignedUrlService.getTemporarySignedUrl("",serverPath,null);
//                File file = getFileFromUrl(serverPath);
//                String preUploadResult = JFunBoxFileUtil.preUpload(destOwnerId, destFoldId, file.getName(), file.length());
//                String uploadUrl = (String)(new Gson().fromJson(preUploadResult, new HashMap<String, Object>().getClass()).get("uploadUrl"));
//                JFunBoxFileUtil.upload(uploadUrl, file);
//                newSimpleFileId = ((Double)(new Gson().fromJson(preUploadResult, new HashMap<String, Object>().getClass()).get("fileId"))).longValue();
//            } else {
//                throw new RuntimeException("随手拍数据异常");
//            }

            // 拷贝附件并获取地址
            if(StringUtils.isNotBlank(serverPath)) {
                serverPath = temporarySignedUrlService.getTemporarySignedUrl("", serverPath, null);
                File file = getFileFromUrl(serverPath);
                String url = ossService.sendObject2Oss("media/" + UUID.randomUUID().toString(), file);
                appMedia.setServerpath(url);
            }

//            String downloadUrlResult;
//            try {
//                downloadUrlResult = JFunBoxLinkUtil.createLink(destOwnerId, newSimpleFileId, "direct", "static", "", "viewer");
//            } catch (Exception e) {
//                downloadUrlResult = JFunBoxLinkUtil.getLink(destOwnerId, newSimpleFileId, "");
//            }
//            String downloadUrl = (String)(new Gson().fromJson(downloadUrlResult, new HashMap<String, Object>().getClass()).get("url"));
//            appMedia.setFileId(destOwnerId + "-" + newSimpleFileId);
            //appMedia.setDownloadUrl(downloadUrl);

            // 因为app接收就相当于做了同步，这时就不需要同步了日志了
            //syncLogs.add(generateOperateLogOfAppMedia(userId, appMedia));

        }
        //syncLogDao.save(syncLogs);
        appMediaRepository.saveAll(newMedias);
    }

    private SyncLog generateOperateLogOfAppMedia(Long userId, AppMedia appMedia) {
        SyncLog syncLog = new SyncLog();
        syncLog.setId(UUID.randomUUID().toString());
        syncLog.setObjtype(3);
        syncLog.setObjid(appMedia.getId());
        syncLog.setOpttype(1);
        syncLog.setOpttime(new Date());
        syncLog.setOptori(2);
        syncLog.setState(2);
        syncLog.setData(JSONObject.toJSONString(appMedia));
        syncLog.setParentobjid(appMedia.getGalleryid());
        syncLog.setOptuserid(userId);
        return syncLog;
    }

    private boolean isNationalLevel(Long userId){
        List<String> roleIds = landUserRoleDao.findRoleIdByUserId(userId);
        if (roleIds.contains("10012")){
            return true;
        }
        return false;
    }

    private File getFileFromUrl(String url) throws Exception {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        // 文件名称不能带问号
        if(fileName.indexOf("?")>-1) {
            fileName = fileName.substring(0, fileName.indexOf("?"));
        }
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + fileName);
        FileUtils.copyURLToFile(new URL(url), file);
        return file;
    }

    // 获取分享给我的随手拍列表
    public Page<APicShare> getShareList(Long userId, int start, int limit) throws Exception {
        String sortParam = "SORT_shareTime_DESC";
        String filterParam = "Q_userTarget_S_EQ=" + userId;
        Page<APicShare> basics = picShareDao.findAll(new QuerySpecification<APicShare>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

        for (APicShare share : basics) {

            setTheShareTarget(share);

            String gid = share.getOldId();

            AppBasic basic = appBasicRepository.findById(gid).orElse(null);
            basic.setCurMedia(appBasicService.getFirstPhont(gid));
        }
        return basics;
    }

    // 获取我分享出去的随手拍列表(包括未接收和已接收),带筛选条件
    public Page<APicShare> getMyShareList(String filterParam, String sortParam, Long userId, int start, int limit) {
        if (!"".equals(filterParam)) {
            filterParam += ";";
        }
        filterParam += "Q_userShare_N_EQ=" + userId + ";(Q_shareType_N_EQ=1;QOR_shareType_N_EQ=4)";
        Page<APicShare> shares = picShareDao.findAll(new QuerySpecification<APicShare>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));

        for (APicShare share : shares) {
            String gid = share.getOldId();

            AppBasic basic;
            if (StringUtils.isNotBlank(share.getAppBasicInfo())){
                basic = JSON.parseObject(share.getAppBasicInfo(), AppBasic.class);
                List<AppMedia> list = basic.getList();
                if (list != null){
                    for (AppMedia appMedia : list){
                        if (appMedia.getType() == 1 || appMedia.getType() == 2){
                            basic.setCurMedia(appMedia);
                            break;
                        }
                    }
                }
            } else {
                basic = appBasicRepository.findById(gid).orElse(null);
                basic.setCurMedia(appBasicService.getFirstPhont(gid));
            }
            // 完善分享目标的信息
            setTheShareTarget(share);
            share.setOldBasic(basic);
        }
        return shares;
    }

    // 取消随手拍分享, 即删除分享记录
    public int cancleShare(Long userId, String shareIds) throws Exception {
        String[] ids = shareIds.split(",");
        int count = 0;
        for (String id : ids) {
            APicShare aPicShare = picShareDao.findById(id).orElse(null);
            if (aPicShare == null) {
                throw new RuntimeException("该随手拍已被取消或删除");
            }
            if (userId.equals(aPicShare.getUserShare())) {
                picShareDao.delete(aPicShare);
                count++;
            } else {
                throw new RuntimeException("未分享过该随手拍");
            }
        }
        return count;
    }

    public int cancleShareByOid(Long userId, String oids) throws Exception {
        String[] ids = oids.split(",");
        int count = 0;
        for (String id : ids) {
            List<APicShare> list = aPicShareRepository.getApicShareByOldId(id);
            if (!list.isEmpty()) {
                for (APicShare aPicShare:list) {
                    if (userId.equals(aPicShare.getUserShare())) {
                        picShareDao.delete(aPicShare);
                        count++;
                    }
                }

            }

        }
        return count;
    }
    // 提交随手拍至工作组
    public void shareToWorkGroups(Long userId, String ids, String workGroupIds, boolean cover,String sharetype)
            throws Exception {
        if (StringUtils.isBlank(workGroupIds)) {
            throw new RuntimeException("工作组id为空");
        }

        if (!cover) {
            checkRepeatedSubmission(ids, workGroupIds, userId);
        }

        // 提交给工作组, 默认自动接收
        for (String id : ids.split(",")) {
            for (String workGroupId : workGroupIds.split(",")) {
                submitOneToTarget(id, workGroupId, userId, 2,sharetype);
            }
        }
    }

    // 校验重复提交
    private void checkRepeatedSubmission(String ids, String targetIds, Long userId){
        int count = 0;
        for (String id : ids.split(",")) {
            for (String workGroupId : targetIds.split(",")) {
                List<APicShare> list = picShareDao.getApicShareByConditions(userId, id, workGroupId);
                if (!list.isEmpty()) {
                    count++;
                }
            }
        }
        if (count > 0) {
            throw new RuntimeException(count + "条记录已存在");
        }
    }

    // 提交一条随手拍给一个工作组或单位, shareType ,2 -工作组  3-单位
    private void submitOneToTarget(String id, String targetId, Long userId, int shareType,String shareObjType) {
        // 新增一条分享记录 (分享到单位)
        APicShare share = new APicShare();
        List<APicShare> list = picShareDao.getApicShareByConditions(userId, id, targetId);
        if (list.isEmpty()) {
            share.setId(UUID.randomUUID().toString());
        } else {
            // 有则覆盖
            share.setId(list.get(0).getId());
        }
        share.setOldId(id);
        share.setUserShare(userId);
        share.setShareTime(new Date());
        share.setUserTarget(targetId);
        share.setStatus(0);
        share.setShareType(shareType); // 分享给单位 3  分享给工作组 2

        String newId = "";
        if(StringUtils.isBlank(shareObjType) || "0".equalsIgnoreCase(shareObjType)) {
            // 保存随手拍数据
            newId = saveAppBasic(id, share, targetId);
        }
        else if("1".equalsIgnoreCase(shareObjType)){
            // 保存任务数据
            newId = saveTaskTB(id, share, targetId);
        }

        // 获取其原始随手拍的List<AppMedia>
        List<AppMedia> mds = appMediaRepository.queryByGid(id);

        List<AppMedia> newMedias = new ArrayList<AppMedia>();
        // 修改对应关联id为分享产生的新id
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties(appMedia, appMediaShare);
            appMediaShare.setGalleryid(newId);
            appMediaShare.setId(UUID.randomUUID().toString());

            newMedias.add(appMediaShare);
        }
        appMediaRepository.saveAll(newMedias);
    }

    public String saveAppBasic(String oid, APicShare share,String targetId){
        // 默认自动接收, 在tb_app_basic 里创建副本,用户改为单位
        AppBasic appBasic = appBasicRepository.findById(oid).orElse(null);

        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties(appBasic, newbasic);

        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(Long.valueOf(appBasic.getUserid()));
        newbasic.setUserid(targetId);
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(3); // 分享给单位
        newbasic.setTime(share.getShareTime());
        appBasicRepository.save(newbasic);

        // 已接收
        share.setStatus(1);
        share.setAcceptTime(new Date());
        share.setNewId(newbasic.getId());
        picShareDao.save(share);

        return newbasic.getId();
    }

    public String saveTaskTB(String oid, APicShare share,String targetId){

        return "";
    }


	public Page<APicShare> getShareListToWorkGroup(Long userId, int start, int limit, String workGroupId)
			throws Exception {
		List<WorkGroupMember> list = workGroupMemberRepository.getAdmin(workGroupId);
		boolean flag = false;
		for (WorkGroupMember member : list) {
			if (userId.equals(member.getUserId())) {
				flag = true;
			}
		}
		if (!flag) {
			throw new RuntimeException("不是工作组管理员");
		}
		String filterParam = "Q_userTarget_S_EQ=" + workGroupId + ";Q_shareType_N_EQ=2";
		String sortParam = "SORT_shareTime_DESC";

		Page<APicShare> shares = picShareDao.findAll(new QuerySpecification<APicShare>(filterParam),
				 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
		for (APicShare aPicShare : shares) {
			setTheShareTarget(aPicShare);
		}
		return shares;

	}


	// 完善share对象的shareTarget信息
	private void setTheShareTarget(APicShare share) {
		// TODO 根据分享目标是个人，还是工作组生成对应的对象
		if (share.getShareType() == 1) {
			LandUser user = landUserRepository.findById(Long.parseLong(share.getUserTarget())).orElse(null);

			ShareTarget target = new ShareTarget();
			target.setId(share.getUserTarget());
			target.setName(user.getName());
			share.setTarget(target);
		} else if (share.getShareType() == 4) {
			WorkGroup workGroup = workGroupRepository.findById(share.getUserTarget()).orElse(null);
			ShareTarget target = new ShareTarget();
			target.setId(share.getUserTarget());
			target.setName(workGroup.getName());
			share.setTarget(target);
		}
	}

	public AppBasic previewShare(String shareId) throws Exception {
		APicShare share = picShareDao.findById(shareId).orElse(null);
		if (share != null && StringUtils.isNotBlank(share.getAppBasicInfo())) {
            AppBasic appBasic = completeAppBasic(share);
			return appBasic;
		} else {
			throw new RuntimeException("该分享已被取消");
		}
	}

    public String previewShareTask(String shareId) throws Exception {
        APicShare share = picShareDao.findById(shareId).orElse(null);
        if (share != null && StringUtils.isNotBlank(share.getAppBasicInfo())) {
            return share.getAppBasicInfo();
        } else {
            throw new RuntimeException("该分享已被取消");
        }
    }

	private AppBasic completeAppBasic(APicShare share){
        String appBasicInfo = share.getAppBasicInfo();
        if (StringUtils.isBlank(appBasicInfo)){
            throw new RuntimeException("分享数据异常");
        }
        AppBasic appBasic = JSON.parseObject(appBasicInfo, AppBasic.class);
        return appBasic;
    }

	public void appCancleShare(String id, String userTarget) throws Exception {
		List<APicShare> list = picShareDao.getNewestShare(userTarget, id,  PageRequest.of(0, 100));
		if (list.isEmpty()) {
			throw new RuntimeException("该分享已被取消或删除");
		}
		for (APicShare share : list) {
			picShareDao.delete(share);
		}

	}

	public int shareToOrganization(Long userId, String ids, String organizationId, boolean cover) throws Exception {
		if (StringUtils.isBlank(organizationId)) {
			List<Organization2User> list = organization2UserDao.queryByUserId(userId);
			if (list.size() == 0) {
				throw new RuntimeException("用户无单位");
			}
			organizationId = list.get(0).getOrganizationId();
		}
		int count = 0;
		String[] idArr = ids.split(",");
		// 未指明覆盖则校验是否已提交
		if (!cover) {
            checkRepeatedSubmission(ids, organizationId, userId);
		}

		for (String id : idArr) {
            submitOneToTarget(id, organizationId, userId, 3,"");
			count++;
		}
		return count;
	}


	// 提交
    public void shareToOrgAndGroups(Long userId, String ids, String organizationId, String workGroupIds, boolean cover) throws Exception{
        if (StringUtils.isNotBlank(workGroupIds)){
            shareToWorkGroups(userId, ids, workGroupIds, cover,"");
        }
        if (StringUtils.isNotBlank(organizationId)){
            shareToOrganization(userId, ids, organizationId, cover);
        }
    }

    // 分享给工作组
    public List<APicShare> shareByWorkGroupIds(Long userId, String ids, String workGroupIds, boolean sm, String message, String appBasicInfo,String title) throws Exception{
        if (StringUtils.isBlank(ids) || StringUtils.isBlank(workGroupIds)) {
            throw new RuntimeException("参数有误");
        }

        List<APicShare> list = new ArrayList<APicShare>();
        for (String id : ids.split(",")) {
            appBasicInfo = completeAppBasicInfo(id, appBasicInfo);

            for (String workGroupId : workGroupIds.split(",")){
                APicShare aPicShare = generateShareRecord(userId, id, workGroupId, true, 4, appBasicInfo);
                aPicShare.setUserTargetName(workGroupRepository.findById(workGroupId).orElse(null).getName());
                list.add(aPicShare);
                if (sm) {
                    // 发送云信消息
                    sendYXMessageToWorkGroup(userId, id, aPicShare.getId(), workGroupId, message,title);
                }
            }
        }
        return list;
    }

    private void sendYXMessageToWorkGroup(Long userId, String id, String shareId, String workGroupId, String message,String title) throws Exception {
        // 消息发送者
        YXUser sharer = yxUserRepository.findOneByUserId(userId);
        // 消息接受者
        WorkGroup workGroup = workGroupRepository.findById(workGroupId).orElse(null);
        // 0为点对点个人消息,1为点对群消息
        String ope = "1";
        // 0消息类型为普通自定义消息
        String type = "0";

        // 发送分享消息  shareType 为 1
        String ext = createOuterMapForWorkGroup(sharer, id, workGroup, shareId, "1");
        String body = "{'msg':'"+title+"'}";
        CloudMsgUtil.sendMsg(sharer.getAccid(), ope, workGroup.getAccid(), type, body, ext);

        if (StringUtils.isNotBlank(message)) {
            // 发送附言消息
            String ext2 = createOuterMapForWorkGroup(sharer, id, workGroup, shareId, "0");
            String body2 = "{'msg':'" + message + "'}";
            CloudMsgUtil.sendMsg(sharer.getAccid(), ope, workGroup.getAccid(), type, body2, ext2);
        }
    }

    public AppBasic acceptShareInWorkGroup(Long userId, String shareId) throws Exception{
        APicShare share = picShareDao.findById(shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("该分享已被取消或删除");
        }
        String workGroupId = share.getUserTarget();
        WorkGroupMember member = workGroupMemberRepository.queryByUserIdAndGroupId(userId, workGroupId);
        if (member == null) {
            throw new RuntimeException("无法接收");
        }
//        List<AppBasic> appBasics = appBasicRepository.queryReceivedWorkGroupShare(share.getOldId(), share.getUserShare());
//        if (appBasics.size() > 0) {
//            throw new RuntimeException("已接收过该分享，无法重复接收");
//        }

        AppBasic appBasic = completeAppBasic(share);

        AppBasic newbasic = new AppBasic();
        BeanUtils.copyProperties(appBasic, newbasic);

        newbasic.setId(UUID.randomUUID().toString());
        newbasic.setShareUser(share.getUserShare());
        newbasic.setUserid(userId.toString());
        newbasic.setUsername(landUserRepository.findById(userId).orElse(null).getName());
        newbasic.setShareId(share.getOldId());
        newbasic.setShareType(4);
        newbasic.setTime(new Date());
        newbasic.setIsDeleted(0);
        newbasic.setOri("907");


        // 获取其原始随手拍的List<AppMedia>
        List<AppMedia> mds = newbasic.getList();

        List<AppMedia> newMedias = new ArrayList<AppMedia>();
        // 修改对应关联id为分享产生的新id
        for (AppMedia appMedia : mds) {
            AppMedia appMediaShare = new AppMedia();
            BeanUtils.copyProperties(appMedia, appMediaShare);
            appMediaShare.setId(UUID.randomUUID().toString());
            appMediaShare.setGalleryid(newbasic.getId());

            newMedias.add(appMediaShare);
        }
        // 国家级用户保存新随手拍媒体文件并上传至个人云盘
        //if (isNationalLevel(userId)){
            saveNewAppMediasAndLogs(userId, newMedias);
        //}

        newbasic.setList(newMedias);

        //if (isNationalLevel(userId)){
            appBasicRepository.save(newbasic);
            saveAppBasicLog(userId, newbasic);
        //}
        return newbasic;
    }

    public String acceptShareInWorkGroupTask(Long userId, String shareId) throws Exception {
        APicShare share = picShareDao.findById(shareId).orElse(null);
        if (share == null) {
            throw new RuntimeException("该分享已被取消或删除");
        }
        String workGroupId = share.getUserTarget();
        WorkGroupMember member = workGroupMemberRepository.queryByUserIdAndGroupId(userId, workGroupId);
        if (member == null) {
            throw new RuntimeException("无法接收");
        }

        return share.getAppBasicInfo();
    }
}
