package com.geoway.landteam.landcloud.service.pub;

import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.service.util.XzqdmUtil;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional(rollbackFor = Exception.class)
public class MStatisticService {

	@Autowired
	AppBasicRepository appBasicRepository;
	
	@Autowired
    JdbcTemplate jdbcTemplate;
	
	@Autowired
	AppBasicService appBasicService;
	
	// 根据类型统计随手拍
	public List<Map<String, Object>> statisticByType() throws Exception{
		List<Map<String, Object>> theList = new ArrayList<Map<String,Object>>();
		List<Object> list = appBasicRepository.statisticByType();
		theList = new ArrayList<Map<String, Object>>();
		for (Object object : list) {
			Object[] arr = (Object[]) object;
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("type", arr[0]);
			map.put("num", arr[1]);
			theList.add(map);
		}
		return theList;
	}
	// 根据行政区代码统计随手拍
	public List<Map<String, Object>> statisticByXzqdm(String xzqdm, String type) throws Exception{
		String args1 = "";
		String args2 = "";
		// type为省级
		if ("province".equals(type)) {
			args1 += "f_province";
			// xzqdm为空则统计全国所有省,否则统计指定省
			if (!"".equals(xzqdm) && xzqdm != null) {
				args2 += "where u.f_province = '" + xzqdm + "'";
			}
		// type为市级	
		}else if ("city".equals(type)) {
			args1 += "f_city";
			if (!"".equals(xzqdm) && xzqdm != null) {
				if ("province".equals(XzqdmUtil.checkXzqdm(xzqdm))) {
					// 统计一个省所有市
					args2 += "where u.f_province = '" + xzqdm + "'";
				} else {
					// 统计指定市
					args2 += "where u.f_city = '" + xzqdm + "'";
				}
			} 
		// type为区级
		}else{
			args1 += "f_county";
			if (!"".equals(xzqdm) && xzqdm != null) {
				if ("city".equals(XzqdmUtil.checkXzqdm(xzqdm))) {
					// 统计一个市所有区
					args2 += "where u.f_city = '" + xzqdm + "'";
				} else {
					// 统计指定区
					args2 += "where u.f_county = '" + xzqdm + "'";
				}
			} 
		}
		String sql = "SELECT" + 
				"	max(u." + args1 + ") as xzqdm, max(v.f_xzqmc) as xzqmc," + 
				"	sum( CASE WHEN u.f_type = '违法巡查' THEN 1 ELSE 0 END ) as wfxc," + 
				"	sum( CASE WHEN u.f_type = '日常变更' THEN 1 ELSE 0 END ) as rcbg," + 
				"	sum( CASE WHEN u.f_type = '调研检查' THEN 1 ELSE 0 END ) as dyjc," + 
				"	sum( CASE WHEN u.f_type != '违法巡查' AND u.f_type != '日常变更' AND u.f_type != '调研检查' THEN 1 ELSE 0 END ) as others " + 
				"FROM" + 
				"	tb_app_basic u join tb_region v on (u." + args1 + " = v.f_xzqdm)  "+
				 args2 +
				" GROUP BY" + 
				"	u." + args1 + 
				" ORDER BY" + 
				"	xzqdm ASC";
		List<Map<String, Object>> list = jdbcTemplate.queryForList(sql);
		return list;
	}
	
	// 根据地区,类型,排序类型 获取随手拍列表
	public Page<AppBasic> getPage(String xzqdm, String type, String sortType,
								  String page, String rows) throws Exception{
		int start = Integer.valueOf(page) - 1;
		int limit = Integer.valueOf(rows);
		String sortParam;
		if ("asc".equals(sortType)) {
			sortParam = "SORT_createtime_ASC";
		} else {
			sortParam = "SORT_createtime_DESC";
		}
		String filterParam = "";
		if (xzqdm != "" && xzqdm != null) {
			filterParam = "Q_province_S_EQ=" + xzqdm;
		}
		if ("dyjc".equals(type)) {
			type = "调研检查";
			filterParam += ";Q_type_S_EQ=" + type;
		} else if ("rcbg".equals(type)) {
			type = "日常变更";
			filterParam += ";Q_type_S_EQ=" + type;
		} else if ("wfxc".equals(type)) {
			type = "违法巡查";
			filterParam += ";Q_type_S_EQ=" + type;
		}
		filterParam += ";Q_isDeleted_N_EQ=0";
		Page<AppBasic> basics = appBasicService.getPageByFilter(filterParam, sortParam, start, limit);
		for (AppBasic basic : basics) {
			String gid = basic.getId();
			basic.setCurMedia(appBasicService.getFirstPhont(gid));
		}
		return basics;
	}


    public Page<AppBasic> getMyBasicList(String userId, String type, String sortType, String page, String rows) {
        int start = Integer.valueOf(page) - 1;
        int limit = Integer.valueOf(rows);
        String sortParam;
        if ("asc".equals(sortType)) {
            sortParam = "SORT_createtime_ASC";
        } else {
            sortParam = "SORT_createtime_DESC";
        }
        String filterParam = "Q_userid_S_EQ=" + userId;
        if ("rcbg".equals(type)) {
            type = "日常变更";
            filterParam += ";Q_type_S_EQ=" + type;
        } else if ("dyjc".equals(type)) {
            type = "调研检查";
            filterParam += ";Q_type_S_EQ=" + type;
        } else if ("wfxc".equals(type)) {
            type = "违法巡查";
            filterParam += ";Q_type_S_EQ=" + type;
        }
        filterParam += ";Q_isDeleted_N_EQ=0";
        Page<AppBasic> basics = appBasicService.getPageByFilter(filterParam, sortParam, start, limit);
        for (AppBasic basic : basics) {
            String gid = basic.getId();
            basic.setCurMedia(appBasicService.getFirstPhont(gid));
        }
        return basics;
    }
}
