package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.review.TbtskFlowService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.entity.TbtskFlowDef;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFlowService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service
 * @date 2021/6/23 14:32
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MStatisticalAnalysisService {


    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    MTbtskFlowService tbtskFlowService;

    @Autowired
    RegionService regionService;

    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    MTskTaskBizService tskTaskBizService;

    @Resource
    TbtskApproveRecordRepository tbtskApproveRecordRepository;

    @Resource
    TskAssignRecordRepository tskAssignRecordRepository;

    @Autowired
    RegionRepository regionRepository;

    @Autowired
    RegionTownRepository regionTownRepository;

    @Autowired
    RegionVillageRepository regionVillageRepository;

    /**
     * 任务进度汇总
     * @param taskId
     * @return
     */
    public JSONObject getTaskData(String taskId){
        JSONObject object = new JSONObject();
            Integer assignCount = 0; //下发数量
            Integer submitCount = 0;  //已提交数量
            Integer submissionCount = 0; //已提报数量
            Integer allCount = 0;   //总量
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        String findSql = "select f_status,f_review_stage,count(1) from " + tableInfo.getfTablename() + " group byf_status,f_review_stage;";
        //判断是否有审核流程
        List<FlowStep> steps = new ArrayList<>();
        if(taskBiz.getIsApprove() == 1){ //1有审核 0 无审核
            List<TbtskFlowDef> flowStep = tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
             steps = gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>() {}.getType());
        }
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty(maps)) {
            for (Map<String, Object> map : maps) {
                if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                    assignCount += Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                    assignCount += Integer.valueOf(map.get("count").toString());
                    submitCount += Integer.valueOf(map.get("count").toString());
                } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                    assignCount += Integer.valueOf(map.get("count").toString());
                    submitCount += Integer.valueOf(map.get("count").toString());
                    submissionCount += Integer.valueOf(map.get("count").toString());
                }
                allCount += Integer.valueOf(map.get("count").toString());
                //统计审核流程数据
                if(!steps.isEmpty()){
                     for(FlowStep step:steps){
                         if(Integer.valueOf(map.get("f_status").toString()) >= Integer.valueOf(step.getPost_status())
                           && Integer.valueOf(map.get("f_review_stage").toString()) >= Integer.valueOf(step.getPost_stage())){
                             object.put(step.getName(), object.getInteger(step.getName())+Integer.valueOf(map.get("count").toString()));
                         }
                     }
                }
             }
            }
        object.put("assignCount", assignCount);
        object.put("submitCount", submitCount);
        object.put("submissionCount", submissionCount);
        object.put("allCount", allCount);
        return object;
    }

    /**
     * 近期作业情况
     * @param taskId
     * @return
     */
    public JSONArray getTaskOperData(String taskId){
        JSONArray jsonArray = new JSONArray();
        List<String> timeList = new ArrayList<>();
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        //判断是否有审核流程
        List<FlowStep> steps = new ArrayList<>();
        if(taskBiz.getIsApprove() == 1){ //1有审核 0 无审核
            List<TbtskFlowDef> flowStep = tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
            steps = gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>() {}.getType());
        }
          // 开始时间
           Calendar start = Calendar.getInstance();
           start.setTime(taskBiz.getCreateTime());
           // 结束时间
           Calendar end = Calendar.getInstance();
           end.setTime( new Date());
        if(testMonth(start,end)){  //获取两个时间中间所有日期
            Long oneDay = 1000 * 60 * 60 * 24l;
            Long time = start.getTimeInMillis();
            while (start.getTimeInMillis() <= end.getTimeInMillis()) {
                Date d = new Date(time);
                DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                timeList.add(df.format(d));
                time += oneDay;
            }
        }else{
            //获取月份
            timeList = getMonth(new SimpleDateFormat("yyyy-MM").format(start.getTime()), new SimpleDateFormat("yyyy-MM").format(end.getTime()));
        }
          for(String s : timeList){
            JSONObject parJsonObject = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            if(testMonth(start,end)){  //按日分
                String findSql = "select f_id from " + tableInfo.getfTablename() + " where f_committime between " +"'"+s+" 00:00:00' and '"+s+" 23:59:59';";
                List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
                jsonObject.put("submitCount",maps.size()); //获取提交数量
                jsonObject.put("assignCount",tskAssignRecordRepository.countByTaskidAndtTimeByDay(taskId,s)); //获取下发数量
                //统计审核流程数据
                if(!steps.isEmpty()){
                    for(FlowStep step:steps){
                        int count = tbtskApproveRecordRepository.countByTaskidAndStepAndtTime(taskId,step.getName(),s+" 00:00:00",s+" 23:59:59");
                        jsonObject.put(step.getName(),count);
                    }
                }
            }else{ //按月份
                String findSql = "select f_id from " + tableInfo.getfTablename() + " where to_char(to_timestamp(TO_NUMBER(SUBSTR(f_committime, 0,11), '9999999999')),'yyyy-MM') > '"+s+"'";
                List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
                jsonObject.put("submitCount",maps.size()); //获取提交数量
                jsonObject.put("assignCount",tskAssignRecordRepository.countByTaskidAndtTimeByMonth(taskId,s)); //获取下发数量
                //统计审核流程数据
                if(!steps.isEmpty()){
                    for(FlowStep step:steps){
                        int count = tbtskApproveRecordRepository.countByTaskidAndStepAndtTimeByMonth(taskId,step.getName(),s);
                        jsonObject.put(step.getName(),count);
                    }
                }
            }
              parJsonObject.put(s,jsonObject);
              jsonArray.add(parJsonObject);
          }
        return jsonArray;
    }


    /**
     * 各政区任务进度统计
     * @param taskId
     * @return
     */
    public JSONArray getTaskDataByRegion(String taskId, Integer level) {
        JSONArray jsonArray = new JSONArray();
         Integer num = 7;
              if(level == 1){
                  num = 3;
              }else if(level == 2){
                  num = 5;
              }else if(level == 3){
                  num = 7;
              }else if(level == 4){
                  num = 10;
              }else if(level == 5){
                  num = 13;
              }
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        //判断是否有审核流程
        List<FlowStep> steps = new ArrayList<>();
        if(taskBiz.getIsApprove() == 1){ //1有审核 0 无审核
            List<TbtskFlowDef> flowStep = tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
            if (flowStep == null || flowStep.size() == 0) {
                return null;
            }
            Gson gson = new Gson();
            steps = gson.fromJson(flowStep.get(0).getSteps(), new TypeToken<List<FlowStep>>() {}.getType());
        }
        List<Map<String, Object>> regionGroupCount = jdbcTemplate.queryForList("select substring(f_xzqdmsys,0,"+num+") xzqdm,count(1) from "+tableInfo.getfTablename()+" group by substring(f_xzqdmsys,0,"+num+")");
        String findSql = "select substring(f_xzqdmsys,0,"+num+") xzqdm,f_status,f_review_stage,count(1) from "+tableInfo.getfTablename()+" group by substring(f_xzqdmsys,0,"+num+"),f_status,f_review_stage";
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty(regionGroupCount)) {
            for (Map<String, Object> map : regionGroupCount) {
               JSONObject jsonObject = new JSONObject();
                 jsonObject.put("xzqdm",level==1?map.get("xzqdm").toString()+"0000":level==2?map.get("xzqdm").toString()+"00":map.get("xzqdm").toString());
                 String xzqdmName = "";
                 if(level < 4){
                     xzqdmName = regionRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"),taskBiz.getVersion()!=null?taskBiz.getVersion():"2018");
                 }else if(level == 4){
                     xzqdmName = regionTownRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"),taskBiz.getVersion()!=null?taskBiz.getVersion():"2018");
                 }else if(level == 5){
                     xzqdmName = regionVillageRepository.getNameByCodeAndVersion(jsonObject.getString("xzqdm"),taskBiz.getVersion()!=null?taskBiz.getVersion():"2018");
                 }
                 jsonObject.put("xzqdmName",xzqdmName);
                 jsonObject.put("allCount",map.get("count").toString());
                    Integer assignCount = 0; //下发数量
                    Integer submitCount = 0;  //已提交数量
                    Integer submissionCount = 0; //已提报数量
                for (Map<String, Object> map1 : maps) {
                    if(map.get("xzqdm").toString().equals(map1.get("xzqdm").toString())){
                        if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                            assignCount += Integer.valueOf(map.get("count").toString());
                        } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                            assignCount += Integer.valueOf(map.get("count").toString());
                            submitCount += Integer.valueOf(map.get("count").toString());
                        } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                            assignCount += Integer.valueOf(map.get("count").toString());
                            submitCount += Integer.valueOf(map.get("count").toString());
                            submissionCount += Integer.valueOf(map.get("count").toString());
                        }
                        //统计审核流程数据
                        if(!steps.isEmpty()){
                            for(FlowStep step:steps){
                                if(Integer.valueOf(map.get("f_status").toString()) >= Integer.valueOf(step.getPost_status())
                                        && Integer.valueOf(map.get("f_review_stage").toString()) >= Integer.valueOf(step.getPost_stage())){
                                    jsonObject.put(step.getName(), jsonObject.getInteger(step.getName())+Integer.valueOf(map.get("count").toString()));
                                }
                            }
                        }
                    }
                }
                jsonObject.put("assignCount", assignCount);
                jsonObject.put("submitCount", submitCount);
                jsonObject.put("submissionCount", submissionCount);
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }



    /**
     * 任务参与人员统计
     * @param taskId
     * @return
     */
   public JSONObject getTaskRoleData(String taskId){
       JSONObject object = new JSONObject();
           object.put("1",0); //管理员
           object.put("3",0);  //作业员
       TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
       if(taskBiz.getIsApprove() == 1) { //1有审核 0 无审核
           List<TbtskFlowDef> flowStep = tbtskFlowService.findFlow(taskId, FlowTypeEnum.AUDIT.getCode());
           Boolean isContainReview = false;
           if (CollectionUtils.isNotEmpty(flowStep)) {
               object.put("2",0); //审核员
               isContainReview = flowStep.get(0).getName().contains("审复核");
               if(isContainReview){
                   object.put("3",0); //复核员
               }
            }
         }
       //查找内容
       String findSql = "select f_role,count(1)  from tbsys_user_biz2 where f_bizid ="+taskId+" group  by f_role";
       List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
       if (CollectionUtils.isNotEmpty(maps)) {
           for (Map<String, Object> map : maps) {
               Integer role = Integer.valueOf(map.get("f_role").toString());
               if(role ==1 ){
                   object.put("1",Integer.valueOf(map.get("count").toString())); //管理员
               }else if(role ==2){
                   object.put("2",Integer.valueOf(map.get("count").toString())); //审核员
               }else if(role ==3){
                   object.put("3",Integer.valueOf(map.get("count").toString())); //作业员
               }else if(role ==4){
                   object.put("4",Integer.valueOf(map.get("count").toString())); //复核员
               }
           }
       }
       return object;
    }

    /**
     * 任务政区人员分布
     * @param taskId
     * @return
     */
   public JSONArray getTaskRoleDataByXzqdm(String taskId, Integer level){
       JSONArray jsonArray = new JSONArray();
       String findSql = "select p.xzqdm,p.role,count(1) from(\n" +
               "--作业员\n" +
               "select b.f_role  as role ,a.f_userid userId,a.f_xzqdm xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_right_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n" +
               " a.f_taskid= b.f_bizid and b.f_bizid ='"+taskId+"' and b.f_role='3' GROUP BY b.f_role,a.f_userid,a" +
               ".f_xzqdm \n" +
               " union all\n" +
               " --管理员\n" +
               " select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n" +
               " a.f_taskid= b.f_bizid and b.f_bizid ='"+taskId+"' and b.f_role='1' GROUP BY b.f_role,a.f_userid,a.f_regioncode \n" +
               "  union all\n" +
               " --审核员\n" +
               "  select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n" +
               " a.f_taskid= b.f_bizid and b.f_bizid ='"+taskId+"' and and b.f_role='2' GROUP BY b.f_role,a.f_userid,a.f_regioncode \n" +
               "  union all\n" +
               " --复核员\n" +
               "   select b.f_role  as role,a.f_userid userId,a.f_regioncode xzqdm,count(1) from tbsys_user_biz2 b,tbtsk_user_manage_area a where a.f_userid=cast(b.f_userid as varchar(12)) and\n" +
               " a.f_taskid= b.f_bizid and b.f_bizid ='"+taskId+"' and b.f_role='4' GROUP BY b.f_role,a.f_userid,a.f_regioncode ) p group by p.xzqdm,p.role ";
       List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
       if (CollectionUtils.isNotEmpty(maps)) {
           for (Map<String, Object> map : maps) {
               if(jsonArray.size()>0){
                 for (Object o : jsonArray) {
                     JSONObject jsonObject = JSONObject.parseObject(o.toString());
                     if(jsonObject.getString("xzqdm").equals(map.get("xzqdm").toString())){
                         jsonObject.put("count",jsonObject.getInteger("count")+Integer.valueOf(map.get("count").toString()));
                     }else{
                         JSONObject object = new JSONObject();
                         object.put("xzqdm",map.get("xzqdm").toString());
                         //根据政区code获取政区名称
                         object.put("regionName",regionService.getFullName(map.get("xzqdm").toString()));
                         object.put("role",Integer.valueOf(map.get("role").toString()));
                         object.put("count",Integer.valueOf(map.get("count").toString()));
                         jsonArray.add(object);
                     }
                 }
               }else{
                   JSONObject object = new JSONObject();
                   object.put("xzqdm",map.get("xzqdm").toString());
                   //根据政区code获取政区名称
                   object.put("regionName",regionService.getFullName(map.get("xzqdm").toString()));
                   object.put("role",Integer.valueOf(map.get("role").toString()));
                   object.put("count",Integer.valueOf(map.get("count").toString()));
                   jsonArray.add(object);
               }
           }
       }
       return jsonArray;
    }


    /**
     *
     * @param taskId
     * @param granularity
     * @param startTime
     * @param endTime
     * @return
     */
    public JSONArray getTaskOverallDataByXzqdm(String taskId, Integer granularity, String startTime, String endTime) {
        JSONArray jsonArray = new JSONArray();
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        //查找内容
        String findSql = "select substring(f_xzqdmsys,0,10) xzqdm,f_status,f_review_stage,count(1) from " + tableInfo.getfTablename() + " group by substring(f_xzqdmsys,0,10),f_status,f_review_stage;";
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(findSql);
        if (CollectionUtils.isNotEmpty(maps)) {
            for (Map<String, Object> map : maps) {
                if (jsonArray.size() > 0) {
                    for (Object o : jsonArray) {
                        JSONObject jsonObject = JSONObject.parseObject(o.toString());
                        if (jsonObject.getString("xzqdm").equals(map.get("xzqdm").toString())) {
                            if ("101".equals(map.get("f_review_stage").toString())) {
                                jsonObject.put("assignCount",jsonObject.getInteger("assignCount")+Integer.valueOf(map.get("count").toString()));
                                jsonObject.put("submitCount",jsonObject.getInteger("submitCount")+Integer.valueOf(map.get("count").toString()));
                                jsonObject.put("submissionCount",jsonObject.getInteger("submissionCount")+Integer.valueOf(map.get("count").toString()));
                                jsonObject.put("completeCount",jsonObject.getInteger("completeCount")+Integer.valueOf(map.get("count").toString()));
                            } else {
                                if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                                    jsonObject.put("assignCount",jsonObject.getInteger("assignCount")+Integer.valueOf(map.get("count").toString()));
                                } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                                    jsonObject.put("assignCount",jsonObject.getInteger("assignCount")+Integer.valueOf(map.get("count").toString()));
                                    jsonObject.put("submitCount",jsonObject.getInteger("submitCount")+Integer.valueOf(map.get("count").toString()));
                                } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                                    jsonObject.put("assignCount",jsonObject.getInteger("assignCount")+Integer.valueOf(map.get("count").toString()));
                                    jsonObject.put("submitCount",jsonObject.getInteger("submitCount")+Integer.valueOf(map.get("count").toString()));
                                    jsonObject.put("submissionCount",jsonObject.getInteger("submissionCount")+Integer.valueOf(map.get("count").toString()));
                                }
                            }
                        } else {
                            JSONObject object = new JSONObject();
                            Integer assignCount = 0;
                            Integer submitCount = 0;
                            Integer submissionCount = 0;
                            Integer completeCount = 0;
                            object.put("xzqdm", map.get("xzqdm").toString());
                            //根据政区code获取政区名称
                            object.put("regionName", regionService.getFullName(map.get("xzqdm").toString()));
                            if ("101".equals(map.get("f_review_stage").toString())) {
                                assignCount = Integer.valueOf(map.get("count").toString());
                                submitCount = Integer.valueOf(map.get("count").toString());
                                submissionCount = Integer.valueOf(map.get("count").toString());
                                completeCount = Integer.valueOf(map.get("count").toString());
                            } else {
                                if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                                    assignCount = Integer.valueOf(map.get("count").toString());
                                } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                                    assignCount = Integer.valueOf(map.get("count").toString());
                                    submitCount = Integer.valueOf(map.get("count").toString());
                                } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                                    assignCount = Integer.valueOf(map.get("count").toString());
                                    submitCount = Integer.valueOf(map.get("count").toString());
                                    submissionCount = Integer.valueOf(map.get("count").toString());
                                }
                            }
                            object.put("assignCount", assignCount);
                            object.put("submitCount", submitCount);
                            object.put("submissionCount", submissionCount);
                            object.put("completeCount", completeCount);
                            jsonArray.add(object);
                        }
                }
            }else{
                JSONObject object = new JSONObject();
                Integer assignCount = 0;
                Integer submitCount = 0;
                Integer submissionCount = 0;
                Integer completeCount = 0;
                object.put("xzqdm", map.get("xzqdm").toString());
                //根据政区code获取政区名称
                object.put("regionName", regionService.getFullName(map.get("xzqdm").toString()));
                if ("101".equals(map.get("f_review_stage").toString())) {
                    assignCount = Integer.valueOf(map.get("count").toString());
                    submitCount = Integer.valueOf(map.get("count").toString());
                    submissionCount = Integer.valueOf(map.get("count").toString());
                    completeCount = Integer.valueOf(map.get("count").toString());
                } else {
                    if (Integer.valueOf(map.get("f_status").toString()) >= 2) {
                        assignCount = Integer.valueOf(map.get("count").toString());
                    } else if (Integer.valueOf(map.get("f_status").toString()) >= 4) {
                        assignCount = Integer.valueOf(map.get("count").toString());
                        submitCount = Integer.valueOf(map.get("count").toString());
                    } else if (Integer.valueOf(map.get("f_status").toString()) >= 10) {
                        assignCount = Integer.valueOf(map.get("count").toString());
                        submitCount = Integer.valueOf(map.get("count").toString());
                        submissionCount = Integer.valueOf(map.get("count").toString());
                    }
                }
                object.put("assignCount", assignCount);
                object.put("submitCount", submitCount);
                object.put("submissionCount", submissionCount);
                object.put("completeCount", completeCount);
                jsonArray.add(object);
            }
        }
    }
           return jsonArray;
    }


    /**
     * 判断时间是否大于一年
     * @param date
     * @param date2
     * @return
     */
    public static boolean testYear(Date date, Date date2){
        boolean result=false;
        if(date2.getTime()/1000-date.getTime()/1000>31536000){//相差的时间不能大于一年
            result=true;
        }
        return result;
    }


    /**
     * 判断时间是否大于一个月
     * @param start
     * @param end
     * @return
     */
    public static boolean testMonth(Calendar start, Calendar end){
        boolean result=false;
        int subMonthCount = (end.get(Calendar.YEAR) - start.get(Calendar.YEAR) == 0)//相差的月份
                ? end.get(Calendar.MONTH) - start.get(Calendar.MONTH) // 同一年
                : ((end.get(Calendar.YEAR) - start.get(Calendar.YEAR) >= 2) // 年数差超过2年
                ? (end.get(Calendar.YEAR) - start.get(Calendar.YEAR) - 1) * 12
                + start.getActualMaximum(Calendar.MONTH) - start.get(Calendar.MONTH)
                + end.get(Calendar.MONTH) + 1
                : start.getActualMaximum(Calendar.MONTH) - start.get(Calendar.MONTH)
                + end.get(Calendar.MONTH) + 1); // 年数差为1，Calendar.get(MONTH)
        // 第一月是0，所以+1
        //System.out.println(subMonthCount);
        if(subMonthCount<1){//相差月份必须大于一个月
            result=false;
        }else{
            result=true;
        }
        return result;
    }

    /**
     * 获取两个时间之间的全部月份
     * @param startTime
     * @param endTime
     * @return
     */
    public List<String> getMonth(String startTime,String endTime){
        List<String> list = new ArrayList<String>();
        try {
            Date startDate = new SimpleDateFormat("yyyy-MM").parse(startTime);
            Date endDate = new SimpleDateFormat("yyyy-MM").parse(endTime);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            // 获取开始年份和开始月份
            int startYear = calendar.get(Calendar.YEAR);
            int startMonth = calendar.get(Calendar.MONTH);
            // 获取结束年份和结束月份
            calendar.setTime(endDate);
            int endYear = calendar.get(Calendar.YEAR);
            int endMonth = calendar.get(Calendar.MONTH);
            for (int i = startYear; i <= endYear; i++) {
                String date = "";
                if (startYear == endYear) {
                    for (int j = startMonth; j <= endMonth; j++) {
                        if (j < 9) {
                            date = i + "-0" + (j + 1);
                        } else {
                            date = i + "-" + (j + 1);
                        }
                        list.add(date);
                    }

                } else {
                    if (i == startYear) {
                        for (int j = startMonth; j < 12; j++) {
                            if (j < 9) {
                                date = i + "-0" + (j + 1);
                            } else {
                                date = i + "-" + (j + 1);
                            }
                            list.add(date);
                        }
                    } else if (i == endYear) {
                        for (int j = 0; j <= endMonth; j++) {
                            if (j < 9) {
                                date = i + "-0" + (j + 1);
                            } else {
                                date = i + "-" + (j + 1);
                            }
                            list.add(date);
                        }
                    } else {
                        for (int j = 0; j < 12; j++) {
                            if (j < 9) {
                                date = i + "-0" + (j + 1);
                            } else {
                                date = i + "-" + (j + 1);
                            }
                            list.add(date);
                        }
                    }

                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
       return list;
    }


}
