package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SyncLog;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.SyncLogRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.SessionUtils;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.service.user.MLandUserService;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class MSyncLogService {

    private final GiLoger logger = GwLoger.getLoger(MSyncLogService.class);

    @Autowired
    SyncLogRepository syncLogRepository;

    @Autowired
    AppBasicService appBasicService;

    @Autowired
    AppMediaRepository appMediaRepository;

    protected String uploadDir;

    @Autowired
    MLandUserService landUserService;

    @Transactional(rollbackFor = Exception.class)
    public boolean syncData(HttpServletRequest request,String ids){
        File tempUploadFile = null;
        Connection connection = null;

        try{
            Long userid = RedisSessionUtils.checkWebLogin(request);
            LandUser landUser = landUserService.queryUserById(userid);

            // 先将app端已经处理好的日志标记为已同步
            if(StringUtils.isNotBlank(ids)) {
                List<String> idList = Arrays.asList(ids.split(","));
                syncLogRepository.updateSyncLog(2,idList);
            }

            // 获取上传的数据库文件
            boolean isMultipart = ServletFileUpload.isMultipartContent(request);
            if (!isMultipart) {
                // 未上传（app端未做改动）
                return true;
            }
            MultipartFile fileOfDB = ((MultipartHttpServletRequest) request).getFile("file");
            // 文件保存至临时文件目录(时间-UUID.db)
            tempUploadFile = buildTempUploadFile();
            FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);

            // 获取DB文件数据库连接
            SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
            connection = connPool.getConnection();
            Statement statement = connection.createStatement();

            String tableName = "operrecord";
            boolean isExists = isTableExists(statement, tableName);
            if(!isExists){
                throw new RuntimeException("同步文件出错，不存在表[operrecord]");
            }

            ResultSet rs = null;
            String querysql = "select * from " + tableName;
            rs = statement.executeQuery(querysql);

            List<AppBasic> appBasicList = new ArrayList<>();
            List<String> appBasicDelList = new ArrayList<>();
            List<AppMedia> appMediaList = new ArrayList<>();
            List<String> appMediaDelList = new ArrayList<>();
            List<SyncLog> appSyncLogList = new ArrayList<>();
            while (rs.next()) {
                SyncLog syncLogApp = getSyncLog(rs);
                if(syncLogApp==null){
                    continue;
                }
                // 保留app上传的操作日志
                syncLogApp.setOptuserid(userid);
                syncLogApp.setState(2);
                appSyncLogList.add(syncLogApp);

                if(syncLogApp.getObjtype()==1){
                    // 随手拍
                    if(syncLogApp.getOpttype()==1 || syncLogApp.getOpttype()==2){
                        // 新增、修改
                        AppBasic appBasic = getAppBasic(syncLogApp.getData());
                        appBasic.setIsDeleted(0);
                        appBasic.setUserid(String.valueOf(userid));
                        appBasic.setUsername(landUser.getName());
                        appBasicList.add(appBasic);
                    }
                    else if(syncLogApp.getOpttype()==3){
                        // 删除
                        appBasicDelList.add(syncLogApp.getObjid());
                    }
                }
//                else if(syncLogApp.getObjtype()==2){
//                    // 云查询-暂不存在云查询类型
//                }
                else if(syncLogApp.getObjtype()==3){
                    // 附件
                    if(syncLogApp.getOpttype()==1 || syncLogApp.getOpttype()==2){
                        // 新增
                        AppMedia appMedia = getAppMedia(syncLogApp.getData());
                        appMedia.setUsername(landUser.getName());
                        appMediaList.add(appMedia);
                    }
                    else if(syncLogApp.getOpttype()==3){
                        // 删除
                        appMediaDelList.add(syncLogApp.getObjid());
                    }
                }
            }

            // 执行
            appBasicService.saveAll(appBasicList);
            if(appBasicDelList!=null && appBasicDelList.size()>0) {
                appBasicService.deleteByIds(appBasicDelList);
            }

            appMediaRepository.saveAll(appMediaList);
            if(appMediaDelList!=null && appMediaDelList.size()>0) {
                appMediaRepository.deleteByIds(appMediaDelList);
            }

            // 保存日志
            syncLogRepository.saveAll(appSyncLogList);

            connPool.closeAll(connection,statement,rs);
            connection.close();
            tempUploadFile.delete();
        }
        catch(Exception ex){
            logger.error("syncData:"+ex.getMessage());
            return false;
        }
        finally {
            try {
                if(connection!=null && !connection.isClosed()){
                    connection.close();
                }
                if(tempUploadFile!=null){
                    tempUploadFile.delete();
                }
            } catch (Exception ex) {
                logger.error(ex.getMessage(),ex);
            }
        }

        return true;
    }

    public List<SyncLog> queryByFilter(String filterParam,String sortParam){
        List<SyncLog> result =new ArrayList<>();
        try{
            result = syncLogRepository.findAll(new QuerySpecification(filterParam), QueryParamUtil.parseSortParams(sortParam));
        }
        catch (Exception ex){
            logger.error("queryByFilter:"+ex.getMessage());
        }
        return result;
    }

    // 判断db中表是否存在
    private boolean isTableExists(Statement statement, String tableName) throws SQLException {
        String sql = String.format("select count(1) from sqlite_master where type = 'table' and name = '%s'",
                tableName);
        ResultSet rs = statement.executeQuery(sql);
        int iResult = 0;
        while (rs.next()) {
            iResult = rs.getInt(1);
        }

        return iResult > 0;
    }

    private File buildTempUploadFile(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        String fileName = String.format("%s-%s.db", sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(uploadDir, fileName);
    }

    private SyncLog getSyncLog(ResultSet rs){
        SyncLog syncLog = null;
        try{
            syncLog = new SyncLog();
            syncLog.setId(rs.getString("f_id"));
            syncLog.setObjtype(rs.getInt("f_objtype"));
            syncLog.setObjid(rs.getString("f_objid"));
            syncLog.setParentobjid(rs.getString("f_parentobjid"));
            syncLog.setOpttime(stampToDate(rs.getString("f_opttime")));
            syncLog.setOptori(rs.getInt("f_optori"));
            syncLog.setOpttype(rs.getInt("f_opttype"));
            syncLog.setData(rs.getString("f_data"));
        }
        catch(Exception ex){
            logger.error("getSyncLog:"+ex.getMessage());
        }
        return syncLog;
    }

    private AppBasic getAppBasic(String json){
        JSONObject jsonObject = JSONObject.parseObject(json);
        AppBasic appBasic = new AppBasic();
        appBasic.setId(jsonObject.getString("f_id"));
        appBasic.setName(jsonObject.getString("f_name"));
        appBasic.setCreatetime(jsonObject.getString("f_createtime"));
        appBasic.setTime(stampToDate(jsonObject.getString("f_createtime")));
        appBasic.setType(jsonObject.getString("f_type"));
        appBasic.setDesc(jsonObject.getString("f_desc"));
        appBasic.setShape(jsonObject.getString("f_shape"));
        appBasic.setLon(jsonObject.getDouble("f_lon"));
        appBasic.setLat(jsonObject.getDouble("f_lat"));

        try{
            appBasic.setMj(jsonObject.getDouble("f_mj"));
        }
        catch(Exception ex){

        }

        appBasic.setOri(jsonObject.getString("f_gallery_type"));
        appBasic.setCloudId(jsonObject.getString("f_cloudId"));
        appBasic.setVipCloudId(jsonObject.getString("f_vipCloudId"));
        appBasic.setMyCloudId(jsonObject.getString("f_webCloudId"));
        appBasic.setHeading(jsonObject.getString("f_GalleryName"));
        appBasic.setRequestId(jsonObject.getString("f_requestid"));

        return appBasic;
    }

    private AppMedia getAppMedia(String json){
        JSONObject jsonObject = JSONObject.parseObject(json);
        AppMedia appMedia = new AppMedia();
        appMedia.setId(jsonObject.getString("f_id"));
        appMedia.setGalleryid(jsonObject.getString("f_galleryid"));
        appMedia.setAzimuth(jsonObject.getString("f_azimuth"));
        appMedia.setDownloadUrl(jsonObject.getString("f_downloadurl"));
        appMedia.setFileId(jsonObject.getString("f_fileid"));
        appMedia.setLat(jsonObject.getDouble("f_lat"));
        appMedia.setLon(jsonObject.getDouble("f_lon"));
        appMedia.setMediasize(jsonObject.getDouble("f_mediasize"));
        appMedia.setMediatimelength(jsonObject.getInteger("f_mediatimelength"));
        appMedia.setPitch(jsonObject.getString("f_pitch"));
        appMedia.setServerpath(jsonObject.getString("f_serverpath"));
        appMedia.setShape(jsonObject.getString("f_shape"));
        String time = jsonObject.getString("f_time");
        if (StringUtils.isNotBlank(time)) {
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(time);
            } catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                    timeLong = date.getTime();
                } catch (ParseException parseException) {

                }
            }
            if (timeLong != null) {
                appMedia.setTime(String.valueOf(timeLong));
            }
        }
        appMedia.setType(jsonObject.getInteger("f_type"));
        appMedia.setVideorecord(jsonObject.getString("f_videorecord"));
        appMedia.setMark(jsonObject.get("mark") == null ? 0 : jsonObject.getInteger("mark"));
        appMedia.setTypetype(jsonObject.get("typetype") == null ? 0 : jsonObject.getInteger("typetype"));
        appMedia.setDeviceSource(0);
        return appMedia;
    }

    /*
     * 将时间戳转换为时间
     */
    private Date stampToDate(String s){
        long lt = new Long(s);
        Date date = new Date(lt);
        return date;
    }
}
