package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.task.TbtskTaskFieldsAddDao;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.entity.Tbgst;
import com.geoway.landteam.customtask.repository.pub.TbgstRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskFieldsAdd;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.seo.TaskMediaGetSeo;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.util.GutilStr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class TaskMediaService {

    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    AppMediaDao appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    ImportOtherDataService importOtherDataService;

    @Autowired
    OssConfigRepository ossConfigDao;

    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;

    @Autowired
    TbgstRepository tbgstRepository;

    @Autowired
    TbtskTaskFieldsAddDao tbtskTaskFieldsAddDao;


    public JSONObject getMedias(TaskMediaGetSeo seo) throws Exception {
        if(seo==null)
        {
            throw new Exception("参数错误");
        }
        if(StringUtils.isBlank(seo.getTaskId()))
        {
            throw new Exception("参数错误,任务id为空");
        }
        if(StringUtils.isBlank(seo.getRelField()))
        {
            throw new Exception("参数错误,关联字段为空");
        }
        if(seo.getRelValues()==null||seo.getRelValues().isEmpty())
        {
            throw new Exception("参数错误,关联值为空");
        }
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(seo.getTaskId());
        if (taskBiz == null) {
            throw new Exception("任务:" + seo.getTaskId() + "不存在");
        }
        TbtskObjectinfo objectinfo = tskTaskBizService.findTableByTaskId(seo.getTaskId());
        if (objectinfo == null) {
            throw new Exception("任务:" + seo.getTaskId() + "表对象不存在");
        }

        List<TbtskFields> fields = tskTaskBizService.getFieldsByTableId(taskBiz.getTableId());
        if(!fields.stream().filter(t->t.getfFieldname().equalsIgnoreCase(seo.getRelField())).findFirst().isPresent())
        {
            throw new Exception("任务:" + seo.getTaskId() + "表对象不存在字段:"+seo.getRelField());
        }


        List<String>selectFiels = new ArrayList<>();
        selectFiels.add("f_id");
        if(!seo.getRelField().equals("f_id"))
        {
            selectFiels.add(seo.getRelField());
        }
        String where = seo.getRelField()+" in ('"+StringUtils.join(seo.getRelValues(),"','")+"')";
        List<Map>mapTbIds = dataBizMapper.queryAllData(objectinfo.getfTablename(), selectFiels, where );
        if (mapTbIds == null || mapTbIds.isEmpty()) {
            return null;
        }

        List<String> tbIds =  mapTbIds.stream().map(t->t.get("f_id").toString()).collect(Collectors.toList());
        List<AppMedia> appMedias = appMediaDao.queryByGalleryids(tbIds);
        List<AppMediaDTO> appMediaDTOS = new ArrayList<>();
        for (int i = 0; i < appMedias.size(); i++) {
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtil.copyProperties(appMedias.get(i), newMedia);
            if (StringUtils.isBlank(newMedia.getServerpath()) && StringUtils.isNotBlank(newMedia.getDownloadUrl())) {
                newMedia.setServerpath(newMedia.getDownloadUrl());
            }

            appMediaDTOS.add(newMedia);

        }
        JSONObject result = new JSONObject();
        result.put("medias",appMedias);
        List<OssConfig>configs = new ArrayList<>();
        Iterable<OssConfig>ossConfigs = ossConfigDao.findAll();
        Iterator<OssConfig> iterator=    ossConfigs.iterator();
        while (iterator.hasNext())
        {
            OssConfig ossConfig =  iterator.next();
            OssConfig oss = new OssConfig();
            BeanUtil.copyProperties(ossConfig,oss);

            oss.setKey(Base64.getEncoder().encodeToString(oss.getKey().getBytes()));
            oss.setKeySecret(Base64.getEncoder().encodeToString(oss.getKeySecret().getBytes()));
            configs.add(oss);
        }
        result.put("ossConfigs",configs);
        if(!seo.getRelField().equals("f_id"))
        {
            result.put("relFields",mapTbIds);
        }

        return result;

    }
}
