package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.pub.TbgstDao;
import com.geoway.landteam.customtask.dao.task.TbtskTaskFieldsAddDao;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.entity.Tbgst;
import com.geoway.landteam.customtask.repository.pub.TbgstRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskFieldsAdd;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.service.util.TableUtil;
import com.gw.base.util.GutilStr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class TaskObjectUpdateInfoService {

    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    AppMediaDao appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    ImportOtherDataService importOtherDataService;

    @Autowired
    OssConfigRepository ossConfigDao;

    @Autowired
    TbtskFlowServiceImpl tbtskFlowService;

    @Autowired
    TbgstRepository tbgstRepository;

    @Autowired
    TbtskTaskFieldsAddDao tbtskTaskFieldsAddDao;


    public JSONObject getUpdateInfo(String taskId, String beginTime,Integer page, Integer size) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Long bt = 0l;
        Long et = 0l;
        try {
            Date date = df.parse(beginTime);
            bt = date.getTime();
        } catch (Exception ex) {
            throw new Exception("更新开始时间格式错误,正确格式如:" + df.format(new Date()));
        }
        List<Map<String,Object>>mapFilter = jdbcTemplate.queryForList(String.format("select f_id as id,f_name as name,f_filter from tbtsk_task_biz_to_ja where f_id ='%s' and f_enable = 1",taskId));
        if(mapFilter==null||mapFilter.isEmpty())
        {
            throw new Exception("任务:" + taskId + "不支持更新");
        }
        TskTaskBiz taskBiz = tskTaskBizService.findByTaskId(taskId);
        if (taskBiz == null) {
            throw new Exception("任务:" + taskId + "不存在");
        }
        TbtskObjectinfo objectinfo = tskTaskBizService.findTableByTaskId(taskId);
        if (objectinfo == null) {
            throw new Exception("任务:" + taskId + "表对象不存在");
        }
        if (!TableUtil.hasField(objectinfo.getfTablename(), "f_updatetime", jdbcTemplate)) {
            throw new Exception("任务:" + taskId + "表对象无更新时间字段");
        }
        List<TbtskFields> fields = tskTaskBizService.getFieldsByTableId(taskBiz.getTableId());
        List<String> selectFiels = new ArrayList<>();
        fields.forEach(t -> selectFiels.add(t.getfFieldname()));
        List<Map> tbs = null;
        Map now = jdbcTemplate.queryForMap("SELECT EXTRACT(epoch FROM now()) as time;");
        //long endTime = (long) Math.ceil(Double.parseDouble(now.get("time").toString())) * 1000;
        String where = "cast(f_updatetime as int8) > " + bt ;
        Object filter = mapFilter.get(0).get("f_filter");
        if(filter!=null&&StringUtils.isNotBlank(filter.toString()))
        {
            where+=" and "+filter.toString();
        }
        JSONObject result = new JSONObject();
        int count = dataBizMapper.getCount(objectinfo.getfTablename(), where);
        result.put("totalCount", count);

        //分页
        int start = (page - 1) * size;
        tbs = dataBizMapper.queryPageData(objectinfo.getfTablename(), selectFiels, size, start, where + " order by f_updatetime asc,f_id asc");
        if (tbs == null || tbs.isEmpty()) {
            return result;
        }

        result.put("tbs", tbs);
        List<String> tbIds = new ArrayList<>();
        List<String> splitdIds = new ArrayList<>();
        TbtskTaskFieldsAdd search = new TbtskTaskFieldsAdd();
        search.setTaskId(taskId);
        if (tbs != null) {
            Map map = null;
            for (int i = 0; i < tbs.size(); i++) {
                map = tbs.get(i);
                if (map != null && map.containsKey("f_id") && map.get("f_id") != null) {
                    String id = map.get("f_id").toString();
                    tbIds.add(id);

                    search.setTbid(id);
                    TbtskTaskFieldsAdd add =  tbtskTaskFieldsAddDao.gwSearchFirst(search);
                    if(add!=null)
                    {
                        Map addMap = JSONObject.parseObject(add.getContent(),Map.class);
                        map.putAll(addMap);
                    }

                    if (map.containsKey("f_issplitted") && map.get("f_issplitted") != null) {
                        boolean splitd = map.get("f_issplitted").toString().equals("1");
                        if (splitd) {
                            splitdIds.add(id);
                        }
                    }
                }
            }
        }



        List<String> splitdTbIds = new ArrayList<>();
        List<Map> SplitedDataList = null;
        Map<String, String> splitedIdMap = new HashMap<>();
        if (!splitdIds.isEmpty()) {
            if (!selectFiels.stream().filter(t -> t.equalsIgnoreCase("f_splitedid")).findFirst().isPresent()) {
                selectFiels.add("f_splitedid");
            }
            String idsWhere = "f_splitedid in ('" + StringUtils.join(splitdIds, "','") + "')";
            SplitedDataList = dataBizMapper.queryAllData(objectinfo.getfTablename() + "_child d", selectFiels, idsWhere);

            if (SplitedDataList != null) {
                Map map = null;

                for (int i = 0; i < SplitedDataList.size(); i++) {
                    map = SplitedDataList.get(i);
                    if (map != null && map.containsKey("f_id") && map.get("f_id") != null) {
                        String id = map.get("f_id").toString();
                        splitdTbIds.add(id);

                        search.setTbid(id);
                        TbtskTaskFieldsAdd add =  tbtskTaskFieldsAddDao.gwSearchFirst(search);
                        if(add!=null)
                        {
                            Map addMap = JSONObject.parseObject(add.getContent(),Map.class);
                            map.putAll(addMap);
                        }


                        if (map.containsKey("f_splitedid") && map.get("f_splitedid") != null) {
                            String spliteid = map.get("f_splitedid").toString();
                            splitedIdMap.put(id, spliteid);

                        }
                    }
                }
            }

        }
        result.put("spliteTbs", SplitedDataList);
        if (!tbIds.isEmpty()) {
            List<AppMedia> appMedias = appMediaDao.queryByGalleryids(tbIds);
            List<AppMediaDTO> appMediaDTOS = new ArrayList<>();
            for (int i = 0; i < appMedias.size(); i++) {
                AppMediaDTO newMedia = new AppMediaDTO();
                BeanUtil.copyProperties(appMedias.get(i), newMedia);
                formatLonLat(newMedia);
                if (StringUtils.isBlank(newMedia.getServerpath()) && StringUtils.isNotBlank(newMedia.getDownloadUrl())) {
                    newMedia.setServerpath(newMedia.getDownloadUrl());
                }
                if (newMedia.getServerpath() != null) {
                    if (StringUtils.isBlank(newMedia.getFromSource())) {
                        //获取文件名
                        String url = newMedia.getServerpath();
                        if (url.contains("?")) {
                            url = StringUtils.split(url, "?")[0];
                        }
                        String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                        newMedia.setFileName(fiename);
                        //获取文件授权有效期
                        url = temporarySignedUrlService.getTemporarySignedUrl(null, url, null);
                        if (GutilStr.isNotBlank(url)) {
                            newMedia.setServerpath(url);
                        }
                    } else {
                        String from = newMedia.getFromSource();
                        if (from.startsWith(importOtherDataService.getMediaSourcePrefix())) {
                            from = importOtherDataService.getMediaSourcePrefix();
                            if (from.endsWith("_")) {
                                from = from.substring(0, from.lastIndexOf("_"));
                            }
                        }
                        OssConfig ossConfig = ossConfigDao.queryBySource(from);
                        if (ossConfig != null) {
                            String url = newMedia.getServerpath();
                            if (url.contains("?")) {
                                url = StringUtils.split(url, "?")[0];
                            }
                            String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                            newMedia.setFileName(fiename);
                            url = temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                            if (GutilStr.isNotBlank(url)) {
                                newMedia.setServerpath(url);
                            }
                        }
                    }
                }
                appMediaDTOS.add(newMedia);

            }
            result.put("fjs", appMediaDTOS);
        }
        if (!splitdTbIds.isEmpty()) {
            {
                List<AppMedia> appMedias = appMediaDao.queryByGalleryids(splitdTbIds);
                List<AppMediaDTO> appMediaDTOS = new ArrayList<>();
                for (int i = 0; i < appMedias.size(); i++) {
                    AppMediaDTO newMedia = new AppMediaDTO();
                    BeanUtil.copyProperties(appMedias.get(i), newMedia);
                    formatLonLat(newMedia);
                    if (StringUtils.isBlank(newMedia.getServerpath()) && StringUtils.isNotBlank(newMedia.getDownloadUrl())) {
                        newMedia.setServerpath(newMedia.getDownloadUrl());
                    }
                    if (newMedia.getServerpath() != null) {
                        if (StringUtils.isBlank(newMedia.getFromSource())) {
                            //获取文件名
                            String url = newMedia.getServerpath();
                            if (url.contains("?")) {
                                url = StringUtils.split(url, "?")[0];
                            }
                            String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                            newMedia.setFileName(fiename);
                            //获取文件授权有效期
                            url = temporarySignedUrlService.getTemporarySignedUrl(null, url, null);
                            if (GutilStr.isNotBlank(url)) {
                                newMedia.setServerpath(url);
                            }
                        } else {
                            String from = newMedia.getFromSource();
                            if (from.startsWith(importOtherDataService.getMediaSourcePrefix())) {
                                from = importOtherDataService.getMediaSourcePrefix();
                                if (from.endsWith("_")) {
                                    from = from.substring(0, from.lastIndexOf("_"));
                                }
                            }
                            OssConfig ossConfig = ossConfigDao.queryBySource(from);
                            if (ossConfig != null) {
                                String url = newMedia.getServerpath();
                                if (url.contains("?")) {
                                    url = StringUtils.split(url, "?")[0];
                                }
                                String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                                newMedia.setFileName(fiename);
                                url = temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                                if (GutilStr.isNotBlank(url)) {
                                    newMedia.setServerpath(url);
                                }
                            }
                        }
                    }
                    appMediaDTOS.add(newMedia);

                }
                result.put("spliteFjs", appMediaDTOS);
            }
            for (String tbId : tbIds) {

            }


        }
        if(!tbIds.isEmpty()) {
           List<ApproveRecordDTO>approveRecordDTOS=   tbtskFlowService.findAllApproveRecord(taskId, tbIds);
           result.put("shs", approveRecordDTOS);
           List<Tbgst>gst=  tbgstRepository.findByBizIdAndTbIds(taskId, tbIds);
           if(gst!=null)
           {
               for(Tbgst g:gst)
               {
                   String newUrl = temporarySignedUrlService.getTemporarySignedUrl(null, g.getUrl(), null);
                   g.setUrl(newUrl);
               }
           }
           result.put("gsts", gst);
        }
        if(!splitdTbIds.isEmpty()) {
            List<ApproveRecordDTO>approveRecordDTOS= tbtskFlowService.findAllApproveRecord(taskId, splitdTbIds);
            result.put("spliteShs", approveRecordDTOS);
            List<Tbgst>gst=  tbgstRepository.findByBizIdAndTbIds(taskId, splitdTbIds);
            if(gst!=null)
            {
                for(Tbgst g:gst)
                {
                    String newUrl = temporarySignedUrlService.getTemporarySignedUrl(null, g.getUrl(), null);
                    g.setUrl(newUrl);
                }
            }
            result.put("spliteGsts", gst);
        }
        return result;
    }

    public List<Map<String,Object>>getUpdateTask()
    {
        return jdbcTemplate.queryForList("select f_id as id,f_name as name,f_order as order from tbtsk_task_biz_to_ja where f_enable = 1 order by f_order");

    }

    private void formatLonLat(AppMediaDTO media){
        Optional.ofNullable(media)
                .map(AppMediaDTO::getLon)
                .map(this::scaleCoordinate)
                .ifPresent(media::setLon);
        Optional.ofNullable(media)
                .map(AppMediaDTO::getLat)
                .map(this::scaleCoordinate)
                .ifPresent(media::setLat);
    }
    public Double scaleCoordinate(Double value){
        return Optional.ofNullable(value)
                .map(BigDecimal::new)
                .map( d -> d.setScale(7,BigDecimal.ROUND_HALF_UP))
                .map(BigDecimal::doubleValue).orElse(value);
    }
}
