package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.mapper.pub.TbsysBhmanagerMapper;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.pub
 * @date 2023/11/23 16:06
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class TbsysBhmanagerService {

    private GiLoger logger = GwLoger.getLoger(TbsysBhmanagerService.class);

    @Autowired
    TbsysBhmanagerMapper tbsysBhmanagerMapper;


    /**
     * 解析自增编号配置
     * @param paramObject
     * @param map
     * @return
     */
    public Pair<String, String> getParamKey(String paramObject, Map map){
        String paramKey ="";
        String numLength="";
        if (StringUtils.isNotBlank(paramObject)){
            JSONArray jsonArray = JSONArray.parseArray(paramObject);
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String paramValue = jsonObject.getString("value");
                switch (jsonObject.get("type").toString()) {
                    case "field":
                        paramKey +=  map.get(paramValue) != null ?map.get(paramValue).toString():"";
                        break;
                    case "time":
                            switch(paramValue){
                                case "yyyy":
                                    paramKey += getCurrentYear();
                                    break;
                                case "MM":
                                    paramKey += getCurrentMonth();
                                    break;
                                case "dd":
                                    paramKey += getCurrentDay();
                                    break;
                                default:
                                    break;
                            }
                        break;
                    case "String":
                        paramKey += paramValue;
                        break;
                    case "sequence":
                        numLength = paramValue;
                        break;
                    default:
                        break;
                }
            }
        }
        return Pair.of(paramKey  , numLength);
    }

    /**
     * 获取序列值
     * @param tableName
     * @param fieldName
     * @param paramKey
     * @param numLength
     * @return
     */
    public String getBhNextValue(String tableName,String fieldName,String paramKey,int numLength){
        Integer bhNextValue = tbsysBhmanagerMapper.getBhNextValue(tableName, fieldName, paramKey);
        return paramKey+padNumber(bhNextValue,numLength);
    }


    /**
     * 数字递增不足五位补足五位长度
     * @param number
     * @param numLength  长度设定
     * @return
     */
    public static String padNumber(int number,int numLength) {
        String numberString = String.valueOf(number);
        if (numberString.length() < numLength) {
            numberString = String.format("%0"+numLength+"d", number);
        }
        return numberString;
    }

    /**
     * 当前年份
     * @return
     */
    public String getCurrentYear(){
        //获取当前时间
        LocalDateTime now = LocalDateTime.now();
        java.time.format.DateTimeFormatter pattern = java.time.format.DateTimeFormatter.ofPattern("yyyy");
        return now.format(pattern);
    }
    /**
     * 当前月份
     * @return
     */
    public String getCurrentMonth(){
        //获取当前时间
        LocalDateTime now = LocalDateTime.now();
        java.time.format.DateTimeFormatter pattern = java.time.format.DateTimeFormatter.ofPattern("MM");
        return now.format(pattern);
    }
    /**
     * 当前日期
     * @return
     */
    public String getCurrentDay(){
        //获取当前时间
        LocalDateTime now = LocalDateTime.now();
        java.time.format.DateTimeFormatter pattern = java.time.format.DateTimeFormatter.ofPattern("dd");
        return now.format(pattern);
    }

}
