package com.geoway.landteam.landcloud.service.pub;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.ImportUserResultInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskResultShare;
import com.geoway.landteam.landcloud.repository.pub.TbtskResultShareRepository;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
/*import jxl.CellType;*/
import jxl.CellType;
import org.apache.poi.ss.usermodel.*;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service
 * @date 2022/12/13 11:16
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class TbtskResultShareService {

    private GiLoger logger = GwLoger.getLoger(TbtskResultShareService.class);

    @Autowired
    TbtskResultShareRepository tbtskResultShareRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    LandUserService landUserService;
    @Value("${project.uploadDir}")
    protected String uploadDir;


    public Map<String,Object> findResultShareRecords(Long userId,String gxbh,String sourceTaskName,String targetaskName, int pageIndex,int pageSize){
        Map<String, Object> result = new HashMap<>();
          String sql = " select\n" +
                  "\tsh.f_id  id,\n" +
                  "\tsh.f_gxbh gxbh,\n" +
                  "\tsh.f_source_task_id  sourceTaskId,\n" +
                  "\tsh.f_target_task_id targetTaskId,\n" +
                  "\tsh.f_status status,\n" +
                  "\tsh.f_create_time  createTime,\n" +
                  "\tsh.f_update_time updateTime,\n" +
                  "\tsh.f_user_id userId,\n" +
                  "\tsh.f_param param,\n" +
                  "\tsh.f_log_url logUrl,\n" +
                  "\tttb.f_name sourceTaskName,\n" +
                  "\ttu.f_username userName\n" +
                  "from\n" +
                  "\ttbtsk_result_share sh\n" +
                  "left join tbtsk_task_biz ttb on\n" +
                  "\t(ttb.f_id = sh.f_source_task_id)\n" +
                  "left join tbsys_user tu on\n" +
                  "\t(tu.f_userid = sh.f_user_id ) where 1=1 ";

          String countSql = "select count(1) from\n" +
                  "\ttbtsk_result_share sh\n" +
                  "left join tbtsk_task_biz ttb on\n" +
                  "\t(ttb.f_id = sh.f_source_task_id)\n" +
                  "left join tbsys_user tu on\n" +
                  "\t(tu.f_userid = sh.f_user_id ) where 1=1 ";
        if (StringUtils.isNotBlank(gxbh)) {
            sql += " and sh.f_gxbh like '%" + gxbh + "%'";
            countSql += " and sh.f_gxbh like '%" + gxbh + "%'";
        }
        if (StringUtils.isNotBlank(sourceTaskName)) {
            sql += " and ttb.f_name like '%" + sourceTaskName + "%'";
            countSql += " and ttb.f_name like '%" + sourceTaskName + "%'";
        }
        if (StringUtils.isNotBlank(targetaskName)) {
            sql += " and sh.f_target_task_id like '%" + targetaskName + "%'";
            countSql += " and sh.f_target_task_id like '%" + targetaskName + "%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql += " order by sh.f_create_time desc limit " + pageSize + " offset " + start;
        List<Map> maps = dataBizService.queryDataBySql(sql);
        Integer count = jdbcTemplate.queryForObject(countSql, Integer.class);
        if (!maps.isEmpty()) {
            for (Map<String, Object> map : maps) {
                  if(map.get("logUrl") != null ){
                      String  accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", map.get("logUrl").toString(), null);
                      map.put("logUrl", accessUrl);
                  }
            }
        }
        result.put("datas", maps);
        result.put("totalNum", count);
        return result;

    }

    /**
     * 启动推送
     * @param userId
     * @param id
     * @return
     */
    public TbtskResultShare startResultShare(Long userId, String id){
        TbtskResultShare resultShare = tbtskResultShareRepository.gwSearchByPK(id);
        resultShare.setStatus(1);
        tbtskResultShareRepository.save(resultShare);
        return resultShare;
    }

    public  List<TskTaskBiz> getResultShareTasks(){
        List<TskTaskBiz> taskBizs = new ArrayList<>();
        //获取线索材料上传接口地址
        SysConfig sysConfig = sysConfigService.findOne("shareTaskId");
        if(sysConfig != null){
            String taskIds = sysConfig.getValue();
           taskBizs = tskTaskBizRepository.findByIds(Arrays.asList(taskIds.split(",")));
        }
        return taskBizs;
    }


    /**
     * 记录上传的数据 通过定时任务处理
     * @param userId
     * @param file
     * @param sourceTaskId
     * @param targetTaskId
     * @throws IOException
     */
    public void importShareData(Long userId, MultipartFile file, String  sourceTaskId, String  targetTaskId) throws Exception {

        // 获取文件名
        String fileName = file.getOriginalFilename();
        String objectname = "resultShare/attachment/" + sourceTaskId + "/" + UUID.randomUUID().toString()+"_"+ fileName;
        String result = ossOperatorService.sendObject2Oss(objectname, file.getInputStream());
         TbtskResultShare tbtskResultShare = new TbtskResultShare();
        tbtskResultShare.setId(UUID.randomUUID().toString());
        tbtskResultShare.setUserId(userId);
        tbtskResultShare.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tbtskResultShare.setSourceTaskId(sourceTaskId);
        tbtskResultShare.setTargetTaskId(targetTaskId);
        tbtskResultShare.setParam(result);
        tbtskResultShare.setStatus(0);
        tbtskResultShare.setGxbh(getgxbh());
        tbtskResultShareRepository.save(tbtskResultShare);
    }

    /**
     * 生成共享编号
     */
    public String getgxbh() {
        String sql = "select nextval('result_share_gid_seq')" + " as id";
        Map<String, Object> map = jdbcTemplate.queryForMap(sql);
         Long bh = (Long) map.get("id");
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
         String gxbh = "500000"+dateFormat.format(new Date())+decimalFormat.format(bh);
        return gxbh;
    }


    //对数据进行解析推送
    public void handlyResultShareExcel( TbtskResultShare tbtskResultShare ) throws Exception {
        File excelFile = null;
        File dir = new File(uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        excelFile = File.createTempFile("tmp", ".xls", dir);
        String  accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", tbtskResultShare.getParam(), null);
        FileUtils.copyURLToFile(new URL(accessUrl), excelFile);
        parseExcel(excelFile.getAbsolutePath(),tbtskResultShare);
        // 获取文件名
        String fileName = excelFile.getName();
        String obsFilePath = "resultShare/attachment/" + tbtskResultShare.getSourceTaskId()+ "/" + UUID.randomUUID().toString() +"_"+ fileName;
        String url = ossOperatorService.sendObject2Oss(obsFilePath, excelFile.getAbsolutePath());
        tbtskResultShare.setLogUrl(url);
        /*tbtskResultShareRepository.save(tbtskResultShare);*/
    }


    /**
     * 从excel中读取数据
     *
     * @param excelFile
     * @throws Exception
     */
    private List<ImportUserResultInfo> parseExcel(String excelFile, TbtskResultShare tbtskResultShare) throws Exception {
        //获取任务相关数据
        List<TbtskFields> sourceFields = null;
        String tableName = "";
        List<String> queryFieldNames = new ArrayList<>();
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(tbtskResultShare.getSourceTaskId());
        if(tskTaskBiz != null){
            TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            if(tableInfo != null){
                tableName = tableInfo.getfTablename();
                sourceFields = tbtskFieldsService.getAllFieldsByTables(tableInfo.getfTablename());
                if (sourceFields != null && sourceFields.size() > 0) {
                    for (TbtskFields field : sourceFields) {
                        queryFieldNames.add(field.getfFieldname());
                    }
                }
            }else{
                throw new Exception("成果来源任务图斑表不存在");
            }
        }else{
            throw new Exception("成果来源任务不存在");
        }
          //获取线索材料上传接口地址
        SysConfig sysConfig = sysConfigService.findOne("synchronizedata");
        if(sysConfig == null){
            throw new Exception("获取线索材料上传接口地址失败");
        }
        Workbook workbook = null;
        OutputStream out = null;
        List<ImportUserResultInfo> userResultInfos = null;
        try {
            File file = new File(excelFile);
            InputStream inputStream = new FileInputStream(file);

            File parentFile = file.getParentFile();
            if (parentFile != null && (!parentFile.exists())) {
                parentFile.mkdirs();
            }

            //这种方式 Excel 2003/2007/2010 都是可以处理的
            workbook = WorkbookFactory.create(inputStream);
            inputStream.close();

            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(0);
            int colNumber = row.getPhysicalNumberOfCells();
            int rowCount = sheet.getPhysicalNumberOfRows();
            // 创建结果列
            createImportResultColumn(workbook, sheet, colNumber);
            for (int i = 2; i < rowCount; i++) {
                ImportUserResultInfo resultInfo = new ImportUserResultInfo();
                resultInfo.setRow(i);
                row = sheet.getRow(i);
                if (row == null) {
                    continue;
                }
                try {
                    String xh = findCellValue(row.getCell(0));
                    String bsm = findCellValue(row.getCell(1));
                    String sjkdl = findCellValue(row.getCell(2));
                    String tbmj = findCellValue(row.getCell(3));
                    String xcry = findCellValue(row.getCell(4));
                    String tbbh = findCellValue(row.getCell(5));
                    String xzdl = findCellValue(row.getCell(6));
                    if (StringUtils.isBlank(tbbh)) {
                        writeErrorInfo(workbook, row, colNumber, "必填项为空，此记录无效");
                    }
                    List<Map> sourceDatas = dataBizService.queryAllData(tableName, queryFieldNames, "f_tbbh = '" + tbbh + "'");
                    if (sourceFields != null && sourceFields.size() > 0) {
                        if (sourceDatas != null) {
                            for (Map map : sourceDatas) {
                                map.put("f_bsm",bsm);
                                if (map.containsKey("f_id")) {
                                    List<AppMedia> appMediaList = appMediaRepository.queryByGalleryids(Arrays.asList(map.get("f_id").toString()));
                                    if(appMediaList.size() > 0 ){
                                        //拼接接口参数
                                        /*  JSONObject param = converParam(map,appMediaList);*/
                                        List<JSONObject> param = converParam1(appMediaList);
                                        String url = sysConfig.getValue() +"/"+tbtskResultShare.getSourceTaskId()+"/"+bsm;
                                        //调用耕地进出平衡任务数据入库接口
                                        JSONObject resultObject =  synchronizedata(url,JSON.toJSONString(param,true));
                                        //记录日志参数
                                        writeParamInfo(workbook, row, colNumber,JSON.toJSONString(param,true),resultObject);
                                        //接口调用记录
                                        writeSuccessInfo(workbook, row, colNumber);
                                    }else{
                                        writeErrorInfo(workbook, row, colNumber, "附件为空");
                                    }

                                }
                            }
                        }
                    }else{
                        writeErrorInfo(workbook, row, colNumber, "找不到图斑数据，数据为空");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e);
                    writeErrorInfo(workbook, row, colNumber, e.getMessage());
                    continue;
                }
            }
            out = new FileOutputStream(file);
            workbook.write(out);
            out.flush();
            out.close();
        } catch (Exception ex) {
            throw ex;
        }

        return userResultInfos;
    }

    public JSONObject converParam(Map map, List<AppMedia> appMediaList){
        JSONObject params = new JSONObject();
         params.put("type",0);
         params.put("data",map);
         List<JSONObject> medias = new ArrayList<>();
         for(AppMedia appMedia:appMediaList){
             JSONObject jsonObject = new JSONObject();
             jsonObject.put("f_type",appMedia.getType());
             String  accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
             jsonObject.put("f_serverpath",accessUrl);
             jsonObject.put("f_videorecord",appMedia.getVideorecord());
             jsonObject.put("f_jym",appMedia.getJym());
             jsonObject.put("f_lon",appMedia.getLon());
             jsonObject.put("f_lat",appMedia.getLat());
             jsonObject.put("f_azimuths",appMedia.getAzimuth());
             jsonObject.put("f_pitchs",appMedia.getPitch());
             jsonObject.put("f_mediasize",appMedia.getMediasize());
             jsonObject.put("f_userid",appMedia.getUsername());
             jsonObject.put("f_username",appMedia.getUsername());
             jsonObject.put("f_device_source",appMedia.getDeviceSource());
             medias.add(jsonObject);
         }
         params.put("media",medias);
        return  params;

    }

    public List<JSONObject> converParam1(List<AppMedia> appMediaList){
         List<JSONObject> medias = new ArrayList<>();
         for(AppMedia appMedia:appMediaList){
             JSONObject jsonObject = new JSONObject();
             jsonObject.put("type",appMedia.getType());
             jsonObject.put("time",appMedia.getTime());
             String  accessUrl = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
             jsonObject.put("serverpath",accessUrl);
             jsonObject.put("videorecord",appMedia.getVideorecord());
             jsonObject.put("lon",appMedia.getLon());
             jsonObject.put("lat",appMedia.getLat());
             jsonObject.put("azimuth",appMedia.getAzimuth());
             jsonObject.put("id",appMedia.getId());
             jsonObject.put("mediasize",appMedia.getMediasize());
             jsonObject.put("deviceSource",appMedia.getDeviceSource());
             String phonemobil="";
             if(StringUtils.isNotBlank(appMedia.getUsername())){
                 LandUser landUser = landUserService.queryAppUserByUsernamePhone(appMedia.getUsername());
                 if(landUser != null){
                     phonemobil = landUser.getPhone();
                 }
             }
             jsonObject.put("phonemobile",phonemobil);
             medias.add(jsonObject);
         }
        return  medias;

    }

    public ImportUserResultInfo parseRow(Workbook wb, Row row, int colNumber) {
        ImportUserResultInfo resultInfo = new ImportUserResultInfo();
        String nameValue = findCellValue(row.getCell(0));
        String phoneValue = findCellValue(row.getCell(1));
        String unitValue = findCellValue(row.getCell(2));
        String deptValue = findCellValue(row.getCell(3));
        String regionCodeValue = findCellValue(row.getCell(4));
        String regionNameValue = findCellValue(row.getCell(5));
        String emailValue = findCellValue(row.getCell(6));
        String roleValue = findCellValue(row.getCell(7));
        String zxjgValue = findCellValue(row.getCell(8));
        String znglValue = findCellValue(row.getCell(9));

        if (StringUtils.isBlank(nameValue)
                && StringUtils.isBlank(phoneValue)
                && StringUtils.isBlank(unitValue)
                && StringUtils.isBlank(regionCodeValue)) {
            resultInfo.setInvalidRow(true);
            resultInfo.setState(2);
            resultInfo.setErrorInfo("必填项为空，此记录无效");
            writeErrorInfo(wb, row, colNumber, "必填项为空，此记录无效");
            return resultInfo;
        }
        return null;
    }

    private void writeErrorInfo(Workbook workbook, Row row, int colNumber, String errorInfo) {
        if (workbook != null) {
            if (row != null && colNumber > -1 && StringUtils.isNotBlank(errorInfo)) {
                Cell cell = row.createCell(colNumber);
                if (cell != null) {
                    cell.setCellValue("接口访问失败，" + errorInfo);
                   /* cell.setCellStyle(createErrorInfoCellStyle(workbook));*/
                }
            }
        }
    }

    private void writeSuccessInfo(Workbook workbook, Row row, int colNumber) {
        if (workbook != null) {
            if (row != null && colNumber > -1) {
                Cell cell = row.createCell(colNumber);
                if (cell != null) {
                    cell.setCellValue("接口访问成功");
                   /* cell.setCellStyle(createSuceessinfocellstyle(workbook));*/
                }
            }
        }
    }

    private void writeParamInfo(Workbook workbook, Row row, int colNumber, String  param, JSONObject resultObject) {
        if (workbook != null) {
            if (row != null && colNumber > -1) {
                Cell cell = row.createCell(colNumber+1);
                Cell cell2 = row.createCell(colNumber+2);
                if (cell != null) {
                    cell.setCellValue(param);
                    cell2.setCellValue(JSONObject.toJSONString(resultObject, SerializerFeature.WriteMapNullValue));

                }
            }
        }
    }

    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            org.apache.poi.ss.usermodel.CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: //文本
                    cellValue = cell.getStringCellValue();
                    break;
                case NUMERIC: //数字、日期
                    if (DateUtil.isCellDateFormatted(cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue()); //日期型
                    } else {
                        cellValue = String.valueOf((long) cell.getNumericCellValue()); //数字
                    }
                    break;
                case BOOLEAN: //布尔型
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                case BLANK: //空白
                    cellValue = cell.getStringCellValue();
                    break;
                case ERROR: //错误
                    cellValue = "错误";
                    break;
                case FORMULA: //公式
                    cellValue = "错误";
                    break;
                default:
                    cellValue = "错误";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    private void createImportResultColumn(Workbook workbook, Sheet sheet, int colNumber) {
        Row row = sheet.getRow(1);
        if (workbook != null) {
            if (row != null && colNumber > -1) {
                Cell cell = row.createCell(colNumber);
                Cell cell2 = row.createCell(colNumber+1);
                Cell cell3 = row.createCell(colNumber+2);
                if (cell != null) {
                    cell.setCellValue("结果");
                    cell2.setCellValue("传参");
                    cell3.setCellValue("返回参数");
                    /* cell.setCellStyle(createSuceessinfocellstyle(workbook));*/
                }
            }
        }

    }

    private CellStyle creatersultecolumnheadercellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
            cellStyle.setFillForegroundColor((short) 13);// 设置背景色  
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cellStyle.getFont().setFontHeightInPoints((short) 12);  //字体大小
        }

        return cellStyle;
    }

    /**
     * 错误信息单元格格式
     *
     * @param wb
     * @return
     */
    private CellStyle createErrorInfoCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
            /* cellStyle.getFont().setColor(new XSSFColor(new java.awt.Color(255, 57, 68)));*/
        }
        return cellStyle;
    }

    private CellStyle createSuceessinfocellstyle(Workbook wb) {
        XSSFCellStyle cellStyle = createCommonCellStyle(wb);
        if (cellStyle != null) {
            /*     cellStyle.getFont().setColor(new XSSFColor(new java.awt.Color(255, 255, 255)));*/
        }
        return cellStyle;
    }

    private XSSFCellStyle createCommonCellStyle(Workbook wb) {
        XSSFCellStyle cellStyle = null;
        if (wb != null) {
            cellStyle = (XSSFCellStyle) wb.createCellStyle();
            if (cellStyle != null) {
                cellStyle.setAlignment(HorizontalAlignment.CENTER); // 居中
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);// 垂直居中

                cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
                cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
                cellStyle.setBorderTop(BorderStyle.THIN);//上边框
                cellStyle.setBorderRight(BorderStyle.THIN);//右边框

                XSSFFont font = (XSSFFont) wb.createFont();
                font.setFontName("仿宋_GB2312");
                font.setBold(true);//粗体显示
                font.setFontHeightInPoints((short) 11);  //字体大小
                cellStyle.setFont(font);//选择需要用到的字体格式

                cellStyle.setWrapText(true);//设置自动换行
            }
        }
        return cellStyle;
    }



    /**
     * 耕地进出平衡任务数据入库接口
     *
     * @param params
     * @return
     * @throws Exception
     */
    public JSONObject synchronizedata(String url, String params) {
        JSONObject result = new JSONObject();
        result.put("code", 1);
        if (url != null) {
            HttpClient httpClient = HttpClientBuilder.create().build();
            try {
                HttpPost httpPost = new HttpPost();
                httpPost.setURI(URI.create(url));
                httpPost.setHeader("Content-Type", "application/json");
                httpPost.setHeader("AppKey", "11bf5bd2ea1c72266615f6fdcc96206f");
                //请求参数转JOSN字符串
                StringEntity entity = new StringEntity(params, "UTF-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json");
                httpPost.setEntity(entity);
                HttpResponse response = httpClient.execute(httpPost);
                String httpEntityContent = getHttpEntityContent(response);
                result = JSONObject.parseObject(httpEntityContent.substring(httpEntityContent.indexOf("{"), httpEntityContent.lastIndexOf("}") + 1));
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                try {
                    ((CloseableHttpClient) httpClient).close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }


    /**
     * 解析返回接口数据
     *
     * @param response
     * @return
     * @throws Exception
     */
    public static String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }

}
