package com.geoway.landteam.landcloud.service.pub.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.Notice;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.HttpConnectionUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.coord.GeoPoint;
import com.geoway.landteam.landcloud.core.model.pub.dto.CommonNum;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.user.UserNameServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.SessionUtils;
import com.geoway.landteam.landcloud.model.resultshare.AppMediaCopyDto2;
import com.geoway.landteam.landcloud.servface.pub.MAppMediaService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.util.RedisSessionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.geolatte.geom.crs.Projection;
import org.locationtech.jts.geom.*;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MAppMediaServiceImpl implements MAppMediaService {

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    OssConfigRepository ossConfigDao;
    @Autowired
    MDataBizService mDataBizService;


    @Autowired
    JdbcTemplate jdbcTemplate;

    @Value("${project.uploadDir}")
    String uploadDir;

    @Autowired
    AppMediaRepository appMediaRepository;

    @Autowired
    private LandUserRepository landUserDao;
    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    private TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    UserNameService userNameService;

    @Override
    public List<Map> uploadTbTxt(HttpServletRequest request, String bizId, String fieldName, String tbId) {

        Long userId = RedisSessionUtils.checkAppOrWebLogin(request);

        TskTaskBiz tskTaskBiz = tskTaskBizRepository.gwSearchByPK(bizId);
        if (tskTaskBiz == null) {
            throw new RuntimeException("无该任务");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.gwSearchByPK(tskTaskBiz.getTableId());


        //txt数组
        List<String> tempList = new ArrayList<>();


        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;

        List<MultipartFile> multipartFiles = multiRequest.getFiles("file");
        InputStream inputStream = null;
        OutputStream outputStream = null;


        if (!multipartFiles.isEmpty()) {
            try {
                Iterator<MultipartFile> fileIte = multipartFiles.iterator();
                while (fileIte.hasNext()) {
                    MultipartFile multipartFile = fileIte.next();
                    inputStream = multipartFile.getInputStream();
                    String filePath = "media/" + userId + "/" + tbId + "/" + multipartFile.getOriginalFilename();
                    if (!filePath.endsWith(".txt")) {
                        throw new RuntimeException("请传入.txt文件");
                    }
                    String resultUrl = defaultOssOperatorService.sendObject2Oss(filePath, inputStream);
                    //查看是否有该附件 如果有则覆盖 不用加入到数组中
                    String exist = " select f_id from tb_app_media where f_galleryid ='" + tbId + "' " + " and f_serverpath = '" + resultUrl + "' and f_type = 6 ";
                    List<Map<String, Object>> existList = jdbcTemplate.queryForList(exist);
                    if (existList.isEmpty()) {
                        //增加的txt附件加入到数组
                        tempList.add(resultUrl);
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        //向media表插入记录
        if (!tempList.isEmpty()) {
            List<AppMedia> appMediaList = new ArrayList<>();
            for (String url : tempList) {
                AppMedia appMedia = new AppMedia();
                appMedia.setId(UUID.randomUUID().toString());
                appMedia.setGalleryid(tbId);
                appMedia.setServerpath(url);
                //txt type 为6
                appMedia.setType(6);
                appMedia.setTypetype(0);
                appMedia.setDeviceSource(0);
                appMediaList.add(appMedia);
            }
            appMediaRepository.saveAll(appMediaList);
        }
        //查找附件内容
        String findSql = "select f_id,f_serverpath from tb_app_media where f_galleryid='" + tbId + "' " + " and f_type = 6 " + " and f_serverpath like '%.txt'";
        List<Map<String, Object>> list = jdbcTemplate.queryForList(findSql);
        List<Map> mapList = new ArrayList<>();

        if (!list.isEmpty()) {
            for (Map<String, Object> map : list) {
                String id = map.get("f_id").toString();
                String name = map.get("f_serverpath").toString().substring(map.get("f_serverpath").toString().lastIndexOf("/") + 1);
                String url = map.get("f_serverpath").toString();
                Map temp = new HashMap();
                temp.put("id", id);
                temp.put("name", name);
                temp.put("url", url);
                mapList.add(temp);
            }
        }

        return mapList;
    }


    @Override
    public String delTbTxt(Long userId, String tbId, String bizId, String fileName, String fieldName) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.gwSearchByPK(bizId);
        if (tskTaskBiz == null) {
            throw new RuntimeException("无该任务");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.gwSearchByPK(tskTaskBiz.getTableId());

        //查询图斑下txt文件
        String sql = "select " + fieldName + " from " + tbtskObjectinfo.getfTablename() + " where f_id = '" + tbId + "'";
        String txtStr = jdbcTemplate.queryForObject(sql, String.class);
        //txt数组
        List<String> txtList = null;
        if (txtStr == null) {
            txtList = new ArrayList<>();
        } else {
            txtList = Arrays.asList(txtStr.split(","));
        }
        //用初始化构造器构造一次
        List<String> tempList = new ArrayList<>(txtList);

        if (!fileName.endsWith(".txt")) {
            fileName += ".txt";
        }
        //拼接完整路径
        String completePath = defaultOssOperatorService.getDomain() + "/" + "media/" + userId + "/" + tbId + "/" + fileName;
        //查找是否有要删除的文件
        if (tempList.indexOf(completePath) != -1) {
            tempList.remove(completePath);
        }

        String tempTxtStr = StringUtils.join(tempList.stream().distinct().collect(Collectors.toList()), ",");
        //保存到tb信息中
        String updateSql = "update " + tbtskObjectinfo.getfTablename() + " set " + fieldName + "='" + tempTxtStr + "'"
                + " where f_id = '" + tbId + "' ";
        jdbcTemplate.update(updateSql);

        return tempTxtStr;
    }

    @Override
    public List<AppMedia> queryByGalleryids(List<String> galleryids) {
        return appMediaRepository.queryByGalleryids(galleryids);
    }

    @Override
    public boolean isExist(String galleryId, String url) {
        return appMediaRepository.isExist(galleryId,url)>0;
    }

    @Override
    public void save(List<AppMedia> appMediaList) {
        appMediaRepository.saveAll(appMediaList);
    }

    @Override
    public int saveOne(AppMedia appMedia) {
        return appMediaRepository.save(appMedia) != null ? 1 : 0;
    }

    @Override
    public boolean deleteRecordAndStorage(List<String> galleryIds) {
        List<AppMedia> mediaList =  appMediaRepository.queryByGalleryids(galleryIds);
        if(mediaList!=null&&!mediaList.isEmpty())
        {
            for (AppMedia media:mediaList) {
                if(StringUtils.isNotBlank(media.getServerpath()))
                {
                    String url = media.getServerpath();
                    if(url.startsWith("https"))
                    {
                        url = url.replace("https","http");
                    }
                    else if(url.startsWith("HTTPS"))
                    {
                        url = url.replace("HTTPS","http");
                    }
                    else if(url.startsWith("HTTP"))
                    {
                        url = url.replace("HTTP","http");
                    }
                    if(url.startsWith("http"))
                    {
                        url = url.replace("http://","");
                        url = url.substring(url.indexOf('/')+1);
                    }
                    defaultOssOperatorService.deleteObject(url);
                }
            }
            appMediaRepository.deleteByGalleryids(galleryIds);
        }

        return true;
    }

    @Override
    public List<AppMedia> getByXYZ(Integer x, Integer y, Integer z) throws IOException {
        SysConfig poiConfig = sysConfigService.findOne("poiUrl");
        String url = poiConfig.getValue() + "?x=" + x + "&y=" + y + "&l=" + z;
        String result = HttpConnectionUtil.httpget(url);
        JSONArray array = JSONArray.parseArray(result);
        if (array.isEmpty()) {
            return null;
        } else {
            List<AppMedia> mediaList = this.getObjectByArray(array);
            Map<String, Object> queryParams = new HashMap<>();
            queryParams.put("x-image-process","image/resize,m_fixed,w_96,h_54");
            List<AppMedia> resultList = this.getAppMedia(mediaList, false, queryParams);
            return resultList;
        }
    }

    private List<AppMedia> getAppMedia(List<AppMedia> appMedias, boolean hasUsername, Map<String, Object> queryParams) {
        List<AppMedia> result = new ArrayList<>();
        for (int i = 0;i < appMedias.size(); i++){
            AppMedia appMedia = appMedias.get(i);
            AppMedia newMedia = new AppMedia();
            BeanUtils.copyProperties(appMedias.get(i),newMedia);
            if (newMedia.getServerpath()!=null) {
                newMedia.setServerpath(newMedia.getServerpath());
            }
            if (hasUsername) {
                if(org.apache.commons.lang3.StringUtils.isNotBlank(appMedia.getUsername())) {
                    String realname = userNameService.getUserRealNameByUserName(appMedia.getUsername());
                    if(StringUtils.isNotBlank(realname))
                    {
                        newMedia.setUsername(realname);
                    }
                } else{
                    newMedia.setUsername("未记录");
                }
            }

            result.add(newMedia);
        }
        return result;
    }

    private List<AppMedia> getObjectByArray(JSONArray array) {
        List<AppMedia> mediaList = new ArrayList<>();
        for (int i = 0; i < array.size(); i++) {
            JSONObject obj = array.getJSONObject(i).getJSONObject("properties");
            String id = obj.getString("f_id");
            String galleryid = obj.getString("f_galleryid");
            Double lon = obj.getDouble("y");
            Double lat = obj.getDouble("x");
            String serverpath = obj.getString("f_serverpath");
            String bizid = "";
            if (null != obj.get("f_bizid") && !"null".equals(obj.getString("f_bizid"))) {
                bizid = obj.getString("f_bizid");
            }
            String tablename = "";
            if (null != obj.get("f_tablename") && !"null".equals(obj.getString("f_tablename"))) {
                tablename = obj.getString("f_tablename");
            }
            String azimuth = obj.getString("f_azimuth");
            AppMedia media = new AppMedia();
            media.setId(id);
            media.setGalleryid(galleryid);
            media.setLat(lat);
            media.setLon(lon);
            media.setServerpath(serverpath);
            media.setAzimuth(azimuth);
            mediaList.add(media);
        }
        return mediaList;
    }

    private List<AppMedia> getObject(List<Map<String, Object>> list) {
        List<AppMedia> mediaList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> obj = list.get(i);
            String id = (String) obj.get("f_id");
            String galleryid = (String) obj.get("f_galleryid");
            Double lon = (Double) obj.get("f_lon");
            Double lat = (Double) obj.get("f_lat");
            String serverpath = (String) obj.get("f_serverpath");
            String bizid = (String) obj.get("f_bizid");
            String tablename = (String) obj.get("f_tablename");
            String azimuth = (String) obj.get("f_azimuth");
            AppMedia media = new AppMedia();
            media.setId(id);
            media.setGalleryid(galleryid);
            media.setLat(lat);
            media.setLon(lon);
            media.setServerpath(serverpath);
         /*   media.setBizid(bizid);*/
            media.setAzimuth(azimuth);
            mediaList.add(media);
        }
        return mediaList;
    }


    @Override
    public List<AppMedia> getMediaByBounds(String xmin, String ymin, String xmax, String ymax, Integer num) {
        BigDecimal xDisince = (new BigDecimal(xmax)).subtract(new BigDecimal(xmin)).divide(new BigDecimal(num));
        BigDecimal yDisince = (new BigDecimal(ymax)).subtract(new BigDecimal(ymin)).divide(new BigDecimal(num));
        String sql = "";
        long time1 = System.currentTimeMillis();
        for (int x = 0; x < num; x++) {
            for (int y = 0; y < num; y++) {
                BigDecimal tempXmin = (new BigDecimal(xmin)).add(xDisince.multiply(new BigDecimal(x)));
                BigDecimal tempXmax = (new BigDecimal(xmin)).add(xDisince.multiply(new BigDecimal(x + 1)));
                BigDecimal tempYmin = (new BigDecimal(ymin)).add(yDisince.multiply(new BigDecimal(y)));
                BigDecimal tempYmax = (new BigDecimal(ymin)).add(yDisince.multiply(new BigDecimal(y + 1)));
                String temp = " (select f_id,f_galleryid,f_lon,f_lat,f_serverpath,f_bizid,f_tablename,f_azimuth from tb_app_media where f_lon > " + tempYmin +
                        " and f_lon < " + tempYmax + " and  f_lat > " + tempXmin + " and f_lat < " + tempXmax + " and f_bizid is not null  limit 1 )";//order by f_time desc
                if (!"".equals(sql)) {
                    sql += " union all ";
                }
                sql += temp;
//                TbAppMedia media = this.appMediaRepository.queryByBound(tempXmin, tempYmin, tempXmax, tempYmax);
//                if (null != media)
//                    result.add(media);
            }
        }
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        List<AppMedia> mediaList = this.getObject(list);

        long time2 = System.currentTimeMillis();
        System.out.println(time2 - time1);

        Map<String, Object> queryParams = new HashMap<>();
        queryParams.put("x-image-process","image/resize,m_fixed,w_96,h_54");
        List<AppMedia> result = this.getAppMedia(mediaList, false, queryParams);

        long time3 = System.currentTimeMillis();
        System.out.println(time3 - time2);
        return result;
    }

    @Override
    public List<AppMedia> getAppMedia(List<AppMedia> appMedias) {
        return this.getAppMedia(appMedias, true, null);
    }

    @Override
    public List<AppMedia> getAllByBounds(String xmin, String ymin, String xmax, String ymax, Integer num) {
        String sql = " select f_id,f_galleryid,f_lon,f_lat,f_serverpath,f_bizid,f_tablename,f_azimuth,f_shape from tb_app_media where f_lon > " + ymin +
                " and f_lon < " + ymax + " and  f_lat > " + xmin + " and f_lat < " + xmax + " and f_bizid is not null order by f_time desc limit " + num;
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        List<AppMedia> mediaList = this.getObject(list);
        Map<String, Object> queryParams = new HashMap<>();
        queryParams.put("x-image-process","image/resize,m_fixed,w_96,h_54");
        List<AppMedia> result = this.getAppMedia(mediaList, false, queryParams);
        return result;
    }



    @Override
    public List<CommonNum> getStatisticsByType() {
        String sql = "select t4.f_scope,t5.f_sum from tbtsk_task_biz_application_group t4," +
                "(select t3.f_busicode, sum(t3.f_sum) as f_sum from " +
                "(select t2.*,t1.f_busicode from tbtsk_task_biz t1, " +
                "(select f_bizid, count(*) as f_sum from tb_app_media where f_bizid is not null GROUP BY f_bizid)t2 where t1.f_id = t2.f_bizid) t3" +
                " GROUP BY t3.f_busicode)t5 where t4.f_busicode = t5.f_busicode;";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        Long sum = 0l;
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            sum += Long.valueOf(obj.get("f_sum").toString());
        }
        List<CommonNum> result = new ArrayList<>();
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            CommonNum item = new CommonNum();
            item.setName((String) obj.get("f_scope"));
            Long num = Long.valueOf(obj.get("f_sum").toString());
            item.setNum(num);
            BigDecimal percent = BigDecimal.valueOf(num*100).divide(BigDecimal.valueOf(sum), 2, RoundingMode.DOWN);
            item.setPercent(percent);
            result.add(item);
        }
        return result;
    }


    @Override
    //@Transactional(rollbackFor = Exception.class)
    public void mediaMount(String taskId, String tbId, JSONObject subMedias) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.gwSearchByPK(taskId);
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());

        /*Map map = mDataBizService.selectByID(tbtskObjectinfo.getfTablename(), "f_id", "'" + tbId + "'");
        if(map.containsKey("f_splitedid") && StringUtils.isNotEmpty(MapUtils.getString(map, "f_splitedid", ""))){
            map = mDataBizService.selectByID(tbtskObjectinfo.getfTablename(), "f_id", "'" + MapUtils.getString(map, "f_splitedid", "") + "'");
        }
        Integer rejectCount = MapUtils.getInteger(map, "f_reject_count", 0);*/
        /*List<AppMedia> media = appMediaRepository.queryALLByGid(tbId);*/
        List<AppMedia> saveList = new ArrayList<>();
        Iterator<String> iterator = subMedias.keySet().iterator();
        while (iterator.hasNext()) {

            String next = iterator.next();
            //先删除对应所有照片，再进行新增挂接
            appMediaRepository.deleteByGalleryid(next);
            if(StringUtils.isEmpty(next) || "0".equals(next)){
                throw new RuntimeException("挂接失败，请刷新后重新选择子图斑挂接");
            }
            /*List<AppMedia> nextMedias = appMediaRepository.queryALLByGid(next);*/
            JSONArray jsonArray = subMedias.getJSONArray(next);
            if(jsonArray.size() > 0){//媒体挂接逻辑改造0809，完全按照挂接结果分配照片
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String id = jsonObject.getString("id");

                    List<AppMedia> ones = appMediaRepository.queryByIds(Arrays.asList(id));
                    AppMedia one = new AppMedia();
                    if(ones.size() > 0 ){
                        one = ones.get(0);
                    }else{
                        AppMedia entity = JSONObject.toJavaObject(jsonObject, AppMedia.class);
                        one = entity;
                        try {
                            if(URLDecoder.decode(one.getServerpath(),"UTF-8").indexOf("?")>0){
                                String decode = URLDecoder.decode(one.getServerpath(),"UTF-8");
                                one.setServerpath(decode.substring(0,decode.indexOf("?")));
                            }
                        } catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                    /*if(!one.getGalleryid().equals(next) ){*/
                        AppMedia temp = new AppMedia();
                        BeanUtils.copyProperties(one, temp, "galleryid","id");
                        if(temp.getServerpath().contains("AWSAccessKeyId")){
                            try {
                                String decode = URLDecoder.decode(temp.getServerpath(),"UTF-8");
                                temp.setServerpath(temp.getServerpath().substring(0,decode.indexOf("?")));
                            } catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        }
                        temp.setGalleryid(next);
                        temp.setId(UUID.randomUUID().toString());
                        // todo
                    Integer exist = appMediaRepository.isExist(temp.getGalleryid(), temp.getServerpath());
                    if(exist <= 0 ){
                        saveList.add(temp);
                    }
                   /* }*/
                }

            }
        }
        appMediaRepository.saveAll(saveList);
    }

    @Override
    public Page<AppMedia> findMediaList(String filterParam, String sortParam, int start, int limit) {
        Page<AppMedia> results = appMediaRepository.findAll(new QuerySpecification(filterParam), PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        return results;
    }

    @Override
    public Map<String, Object> findMediaDroneList(Integer deviceSource, Integer  type,  String  startTime,int page,int rows,String endTime, String sortParam)  {
        String sql = " select s.f_id id,s.f_galleryid galleryid,s.f_type type1,s.f_time time1,s.f_lon lon,s.f_lat lat,s.f_azimuth azimuth,s.f_pitch pitch,s.f_shape shape,s.f_videorecord videorecord,s.f_serverpath serverpath,s.f_mediatimelength mediatimelength,s.f_mediasize mediasize,s.f_fileid fileId,s.f_downloadurl downloadUrl,s.f_mark mark,s.f_typetype typetype,s.f_username username,s.f_group_code groupCode,s.f_media metaInfo,s.f_jym jym,s.f_viewurl viewUrl,s.f_appkey appKey,s.f_createtime createTime,s.f_tilestate tileState,s.f_tileurl tileUrl,s.f_scale scale,s.f_psgd psgd,s.f_takeofflon takeOffLon,s.f_takeofflat takeOffLat,s.f_takeoffrelheight takeOffHeight,s.f_device_source deviceSource,s.f_takeOffAltitude takeOffAltitude,s.f_psAltitude psAltitude,s.f_copyid copyid,s.f_bizid bizId,s.f_fromsource fromSource,s.f_tablename tableName,s.f_35mmfocal f35mmfocal,s.f_roll roll,s.f_dimwidth dimWidth,s.f_dimheight dimHeight,s.f_area area1,s.f_sm3 sm3\n" +
                "from (\n" +
                "    select *, row_number() over (partition by ttt.f_galleryid  order by ttt.f_time  desc) as group_idx\n" +
                "    from tb_app_media ttt where AAAAAA\n" +
                ") s\n" +
                "where s.group_idx = 1 ";
        String countsql = " select count(1)\n" +
                "from (\n" +
                "    select *, row_number() over (partition by ttt.f_galleryid  order by ttt.f_time  desc) as   group_idx\n" +
                "    from tb_app_media ttt where AAAAAA\n" +
                ") s\n" +
                "where s.group_idx = 1 ";
         String where = " 1 = 1"  ;
          if(deviceSource != null){
              where += " and ttt.f_device_source ='"+deviceSource+"'";
          }
          if(StringUtils.isNotBlank(startTime)){
              where += " and ttt.f_time >='"+converTime(startTime)+"'";
          }
          if(StringUtils.isNotBlank(endTime)){
              where += " and ttt.f_time <= '"+converTime(endTime)+"'";
          }
          if(type != null){
              where += " and ttt.f_type = '"+type+"'";
          }
          if(StringUtils.isNotBlank(sortParam)){
              if(sortParam.contains("DESC")){
                  sql += " order by s.f_time desc limit "+ rows +" offset "+ (page-1)*rows;
              }else{
                  sql += " order by s.f_time asc limit "+ rows +" offset "+ (page-1)*rows;
              }
          }
        List<Map<String, Object>> mediaList = jdbcTemplate.queryForList(sql.replace("AAAAAA",where));
          List<AppMedia> appMediaList = new ArrayList<>();
          if(mediaList.size() > 0){
              for(Map<String, Object> map : mediaList){
                  AppMedia appMedia = JSON.parseObject(JSON.toJSONString(map), AppMedia.class);
                  if(map.get("type1") != null){
                      appMedia.setType(Integer.valueOf(map.get("type1").toString()));
                  }
                  if(map.get("time1") != null){
                      appMedia.setTime(map.get("time1").toString());
                  }
                  if(map.get("area1") != null ){
                      appMedia.setArea(Double.valueOf(map.get("area1").toString()));
                  }
                  if (appMedia.getServerpath() != null && !appMedia.getServerpath().contains("AccessKeyId")) {
                      String url = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
                      if (StringUtils.isNotBlank(url)) {
                          appMedia.setServerpath(url);
                      }
                  }
                  appMediaList.add(appMedia);
              }
          }
        Long mediaCount = jdbcTemplate.queryForObject(countsql.replace("AAAAAA",where),Long.class);
        Map<String, Object> map = new HashMap<>();
        map.put("list", appMediaList);
        map.put("total",mediaCount);
        return map;
    }

    @Override
    public Map<String, Object> getMediaGroupList(Long userId, String taskId, String galleryId, String groupCode, String userName, String startTime, String endTime) {
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("groupCode",null);
       String temsql = "select s.f_id id,s.f_galleryid galleryid,s.f_type as type1,s.f_time as time1,s.f_lon lon,s.f_lat lat,s.f_azimuth azimuth,s.f_pitch pitch,s.f_shape shape,s.f_videorecord videorecord,s.f_serverpath serverpath,s.f_mediatimelength mediatimelength,s.f_mediasize mediasize,s.f_fileid fileId,s.f_downloadurl downloadUrl,s.f_mark mark,s.f_typetype typetype,s.f_username username,s.f_group_code groupCode,s.f_media metaInfo,s.f_jym jym,s.f_viewurl viewUrl,s.f_appkey appKey,s.f_createtime createTime,s.f_tilestate tileState,s.f_tileurl tileUrl,s.f_scale scale,s.f_psgd psgd,s.f_takeofflon takeOffLon,s.f_takeofflat takeOffLat,s.f_takeoffrelheight takeOffHeight,s.f_device_source deviceSource,s.f_takeOffAltitude takeOffAltitude,s.f_psAltitude psAltitude,s.f_copyid copyid,s.f_bizid bizId,s.f_fromsource fromSource,s.f_tablename tableName,s.f_35mmfocal f35mmfocal,s.f_roll roll,s.f_dimwidth dimWidth,s.f_dimheight dimHeight,s.f_area area1,s.f_sm3 sm3 from tb_app_media s  where f_device_source in('0','1')";
        //条件过滤
        String where = " and  f_galleryid ='"+galleryId+"' ";
        if(StringUtils.isNotBlank(userName)){
            where += " and f_username like '%"+userName+"%'";
        }
        if(StringUtils.isNotBlank(startTime)){
            where += " and f_time >='"+converTime(startTime)+"'";
        }
        if(StringUtils.isNotBlank(endTime)){
            where += " and f_time <= '"+converTime(endTime)+"'";
        }
        if(StringUtils.isNotBlank(groupCode)){
           if("1".equals(groupCode)){ //按年份（2024）分组
               String timeSql = "select to_char(to_timestamp((left(f_time,10))::int),'yyyy') as groupname,count(1) from tb_app_media tam  where f_device_source in('0','1') "+where+" group by groupname";
               List<Map<String,Object>> mapList=jdbcTemplate.queryForList(timeSql);
               resultMap.put("groupCode",mapList);
               JSONObject jsonObject = new JSONObject();
               for(Map<String,Object> map : mapList){
                   String time = map.get("groupname").toString();
                   String sql = temsql+ where +" and to_char(to_timestamp((left(f_time,10))::int),'yyyy')  = " +"'"+time+"' order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put(time,mapConvertObject(mediaList));
               }
               resultMap.put("groupList",jsonObject);
           }else if("2".equals(groupCode)){//2 月份（202405）
               String timeSql = "select to_char(to_timestamp((left(f_time,10))::int),'YYYY-MM') as groupname,count(1) from tb_app_media tam  where f_device_source in('0','1') "+where+" group by groupname";
               List<Map<String,Object>> mapList=jdbcTemplate.queryForList(timeSql);
               resultMap.put("groupCode",mapList);
               JSONObject jsonObject = new JSONObject();
               for(Map<String,Object> map : mapList){
                   String time = map.get("groupname").toString();
                   String sql = temsql+ where +" and to_char(to_timestamp((left(f_time,10))::int),'YYYY-MM')  = '"+time+"' order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put(time,mapConvertObject(mediaList));
               }
               resultMap.put("groupList",jsonObject);
           }else if("3".equals(groupCode)){// 3 拍摄人员
               String timeSql = "select f_username as groupname,count(1) from tb_app_media  where f_device_source in('0','1') "+where+" group by f_username";
               List<Map<String,Object>> mapList=jdbcTemplate.queryForList(timeSql);
               resultMap.put("groupCode",mapList);
               JSONObject jsonObject = new JSONObject();
               for(Map<String,Object> map : mapList){
                   String f_username = map.get("groupname").toString();
                   String sql = temsql+ where +" and f_username  = '"+f_username+"' order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put(f_username,mapConvertObject(mediaList));
               }
               resultMap.put("groupList",jsonObject);
           }else if("4".equals(groupCode)){// 4 按用户级别（县级作业员 市级 市级审核员 省级审核员）
               List<Map<String,Object>> groupList= new ArrayList<>();
               JSONObject jsonObject = new JSONObject();
               List<String> allUserName = new ArrayList<>();
               //县级作业员
               String xjSql = "select distinct (tu.f_username) from tbtsk_right_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='"+taskId+"'";
               List<Map<String,Object>> mapList=jdbcTemplate.queryForList(xjSql);
               List<String> userNames = new ArrayList<>();
               for(Map<String,Object> map : mapList){
                   userNames.add(map.get("f_username").toString());
               }
               if(userNames.size() > 0 ){
                   allUserName.addAll(userNames);
                   String sql = temsql+ where +" and f_username in('"+String.join("','",userNames)+"') order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put("县级",mapConvertObject(mediaList));

                   Map<String,Object> xjMap = new HashMap<>();
                   xjMap.put("count",mediaList.size());
                   xjMap.put("groupname","县级");
                   groupList.add(xjMap);
               }
              //市级
               String citySql = "select distinct (tu.f_username) from tbtsk_user_audit_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='"+taskId+"' and tra.f_level ='2'";
               List<Map<String,Object>> cityList=jdbcTemplate.queryForList(citySql);
               List<String> cityuserNames = new ArrayList<>();
               for(Map<String,Object> map : cityList){
                   cityuserNames.add(map.get("f_username").toString());
               }
               if(cityuserNames.size() > 0 ){
                   allUserName.addAll(cityuserNames);
                   String sql = temsql+ where +" and f_username  in('"+String.join("','",cityuserNames)+"') order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put("市级",mapConvertObject(mediaList));

                   Map<String,Object> cityMap = new HashMap<>();
                   cityMap.put("count",mediaList.size());
                   cityMap.put("groupname","市级");
                   groupList.add(cityMap);
               }
               //省级1
               String sjSql = "select distinct (tu.f_username) from tbtsk_user_audit_area tra,tbsys_user tu  where cast(tra.f_userid AS numeric) = tu.f_userid and  f_taskid ='"+taskId+"' and tra.f_level ='1'";
               List<Map<String,Object>> sjList=jdbcTemplate.queryForList(sjSql);
               List<String> sjuserNames = new ArrayList<>();
               for(Map<String,Object> map : sjList){
                   sjuserNames.add(map.get("f_username").toString());
               }
               if(sjuserNames.size() > 0 ){
                   allUserName.addAll(sjuserNames);
                   String sql = temsql+ where +" and f_username in('"+String.join("','",sjuserNames)+"') order by f_time desc";
                   List<Map<String,Object>> mediaList=jdbcTemplate.queryForList(sql);
                   jsonObject.put("省级",mapConvertObject(mediaList));

                   Map<String,Object> sjMap = new HashMap<>();
                   sjMap.put("count",mediaList.size());
                   sjMap.put("groupname","省级");
                   groupList.add(sjMap);
               }

               //如果所有级别用户名附件内都不存在 则加入县级
               if(!allUserName.isEmpty()){
                   String sql = temsql+ where +" and f_username not in('"+String.join("','",allUserName)+"') order by f_time desc";
                   List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
                   Object xj = jsonObject.get("县级");
                   if(xj != null){
                       List<AppMedia> temp = (List<AppMedia>) xj;
                       temp.addAll(mapConvertObject(maps));
                       resultMap.put("县级",temp);
                   }else{
                       resultMap.put("县级",mapConvertObject(maps));
                   }
               }
               resultMap.put("groupCode",groupList);
               resultMap.put("groupList",jsonObject);
           }
        }
        return resultMap;
    }

    @Override
    public List<AppMedia>getMedia(String excludeFrom,String excludeGid,String wkt,String startTime,String endTime,Integer limit) throws Exception {
        String sql = "select f_id as id,f_galleryid as galleryid,f_type as type,f_time as time,f_lon as lon,f_lat as lat,f_azimuth as azimuth,f_pitch as pitch,f_serverpath as serverpath,f_mediasize as mediasize,f_mark as mark,f_typetype as typetype,f_username as username,f_group_code as groupCode,f_psgd as psgd,f_takeofflon as takeOffLon,f_takeofflat as takeOffLat,f_takeoffrelheight as takeOffHeight,f_device_source as deviceSource,f_takeoffaltitude as takeOffAltitude,f_psaltitude as psAltitude,f_copyid as copyid,f_bizid as bizId, f_fromsource as fromSource,f_psfyj as psfyj,f_zsdm as zsdm from tb_app_media where 1 =1 ";
        List<String> wheres = new ArrayList<>();
        if(StringUtils.isNotBlank(excludeGid))
        {
            wheres.add("f_galleryid != '"+excludeGid+"'");
        }
        if(StringUtils.isNotBlank(excludeFrom))
        {
            wheres.add("(f_fromsource is null or f_fromsource != '"+excludeFrom+"')");
        }
        if (StringUtils.isNotBlank(wkt))
        {
            wheres.add(String.format("st_contains(ST_GeomFromText('%s'), st_geomfromtext('POINT(' || cast(f_lon as VARCHAR) || ' ' || cast(f_lat as VARCHAR) || ')'))",wkt));
        }
        if(StringUtils.isNotBlank(startTime))
        {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
               Date start=  df.parse(startTime);
               wheres.add("cast(f_time as INT8) >= "+start.getTime());
            }
            catch (Exception ex)
            {
                throw new Exception("时间格式错误，要求格式如下:yyyy-MM-dd");
            }
        }
        if(StringUtils.isNotBlank(endTime))
        {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end=  df.parse(endTime);
                long timestamp = end.getTime()+ 3600*24*1000;
                wheres.add("cast(f_time as INT8) <= "+timestamp);
            }
            catch (Exception ex)
            {
                throw new Exception("时间格式错误，要求格式如下:yyyy-MM-dd");
            }
        }
        if(!wheres.isEmpty())
        {
            sql+=" and "+StringUtils.join(wheres," and ");
        }
        if(limit!=null)
        {
            sql+=" order by f_time desc limit "+limit;
        }
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return null;
        List<AppMedia> appMediaList = new ArrayList<>();

        for(Map<String, Object> map : maps) {
            AppMedia appMedia = JSON.parseObject(JSON.toJSONString(map), AppMedia.class);
            appMediaList.add(appMedia);
        }
        return appMediaList;
    }


    @Override
    public List<AppMediaCopyDto2>getMediaForHebei(String excludeFrom,String excludeGid,String wkt,String startTime,String endTime,Integer limit) throws Exception {
        String sql = "select \n" +
                "m.f_id as id,\n" +
                "m.f_galleryid as galleryid,\n" +
                "m.f_type as type,\n" +
                "m.f_time as time,\n" +
                "m.f_lon as lon,\n" +
                "m.f_lat as lat,\n" +
                "m.f_azimuth as azimuth,\n" +
                "m.f_pitch as pitch,\n" +
                "m.f_serverpath as serverpath,\n" +
                "m.f_mediasize as mediasize,\n" +
                "m.f_mark as mark,\n" +
                "m.f_typetype as typetype,\n" +
                "m.f_username as username,\n" +
                "m.f_group_code as groupCode,\n" +
                "m.f_psgd as psgd,\n" +
                "m.f_takeofflon as takeOffLon,\n" +
                "m.f_takeofflat as takeOffLat,\n" +
                "m.f_takeoffrelheight as takeOffHeight,\n" +
                "m.f_device_source as deviceSource,\n" +
                "m.f_takeoffaltitude as takeOffAltitude,\n" +
                "m.f_psaltitude as psAltitude,\n" +
                "m.f_copyid as copyid,\n" +
                "m.f_bizid as bizId, \n" +
                "m.f_fromsource as fromSource,\n" +
                "m.f_psfyj as psfyj,\n" +
                "m.f_zsdm as zsdm \n" +
                "from tb_app_media m\n" +
                "where 1 =1  ";
        List<String> wheres = new ArrayList<>();
        if(StringUtils.isNotBlank(excludeGid))
        {
            wheres.add("m.f_galleryid != '"+excludeGid+"'");
        }
        if(StringUtils.isNotBlank(excludeFrom))
        {
            wheres.add("(m.f_fromsource is null or m.f_fromsource != '"+excludeFrom+"')");
        }
        if (StringUtils.isNotBlank(wkt))
        {
            wheres.add(String.format("st_contains(ST_GeomFromText('%s'), st_geomfromtext('POINT(' || cast(m.f_lon as VARCHAR) || ' ' || cast(m.f_lat as VARCHAR) || ')'))",wkt));
        }
        if(StringUtils.isNotBlank(startTime))
        {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date start=  df.parse(startTime);
                wheres.add("cast(m.f_time as INT8) >= "+start.getTime());
            }
            catch (Exception ex)
            {
                throw new Exception("时间格式错误，要求格式如下:yyyy-MM-dd");
            }
        }
        if(StringUtils.isNotBlank(endTime))
        {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end=  df.parse(endTime);
                long timestamp = end.getTime()+ 3600*24*1000;
                wheres.add("cast(m.f_time as INT8) <= "+timestamp);
            }
            catch (Exception ex)
            {
                throw new Exception("时间格式错误，要求格式如下:yyyy-MM-dd");
            }
        }
        if(!wheres.isEmpty())
        {
            sql+=" and "+StringUtils.join(wheres," and ");
        }
        sql+= " order by m.f_time desc ";
        if(limit!=null)
        {
            sql+=" limit "+limit;
        }
        List<Map<String,Object>>maps = jdbcTemplate.queryForList(sql);
        if(maps==null||maps.isEmpty())
            return null;
        List<AppMediaCopyDto2> appMediaList = new ArrayList<>();

        for(Map<String, Object> map : maps) {
            AppMediaCopyDto2 appMedia = JSON.parseObject(JSON.toJSONString(map), AppMediaCopyDto2.class);
            appMedia.formatYearMonth();
            appMediaList.add(appMedia);
        }
        return appMediaList;
    }


    public List<AppMedia> mapConvertObject( List<Map<String, Object>> mediaList){
        List<AppMedia> appMediaList = new ArrayList<>();
        if(mediaList.size() > 0){
            for(Map<String, Object> map : mediaList){
                AppMedia appMedia = JSON.parseObject(JSON.toJSONString(map), AppMedia.class);
                if(map.get("type1") != null){
                    appMedia.setType(Integer.valueOf(map.get("type1").toString()));
                }
                if(map.get("time1") != null){
                    appMedia.setTime(map.get("time1").toString());
                }
                if(map.get("area1") != null ){
                    appMedia.setArea(Double.valueOf(map.get("area1").toString()));
                }
                if (appMedia.getServerpath() != null && StringUtils.isNotBlank(appMedia.getServerpath()) && !appMedia.getServerpath().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", appMedia.getServerpath(), null);
                    if (StringUtils.isNotBlank(url)) {
                        appMedia.setServerpath(url);
                    }
                }
                appMediaList.add(appMedia);
            }
        }
        return appMediaList;
    }
    /**
     * 将字符串转为时间戳
     * @param time
     * @return
     */
    public static Long converTime(String time ) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime();
        } catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }



    /**
     * 得到照片四至范围组成的多边形
     * @param altitude  拍照高度
     * @param orientation   拍照方位角
     * @param yuntai        拍照云台角
     * @param angleOfView   相机镜头的视角角度
     * @param lon           拍照点经度
     * @param lat           拍照点纬度
     * @param isFollowOrientation 是否跟随方位角的改变而改变
     * @param ratio 宽/高的比值
     */
    public static List<GeoPoint> getPhotoRangePosList(Projection proj, double altitude, double orientation, double yuntai,
                                                    double angleOfView, double lon, double lat, boolean isFollowOrientation, float ratio){
        if (yuntai >= 0){
            //当云台角大于等于0时，无法绘制多边形
            return null;
        }

       /* GeoPoint gp_aircraft = new GeoPoint((int)(lon * 1E6), (int)(lat * 1E6));*/
        GeoPoint gp_aircraft = new GeoPoint(lon,lat);
        //1、根据云台角度求出拍照范围中心点到拍照点的水平距离r
        double r;
        if (yuntai == -90){
            r = 0;
        } else {
            r = altitude/Math.tan(Math.abs(Math.toRadians(yuntai)));
        }

        //2、根据r和相机覆盖范围的中心点所在象限求出相机覆盖范围的中心点坐标(x,y)
        double x = gp_aircraft.getX() + r * Math.sin(Math.toRadians(orientation));
        double y = gp_aircraft.getY() + r * Math.cos(Math.toRadians(orientation));

      /*  GeoPoint mapPos = new GeoPoint(x, y);*/
        GeoPoint mapPos = new GeoPoint(lon,lat);
       /* GeoPoint gp = GeoUtil.MapPos84ToGeoPoint(proj.toWgs84(mapPos));*/

        //3、计算相机覆盖范围的半径
        double h = altitude * Math.tan(Math.toRadians(angleOfView/2));

        //4、根据方位角计算出该圆的外接矩形四个点坐标
        List<GeoPoint> mapPosList = new ArrayList<>();

        //跟随照片长宽比的改变而改变
        if (isFollowOrientation){
            double radOri = Math.toRadians(orientation);
            //随着方位角的改变而改变的外接矩形
            GeoPoint mapPosLeftTop = new GeoPoint(mapPos.getX() - h*(Math.cos(radOri) - ratio * Math.sin(radOri)),
                    mapPos.getY() + h * (Math.cos(radOri) + ratio * Math.sin(radOri)));
            GeoPoint mapPosRightTop = new GeoPoint(mapPos.getX() + h * (Math.cos(radOri) + ratio * Math.sin(radOri)),
                    mapPos.getY() + h * (Math.cos(radOri) - ratio * Math.sin(radOri)));
            GeoPoint mapPosRightBottom = new GeoPoint(mapPos.getX() + h * (Math.cos(radOri) - ratio * Math.sin(radOri)),
                    mapPos.getY() - h * (Math.cos(radOri) + ratio * Math.sin(radOri)));
            GeoPoint mapPosLeftBottom = new GeoPoint(mapPos.getX() - h * (Math.cos(radOri) + ratio * Math.sin(radOri)),
                    mapPos.getY() - h * (Math.cos(radOri) - ratio * Math.sin(radOri)));
            mapPosList.add(mapPosLeftTop);
            mapPosList.add(mapPosRightTop);
            mapPosList.add(mapPosRightBottom);
            mapPosList.add(mapPosLeftBottom);

        } else {
            //正东南西北方向的外接矩形
            GeoPoint mapPosLeftTop = new GeoPoint(mapPos.getX() - h, mapPos.getY() + h*ratio);
            GeoPoint mapPosRightTop = new GeoPoint(mapPos.getX() + h, mapPos.getY() + h*ratio);
            GeoPoint mapPosRightBottom = new GeoPoint(mapPos.getX() + h, mapPos.getY() - h*ratio);
            GeoPoint mapPosLeftBottom = new GeoPoint(mapPos.getX() - h, mapPos.getY() - h*ratio);
            mapPosList.add(mapPosLeftTop);
            mapPosList.add(mapPosRightTop);
            mapPosList.add(mapPosRightBottom);
            mapPosList.add(mapPosLeftBottom);
        }
        return mapPosList;
    }

    public static void main(String[] args) throws ParseException {

        List<GeoPoint> geoPoints = getPhotoRangePosList(null,41.8,85,-14,77,114.496965,30.556861,true,1);
        /**
         * GeometryFactory工厂，参数一：数据精度 参数二空间参考系SRID
         */
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);

        /**
         * 熟知文本WKT阅读器，可以将WKT文本转换为Geometry对象
         */
        WKTReader wktReader = new WKTReader(geometryFactory);

        /**
         * Geometry对象，包含Point、LineString、Polygon等子类
         */
        Geometry geometry = wktReader.read("POINT (113.53896635 22.36429837)");

        /**
         * 将二进制流的形式读取Geometry对象
         */
        WKBReader wkbReader = new WKBReader(geometryFactory);

        /**
         * 单纯的一个坐标点，单点可以创建Point，多点可以创建LineString、Polygon等
         */
        Coordinate coordinate = new Coordinate(114.496965, 30.556861);
        Point point = geometryFactory.createPoint(coordinate);

        Polygon polygon = geometryFactory.createPolygon(new Coordinate[]{
                new Coordinate(geoPoints.get(0).getX(), geoPoints.get(0).getY()),
                new Coordinate(geoPoints.get(1).getX(), geoPoints.get(1).getY()),
                new Coordinate(geoPoints.get(2).getX(), geoPoints.get(2).getY()),
                new Coordinate(geoPoints.get(3).getX(), geoPoints.get(3).getY()),
                new Coordinate(geoPoints.get(0).getX(), geoPoints.get(0).getY())
        });
        Geometry geometry1 = point;
        Geometry geometry2 = polygon;

        /**
         * WKT输出器，将Geometry对象写出为WKT文本
         */
        WKTWriter wktWriter = new WKTWriter();
        String write = wktWriter.write(point);
    }

}
