package com.geoway.landteam.landcloud.service.pub.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.repository.base.RegionVillageRepository;
import com.geoway.landteam.landcloud.servface.pub.MPatrolPlanScopeKeyAreaService;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeKeyAreaMapper;
import com.geoway.landteam.patrolclue.mapper.patrollibrary.PatrolPlanScopeMapper;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlan;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScope;
import com.geoway.landteam.patrolclue.model.patrollibrary.entity.PatrolPlanScopeKeyArea;
/*import com.gw.base.data.GwValidateException;*/
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @Author limihao
 * @Date 2022/5/18 11:08
 * @ClassName PatrolPlanScopeKeyAreaServiceImpl
 **/
@Service
public class MPatrolPlanScopeKeyAreaServiceImpl implements MPatrolPlanScopeKeyAreaService {
    @Autowired
    PatrolPlanScopeKeyAreaMapper patrolPlanScopeKeyAreaMapper;
    @Autowired
    RegionVillageRepository regionVillageRepository;
    @Autowired
    PatrolPlanMapper patrolPlanMapper;
    @Autowired
    PatrolPlanScopeMapper patrolPlanScopeMapper;
    @Override
    public void createKeyArea(String planId, String scopeId, JSONArray array) throws ParseException {
        PatrolPlan one = patrolPlanMapper.selectByPrimaryKey(planId);
        PatrolPlanScope one1 = patrolPlanScopeMapper.selectByPrimaryKey(scopeId);
        if (one == null || one1 == null) {
            throw new RuntimeException("计划或计划范围不存在");
        }
        String maxId = patrolPlanScopeKeyAreaMapper.queryMaxByPlanIdAndScopeId(planId, scopeId);
        if(StringUtils.isBlank(maxId)){
            maxId = "-1";
        }
        int index = Integer.parseInt(maxId);
        List<PatrolPlanScopeKeyArea> keyAreas = new ArrayList<>();
        for (int i = 0; i < array.size(); i++) {
            JSONObject object = array.getJSONObject(i);
            index = index+1;
            PatrolPlanScopeKeyArea keyArea = new PatrolPlanScopeKeyArea();
            String wkt = object.getString("wkt");
            String area = object.getString("area");
            Geometry geometry = WKTUtil.wktToGeom(wkt);
            List<RegionVillage> regionVillages = regionVillageRepository.queryContains1(wkt);
            if (regionVillages != null && !regionVillages.isEmpty()) {
                RegionVillage regionVillage = regionVillages.get(0);
                keyArea.setfXzqdm(regionVillage.getCode());
                keyArea.setfXzqmc(regionVillage.getName());
            }
            keyArea.setfDkbh("ZD"+String.format("%04d",index));
            keyArea.setfArea(area);
            keyArea.setfPlanid(planId);
            keyArea.setfScopeid(scopeId);
            keyArea.setfShape(geometry);
            keyArea.setfId(UUID.randomUUID().toString());
            keyAreas.add(keyArea);
        }
        if(!keyAreas.isEmpty()){
            patrolPlanScopeKeyAreaMapper.insertList(keyAreas);
        }
    }

    @Override
    public List<PatrolPlanScopeKeyArea> getByPlanId(String planId) {
        return patrolPlanScopeKeyAreaMapper.getByPlanId(planId);
    }

    @Override
    public void deleteById(String id) {
        patrolPlanScopeKeyAreaMapper.deleteByPrimaryKey(id);
    }
}
