package com.geoway.landteam.landcloud.service.pub.impl;

import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

/**
 * Created by licong on 2021/6/25.
 */
@Service
public class MinIOServiceImpl implements MinIOService {

    private MinioClient minioClient;
    private MinioClient innerMinioClient;
    private OssConfig config;
    @Autowired
    private OssConfigRepository ossConfigDao;

    @Override
    public void addToBucket(String bucketPath, String filePath) throws Exception {
        // 检查存储桶是否已经存在
        MinioClient client = this.getInnerMinioClient();
        OssConfig ossConfig = this.getConfig();
//        boolean isExist = client.bucketExists(ossConfig.getBucketName());
//        if(!isExist) {
//            client.makeBucket(ossConfig.getBucketName());
//        }
        bucketPath = bucketPath.replace("\\", "/");
        //client.putObject( ossConfig.getBucketName(), bucketPath, filePath, null);
        InputStream is = new FileInputStream(filePath);
        long size =is.available();
        long partSize = 102400l;
        PutObjectArgs args = PutObjectArgs.builder().bucket(ossConfig.getBucketName()).object(filePath).stream(is,size,partSize).build();
        client.putObject(args);
    }

    @Override
    public String getUrl(String objectName) throws Exception  {
        objectName = objectName.replace("\\", "/");
        OssConfig ossConfig = this.getConfig();
        GetPresignedObjectUrlArgs args = GetPresignedObjectUrlArgs.builder().expiry(3600, TimeUnit.SECONDS).bucket(ossConfig.getBucketName()).object(objectName).build();
        return this.getMinioClient().getPresignedObjectUrl(args);
    }

    @Override
    public byte[] getByte(String objectName) throws Exception {
        objectName = objectName.replace("\\", "/");
        OssConfig ossConfig = this.getConfig();
        GetObjectArgs args = GetObjectArgs.builder().bucket(ossConfig.getBucketName()).object(objectName).build();
        InputStream inputStream = this.getMinioClient().getObject(args);
        byte[] result = IOUtils.toByteArray(inputStream);
        inputStream.close();
        return result;
    }

    @Override
    public String getHeaderUrl() {
        return this.getConfig().getEndPoint();
    }

    private OssConfig getConfig(){
        if (null == this.config) {
            OssConfig config = this.ossConfigDao.queryByType("minio");
            this.config = config;
        }
        return this.config;
    }

    private MinioClient getMinioClient()  {
        if (null == this.minioClient) {
            OssConfig config = this.getConfig();
            //this.minioClient = new MinioClient(config.getEndPoint(), config.getKey(), config.getKeySecret());
            this.innerMinioClient =MinioClient.builder().endpoint(config.getEndPoint()).credentials(config.getKey(),config.getKeySecret()).build();
        }
        return this.minioClient;
    }

    private MinioClient getInnerMinioClient() {
        if (null == this.innerMinioClient) {
            OssConfig config = this.getConfig();
            //this.innerMinioClient = new MinioClient(config.getInnerEndPoint(), config.getKey(), config.getKeySecret());
            this.innerMinioClient =MinioClient.builder().endpoint(config.getInnerEndPoint()).credentials(config.getKey(),config.getKeySecret()).build();
        }
        return this.innerMinioClient;
    }
}
