package com.geoway.landteam.landcloud.service.satelliteCenter;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskWpzfAttrRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.dto.TbtskTaskPiwenDto;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskWpzfAttr;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.oss.OssConfig;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.dao.pub.AppMediaDao;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.satelliteCenter.TbWxzxRecordDao;
import com.geoway.landteam.landcloud.dao.satelliteCenter.TbWxzxRecordFileDao;
import com.geoway.landteam.landcloud.mapper.satelliteCenter.TbWxzxRecordFileMapper;
import com.geoway.landteam.landcloud.mapper.satelliteCenter.TbWxzxRecordMapper;
import com.geoway.landteam.landcloud.model.satelliteCenter.dto.ReportDataDto;
import com.geoway.landteam.landcloud.model.satelliteCenter.dto.ReportFileDto;
import com.geoway.landteam.landcloud.model.satelliteCenter.entity.TbWxzxRecord;
import com.geoway.landteam.landcloud.model.satelliteCenter.entity.TbWxzxRecordFile;
import com.geoway.landteam.landcloud.servface.base.dto.AppMediaDTO;
import com.geoway.landteam.landcloud.servface.other.ImportOtherDataService;
import com.geoway.landteam.landcloud.servface.satelliteCenter.TbWxzxRecordService;
import com.geoway.landteam.landcloud.service.customtask.task.TbtskTaskPiwenService;
import com.gw.base.data.model.annotation.GaModelField;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilStr;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.persistence.Column;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.server.ExportException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import org.springframework.web.multipart.MultipartFile;

import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

/**
 * @className: TbWxzxRecordServiceImpl
 * @author: halberd
 * @description: TODO
 * @date: 2024/11/18
 * @version: 1.0
 */
@Service
public class TbWxzxRecordServiceImpl implements TbWxzxRecordService {

    private final GiLoger logger = GwLoger.getLoger(TbWxzxRecordServiceImpl.class);
    @Value("${project.downloadDir}")
    String localDownload;
    @Value("${project.uploadDir}")
    String localUpload;

    @Value("${satelliteCenter.loginUrl}")
    String serverLoginUrl;

    @Value("${satelliteCenter.infoUrl}")
    String serverInfoUrl;

    @Value("${satelliteCenter.fileUrl}")
    String serverFileUrl;

    @Value("${satelliteCenter.username}")
    String serverUsername;

    @Value("${satelliteCenter.password}")
    String serverPassword;


    @Resource
    TbWxzxRecordDao tbWxzxRecordDao;

    @Resource
    TbWxzxRecordFileMapper tbWxzxRecordFileMapper;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Resource
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Resource
    JdbcTemplate jdbcTemplate;

    @Autowired
    TbtskTaskPiwenService tbtskTaskPiwenService;

    @Autowired
    AppMediaDao appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    ImportOtherDataService importOtherDataService;

    @Autowired
    OssConfigRepository ossConfigRepository;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    private static Map<String,OssConfig> mapOssConfig = new HashMap<>();
    /**
     * 保存上报记录
     * @param tbWxzxRecord
     * @return
     */
    @Override
    public TbWxzxRecord saveOrUpdate(TbWxzxRecord tbWxzxRecord){
        if(StringUtils.isNotEmpty(tbWxzxRecord.getId()))
            tbWxzxRecordDao.gwUpdateByPK(tbWxzxRecord);
        else{
            tbWxzxRecord.setId(UUID.randomUUID().toString().replace("-",""));
            tbWxzxRecordDao.gwAccess(tbWxzxRecord);
        }
        return tbWxzxRecord;
    }

    /**
     * 保存附件记录
     * @param tbWxzxRecordFile
     * @return
     */
    public TbWxzxRecordFile saveOrUpdateFile(TbWxzxRecordFile tbWxzxRecordFile){
        if(StringUtils.isNotEmpty(tbWxzxRecordFile.getId()))
            tbWxzxRecordFileMapper.gwUpdateByPK(tbWxzxRecordFile);
        else{
            tbWxzxRecordFile.setId(UUID.randomUUID().toString().replace("-",""));
            tbWxzxRecordFileMapper.gwAccess(tbWxzxRecordFile);
        }
        return tbWxzxRecordFile;
    }

    /**
     * 获取已关联附件信息
     * @param dkid
     * @param taskid
     * @return
     */
    public Map<String,TbWxzxRecordFile> findFilesInfo(String dkid,String taskid){
       List<TbWxzxRecordFile> ls = tbWxzxRecordFileMapper.selectByTaskidAndDkid(taskid,dkid);
       if(ls==null){
           return new HashMap<>();
       }
       return ls.stream().collect(Collectors.toMap(TbWxzxRecordFile::getLocalUrl, item -> item));
    }



    @Override
    public void updateReportData(Map<String,Object> map,String taskId,String token){

        TbWxzxRecord tbWxzxRecord = new TbWxzxRecord();
        tbWxzxRecord.setTbid(map.get("f_id").toString());
        tbWxzxRecord.setTaskid(taskId);
        tbWxzxRecord.setTime(new Date());
        try{
            String errMsg= "";
            ReportDataDto reportDataDto = new ReportDataDto();
            String zgqk = String.valueOf(map.get("f_zglsqk"));
            boolean isBb = false;
            boolean isCcfk = false;
            String[] arr = zgqk.split("&");
            for(String str : arr){
                if("补办手续".equals(str)){
                    isBb = true;
                }
                else if("拆除复耕".equals(str)){
                    isCcfk = true;
                }
            }
            //地块编号 是
            if(map.get("f_dkbh")!=null){
                reportDataDto.setDkbh(String.valueOf(map.get("f_dkbh")));
            } else{
                errMsg+="地块编号为空;";
            }


            if(map.get("f_xzqdm")!=null) {
                String xzqdm = String.valueOf(map.get("f_xzqdm"));
                if(xzqdm.length()>6){
                    xzqdm = xzqdm.substring(0,6);
                }
                //行政区代码 是
                reportDataDto.setXzqdm(xzqdm);
            } else {
                errMsg+="行政区代码为空;";
            }
            //年份 是
            String year = "";
            if(map.get("f_jcpc")!=null){
                year = String.valueOf(map.get("f_jcpc"));
                reportDataDto.setYear(year);
            } else {
                errMsg+="年份为空;";
            }
            //整改进展情况（0-未知，1-已整改到位，2-未整改到位，3-部分整改，4-非粮化图斑）
            //当前默认 1,后续会有4 是
            reportDataDto.setZglsdw(1);
            //拆除复垦（耕）面积（单位：亩） 是
            if(map.get("f_hftdy_n2")!=null){
                reportDataDto.setCcmj(Double.parseDouble(map.get("f_hftdy_n2").toString()));
            } else {
                if(isCcfk){
                    errMsg+="拆除复垦（耕）面积为空;";
                } else {
                    reportDataDto.setCcmj(0d);
                }
            }
            //拆除复垦（耕）其中耕地面积（单位：亩） 是
            if(map.get("f_fgdwmj")!=null){
                reportDataDto.setCcgdmj(Double.parseDouble(map.get("f_fgdwmj").toString()));
            } else {
                if(isCcfk) {
                    errMsg += "拆除复垦（耕）其中耕地面积为空;";
                } else {
                    reportDataDto.setCcgdmj(0d);
                }
            }
            //拆除复垦（耕）其中永久基本农田面积（单位：亩） 是
            if(map.get("f_ccyjj_n2")!=null){
                reportDataDto.setCcyjjbntmj(Double.parseDouble(map.get("f_ccyjj_n2").toString()));
            } else {
                if(isCcfk) {
                    errMsg += "拆除复垦（耕）其中永久基本农田面积为空;";
                } else {
                    reportDataDto.setCcyjjbntmj(0d);
                }
            }
            //完善用地手续面积（单位：亩） 是
            if(map.get("f_bbmjm_n1")!=null){
                reportDataDto.setWsmj(Double.parseDouble(map.get("f_bbmjm_n1").toString()));
            } else {
                if(isBb){
                    errMsg+="完善用地手续面积为空;";
                } else {
                    reportDataDto.setWsmj(0d);
                }
            }
            //完善用地手续其中耕地面积（单位：亩） 是
            if(map.get("f_bbgdmj")!=null){
                reportDataDto.setWsgdmj(Double.parseDouble(map.get("f_bbgdmj").toString()));
            } else {
                if(isBb) {
                    errMsg += "完善用地手续其中耕地面积为空;";
                } else {
                    reportDataDto.setWsgdmj(0d);
                }
            }
            //完善用地手续其中永久基本农田面积（单位：亩） 是
            if(map.get("f_bbjbntmj")!=null){
                reportDataDto.setWsyjjbntmj(Double.parseDouble(map.get("f_bbjbntmj").toString()));
            } else {
                if(isBb) {
                    errMsg += "完善用地手续其中永久基本农田面积为空;";
                } else {
                    reportDataDto.setWsyjjbntmj(0d);
                }
            }

            //填报次数（多轮填报） 必填 系统有一轮填报二轮填报的顺序，具体体现在times字段
            //reportDataDto.setTimes(1);
            Long times = findReportTimes(tbWxzxRecord.getTbid(),tbWxzxRecord.getTaskid());
            times++;
            reportDataDto.setTimes(times.intValue());

            //是否属于农村乱占耕地建房存量问题(0-未知，1-是，2-否) 非必填
            //系统无该字段，本次默认传0-未知后期在任务结构中添加该字段
            //reportDataDto.setNrnclzgdjf(0);
            //农村乱占耕地建房存量问题编号 非必填
            //其他情况- 下一步整改措施（0-未知，1-拆除复垦（耕），2-完善用地手续，3-两者相结合）非必填
            //本次汇交不填后期在任务结构中添加该字段
            //其他情况- 拟完成整改时间（毫秒数） 非必填
            //本次汇交不填后期在任务结构中添加该字段
            //省级审核通过 31 是
            reportDataDto.setTaskStatus(31);
            //裁切后矢量	整改任务允许图斑分割，不填	非必填
            //填报最后提交时间（毫秒数） 是
            if(map.get("f_committime")!=null){
                reportDataDto.setLastSubmitTime(Long.parseLong(map.get("f_committime").toString()));
            } else{
                errMsg+="填报最后提交时间为空;";
            }

            if(map.get("f_upload_userid")!=null){
                reportDataDto.setReportPerson(map.get("f_upload_userid").toString());
                reportDataDto.setHeadPerson(map.get("f_upload_userid").toString());
            } else{
                errMsg+="填报人、负责人为空;";
            }
            if(map.get("f_approve_user")!=null){
                reportDataDto.setCheckName(map.get("f_approve_user").toString());
            } else{
                errMsg+="省级审核人名称为空;";
            }
            if(map.get("f_approve_time")!=null){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                reportDataDto.setCheckTime(sdf.parse(map.get("f_approve_time").toString()).getTime());
            } else{
                errMsg+="省级审核通过时间为空;";
            }

            tbWxzxRecord.setRegionCode(reportDataDto.getXzqdm());
            try{
                //采用图斑编号吧
                String dkbh = String.valueOf(map.get("f_id").toString());
                Map<String,TbWxzxRecordFile> fileMap = findFilesInfo(dkbh,taskId);
                if(StringUtils.isEmpty(errMsg)){
                    List<String> errLs = new ArrayList<>();
                    boolean isHaveFile = false;
                    List<ReportFileDto> attatchs = new ArrayList<>();
                    List<ReportFileDto> files1 = findTaskTbPiwen(fileMap,taskId,map.get("f_id").toString(),year,token,errLs);
                    if(!files1.isEmpty()){
                        attatchs.addAll(files1);
                        isHaveFile = true;
                    }
                    Map<String,Boolean> flgMap = new HashMap<>();
                    flgMap.put("ccfkHave",false);
                    flgMap.put("bbHave",false);
                    List<ReportFileDto> files2 =findTaskMediaFile(fileMap,taskId,map.get("f_id").toString(),year,token,zgqk,flgMap,errLs);
                    if(!files2.isEmpty()){
                        attatchs.addAll(files2);
                    }
                    if(isBb){
                        if(!isHaveFile && !flgMap.get("bbHave")){
                            errMsg+="当填写完善用地手续面积时，必须上传证明材料;";
                        }
                    }
                    if(isCcfk && !flgMap.get("ccfkHave")){
                        errMsg+="当填写拆除复垦（耕）面积时，必须上传外业照片;";
                    }
                    if(attatchs==null || attatchs.isEmpty()){
                        errMsg+="没有任务附件信息;";
                    }
                    reportDataDto.setFiles(attatchs);

                    if(StringUtils.isEmpty(errMsg)){
                        tbWxzxRecord.setTbRecord(JSONObject.toJSONString(reportDataDto));
                        reportData(token,reportDataDto,tbWxzxRecord);
                        tbWxzxRecord.setTbState(1);
                    } else {
                        tbWxzxRecord.setTbState(2);
                    }
                    if(!errLs.isEmpty()){
                        errMsg+=String.join("**附件错误:",errLs);
                    }
                }else{
                    tbWxzxRecord.setTbState(2);
                }
            } catch (Exception ex){
                errMsg+=ex.getMessage();
                tbWxzxRecord.setTbState(2);
            }
            tbWxzxRecord.setTbErr(errMsg);
        } catch (Exception e){
            tbWxzxRecord.setTbState(2);
            tbWxzxRecord.setTbErr(e.getMessage());
        } finally {
            saveOrUpdate(tbWxzxRecord);
        }

    }


    /**
     * 开始进行数据上报
     */
    @Override
    public void startReportData(){
        String taskId = "e6dcb7e3-0b7c-4964-b77c-6f07e8acaf01";
        try{
            String token = getToken();
            List<Map<String,Object>>  reportList = findUnReportData(taskId);
            if(reportList!=null && !reportList.isEmpty()){
                for(Map<String,Object> map:reportList){
                    updateReportData(map, taskId, token);
                }
            }
        }catch (Exception exception){
            logger.error(exception.getMessage());
        }
    }

    /**
     * 获取已提交次数
     * @param tbid
     * @param taskid
     * @return
     */
    public Long findReportTimes(String tbid,String taskid){
        String sql = "select count(1) as ct from tb_wxzx_record where tb_state=1 and tbid='"+ tbid +"' and taskid='"+ taskid +"'";
        Map<String,Object> map =  jdbcTemplate.queryForMap(sql);
        //jdbcTemplate.queryForList();
        return Long.parseLong(map.get("ct").toString());
    }


    /**
     * 获取指定任务的未上报卫星中心的省级审核通过的数据
     * @param taskId
     * @return
     * @throws Exception
     */
    @Override
    public List<Map<String,Object>> findUnReportData(String taskId) throws Exception {
        TskTaskBiz task = tskTaskBizService.findByTaskId(taskId);
        if(task==null)
        {
            throw new Exception("任务不存在");
        }
        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.getObjectByTableId(task.getTableId());
        if(objectinfo==null)
        {
            throw new Exception("任务表对象不存在");
        }
        if(StringUtils.isBlank(objectinfo.getfTablename()))
        {
            throw new Exception("任务表对象表名为空");
        }
//        String sql = " select m.bdkbh as f_dkbh,m.is_unique,t.f_id,t.f_zglsqk,t.f_xzqdm,t.f_jcpc," +
//                "t.f_hftdy_n2,t.f_fgdwmj,t.f_ccyjj_n2,t.f_bbmjm_n1,t.f_bbgdmj,t.f_bbjbntmj," +
//                "t.f_committime,t.f_reject_count,t.f_upload_userid,r.f_approve_user,r.f_approve_time" +
//                " from tb_1125 m left join "+ objectinfo.getfTablename() +" t on m.btbbh = t.f_dkbh left join tbtsk_approve_record r on r.f_tbid=t.f_id and r.f_stepname='省级审核' and r.f_taskid='"+ taskId +"'" +
//                " where m.is_unique=0 and t.f_review_stage=101 and t.f_status=10 and " +
//                " t.f_id not in (select tbid from tb_wxzx_record where (tb_state=0 or tb_state=1) and taskid='" + taskId +"') ";
        String sql = " select m.bdkbh as f_dkbh,m.is_unique,t.f_id,t.f_zglsqk,t.f_xzqdm,t.f_jcpc," +
                "t.f_hftdy_n2,t.f_fgdwmj,t.f_ccyjj_n2,t.f_bbmjm_n1,t.f_bbgdmj,t.f_bbjbntmj," +
                "t.f_committime,t.f_reject_count,t.f_upload_userid," +
                "(select r.f_approve_user from tbtsk_approve_record r where r.f_tbid=t.f_id and r.f_stepname='省级审核' and r.f_taskid='"+ taskId +"' and r.f_option =1 limit 1) f_approve_user," +
                "(select r.f_approve_time from tbtsk_approve_record r where r.f_tbid=t.f_id and r.f_stepname='省级审核' and r.f_taskid='"+ taskId +"' and r.f_option =1 limit 1) f_approve_time" +
                " from tb_1125 m left join "+ objectinfo.getfTablename() +" t on m.btbbh = t.f_dkbh " +
                //"left join tbtsk_approve_record r on r.f_tbid=t.f_id and r.f_stepname='省级审核' and r.f_option =1 and r.f_taskid='"+ taskId +"'" +
                " where m.is_unique=0 and t.f_review_stage=101 and t.f_status=10 and " +
                " t.f_id not in (select tbid from tb_wxzx_record where (tb_state=0 or tb_state=1) and taskid='" + taskId +"') ";
                //+ " and t.f_id in ('a3a0e9ed-7ecd-4661-a42f-bc14341c8d74','1cb7a9c9-bbb2-4a35-bba3-8b82ddf45f55','1da6fa20-3602-4b8e-9bc5-9957a4d5b68d','3e30dfdd-f30b-42d9-af11-bbe1025753c9')";
        return jdbcTemplate.queryForList(sql);
    }

    /**
     * 根据任务ID和图斑ID获取对应的批文文件
     * @param taskid
     * @param tbid
     * @return
     */
    public List<ReportFileDto>  findTaskTbPiwen(Map<String,TbWxzxRecordFile> fileMap,String taskid, String tbid,String year,String token,List<String> errLs) throws Exception {
        List<TbtskTaskPiwenDto> ls = tbtskTaskPiwenService.findPiwenByTaskIdAndDataId(taskid,tbid,null);
        List<ReportFileDto> fileList = new ArrayList<>();
        String dir = localDownload + File.separator + "pw";
        if(ls!=null && !ls.isEmpty()){
            for(TbtskTaskPiwenDto piwen : ls){
                if(StringUtils.isEmpty(piwen.getPzrq()))
                    throw new Exception("批文信息id["+piwen.getId() +"]:批准日期为空");
                if(StringUtils.isEmpty(piwen.getPzwh()))
                    throw new Exception("批文信息id["+piwen.getId() +"]:批准文号为空");
                if(piwen.getPzmj()==null)
                    throw new Exception("批文信息id["+piwen.getId() +"]:批准面积为空");
                //批准时间
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
                Long pzsj = sdf.parse(piwen.getPzrq()).getTime();//*
                //批准文号 *
                String pzwh = piwen.getPzwh();
                //批准面积 *
                Double pzmj = piwen.getPzmj();
                Double pznydmj = piwen.getPznydmj();
                Double pzgdmj = piwen.getPzgdmj();
                Double pzyjjbntmj = piwen.getPzyjjbntmj();
                String pzjg = piwen.getPzjg();
                String pwfj = piwen.getPwfj();
                String pwfjSl = piwen.getPwplfj();
                String pwlx ="";
                if("1".equals(piwen.getType())){
                    pwlx = "农用地转用";
                } else if("2".equals(piwen.getType())){
                    pwlx = "增减挂钩";
                } else if("3".equals(piwen.getType())){
                    pwlx = "工矿废弃地复垦建新";
                } else if("4".equals(piwen.getType())){
                    pwlx = "先行用地";
                } else if("5".equals(piwen.getType())){
                    pwlx = "不动产权证书 （含土地使用权证等）";
                } else if("6".equals(piwen.getType())){
                    pwlx = "其他合法用地手续";
                } else if("7".equals(piwen.getType())){
                    pwlx = "土地供应";
                } else if("8".equals(piwen.getType())){
                    pwlx = "设施农用地";
                } else if("9".equals(piwen.getType())){
                    pwlx = "临时用地";
                }
                if(StringUtils.isEmpty(piwen.getType()))
                    throw new Exception("批文信息id["+piwen.getId() +"]:批准类型为空");
                //批准文件
                if(StringUtils.isNotEmpty(pwfj)){
                    //String url = temporarySignedUrlService.getTemporarySignedUrl(defaultOssOperatorService.getDefaultOssConfig().getServerId().toString(), pwfj, null);
                    String url = pwfj;
                    ReportFileDto dto = new ReportFileDto();
                    dto.setFileType(5);
                    dto.setPzwh(pzwh);
                    dto.setPzmj(pzmj);
                    dto.setPzsj(pzsj);
                    dto.setPznydmj(pznydmj);
                    dto.setPzgdmj(pzgdmj);
                    dto.setPzyjjbntmj(pzyjjbntmj);
                    dto.setPzjg(pzjg);
                    dto.setPwlx(pwlx);
                    try{
                        if(!findFileDetail(url,dto,fileMap)){
                            getAndUploadFile(url,dto,year,token,dir);
                            saveFile(url,dto,taskid,tbid);
                        }
                        fileList.add(dto);
                    } catch (Exception ex){
                        errLs.add(ex.getMessage());
                        logger.error(ex.getMessage());
                        //continue;
                        //throw ex;
                    }
                }
                //批准矢量文件
                if(StringUtils.isNotEmpty(pwfjSl)){
                    //String url = temporarySignedUrlService.getTemporarySignedUrl(defaultOssOperatorService.getDefaultOssConfig().getServerId().toString(), pwfjSl, null);
                    String url = pwfjSl;
                    ReportFileDto dto = new ReportFileDto();
                    dto.setFileType(5);
                    dto.setPzwh(pzwh);
                    dto.setPzmj(pzmj);
                    dto.setPzsj(pzsj);
                    dto.setPznydmj(pznydmj);
                    dto.setPzgdmj(pzgdmj);
                    dto.setPzyjjbntmj(pzyjjbntmj);
                    dto.setPzjg(pzjg);
                    dto.setPwlx(pwlx);
                    try{
                        if(!findFileDetail(url,dto,fileMap)){
                            getAndUploadFile(url,dto,year,token,dir);
                            saveFile(url,dto,taskid,tbid);
                        }
                        fileList.add(dto);
                    } catch (Exception ex){
                        errLs.add(ex.getMessage());
                        logger.error(ex.getMessage());
                        continue;
                        //throw ex;
                    }

                }
            }
        }

        return fileList;
    }

    /**
     * 获取token
     * @return
     * @throws Exception
     */
    @Override
    public String getToken() throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, Object> body = new LinkedMultiValueMap<>();
        body.add("username", serverUsername);
        body.add("password", serverPassword);
        HttpEntity<MultiValueMap<String, Object>> requestEntity = new HttpEntity<>(body, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(serverLoginUrl, requestEntity, String.class);
        String res = response.getBody();
        JSONObject jsonObject =JSONObject.parseObject(res);
        if(jsonObject.getInteger("code") ==0){
            return jsonObject.getString("data");
        } else {
            throw new Exception("token获取失败:" + res);
        }
    }

    /**
     * 填报信息上传卫星中心
     * @param token
     * @param reportDataDto
     * @throws Exception
     */
    public void reportData(String token, ReportDataDto reportDataDto,TbWxzxRecord tbWxzxRecord) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        // 设置请求头为application/json
        HttpHeaders headers = new HttpHeaders();
        headers.add("token",token);
        headers.setContentType(MediaType.APPLICATION_JSON);
        // 创建要发送的JSON数据
        String jsonData = JSONObject.toJSONString(reportDataDto);
        // 创建HttpEntity对象，包含请求头和JSON数据
        HttpEntity<String> entity = new HttpEntity<>(jsonData, headers);
        // 发送POST请求并获取响应
        ResponseEntity<String> response = restTemplate.postForEntity(serverInfoUrl, entity, String.class);
        String res = response.getBody();
        JSONObject jsonObject =JSONObject.parseObject(res);
        if(jsonObject.getInteger("code") !=0){
            if(jsonObject.getInteger("code")==1 && "已填报".equals(jsonObject.getString("message"))){
                tbWxzxRecord.setTbErr(res);
                return;
            }
            throw new Exception("数据上传失败:" + res);
        }
    }

    public void saveFile(String fileUrl,ReportFileDto dto,String taskid,String dkid){
        String tempUrl ="";
        if (fileUrl.contains("?")) {
            tempUrl = StringUtils.split(fileUrl, "?")[0];
        } else{
            tempUrl = fileUrl;
        }
        TbWxzxRecordFile tbWxzxRecordFile = new TbWxzxRecordFile();
        tbWxzxRecordFile.setDkid(dkid);
        tbWxzxRecordFile.setTaskid(taskid);
        tbWxzxRecordFile.setLocalUrl(tempUrl);
        tbWxzxRecordFile.setServerUrl(dto.getUrl());
        tbWxzxRecordFile.setCreateTime(new Date());
        tbWxzxRecordFile.setFilemd5(dto.getMd5());
        tbWxzxRecordFile.setFilename(dto.getFilename());
        tbWxzxRecordFile.setFilesize(dto.getSize());
        tbWxzxRecordFile.setFiletype(dto.getType());
        saveOrUpdateFile(tbWxzxRecordFile);
    }

    public Boolean findFileDetail(String fileUrl,ReportFileDto dto,Map<String,TbWxzxRecordFile> fileMap){
        String tempUrl ="";
        if (fileUrl.contains("?")) {
            tempUrl = StringUtils.split(fileUrl, "?")[0];
        } else{
            tempUrl = fileUrl;
        }
        if(fileMap!=null && fileMap.containsKey(tempUrl)){
            TbWxzxRecordFile tbWxzxRecordFile = fileMap.get(tempUrl);
            dto.setFilename(tbWxzxRecordFile.getFilename());
            dto.setSize(tbWxzxRecordFile.getFilesize());
            dto.setMd5(tbWxzxRecordFile.getFilemd5());
            dto.setType(tbWxzxRecordFile.getFiletype());
            dto.setUrl(tbWxzxRecordFile.getServerUrl());
            return true;
        }
        return false;
    }

    /**
     * 将私有云文件下载并再次上传到卫星中心
     * @param fileUrl
     * @param dto
     * @param year
     * @param token
     * @throws Exception
     */
    public void getAndUploadFile(String fileUrl,ReportFileDto dto,String year,String token,String dir) throws Exception {
        String newUrl = "";
        String tempUrl ="";
        if (fileUrl.contains("?")) {
            tempUrl = StringUtils.split(fileUrl, "?")[0];
        } else {
            tempUrl = fileUrl;
        }
        String fileName = tempUrl.substring(tempUrl.lastIndexOf("/") + 1, tempUrl.length());
        fileName = java.net.URLDecoder.decode(fileName, "utf-8");
        if(fileName.contains("?")) {
            fileName = StringUtils.split(fileName, "?")[0];
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toUpperCase();
        dto.setFilename(fileName);
        String filePath = downloadFile(fileUrl, fileName,dir);
        if (StringUtils.isNotEmpty(filePath)) {
            File file = new File(filePath);
            try{
//                if ("MP4".equals(fileType) && file.length() > 1024 * 1024 * 20) {
//                    throw new Exception("视频附件大小超过20M:" + fileUrl);
//                } else {
//                    if (file.length() > 1024 * 1024 * 5) {
//                        throw new Exception("附件大小超过5M:" + fileUrl);
//                    }
//                }
                if(file.length()==0){
                    throw new Exception("文件size为空："+fileUrl);
                }
                dto.setSize(file.length());
                try(FileInputStream fs = new FileInputStream(filePath)){
                    byte[] md5 = DigestUtils.md5(fs);
                    String base64Md5 = Base64.getEncoder().encodeToString(md5);
                    dto.setMd5(base64Md5);
                }
                dto.setType(fileType);
                //dto.setUrl(fileUrl);
                newUrl = uploadFile(file, year, token);
                dto.setUrl(newUrl);
            } catch (Exception ex){
              throw new Exception("文件大小:" + dto.getSize() + ex.getMessage());
            } finally {
                file.delete();
            }
        } else {
            throw new Exception("附件下载失败:" + fileUrl);
        }
    }


    /**
     * 上传附件到卫星中心
     * @param file
     * @param year
     * @param token
     * @return
     * @throws Exception
     */
    public String uploadFile(File file,String year,String token) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        // 1、封装请求头
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("multipart/form-data");
        headers.add("token",token);
        headers.setContentType(type);
        headers.setContentLength(file.length());
        headers.setContentDispositionFormData("media", file.getName());
        // 2、封装请求体
        MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
        FileSystemResource resource = new FileSystemResource(file);
        param.add("file", resource);
        param.add("year", year);
        // 3、封装整个请求报文
        HttpEntity<MultiValueMap<String, Object>> formEntity = new HttpEntity<>(param, headers);
        ResponseEntity<String> response = restTemplate.postForEntity(serverFileUrl, formEntity, String.class);
        String res = response.getBody();
        JSONObject jsonObject =JSONObject.parseObject(res);
        if(jsonObject.getInteger("code") ==0){
            return jsonObject.getString("data");
        } else {
            throw new Exception("附件["+ file.getPath() +"]上传失败:" + res);
        }
    }

    /**
     * 将路径对应的附件进行下载
     * @param fileUrl
     * @param fileName
     * @return
     * @throws IOException
     */
    public String downloadFile(String fileUrl,String fileName,String dir) throws Exception {
        String downloadUrl = dir +File.separator+fileName;
        File downdirectory = new File(dir);
        if(!downdirectory.exists()){
            downdirectory.mkdirs();
        }
        //构造URL
        URL url = new URL(fileUrl);
        URLConnection con = url.openConnection();
        con.setConnectTimeout(20 * 1000);
        // 指定目的路径，获取到输出流
        File out = new File(downloadUrl);
        OutputStream outputStream = new FileOutputStream(out);
        try(InputStream inputStream = con.getInputStream()) {
            // 通过输入流读取文件内容
            int len = 0;
            byte[] bytes = new byte[1024];
            while ((len = inputStream.read(bytes)) != -1){
                // 通过输出流，下载到本地
                outputStream.write(bytes,0,len);
            }
            outputStream.flush();
            outputStream.close();
        } catch (Exception e) {
            outputStream.close();
            if(out.exists()){
                out.delete();
            }
            throw new Exception(fileUrl+"下载失败:" + e.getMessage());
        }
        return downloadUrl;
    }

    public List<ReportFileDto> findTaskMediaFile(Map<String,TbWxzxRecordFile> fileMap,String taskid,String tbid,String year,String token,String zgqk,Map<String,Boolean> flgMap,List<String> errLs) throws Exception {
        Integer reportType = 0;
        if(StringUtils.isNotEmpty(zgqk)){
            String[] arr = zgqk.split("&");
            for(String str : arr){
                if("补办手续".equals(str)){
                    reportType+=1;
                }
                else if("拆除复耕".equals(str)){
                    reportType+=3;
                }
            }
        }
        List<ReportFileDto> resList = new ArrayList<>();
        List<AppMedia> appMedias = appMediaDao.queryALLByGid(tbid);
        String dir = localDownload + File.separator + "media";
        for (int i = 0; i < appMedias.size(); i++) {
            Integer type = appMedias.get(i).getType();
            if(type!=1 && type!=2 && type!=5)
                continue;
            AppMediaDTO newMedia = new AppMediaDTO();
            BeanUtil.copyProperties(appMedias.get(i), newMedia);
            if(StringUtils.isBlank(newMedia.getServerpath())&&StringUtils.isNotBlank(newMedia.getDownloadUrl()))
            {
                newMedia.setServerpath(newMedia.getDownloadUrl());
            }
            if (newMedia.getServerpath() != null) {
                if(StringUtils.isBlank(newMedia.getFromSource())) {
                    //获取文件名
                    String url = newMedia.getServerpath();
                    if (url.contains("?")) {
                        url = StringUtils.split(url, "?")[0];
                    }
                    String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                    newMedia.setFileName(fiename);
                    //获取文件授权有效期
                    url = temporarySignedUrlService.getTemporarySignedUrl(defaultOssOperatorService.getDefaultOssConfig().getServerId().toString(), url, null);
                    if (GutilStr.isNotBlank(url)) {
                        newMedia.setServerpath(url);
                    }
                }
                else
                {
                    String from = newMedia.getFromSource();
                    if(from.startsWith(importOtherDataService.getMediaSourcePrefix()))
                    {
                        continue;
                    }
                    else {
                        OssConfig ossConfig = null;
                        if (mapOssConfig.containsKey(from)) {
                            ossConfig = mapOssConfig.get(from);
                        } else {
                            ossConfig = ossConfigRepository.queryBySource(from);
                            mapOssConfig.put(from, ossConfig);
                        }

                        if (ossConfig != null) {
                            String url = newMedia.getServerpath();
                            if (url.contains("?")) {
                                url = StringUtils.split(url, "?")[0];
                            }
                            String fiename = url.substring(url.lastIndexOf("/") + 1, url.length());
                            newMedia.setFileName(fiename);
                            url = temporarySignedUrlService.getTemporarySignedUrl(ossConfig.getServerId().toString(), url, null);
                            if (GutilStr.isNotBlank(url)) {
                                newMedia.setServerpath(url);
                            }
                        }
                    }
                }
            }
            Integer fileType=1;
            ReportFileDto dto = new ReportFileDto();
            //区分现场照片和附件
            if(5==type){
                //附件
                if(reportType==3){
                    fileType = 2;
                } else {
                    flgMap.put("bbHave",true);
                }
            } else if(1==type || 2==type) {
                //现场照片
                if(reportType>=3){
                    fileType = 2;
                    flgMap.put("ccfkHave",true);
                }
                //拍摄人
                dto.setPsry(newMedia.getUsername());
                String pssj = newMedia.getCreateTime();
                //拍摄时间（毫秒数）
                if(StringUtils.isNotEmpty(pssj)){
                    Long t = Long.parseLong(pssj);
                    dto.setPssj(t);
                }
                //拍摄相对高度
                if(newMedia.getPsgd()!=null){
                    dto.setXdgd(newMedia.getPsgd().toString());
                }
                //拍摄绝对高度
                if(appMedias.get(i).getJdgd()!=null){
                    dto.setJdgd(appMedias.get(i).getJdgd().toString());
                }
                //拍摄点经度（十进制小数）
                dto.setLongitude(newMedia.getLon());
                //拍摄点纬度（十进制小数）
                dto.setLatitude(newMedia.getLat());
                //拍摄俯仰角
                if(StringUtils.isNotEmpty(newMedia.getPitch())){
                    int roundValue = (int) Math.round(Double.parseDouble(newMedia.getPitch()));
                    dto.setPsfyj(roundValue);
                }
                //拍摄角度（方位角）
                if(StringUtils.isNotEmpty(newMedia.getAzimuth())){
                    int roundValue = (int) Math.round(Double.parseDouble(newMedia.getAzimuth()));
                    dto.setPsjd(roundValue);
                }
                //拍摄横滚角
                dto.setPshgj(appMedias.get(i).getRoll());
                //拍摄焦距
                if(appMedias.get(i).getFocal()!=null){
                    int roundValue = (int) Math.round(appMedias.get(i).getFocal());
                    dto.setPsjj(roundValue);
                }
                //附件原始高度
                if(newMedia.getDimHeight()!=null){
                    dto.setFjysgd(newMedia.getDimHeight().toString());
                }
                //附件原始宽度
                if(newMedia.getDimWidth()!=null){
                    dto.setFjyskd(newMedia.getDimWidth().toString());
                }
                //pstz "拍摄特征（Y-远景，J-近景，T-局部特征）"
            }
            dto.setFileType(fileType);
            try{
                if(!findFileDetail(newMedia.getServerpath(),dto,fileMap)){
                    getAndUploadFile(newMedia.getServerpath(),dto,year,token,dir);
                    saveFile(newMedia.getServerpath(),dto,taskid,tbid);
                }
            } catch (Exception ex){
                errLs.add(ex.getMessage());
                logger.error(ex.getMessage());
                continue;
                //throw ex;
            }
            resList.add(dto);
        }

        return resList;
    }
}
