package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.dao.pub.DmDictValueDao;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.DmDictValue;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUserDetail;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserDetailRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

import static com.google.common.base.Preconditions.checkArgument;


/*
 * @author   : lcw
 * @date     : 2022/7/5
 * @des      : 常规监测市级审核详情记录excel生成服务
 **/
@Service("CgjcApproveRecordDetailService")
@Transactional(rollbackFor = Exception.class)
public class CgjcApproveRecordDetailService {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    private SysConfigRepository configRepository;

    private static final String TAKE_HAND_TASK_ID = "statistics";;

    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    LandUserService landUserService;

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    RegionService regionService;

    @Resource
    private DmDictValueDao dictValueDao;

    @Autowired
    LandUserDetailRepository landUserDetailDao;

    @Autowired
    private MinIOService minIOService;

    private String resultUrl = "";

    @Value("${project.import.media}")
    protected String mediaFolder;

    @Autowired
    private DefaultOssOperatorService stsService;

    @Value("${project.applicationType}")
    protected String applicationType;

    @Autowired
    UserNameService userNameService;

    private GiLoger logger = GwLoger.getLoger(CgjcApproveRecordDetailService.class);

    /**
     * 下载图斑图形数据
     *
     * @param taskId
     * @param userId
     * @return
     */
    public DataDownloadRecord downloadCgjcApproveDetail(String taskId, Long userId, String shsjStart, String shsjEnd, String hasPass, String approveUser) {
        checkParameters(taskId, userId);

        DataDownloadRecord record = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId);
        record.setName("审核详细记录统计信息汇总("+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())+")");
        dataDownloadRecordService.save(record);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(), JSON.toJSONString(record), 2, TimeUnit.DAYS);

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(record.getTbIds()) ? record.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        // 类型为空
        attachParameter.setDownloadType(0);
        attachParameter.setDataType("approveRecordDetail");

        JSONObject condition = new JSONObject();
        condition.put("shsjStart",shsjStart);
        condition.put("shsjEnd",shsjEnd);
        condition.put("hasPass",hasPass);
        condition.put("approveUser",approveUser);

        attachParameter.setCondition(condition.toJSONString());

        String parameterString = JSON.toJSONString(attachParameter);

        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);
        //downloadGeometryProducerService.sendDataDownloadMessageToMq("ssp", dataType, parameterString);
        return record;
    }

     public Boolean runDownloadCgjcApproveDetail(TaskRecord taskRecord,DownloadParameter downloadParameter) throws Exception {
         DataDownloadRecord dataDownloadRecord = null;
         try{
             Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
             if (value != null) {
                /* dataDownloadRecord = (DataDownloadRecord) net.sf.json.JSONObject.toBean(net.sf.json.JSONObject.fromObject(value), DataDownloadRecord.class);*/
                 dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                 if (dataDownloadRecord != null) {
                     if(dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)){
                         throw new Exception("用户取消了下载任务");
                     };
                     List<String> areas = landUserService.queryUserAreas(taskRecord.getUserid());
                     String area = StringUtils.join(areas,",");
                     String path = createCgjcApproveRecordDetail(taskRecord.getBizId(),area,taskRecord.getUserid(), downloadParameter);
                     File srcFile = new File(path);
                     logger.info("日常任务下载 开始上传到obs " + path);

                     String resultUrl="";
                     // zip文件上传到obs云盘
                     if ("lan".equals(this.applicationType)) {
                         resultUrl= this.uploadFileToDisk(taskRecord.getUserid(), srcFile);
                     } else {
                         resultUrl= uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                     }

                     if (dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                         throw new Exception("用户取消了下载任务");
                     }
                     // 计算大小
                     Double fileSize = srcFile.length() / 1024d;
                     dataDownloadRecord.setAttachSize(fileSize);
                     dataDownloadRecord.setUrl(resultUrl);
                     dataDownloadRecord.setEndTime(new Date());
                     dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                     dataDownloadRecordService.save(dataDownloadRecord);
                     srcFile.delete();
                     //    dataDownloadDailyTaskService.downloadDailyTaskAttach(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                 }
             }
         }catch (Exception e){
             dataDownloadRecord.setEndTime(new Date());
             dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
             dataDownloadRecord.setErrorMsg(e.getMessage());
             dataDownloadRecordService.update(dataDownloadRecord);
             throw e;
         }
        return true;
     }

    /**
     * 上传到云盘
     * 上传到云盘
     *
     * @param userId
     * @param safeFileName
     */
    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        // 上传到obs
        return stsService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl="";

        if (true) {
            File destFile = new File(this.mediaFolder, "media/" + file.getName());
            FileUtils.copyFile(file, destFile);
            resultUrl = "media/" + sendObjName;
        } else {
            this.minIOService.addToBucket(sendObjName, file.getAbsolutePath());
            resultUrl = sendObjName;
        }
        return resultUrl;
    }

    private void checkParameters(String taskId, Long userId) {
        checkArgument(StringUtils.isNotBlank(taskId), "taskId must not be null or empty.");
        checkArgument(userId > -1, "userId can not be negative number.");
    }

    public String createCgjcApproveRecordDetail(String taskId,String xzqdm,Long userId,DownloadParameter downloadParameter) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz==null){
            throw new Exception("当前任务不存在");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());

        if (tbtskObjectinfo==null){
            throw new Exception("当前任务table信息不存在");
        }

        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = regionService.queryAllRegionAndCode(provinceCode);

        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有

        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(xzqdm.equals("")||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }

        String excelPath="";
        try{
            List<Map<String, Object>> shList=new ArrayList<>();
            //获取条件
            JSONObject condition= JSONObject.parseObject(downloadParameter.getCondition());
            String shsjStart= condition.get("shsjStart").toString();
            String shsjEnd =  condition.get("shsjEnd").toString();
            String hasPass= condition.get("hasPass").toString();
            String approveUser =  condition.get("approveUser").toString();
            List<DmDictValue> dmDictValue= dictValueDao.queryByDictId(200913L);
            if(dmDictValue.size()==0){
                throw new Exception("审核未通过提示语字典值不存在，请检查是否存在id为200913的字典项");
            }
            shList= getShList(tbtskObjectinfo.getfTablename(),taskId,cRegions, shsjStart,shsjEnd,hasPass,approveUser,dmDictValue);
            excelPath= createCgjcApproveRecordDetailExcel(shList,tskTaskBiz.getName(),shsjStart,shsjEnd,hasPass,approveUser,dmDictValue);
        }catch (Exception e){
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }


    /**
     * 获取审核统计信息
     * @param
     */
    public List<Map<String, Object>> getShList(String tableName,String taskId,List<Region>  cRegions,String shsjStart,String shsjEnd,String hasPass,String approveUser,List<DmDictValue> dmDictValue){
        String regions="";
        for(int i=0;i<cRegions.size();i++){
            regions+="'"+cRegions.get(i).getCode()+"',";
        }

        String conditionSql = " where 1=1 ";
        if (!shsjStart.equals("")){
            conditionSql+= " and ar.f_approve_time >= TO_TIMESTAMP(" +shsjStart.toString().substring(0,shsjStart.toString().length()-3)+") ";
        }
        if (!shsjEnd.equals("")){
            conditionSql+= " and ar.f_approve_time <= TO_TIMESTAMP(" +shsjEnd.toString().substring(0,shsjEnd.toString().length()-3)+") ";
        }

        if (!hasPass.equals("")){
            if(hasPass.equals("true")){
                conditionSql+= " and ar.f_stepindex = 1 AND ar.f_option='1' ";
            }else if (hasPass.equals("false")){
                conditionSql+= " and ( (ar.f_stepindex = 1 AND ar.f_option='2') or ar.f_stepindex = 0 or ar.f_stepindex is null )";
            }
        }

        if (!approveUser.equals("")){
            conditionSql+= " and ar.f_approve_user = '"+approveUser+"'";
        }

        String shListSql =  "SELECT\n" +
                "\tT.f_xzqdm,T.f_xzqmc1,\n" +
                "\tCOUNT ( * ) spotAllCount,\n" +
                "\tSUM ( f_tbmj ) tbmjAllSum,\n" +
                "\tCOUNT((ar.f_stepindex=0 AND ar.f_option='1' ) OR NULL OR ( ar.f_stepindex = 1 AND ar.f_option='1' ) OR ( ar.f_stepindex =1 AND ar.f_option='2')) xjTgSpotCount,\n" +
                "\tSUM( CASE WHEN (ar.f_stepindex = 0 AND ar.f_option='1' ) OR NULL OR ( ar.f_stepindex = 1 AND ar.f_remark ='通过' ) OR ( ar.f_stepindex = 1 AND ar.f_option='2') THEN T.f_tbmj ELSE 0 END ) xjTgTbmjSum,\n" +
                "\tCOUNT ( ( ar.f_stepindex = 1 ) OR NULL ) sjAllSpotCount,\n" +
                "\tSUM ( CASE WHEN ar.f_stepindex = 1 THEN T.f_tbmj ELSE 0 END ) sjAllTbmjSum,\n" +
                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='1' ) OR NULL ) sjTgSpotCount,\n" +
                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgTbmjSum,\n" +
                "\tCOUNT ( ( ar.f_stepindex = 1 AND T.f_bzw = '已纳入二上' AND ar.f_option='1' ) OR NULL ) sjTgEsSpotCount,\n" +
                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND T.f_bzw = '已纳入二上' AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgEsTbmjSum,\n" +
                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' ) OR NULL ) sjWtgSpotCount,\n" +
                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' THEN T.f_tbmj ELSE 0 END ) sjWtgTbmjSum,\n" ;
        for (int i = 0;i<dmDictValue.size();i++){
            shListSql+= "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='"+dmDictValue.get(i).getName()+"' ) OR NULL ) "+dmDictValue.get(i).getCode()+"count,\n";
            //为最后一项则去掉‘，’号
            if(i==dmDictValue.size()-1){
                shListSql+= "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='"+dmDictValue.get(i).getName()+"' THEN T.f_tbmj ELSE 0 END ) "+dmDictValue.get(i).getCode()+"sum\n";
            }else {
                shListSql+= "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='"+dmDictValue.get(i).getName()+"' THEN T.f_tbmj ELSE 0 END ) "+dmDictValue.get(i).getCode()+"sum,\n";
            }

        }
        shListSql +="FROM\n" +
                "\t"+tableName+"\n" +
                "\tAS T LEFT JOIN (\n" +
                "\tSELECT\n" +
                "\t\tar3.* \n" +
                "\tFROM\n" +
                "\t\ttbtsk_approve_record AS ar3\n" +
                "\t\tINNER JOIN (\n" +
                "\t\t\t SELECT f_tbid,\n" +
                "\t\t\tMAX ( f_approve_time ) AS f_approve_time \n" +
                "\t\tFROM\n" +
                "\t\t\t( SELECT ar1.* FROM tbtsk_approve_record AS ar1 WHERE ar1.f_taskid = '"+taskId+"' ) AS tar \n" +
                "\t\tGROUP BY\n" +
                "\t\t\tf_tbid \n" +
                "\t\t) ar2 ON ar2.f_tbid = ar3.f_tbid \n" +
                "\t\tAND ar2.f_approve_time = ar3.f_approve_time \n" +
                "\t) ar ON T.f_id = ar.f_tbid and  T.f_xzqdm like '50%' \n" + conditionSql;


//        String shListSql =  "SELECT\n" +
//                "\tT.f_xzqdm,T.f_xzqmc1,\n" +
//                "\tCOUNT ( * ) spotAllCount,\n" +
//                "\tSUM ( f_tbmj ) tbmjAllSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 0 AND ar.f_option='1' ) OR NULL ) xjTgSpotCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 0 AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) xjTgTbmjSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 ) OR NULL ) sjAllSpotCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 THEN T.f_tbmj ELSE 0 END ) sjAllTbmjSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='1' ) OR NULL ) sjTgSpotCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgTbmjSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND T.f_bzw = '已纳入二上' AND ar.f_option='1' ) OR NULL ) sjTgEsSpotCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND T.f_bzw = '已纳入二上' AND ar.f_option='1' THEN T.f_tbmj ELSE 0 END ) sjTgEsTbmjSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' ) OR NULL ) sjWtgSpotCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' THEN T.f_tbmj ELSE 0 END ) sjWtgTbmjSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='不符合新增耕地认定' ) OR NULL ) sjWtgBfhxzgdrdCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='不符合新增耕地认定' THEN T.f_tbmj ELSE 0 END ) sjWtgBfhxzgdrdSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证照片反映只存在零星/部分耕种' ) OR NULL ) sjWtgJzzpbfgzCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证照片反映只存在零星/部分耕种' THEN T.f_tbmj ELSE 0 END ) sjWtgJzzpbfgzSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证方法错误，所在方位角不能反映图斑情况' ) OR NULL ) sjWtgJzffcwCount,\n" +
//                "\tSUM ( CASE WHEN  ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证方法错误，所在方位角不能反映图斑情况'  THEN T.f_tbmj ELSE 0 END ) sjWtgJzffcwSum,\n"+
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证照片局部性，未反映全貌' THEN T.f_tbmj ELSE 0 END ) sjWtgJzzpjbxSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='举证照片局部性，未反映全貌' ) OR NULL ) sjWtgJzzpjbxCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='未举证，不能进行利用现状判断或影像不支持' THEN T.f_tbmj ELSE 0 END ) sjWtgWjzSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='未举证，不能进行利用现状判断或影像不支持' ) OR NULL ) sjWtgWjzCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='照片冗余' THEN T.f_tbmj ELSE 0 END ) sjWtgZprySum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='照片冗余' ) OR NULL ) sjWtgZpryCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='翻耕状态未种植' THEN T.f_tbmj ELSE 0 END ) sjWtgFgztwzzSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='翻耕状态未种植' ) OR NULL ) sjWtgFgztwzzCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='二级类地类认定错误' THEN T.f_tbmj ELSE 0 END ) sjWtgEjldlrdcwSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='二级类地类认定错误' ) OR NULL ) sjWtgEjldlrdcwCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='园木覆盖度、林木郁闭度较大，已达到相应园林地地类标准' THEN T.f_tbmj ELSE 0 END ) sjWtgYmfgdSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='园木覆盖度、林木郁闭度较大，已达到相应园林地地类标准' ) OR NULL ) sjWtgYmfgdCount,\n" +
//                "\tSUM ( CASE WHEN ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='碎/小图斑' THEN T.f_tbmj ELSE 0 END ) sjWtgSxtbSum,\n" +
//                "\tCOUNT ( ( ar.f_stepindex = 1 AND ar.f_option='2' AND ar.f_remark ='碎/小图斑' ) OR NULL ) sjWtgSxtbCount\n" +
//                "FROM\n" +
//                "\t"+tableName+"\n" +
//                "\tAS T LEFT JOIN (\n" +
//                "\tSELECT\n" +
//                "\t\tar3.* \n" +
//                "\tFROM\n" +
//                "\t\ttbtsk_approve_record AS ar3\n" +
//                "\t\tINNER JOIN (\n" +
//                "\t\tSELECT\n" +
//                "\t\t\tf_tbid,\n" +
//                "\t\t\tMAX ( f_approve_time ) AS f_approve_time \n" +
//                "\t\tFROM\n" +
//                "\t\t\t( SELECT ar1.* FROM tbtsk_approve_record AS ar1 WHERE ar1.f_taskid = '"+taskId+"' ) AS tar \n" +
//                "\t\tGROUP BY\n" +
//                "\t\t\tf_tbid \n" +
//                "\t\t) ar2 ON ar2.f_tbid = ar3.f_tbid \n" +
//                "\t\tAND ar2.f_approve_time = ar3.f_approve_time \n" +
//                "\t) ar ON T.f_id = ar.f_tbid and  T.f_xzqdm like '50%' \n" + conditionSql;
        if(regions!=""){
            regions=regions.substring(0,regions.length()-1);
            shListSql+=" AND t.f_xzqdm in ("+regions+") ";
        }
        shListSql+="GROUP BY\n" +
                "\tT.f_xzqdm,T.f_xzqmc1";

        List<Map<String, Object>> shNumList  = this.jdbcTemplate.queryForList(shListSql);
        return shNumList;
    }

    /**
     * 数据excel模板填充生成
     * @param
     */
    public String createCgjcApproveRecordDetailExcel( List<Map<String, Object>> dataList,String taskName,String shsjStart,String shsjEnd,String hasPass,String approveUser,List<DmDictValue> dmDictValue) throws Exception {
       /* String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = new StringBuilder()
                .append(pathRoot)
                .append("excel")
                .append(File.separator)
                .append("常规监测审核详细记录模板.xlsx")
                .toString();*/
        ClassPathResource STSONG = new ClassPathResource("/static/excel/常规监测审核详细记录模板.xlsx");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile(STSONG.getInputStream(), STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();


        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append(taskName+"_详细审核记录_"+System.currentTimeMillis()+".xlsx")
                .toString();

        try{
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, String>> listMap=new ArrayList<>();
            List<Map<String, String>> colsMap=new ArrayList<>();
            DecimalFormat format = new DecimalFormat("#.00");
            for (int i=0;i<dataList.size();i++){
                Map<String, String> cmap=new HashMap<>();
                for(String key : dataList.get(i).keySet()){
                    if(dataList.get(i).get(key)!=null){
                        cmap.put(key,dataList.get(i).get(key).toString());
                    }else {
                        if(key.contains("sum")||key.contains("count")){
                            cmap.put(key,String.valueOf(0));
                        }else {
                            cmap.put(key,"");
                        }
                    }
                }
                Double othercount=Double.valueOf(cmap.get("sjwtgspotcount"));
                Double othersum=Double.valueOf(cmap.get("sjwtgtbmjsum"));

                for (int j = 0; j<dmDictValue.size();j++){
                    othercount=othercount-Double.valueOf(cmap.get(dmDictValue.get(j).getCode()+"count"));
                    othersum=othersum-Double.valueOf(cmap.get(dmDictValue.get(j).getCode()+"sum"));
                }
                cmap.put("othercount",String.valueOf(othercount));
                cmap.put("othersum",String.valueOf(othersum));
//                cmap.put("othercount", String.valueOf((new Double(Double.valueOf(cmap.get("sjwtgspotcount"))-
//                        Double.valueOf(cmap.get("sjwtgbfhxzgdrdcount"))-Double.valueOf(cmap.get("sjwtgjzzpbfgzcount"))-Double.valueOf(cmap.get("sjwtgjzffcwcount"))-
//                        Double.valueOf(cmap.get("sjwtgjzzpjbxcount"))-Double.valueOf(cmap.get("sjwtgwjzcount"))-Double.valueOf(cmap.get("sjwtgzprycount"))-
//                        Double.valueOf(cmap.get("sjwtgfgztwzzcount"))-Double.valueOf(cmap.get("sjwtgejldlrdcwcount"))-Double.valueOf(cmap.get("sjwtgymfgdcount"))-
//                        Double.valueOf(cmap.get("sjwtgsxtbcount")))).longValue()));
//                cmap.put("othersum",String.valueOf(Double.valueOf(cmap.get("sjwtgtbmjsum"))-
//                        Double.valueOf(cmap.get("sjwtgbfhxzgdrdsum"))-Double.valueOf(cmap.get("sjwtgjzzpbfgzsum"))-Double.valueOf(cmap.get("sjwtgjzffcwsum"))-
//                        Double.valueOf(cmap.get("sjwtgjzzpjbxsum"))-Double.valueOf(cmap.get("sjwtgwjzsum"))-Double.valueOf(cmap.get("sjwtgzprysum"))-
//                        Double.valueOf(cmap.get("sjwtgfgztwzzsum"))-Double.valueOf(cmap.get("sjwtgejldlrdcwsum"))-Double.valueOf(cmap.get("sjwtgymfgdsum"))-
//                        Double.valueOf(cmap.get("sjwtgsxtbsum"))));
                listMap.add(cmap);
            }

            for (int j = 0; j<dmDictValue.size();j++){
                Map colMap = new HashMap<>();
                colMap.put("name",dmDictValue.get(j).getName());
                colMap.put("spotCountName","图斑量（个）");
                colMap.put("spotAreaName","图斑面积");
                colMap.put("spotCountCode","n:t."+dmDictValue.get(j).getCode()+"count");
                colMap.put("spotAreaCode","n:t."+dmDictValue.get(j).getCode()+"sum");
                colsMap.add(colMap);
            }
            map.put("maplist",listMap);
            map.put("colList",colsMap);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if(!shsjStart.equals("")){
                Date startDate=new Date(Long.valueOf(shsjStart));
                shsjStart = simpleDateFormat.format(startDate);
            }
            if(!shsjEnd.equals("")){
                Date endDate=new Date(Long.valueOf(shsjEnd));
                shsjEnd = simpleDateFormat.format(endDate);
            }
            String passName="全部";
            if(!hasPass.equals("")){
                if(hasPass.equals("true")){
                    passName="通过";
                }else if (hasPass.equals("false")){
                    passName="不通过";
                }
            }
            String userName="全部";
            if(!approveUser.equals("")){
               userName = userNameService.getUserPhoneByUserName(approveUser);
            }
            map.put("shsjStart",shsjStart);
            map.put("shsjEnd",shsjEnd);
            map.put("passName",passName);
            map.put("userName",userName);
            TemplateExportParams params = new TemplateExportParams(srcFileName);
            params.setColForEach(true);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }


}
