package com.geoway.landteam.landcloud.service.statistics;
import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.data.GwValidateException;
import com.gw.base.data.result.GwEmAlertType;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import static com.google.common.base.Preconditions.checkArgument;


/*
 * @author   : lcw
 * @date     : 2022/7/5
 * @des      : 常规监测市级审核记录excel生成服务
 **/
@Service("CgjcApproveRecordService")
@Transactional(rollbackFor = Exception.class)
public class CgjcApproveRecordService {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    private SysConfigRepository configRepository;

    private static final String TAKE_HAND_TASK_ID = "statistics";;

    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    LandUserService landUserService;

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    RegionService regionService;

    @Autowired
    MTskTaskBizService mTskTaskBizService;

    @Autowired
    private MinIOService minIOService;

    private String resultUrl = "";

    @Value("${project.applicationType}")
    protected String mediaFolder;

    @Autowired
    private DefaultOssOperatorService stsService;

    @Value("${project.applicationType}")
    protected String applicationType;

    private GiLoger logger = GwLoger.getLoger(CgjcApproveRecordService.class);

    /**
     * 下载图斑图形数据
     *
     * @param userId
     * @return
     */
    public DataDownloadRecord downloadCgjcApprove(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        checkParameters(taskId, userId);

        DataDownloadRecord record = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId);
        record.setName("审核记录统计信息汇总("+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())+")");
        dataDownloadRecordService.save(record);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(), JSON.toJSONString(record), 2, TimeUnit.DAYS);
       /* //判断是批量下载还是全量条件下载
        Boolean batch = parameter.getIsBatch().equals("1") ? true : false;
        if(batch){//批量下载
            if (StringUtils.isBlank(parameter.getTbIds()) ) {
                throw new GwValidateException("未勾选图斑");
            }
        }else { //全量条件下载
            try {
                if (StringUtils.isBlank(parameter.getSortParam())) {
                    parameter.setSortParam(" f_createtime desc ");
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }*/

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString(parameter));
        attachParameter.setBizType(TAKE_HAND_TASK_ID);
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        // 类型为空
        attachParameter.setDownloadType(0);
        attachParameter.setDataType("approveRecord");

        String parameterString = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);

        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);
        //downloadGeometryProducerService.sendDataDownloadMessageToMq("ssp", dataType, parameterString);
        return record;
    }

     public Boolean runDownloadCgjcApprove(TaskRecord taskRecord,DownloadParameter downloadParameter) throws Exception {
         DataDownloadRecord dataDownloadRecord = null;
         try{
             Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
             if (value != null) {
                /* dataDownloadRecord = (DataDownloadRecord) net.sf.json.JSONObject.toBean(net.sf.json.JSONObject.fromObject(value), DataDownloadRecord.class);*/
                 dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                 if (dataDownloadRecord != null) {
                     if(dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)){
                         throw new Exception("用户取消了下载任务");
                     };
                     List<String> areas = landUserService.queryUserAreas(taskRecord.getUserid());
                     String area = StringUtils.join(areas,",");
                     String path = createCgjcApproveRecord(taskRecord.getBizId(),area,taskRecord.getUserid(),taskRecord);
                     File srcFile = new File(path);
                     logger.info("日常任务下载 开始上传到obs " + path);

                     String resultUrl="";
                     // zip文件上传到obs云盘
                     if ("lan".equals(this.applicationType)) {
                         resultUrl= this.uploadFileToDisk(taskRecord.getUserid(), srcFile);
                     } else {
                         resultUrl= uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                     }

                     if (dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                         throw new Exception("用户取消了下载任务");
                     }
                     // 计算大小
                     Double fileSize = srcFile.length() / 1024d;
                     dataDownloadRecord.setAttachSize(fileSize);
                     dataDownloadRecord.setUrl(resultUrl);
                     dataDownloadRecord.setEndTime(new Date());
                     dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                     dataDownloadRecordService.save(dataDownloadRecord);
                     srcFile.delete();
                     //    dataDownloadDailyTaskService.downloadDailyTaskAttach(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                 }
             }
         }catch (Exception e){
             dataDownloadRecord.setEndTime(new Date());
             dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
             dataDownloadRecord.setErrorMsg(e.getMessage());
             dataDownloadRecordService.update(dataDownloadRecord);
             throw e;
         }
        return true;
     }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param
     */
    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        // 上传到obs
        return stsService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl="";

        if (true) {
            File destFile = new File(this.mediaFolder, "media/" + file.getName());
            FileUtils.copyFile(file, destFile);
            resultUrl = "media/" + sendObjName;
        } else {
            this.minIOService.addToBucket(sendObjName, file.getAbsolutePath());
            resultUrl = sendObjName;
        }
        return resultUrl;
    }

    private void checkParameters(String taskId, Long userId) {
        checkArgument(StringUtils.isNotBlank(taskId), "taskId must not be null or empty.");
        checkArgument(userId > -1, "userId can not be negative number.");
    }

    public String createCgjcApproveRecord(String taskId,String xzqdm,Long userId,TaskRecord taskRecord) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz==null){
            throw new Exception("当前任务不存在");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if (tbtskObjectinfo==null){
            throw new Exception("当前任务table信息不存在");
        }
        String tbIds = "";
        JSONObject paramObject = new JSONObject();
        String paramKey = "";
        if(taskRecord!=null){
            String param = taskRecord.getParam();
            DownloadParameter downloadParameter = JSONObject.toJavaObject(JSONObject.parseObject(param),DownloadParameter.class);
            String condition = downloadParameter.getCondition();
            TaskQueryParameter parameter = JSONObject.toJavaObject(JSONObject.parseObject(condition),TaskQueryParameter.class);
            Pair<Long, List<Map>> longListPair = mTskTaskBizService.queryWebDisplayListDataNotPage(parameter);
            Pair<Long, List<Map>> pair = Pair.of(longListPair.getKey(), longListPair.getValue());
            List<Map> mapList = pair.getRight();
            List<String> ids = mapList.stream().map(map -> map.get("f_id").toString()).collect(Collectors.toList());
            parameter.setTbIds(StringUtils.join(ids, ","));
            tbIds = StringUtils.join(ids, ",");

            //将过滤条件换成起来
            if(redisTemplate.hasKey(tskTaskBiz.getId()+"_CgjcApproveParamObject")){
                paramObject= (JSONObject) redisTemplate.opsForValue().get(tskTaskBiz.getId()+"_CgjcApproveParamObject");
            }else{
                paramObject.put(String.valueOf(parameter),tskTaskBiz.getId()+"_CgjcApproveParamObject_"+paramObject.size());
               // paramKey  = tskTaskBiz.getId()+"_CgjcApproveParamObject_"+paramObject.size();
                redisTemplate.opsForValue().set(tskTaskBiz.getId()+"_CgjcApproveParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
            }
            if(paramObject.containsKey(String.valueOf(parameter))){
                paramKey = paramObject.getString(String.valueOf(parameter));
            }else{
                paramKey =  tskTaskBiz.getId()+"_CgjcApproveParamObject_"+paramObject.size();
                paramObject.put(String.valueOf(parameter),paramKey);
                redisTemplate.opsForValue().set(tskTaskBiz.getId()+"_CgjcApproveParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
            }
        }

        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = new ArrayList<>();
        if(redisTemplate.hasKey("region_all")){
            result= (List<Region>) redisTemplate.opsForValue().get("region_all");
        }else{
            result = regionService.queryAllRegionAndCode(provinceCode);
            redisTemplate.opsForValue().set("region_all",result,30, TimeUnit.DAYS);
        }

        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有

        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(xzqdm.equals("")||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }

        String excelPath="";
        try{
            //先读取redis
            List<Map<String, Object>> shList = new ArrayList<>();
           /* if(redisTemplate.hasKey(tbtskObjectinfo.getfTablename()+"_tbApproveRecords")){
                shList= (List<Map<String, Object>>) redisTemplate.opsForValue().get(tbtskObjectinfo.getfTablename()+"_tbApproveRecords");
            }else{
                shList= getShList(tbtskObjectinfo.getfTablename(),taskId,cRegions,tbIds);
                redisTemplate.opsForValue().set(tbtskObjectinfo.getfTablename()+"_tbApproveRecords",shList,24*60*60,TimeUnit.SECONDS);
            }*/
            if(StringUtils.isNotBlank(paramKey) && redisTemplate.hasKey(paramKey+"_tbApproveRecords")){
                shList= (List<Map<String, Object>>) redisTemplate.opsForValue().get(paramKey+"_tbApproveRecords");
            }else{
                shList= getShList(tbtskObjectinfo.getfTablename(),taskId,cRegions,tbIds);
                redisTemplate.opsForValue().set(paramKey+"_tbApproveRecords",shList,6*60*60,TimeUnit.SECONDS);
            }
           /* shList= getShList(tbtskObjectinfo.getfTablename(),taskId,cRegions,tbIds);*/
            excelPath= createCgjcApproveRecordExcel(shList,tskTaskBiz.getName());
        }catch (Exception e){
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }


    /**
     * 获取审核统计信息
     * @param
     */
    public List<Map<String, Object>> getShList(String tableName,String taskId,List<Region>  cRegions,String tbIds){
        String regions="";
        for(int i=0;i<cRegions.size();i++){
            regions+="'"+cRegions.get(i).getCode()+"',";
        }
      /*  String tmpTable = "";
        if(StringUtils.isNotBlank(tbIds)){
            tmpTable = " with tmp as (select unnest(string_to_array('"+tbIds+"',',')) f_id )";
        }
        //区县通过、市级通过、市级未通过
        String shListSql =  tmpTable + " SELECT " +
                " t.f_id,t.f_tbbh,t.f_xzqdm,t.f_xzqmc1,ar7.f_remark,ar7.f_approve_user,ar7.f_approve_time,ar7.f_option,ar7.sjnum,ar.xj_remark," +
                " ar.xj_approve_user,ar.xj_approve_time,ar.xj_option,ar.xjnum " +
                " FROM " + tableName +" AS t " +
                " inner JOIN ( SELECT ar3.f_remark as xj_remark,ar3.f_tbid, ar3.f_approve_user as xj_approve_user,ar3.f_approve_time as xj_approve_time, ar3.f_option as xj_option,ar2.xjnum FROM tbtsk_approve_record as ar3 INNER  JOIN " +
                " ( SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time,COUNT(f_tbid) as xjnum  FROM " +
                " ( SELECT ar1.* FROM tbtsk_approve_record AS ar1 where ar1.f_taskid = '"+taskId+"' AND ar1.f_stepindex = 0) " +
                " as tar GROUP BY f_tbid) ar2 on ar2.f_tbid = ar3.f_tbid and ar2.f_approve_time = ar3.f_approve_time) ar " +
                " ON  t.f_id = ar.f_tbid "+
                " LEFT JOIN ( " +
                " SELECT ar4.*,ar5.sjnum " +
                " FROM tbtsk_approve_record AS ar4 INNER JOIN ( " +
                " SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time ,COUNT(f_tbid) as sjnum FROM( " +
                " SELECT ar6.* FROM tbtsk_approve_record AS ar6 where ar6.f_taskid ='"+taskId+"' AND ar6.f_stepindex = 1 ) AS tar " +
                " GROUP BY f_tbid ) ar5 ON ar5.f_tbid = ar4.f_tbid AND ar5.f_approve_time = ar4.f_approve_time " +
                " ) ar7 ON T.f_id = ar7.f_tbid ";*/

        String tmpTable1 = "with approve as (select tar.f_taskid f_taskid,tar.f_stepindex f_stepindex,tar.f_remark f_remark,tar.f_tbid f_tbid,tar.f_approve_user  f_approve_user,tar.f_approve_time f_approve_time,tar.f_option f_option from tbtsk_approve_record tar\n" +
                "union all\n" +
                "select trr.f_taskid f_taskid,case trr.f_stepname when '市级审核' then 1  when  '县级级审核' then 0 else 0 end f_stepindex,trr.f_remark f_remark,trr.f_tbid f_tbid,trr.f_username f_approve_user,trr.f_reject_time f_approve_time,2 as f_option from tbtsk_reject_record trr )";
        if(StringUtils.isNotBlank(tbIds)){
            tmpTable1 += " , tmp as (select unnest(string_to_array('"+tbIds+"',',')) f_id )";
        }
        //区县通过、区县不通过、市级通过、市级未通过
        String shListSql1 =  tmpTable1 + " SELECT " +
                " t.f_id,t.f_tbbh,t.f_xzqdm,t.f_xzqmc1,ar7.f_remark,ar7.f_approve_user,ar7.f_approve_time,ar7.f_option,ar7.sjnum,ar.xj_remark," +
                " ar.xj_approve_user,ar.xj_approve_time,ar.xj_option,ar.xjnum " +
                " FROM " + tableName +" AS t " +
                " inner JOIN ( SELECT ar3.f_remark as xj_remark,ar3.f_tbid, ar3.f_approve_user as xj_approve_user,ar3.f_approve_time as xj_approve_time, ar3.f_option as xj_option,ar2.xjnum FROM approve as ar3 INNER  JOIN " +
                " ( SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time,COUNT(f_tbid) as xjnum  FROM " +
                " ( SELECT ar1.* FROM approve AS ar1 where ar1.f_taskid = '"+taskId+"' AND ar1.f_stepindex = 0) " +
                " as tar GROUP BY f_tbid) ar2 on ar2.f_tbid = ar3.f_tbid and ar2.f_approve_time = ar3.f_approve_time) ar " +
                " ON  t.f_id = ar.f_tbid "+
                " LEFT JOIN ( " +
                " SELECT ar4.*,ar5.sjnum " +
                " FROM approve AS ar4 INNER JOIN ( " +
                " SELECT f_tbid,MAX ( f_approve_time ) AS f_approve_time ,COUNT(f_tbid) as sjnum FROM( " +
                " SELECT ar6.* FROM approve AS ar6 where ar6.f_taskid ='"+taskId+"' AND ar6.f_stepindex = 1 ) AS tar " +
                " GROUP BY f_tbid ) ar5 ON ar5.f_tbid = ar4.f_tbid AND ar5.f_approve_time = ar4.f_approve_time " +
                " ) ar7 ON T.f_id = ar7.f_tbid ";

        if(StringUtils.isNotBlank(tmpTable1)){
            shListSql1 += " INNER JOIN tmp on tmp.f_id = t.f_id ";
        }
        if(regions!=""){
            regions=regions.substring(0,regions.length()-1);
            shListSql1+=" where t.f_xzqdm in ("+regions+")";
        }
        List<Map<String, Object>> shNumList  = this.jdbcTemplate.queryForList(shListSql1);
        return shNumList;
    }

    /**
     * 数据excel模板填充生成
     * @param
     */
    public String createCgjcApproveRecordExcel( List<Map<String, Object>> dataList,String taskName) throws Exception {
      /*  String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = new StringBuilder()
                .append(pathRoot)
                .append("excel")
                .append(File.separator)
                .append("常规监测市级审核记录模板.xlsx")
                .toString();*/
        ClassPathResource STSONG = new ClassPathResource("/static/excel/常规监测市级审核记录模板.xlsx");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile(STSONG.getInputStream(), STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();
        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append(taskName+"_市级审核记录_"+System.currentTimeMillis()+".xlsx")
                .toString();

        try{
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, String>> listMap=new ArrayList<>();
            for (int i=0;i<dataList.size();i++){
                Map<String, String> cmap=new HashMap<>();
                for(String key : dataList.get(i).keySet()){
                    if(dataList.get(i).get(key)!=null && !"null".equals(dataList.get(i).get(key))){
                        cmap.put(key,dataList.get(i).get(key).toString());
                    }else {
                        if(key.equals("xj_remark")){
                            if(dataList.get(i).containsKey("xj_option") && dataList.get(i).get("xj_option") !=null){
                                if(Integer.valueOf(dataList.get(i).get("xj_option").toString()) == 1){
                                    cmap.put(key,"通过");
                                }else if(Integer.valueOf(dataList.get(i).get("xj_option").toString()) == 2){
                                    cmap.put(key,"不通过");
                                }else{
                                    cmap.put(key,"未审");
                                }
                            }else {
                                cmap.put(key,"");
                            }
                        } else if(key.equals("f_remark")){
                            if(dataList.get(i).containsKey("f_option") && dataList.get(i).get("f_option") !=null){
                                if(Integer.valueOf(dataList.get(i).get("f_option").toString()) == 1){
                                    cmap.put(key,"通过");
                                }else if(Integer.valueOf(dataList.get(i).get("f_option").toString()) == 2){
                                    cmap.put(key,"不通过");
                                }else{
                                    cmap.put(key,"未审");
                                }
                            }else {
                                cmap.put(key,"");
                            }
                        }else {
                            cmap.put(key,"");
                        }
                    }

                }
                listMap.add(cmap);
            }

            map.put("maplist",listMap);
            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }


}
