package com.geoway.landteam.landcloud.service.statistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.google.gson.JsonObject;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;


/*
 * @author   : lcw
 * @date     : 2022/7/5
 * @des      :
 **/
@Service("CgjcProgressService")
public class CgjcProgressService {

    private GiLoger logger = GwLoger.getLoger(CgjcProgressService.class);

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private MinIOService minIOService;

    @Value("${project.applicationType}")
    protected String applicationType;

    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Resource
    TaskRecordService taskRecordService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    private SysConfigRepository configRepository;

    @Autowired
    RedisTemplate redisTemplate;

    @Autowired
    RegionService regionService;

    @Autowired
    MTskTaskBizService mTskTaskBizService;

    public String createCgjcProgress(TaskQueryParameter parameter, String xzqdm, Long userId) throws Exception {
        String taskId = parameter.getTaskId();
        parameter.setUserId(userId);
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
        if (tskTaskBiz==null){
            throw new Exception("当前任务不存在");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());

        if (tbtskObjectinfo==null){
            throw new Exception("当前任务table信息不存在");
        }
        Pair<Long, List<Map>> longListPair = mTskTaskBizService.queryWebDisplayListDataNotPage(parameter);
        Pair<Long, List<Map>> pair = Pair.of(longListPair.getKey(), longListPair.getValue());
        List<Map> mapList = pair.getRight();
        //List<String> ids = mapList.stream().map(map -> map.get("f_id").toString()).collect(Collectors.toList());
        List<String> ids = new ArrayList<>();
        int submitNum = 0;
        for(Map map : mapList){
            String f_id =  map.get("f_id").toString();
            Integer f_status =  map.get("f_status")!=null?Integer.valueOf(map.get("f_status").toString()):1;
            if(f_status >=4){
                submitNum++;
            }
            ids.add(f_id);
        }
        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = new ArrayList<>();
        if(redisTemplate.hasKey("region_all")){
            result= (List<Region>) redisTemplate.opsForValue().get("region_all");
        }else{
           result = regionService.queryAllRegionAndCode(provinceCode);
            redisTemplate.opsForValue().set("region_all",result,30, TimeUnit.DAYS);
        }
        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有
        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(xzqdm.equals("")||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }
        String excelPath="";
        try{
            JSONObject paramObject = new JSONObject();
            String paramKey = "";
            if(redisTemplate.hasKey(tbtskObjectinfo.getfId()+"_CgjcprogressParamObject")){
                paramObject= (JSONObject) redisTemplate.opsForValue().get(tbtskObjectinfo.getfId()+"_CgjcprogressParamObject");
            }else{
                paramObject.put(String.valueOf(parameter),tbtskObjectinfo.getfId()+"_CgjcprogressParamObject_"+paramObject.size());
                //paramKey  = tbtskObjectinfo.getfId()+"_CgjcprogressParamObject_"+paramObject.size();
                redisTemplate.opsForValue().set(tbtskObjectinfo.getfId()+"_CgjcprogressParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
            }
            if(paramObject.containsKey(String.valueOf(parameter))){
                paramKey = paramObject.getString(String.valueOf(parameter));
            }else{
                paramKey = tbtskObjectinfo.getfId()+"_CgjcprogressParamObject_"+paramObject.size();
                paramObject.put(String.valueOf(parameter),paramKey);
                redisTemplate.opsForValue().set(tbtskObjectinfo.getfId()+"_CgjcprogressParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
            }
            //先读取redis
            Map<String, Map<String, Object>> tbNumMap=new HashMap<>();
            Map<String, Map<String, Object>> shNumMap=new HashMap<>();
            if(StringUtils.isNotBlank(paramKey) && redisTemplate.hasKey(paramKey+"_tbNumMap")){
                tbNumMap=(Map<String, Map<String, Object>>)redisTemplate.opsForValue().get(paramKey+"_tbNumMap");
            }else{
                tbNumMap= getTbNum(tbtskObjectinfo.getfTablename(),StringUtils.join(ids,","));
                redisTemplate.opsForValue().set(paramKey+"_tbNumMap",tbNumMap,6*60*60, TimeUnit.SECONDS);
            }
            if(StringUtils.isNotBlank(paramKey) && redisTemplate.hasKey(paramKey+"_shNumMap")){
                shNumMap=(Map<String, Map<String, Object>>)redisTemplate.opsForValue().get(paramKey+"_shNumMap");
            }else{
                shNumMap= getShNum(tbtskObjectinfo.getfTablename(),taskId,StringUtils.join(ids,","));
                redisTemplate.opsForValue().set(paramKey+"_shNumMap",shNumMap,6*60*60, TimeUnit.SECONDS);
            }
/*
            if(redisTemplate.hasKey(tbtskObjectinfo.getfTablename()+"_tbNumMap")){
                tbNumMap=(Map<String, Map<String, Object>>)redisTemplate.opsForValue().get(tbtskObjectinfo.getfTablename()+"_tbNumMap");
            }else{
                tbNumMap= getTbNum(tbtskObjectinfo.getfTablename(),StringUtils.join(ids,","));
                redisTemplate.opsForValue().set(tbtskObjectinfo.getfTablename()+"_tbNumMap",tbNumMap,24*60*60, TimeUnit
                        .SECONDS);
            }
            if(redisTemplate.hasKey(tbtskObjectinfo.getfTablename()+"_shNumMap")){
                shNumMap=(Map<String, Map<String, Object>>)redisTemplate.opsForValue().get(tbtskObjectinfo.getfTablename()+"_shNumMap");
            }else{
                shNumMap= getShNum(tbtskObjectinfo.getfTablename(),taskId,StringUtils.join(ids,","));
                redisTemplate.opsForValue().set(tbtskObjectinfo.getfTablename()+"_shNumMap",shNumMap,24*60*60, TimeUnit
                        .SECONDS);
            }
*/
            excelPath= createCgjcProgressExcel(cRegions,tbNumMap,shNumMap,ids.size(),submitNum);
        }catch (Exception e){
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return excelPath;
    }


    /**
     * 获取图斑统计信息
     * @param
     */
    public Map<String, Map<String, Object>> getTbNum(String tableName,String tbIds){
        String tbFilter = "";
        if(StringUtils.isNotBlank(tbIds)) {
            tbFilter = " with tmp as (select unnest(string_to_array('" + tbIds + "',',')) f_id ) ";
        }
        //图斑数、未下发数、未提交,已回退、外业核查、内业核查，按行政区统计
        String tbSql = "";
        if(StringUtils.isNotBlank(tbFilter)){
            tbSql = ",tmp where tmp.f_id = t.f_id ";
        }
        String tbNumSql = tbFilter + "select substring(f_xzqdmsys,1,6) f_xzqdm, " +
                " count(1)  tbnum ," +
                " count(f_status = 1 OR NULL) wxfnum ," +
                " count(f_status = 2 OR NULL) wtjnum," +
                " count(f_status = 5 OR NULL) ythnum," +
                " count((f_status>=4 and f_submit_userid is not null) or NULL ) wyhcnum, " +
                " count((f_status>=4 and f_submit_userid is null) or NULL ) nyhcnum  from "+ tableName + " t " + tbSql+" group by substring(f_xzqdmsys,1,6)";
        List<Map<String, Object>> tbNumList  = this.jdbcTemplate.queryForList(tbNumSql);
        Map<String, Map<String, Object>> tbNumMap=new HashMap<>();

        for (int i=0;i<tbNumList.size();i++){
            tbNumMap.put(tbNumList.get(i).get("f_xzqdm").toString(),tbNumList.get(i));
        }
        return tbNumMap;
    }

    /**
     * 获取审核统计信息
     * @param
     */
    public Map<String, Map<String, Object>> getShNum(String tableName,String taskId,String tbIds){
        //区县通过、市级通过、市级未通过
        String tbFilter = "";
        if(StringUtils.isNotBlank(tbIds)) {
            tbFilter = " with tmp1 as (select unnest(string_to_array('" + tbIds + "',',')) f_id ) ";
        }
        //图斑数、未下发数、未提交,已回退、外业核查、内业核查，按行政区统计
        String tbSql = "";
        String tableSql = "";
        if(StringUtils.isNotBlank(tbFilter)){
            tbSql = " and tb.f_id = tmp1.f_id ";
            tableSql = ",tmp1";
        }
        String sql = tbFilter + "select \n" +
                "f_xzqdm,\n" +
                "sum(\n" +
                "case when (code = 0 and f_stepname = '区县审核') or f_review_stage > 93 then 1 else 0 \n" +
                "end ) as qxtgnum,\n" +
                "sum(\n" +
                "case when (code = 1 and f_stepname = '区县审核') and f_review_stage < 95 then 1 else 0 \n" +
                "end ) as qxwtgnum,\n" +
                "sum(\n" +
                "case when (code = 0 and f_stepname = '市级审核') or f_review_stage = 101 then 1 else 0 \n" +
                "end ) as sjtgnum,\n" +
                "sum(\n" +
                "case when (code = 1 and f_stepname = '市级审核') and f_review_stage < 101 then 1 else 0 \n" +
                "end ) as sjwtgnum\n" +
                "from (\n" +
                "with tmp as (\n" +
                "\tselect f_taskid,f_tbid,f_stepname,f_approve_time timedate,0 code  from tbtsk_approve_record ar where ar.f_is_revoked is null and  f_taskid = '"+taskId+"' \n" +
                "\tunion all \n" +
                "\tselect f_taskid,f_tbid,f_stepname,f_reject_time timedate,1 code from tbtsk_reject_record rr where f_taskid = '"+taskId+"'\n" +
                ")\n" +
                "select substring(tb.f_xzqdmsys,1,6) f_xzqdm,region.f_xzqmc,tb.f_review_stage,tb.f_id,tb.f_tbbh,tmp.* from "+tableName+" tb,tmp,tb_region region"+tableSql+" where tb.f_id = tmp.f_tbid\n" +
                "and not exists(select null from tmp t where t.f_tbid = tmp.f_tbid and t.timedate > tmp.timedate ) and region.f_xzqdm = substring(tb.f_xzqdmsys,1,6)\n" + tbSql +
                ") g group by f_xzqdm,f_xzqmc";
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql);


        Map<String, Map<String, Object>> shNumMap=new HashMap<>();

        for (Map<String, Object> map : list) {
            Map map1 = new HashMap();
            map1.put("qxtgnum",map.get("qxtgnum").toString());
            map1.put("qxwtgnum",map.get("qxwtgnum").toString());
            map1.put("sjtgnum",map.get("sjtgnum").toString());
            map1.put("sjwtgnum",map.get("sjwtgnum").toString());
            shNumMap.put(map.get("f_xzqdm").toString(),map1);
        }

//        for (int i=0;i<qxNumList.size();i++){
//            Map<String, Object> newMap= new HashMap<>();
//            newMap.put("qxtgnum",qxNumList.get(i).get("qxtgnum"));
//            newMap.put("qxwtgnum",qxNumList.get(i).get("qxwtgnum"));
//            newMap.put("sjtgnum",0);
//            newMap.put("sjwtgnum",0);
//            newMap.put("f_xzqdm",qxNumList.get(i).get("f_xzqdm"));
//            shNumMap.put(qxNumList.get(i).get("f_xzqdm").toString(),newMap);
//        }
//
//        for (int i=0;i<sjNumList.size();i++){
//            String xzqdm = sjNumList.get(i).get("f_xzqdm").toString();
//            if (shNumMap.containsKey(xzqdm)){
//                Map<String, Object> map = shNumMap.get(xzqdm);
//                map.put("sjtgnum",sjNumList.get(i).get("sjtgnum"));
//                map.put("sjwtgnum",sjNumList.get(i).get("sjwtgnum"));
//                shNumMap.put(xzqdm,map);
//            }else {
//                Map<String, Object> newMap= new HashMap<>();
//                newMap.put("qxtgnum",0);
//                newMap.put("qxwtgnum",0);
//                newMap.put("sjtgnum",sjNumList.get(i).get("sjtgnum"));
//                newMap.put("sjwtgnum",sjNumList.get(i).get("sjwtgnum"));
//                newMap.put("f_xzqdm",sjNumList.get(i).get("f_xzqdm"));
//                shNumMap.put(sjNumList.get(i).get("f_xzqdm").toString(),newMap);
//            }
//
//        }
        //sql
//        String sql = " select "
        return shNumMap;
    }

    /**
     * 数据excel模板填充生成
     * @param
     */
    public String createCgjcProgressExcel(List<Region>  cRegions,Map<String, Map<String, Object>> tbNumMap,
                                          Map<String, Map<String, Object>> shNumMap,Integer totalNum,Integer submitNum) throws Exception {
        ClassPathResource STSONG = new ClassPathResource("/static/excel/常规监测进度统计模板.xls");
        File STSONGFile = File.createTempFile("template_STSONG_copy", ".xls");
        FileUtils.copyInputStreamToFile(STSONG.getInputStream(), STSONGFile);
        String srcFileName = STSONGFile.getAbsolutePath();

        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append("常规监测进度统计_"+System.currentTimeMillis()+".xls")
                .toString();

        try{
            List<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i=0;i<cRegions.size();i++){
                Map<String, String> data=new HashMap<>();
                data.put("xzqmc",cRegions.get(i).getName());
                //图斑统计值，封装
                if(tbNumMap.get(cRegions.get(i).getCode())!=null){
                    //图斑数量
                    data.put("tbnum",tbNumMap.get(cRegions.get(i).getCode()).get("tbnum").toString());
                    //未下发数量
                    data.put("wxfnum",tbNumMap.get(cRegions.get(i).getCode()).get("wxfnum").toString());
                    //未提交数量
                    data.put("wtjnum",tbNumMap.get(cRegions.get(i).getCode()).get("wtjnum").toString());
                    //已退回数量
                    data.put("ythnum",tbNumMap.get(cRegions.get(i).getCode()).get("ythnum").toString());
                    //外业核查数量
                    data.put("wyhcnum",tbNumMap.get(cRegions.get(i).getCode()).get("wyhcnum").toString());
                    //内业核查数量
                    data.put("nyhcnum",tbNumMap.get(cRegions.get(i).getCode()).get("nyhcnum").toString());
                }else{
                    data.put("tbnum","0");
                    data.put("wxfnum","0");
                    data.put("wtjnum","0");
                    data.put("ythnum","0");
                    data.put("wyhcnum","0");
                    data.put("nyhcnum","0");
                }
                //审核统计值，封装
                if(shNumMap.get(cRegions.get(i).getCode())!=null){
                    //区县审核通过数量
                    data.put("qxtgnum",shNumMap.get(cRegions.get(i).getCode()).get("qxtgnum").toString());
                    data.put("qxwtgnum",shNumMap.get(cRegions.get(i).getCode()).get("qxwtgnum").toString());
                    //市级审核通过数量
                    data.put("sjtgnum",shNumMap.get(cRegions.get(i).getCode()).get("sjtgnum").toString());
                    //市级审核未通过数量
                    data.put("sjwtgnum",shNumMap.get(cRegions.get(i).getCode()).get("sjwtgnum").toString());
                }else{
                    data.put("qxtgnum","0");
                    data.put("qxwtgnum","0");
                    data.put("sjtgnum","0");
                    data.put("sjwtgnum","0");
                }
                //区县审核未通过数量
                listMap.add(data);
            }

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("maplist",listMap);

            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }

            //// 处理尾部合并的数据
            Sheet sheetAt = workbook.getSheetAt(0);
            int lastRowNum = 44;
           // int lastRowNum = sheetAt.getLastRowNum()+1;
            //在指定行后追加数据
            sheetAt.addMergedRegion(new CellRangeAddress(lastRowNum,lastRowNum,0,10));
            Row row = sheetAt.createRow(lastRowNum);
            Cell cell = row.createCell(0);
            cell.setCellValue("备注：图斑总数("+totalNum+")=未提交("+(totalNum-submitNum)+")+已提交("+submitNum+")");
            row.setHeightInPoints(30);
            CellStyle cellStyle = workbook.createCellStyle();
            /*cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
            cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
            cellStyle.setBorderTop(BorderStyle.THIN);//上边框
            cellStyle.setBorderRight(BorderStyle.THIN);//右边框*/
            cellStyle.setAlignment(HorizontalAlignment.CENTER); // 水平对齐 居中
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER); //垂直居中对齐
            cell.setCellStyle(cellStyle);
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
//            ExcelWriter excelWriter = EasyExcel.write(ouputPath).withTemplate(srcFileName).build();
//            WriteSheet writeSheet = EasyExcel.writerSheet().build();
//            // 这里注意 入参用了forceNewRow 代表在写入list的时候不管list下面有没有空行 都会创建一行，然后下面的数据往后移动。默认 是false，会直接使用下一行，如果没有则创建。
//            // forceNewRow 如果设置了true,有个缺点 就是他会把所有的数据都放到内存了，所以慎用
//            // 简单的说 如果你的模板有list,且list不是最后一行，下面还有数据需要填充 就必须设置 forceNewRow=true 但是这个就会把所有数据放到内存 会很耗内存
//            // 如果数据量大 list不是最后一行 参照下一个
//            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
//            excelWriter.fill(listMap, fillConfig, writeSheet);
        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }


    /**
     * 异步常规监测进度excel
     *
     * @param userId
     * @return
     */

    public DataDownloadRecord downloadCgjcProgress(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        DataDownloadRecord record = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId);
        record.setName("常规监测进度统计("+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())+")");
        dataDownloadRecordService.save(record);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(), JSON.toJSONString(record), 2, TimeUnit.DAYS);

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString(parameter));
        attachParameter.setBizType("statistics");
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        // 类型为空
        attachParameter.setDownloadType(0);
        attachParameter.setDataType("progressRecord");
        String parameterString = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);
        return record;
    }



    public void runDownloadCgjcProgress(TaskRecord taskRecord,DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try{
            Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
            if (value != null) {
                dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                if (dataDownloadRecord != null) {
                    if(dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)){
                        throw new Exception("用户取消了下载任务");
                    };
                    String condition = downloadParameter.getCondition();
                    TaskQueryParameter parameter = JSONObject.toJavaObject(JSONObject.parseObject(condition),TaskQueryParameter.class);
                    String path = createCgjcProgress(parameter,parameter.getRegionCode(),parameter.getUserId());
                    File srcFile = new File(path);
                    logger.info("日常任务下载 开始上传到obs " + path);

                    String resultUrl="";
                    // zip文件上传到obs云盘
                    if ("lan".equals(this.applicationType)) {
                        resultUrl= this.uploadFileToDisk(taskRecord.getUserid(), srcFile);
                    } else {
                        resultUrl= uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                    }

                    if (dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                        throw new Exception("用户取消了下载任务");
                    }
                    // 计算大小
                    Double fileSize = srcFile.length() / 1024d;
                    dataDownloadRecord.setAttachSize(fileSize);
                    dataDownloadRecord.setUrl(resultUrl);
                    dataDownloadRecord.setEndTime(new Date());
                    dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                    dataDownloadRecordService.save(dataDownloadRecord);
                    srcFile.delete();
                }
            }
        }catch (Exception e){
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
    }

    /**
     * 上传到云盘
     *
     * @param userId
     * @param
     */
    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        // 上传到obs
        return ossOperatorService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl="";

        if (true) {
            File destFile = new File(this.applicationType, "media/" + file.getName());
            FileUtils.copyFile(file, destFile);
            resultUrl = "media/" + sendObjName;
        } else {
            this.minIOService.addToBucket(sendObjName, file.getAbsolutePath());
            resultUrl = sendObjName;
        }
        return resultUrl;
    }

}
