package com.geoway.landteam.landcloud.service.statistics;


import com.geoway.landteam.landcloud.common.dto.EasyUIResponse;
import com.geoway.landteam.landcloud.model.statistics.dto.Gztj;
import com.geoway.landteam.landcloud.model.statistics.dto.HeatMap;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

public interface CgjcService {
    /**
     * 获取热力图结果
     * @param name
     * @param wkt
     * @param num 聚合点个数
     * @return
     */
    public List<HeatMap> getByWkt(String name, String wkt, Integer num, Double xmin, Double xmax, Double ymin, Double ymax, String isYswt);

    /**
     * 按行政区划统计
     * @param level
     * @return
     */
    public Map<String, Long> getStatisticsByLevel(String name, Integer level, String isYswt);

    /**
     * 获取图斑
     *
     * @param request
     * @param name 季度名称
     * @param page 页面，从1开始
     * @param pageSize 页数
     * @param shp 是否返回空间数据
     * @param tbbh 图斑标会
     * @param xzqmc 行政区名称（只支持区县级）
     * @param bhlx 变化类型
     * @param wkt
     * @param ztfx 专题分析
     * @param zdgkq 重点管控区
     * @param sxws 手续完善
     * @param xzmc 乡镇名称
     * @return
     */
    public EasyUIResponse getStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh,
                                              String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, String xzmc);
    /**
     * 获取疑似问题图斑
     *
     * @param request
     * @param name 季度名称
     * @param page 页面，从1开始
     * @param pageSize 页数
     * @param shp 是否返回空间数据
     * @param tbbh 图斑标会
     * @param xzqmc 行政区名称（只支持区县级）
     * @param bhlx 变化类型
     * @param wkt
     * @param ztfx 专题分析
     * @param zdgkq 重点管控区
     * @param sxws 手续完善
     * @param wtfl 问题分类
     * @param xzmc 乡镇名称
     * @return
     */
    public EasyUIResponse getYswtStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh,
                                                  String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, Integer wtfl,
                                                  String xzmc);

    /**
     * 获取图斑数据
     * @param name
     * @param wkt
     * @return
     */
    public List<Map<String, Object>> getDataByWkt(String name, String wkt);

    /**
     * 工作统计统计接口
     * @param seasons 季度，逗号间隔，格式：202102,202103
     * @param xzqdms 行政区代码，逗号间隔
     * @return
     */
    public Gztj getStatistics(String seasons, String xzqdms);

    /**
     * 获取最新的季度
     * @return
     */
    String getLastSeasion();

    /**
     * 全量下载，接口同getStatisticsByPage
     * @param name
     * @param tbbh
     * @param xzqmc
     * @param bhlx
     * @param wkt
     * @param ztfx
     * @param zdgkq
     * @param sxws
     * @param userId
     * @throws Exception
     */
    public void downloadAll(HttpServletRequest request, String name, String tbbh, String xzqmc, String bhlx, String jzqk, String wkt,
                            String ztfx, String zdgkq, String sxws, Long userId) throws Exception;

    public List<Map<String, Object>> getWyjd(String name);
}