package com.geoway.landteam.landcloud.service.statistics;


import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.statistics.dto.GdLrLcTotalEntity;
import com.geoway.landteam.landcloud.servface.pub.MinIOService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/*
 * @author   : lcw
 * @date     : 2022/6/9
 * @des      : 耕地流出汇通服务类，用于excel数据汇总
 **/
@Service("GdLcTotalService")
public class GdLcTotalService {

    private GiLoger logger = GwLoger.getLoger(GdLcTotalService.class);

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    private MinIOService minIOService;

    @Value("${project.applicationType}")
    protected String applicationType;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    private ExecutorService executor = Executors.newCachedThreadPool();

    @Resource
    TaskRecordService taskRecordService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;

    @Autowired
    SysConfigRepository configRepository;

    @Autowired
    RegionService regionService;

    @Autowired
    MTskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    RedisTemplate redisTemplate;

    //当前table筛选条件sql
    public String tableConditionSql="";

    public String lrlcTemplateId="b5dee4b2-8b06-414a-b182-2715079afe93";


    /**
     * 创建耕地流入流出汇总数据excel模板填充生成任务
     * @param taskId
     */
    public String createGdLrLcTotal(TskTaskBiz tskTaskBiz, String xzqdm, Long userId, String conditionSql, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        tableConditionSql = conditionSql;
        JSONObject paramObject = new JSONObject();
        String paramKey = "";
        if(redisTemplate.hasKey(tskTaskBiz.getId()+"_GdLrLcParamObject")){
            paramObject= (JSONObject) redisTemplate.opsForValue().get(tskTaskBiz.getId()+"_GdLrLcParamObject");
        }else{
            paramObject.put(tableConditionSql,tskTaskBiz.getId()+"_GdLrLcParamObject_"+paramObject.size());
           // paramKey  = tskTaskBiz.getId()+"_GdLrLcParamObject_"+paramObject.size();
            redisTemplate.opsForValue().set(tskTaskBiz.getId()+"_GdLrLcParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
        }
        if(paramObject.containsKey(tableConditionSql)){
            paramKey = paramObject.getString(tableConditionSql);
        }else{
            paramKey = tskTaskBiz.getId()+"_GdLrLcParamObject_"+paramObject.size();
            paramObject.put(tableConditionSql,paramKey);
            redisTemplate.opsForValue().set(tskTaskBiz.getId()+"_GdLrLcParamObject",paramObject,6*60*60, TimeUnit.SECONDS);
        }
        TbtskObjectinfo tbtskObjectinfo = null;
        if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
            tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        }
        //获取所有行政区信息
        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = new ArrayList<>();
        if(redisTemplate.hasKey("region_all")){
            result= (List<Region>) redisTemplate.opsForValue().get("region_all");
        }else{
            result = regionService.queryAllRegionAndCode(provinceCode);
            redisTemplate.opsForValue().set("region_all",result,30, TimeUnit.DAYS);
        }

        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有

        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(StringUtils.isBlank(xzqdm)||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }
        String path="";
        try {
            List<GdLrLcTotalEntity>  gdLrLcTotalList = new ArrayList<>();
            for (int i = 0 ;i<cRegions.size();i++){
                GdLrLcTotalEntity gdLrLcTotalEntity=new GdLrLcTotalEntity();
                //先从redis读取
                if(StringUtils.isNotBlank(paramKey) && redisTemplate.hasKey(paramKey+"_LC_"+cRegions.get(i).getCode())){
                    gdLrLcTotalEntity=(GdLrLcTotalEntity)redisTemplate.opsForValue().get(paramKey+"_LC_"+cRegions.get(i).getCode());
                }else {
                    gdLrLcTotalEntity.setXzqdm(cRegions.get(i).getCode());
                    gdLrLcTotalEntity.setXzqmc(cRegions.get(i).getName());
                    getGdLrLcTotalData(tbtskObjectinfo,gdLrLcTotalEntity);
                    redisTemplate.opsForValue().set(paramKey+"_LC_"+cRegions.get(i).getCode(),gdLrLcTotalEntity,6*60*60, TimeUnit.SECONDS);
                }
                gdLrLcTotalEntity.setOrder(i+1);
                gdLrLcTotalList.add(gdLrLcTotalEntity);
            }
            path= createGdLrLcTotalExcel(gdLrLcTotalList,shhj,shzt,shsjStart,shsjEnd);
//                    exportFileTaskEntity.setStatus(1);
//                    exportFileTaskEntity.setResult("创建成功");
//                    exportFileTaskEntity.setFinishtime(new Date());
//                    exportFileTaskEntity.setFilepath(path);
//                    exportFileTaskDao.save(exportFileTaskEntity);
        } catch (Exception e) { // 设置任务状态为失败
//                    exportFileTaskEntity.setStatus(2);
//                    exportFileTaskEntity.setResult(e.getMessage());
//                    exportFileTaskDao.save(exportFileTaskEntity);
            e.printStackTrace();
            throw new Exception("导出失败");
        }
//            }
//        });
//
//        executor.execute(thread);
        return path;
    }


    /**
     * 耕地流入流出汇总数据excel模板填充生成
     * @param gdLrLcTotalList
     */
    public String createGdLrLcTotalExcel(List<GdLrLcTotalEntity> gdLrLcTotalList,String shhj,String shzt,String shsjStart,String shsjEnd) throws Exception {
//        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        ClassPathResource xftbmx = new ClassPathResource("/excel/耕地流入流出系统抓取汇总表模板.xls");
        InputStream gdlrlcInputStream = xftbmx.getInputStream();
        File gdlrlcFile = File.createTempFile("template_gdlrlc_copy", ".xls");
        try {
            FileUtils.copyInputStreamToFile(gdlrlcInputStream, gdlrlcFile);
        } finally {
            IOUtils.closeQuietly(gdlrlcInputStream);
        }
        String srcFileName = new StringBuilder()
                .append(gdlrlcFile.getAbsolutePath())
                .toString();
        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append("耕地流出系统抓取汇总表_"+System.currentTimeMillis()+".xls")
                .toString();

        try{
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i=0 ;i<gdLrLcTotalList.size();i++){
                Map<String, String> cmap= beanToMap(gdLrLcTotalList.get(i));
                listMap.add(cmap);
            }
            map.put("maplist",listMap);
            map.put("shhj",shhj);
            map.put("shzt","通过");
            map.put("shsjStart",shsjStart);
            map.put("shsjEnd",shsjEnd);

            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
//            EasyExcel.write(ouputPath)
//                    .withTemplate(srcFileName)
//                    .sheet("Sheet1")
//                    .doFill(gdLrLcTotalList);

        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }





    public static Map<String,String> beanToMap(Object object) throws IllegalAccessException {
        Map<String, String> map = new HashMap<String, String>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object).toString());
        }
        return map;
    }

    /**
     * 耕地流入流出汇总数据获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public void getGdLrLcTotalData(TbtskObjectinfo tbtskObjectinfo, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception {

        boolean isSplited = false;
        if(tbtskObjectinfo.getfIsspatial() != null && tbtskObjectinfo.getfIsspatial().equals(1)
                && StringUtils.isNotBlank(tbtskObjectinfo.getSplitTableName())) {
            isSplited = true;
        }
        String tableName = tbtskObjectinfo.getfTablename();
        String childTableName = tbtskObjectinfo.getSplitTableName();
        Integer integer = tbtskObjectinfo.getfIsspatial();
        //合法占用耕地数据sql获取
        String hfzygdSql=this.getHfzygdSql(tableName,gdLrLcTotalEntity, isSplited, false);

        //违法违规占用耕地SQL获取
        String wfwgzygdSql=this.getWfwgzygdSql(tableName,gdLrLcTotalEntity, isSplited, false);

        //耕地非粮化SQL获取
        String gdflhSql=this.getGdflhSql(tableName,gdLrLcTotalEntity,  isSplited, false);

        String allSql = hfzygdSql + " UNION ALL " + wfwgzygdSql + " UNION ALL " + gdflhSql;

        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);

        if(integer != null && integer.equals(1) && StringUtils.isNotBlank(childTableName)) {
            //合法占用耕地数据sql获取
            String childhfzygdSql=this.getHfzygdSql(childTableName,gdLrLcTotalEntity, isSplited, true);

            //违法违规占用耕地SQL获取
            String childwfwgzygdSql=this.getWfwgzygdSql(childTableName,gdLrLcTotalEntity, isSplited, true);

            //耕地非粮化SQL获取
            String childgdflhSql=this.getGdflhSql(childTableName,gdLrLcTotalEntity, isSplited, true);
            String childallSql = childhfzygdSql + " UNION ALL " + childwfwgzygdSql + " UNION ALL " + childgdflhSql;
            List<Map<String,Object>> childresult= this.jdbcTemplate.queryForList(childallSql);
            for (Map<String, Object> map : result) {
                String name = map.get("name").toString();
                double sum = Double.parseDouble(map.get("sum").toString());
                List<Map<String, Object>> filterMap = childresult.stream().filter(u -> u.get("name").toString().equals(name)).collect(Collectors.toList());
                if(filterMap != null && filterMap.size() >= 0) {
                    double childSum = Double.parseDouble(filterMap.get(0).get("sum").toString());
                    double allSum = sum + childSum;
                    map.put(name, allSum);
                }
            }
        }
        JSONObject jobj=new JSONObject();
        for(Map<String,Object> data:result) {
            jobj.put(data.get("name").toString(),data.get("sum"));
        }

        //耕地流出->无手续占用耕地->合法占用耕地->小计
        gdLrLcTotalEntity.setHfzygdxj(Double.valueOf(jobj.getDouble("hfzygdxj"))+ Double.valueOf(jobj.getDouble("hfjsyd")));
        //耕地流出->无手续占用耕地->合法占用耕地->城镇及园区建设
        gdLrLcTotalEntity.setHfczjyqjc(Double.valueOf(jobj.getDouble("hfczjyqjc")));
        //耕地流出->无手续占用耕地->合法占用耕地->交通建设
        gdLrLcTotalEntity.setHfjtjs(Double.valueOf(jobj.getDouble("hfjtjs")));
        //耕地流出->无手续占用耕地->合法占用耕地->农房建设
        gdLrLcTotalEntity.setHflsyd(Double.valueOf(jobj.getDouble("hflsyd")));
        //耕地流出->无手续占用耕地->合法占用耕地->临时用地
        gdLrLcTotalEntity.setHfnfjs(Double.valueOf(jobj.getDouble("hfnfjs")));
        //耕地流出->无手续占用耕地->合法占用耕地->其他建设
//        gdLrLcTotalEntity.setHfqtjs(Double.valueOf(jobj.getDouble("hfqtjs")));
        //耕地流出->无手续占用耕地->城镇住宅及商业服务业
        gdLrLcTotalEntity.setWfczzzjsyfw(Double.valueOf(jobj.getDouble("wfczzzjsyfw")));
        //耕地流出->无手续占用耕地->采矿用地
        gdLrLcTotalEntity.setWfckyd(Double.valueOf(jobj.getDouble("wfckyd")));

        gdLrLcTotalEntity.setHfqtjs( new BigDecimal(gdLrLcTotalEntity.getHfzygdxj()
                        - gdLrLcTotalEntity.getHfczjyqjc()
                        - gdLrLcTotalEntity.getHfjtjs()
                        - gdLrLcTotalEntity.getHflsyd()
                        - gdLrLcTotalEntity.getHfnfjs()
                        - Double.valueOf(jobj.getDouble("hfryjsyd"))
                ).setScale(2, RoundingMode.HALF_UP).doubleValue()
        );

        //耕地流出->无手续占用耕地->违法违规占用耕地->小计
        gdLrLcTotalEntity.setWfwgzygdxj(Double.valueOf(jobj.getDouble("wfwgzygdxj")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->交通建设
        gdLrLcTotalEntity.setWfjtjs(Double.valueOf(jobj.getDouble("wfjtjs")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->公共服务基础设施建设
        gdLrLcTotalEntity.setWfggfwjcssjs(Double.valueOf(jobj.getDouble("wfggfwjcssjs")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->园区未批先建
        gdLrLcTotalEntity.setWfyqwpxj(Double.valueOf(jobj.getDouble("wfyqwpxj")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->农房建设
        gdLrLcTotalEntity.setWfnfjs(Double.valueOf(jobj.getDouble("wfnfjs")));

        //耕地流出->无手续占用耕地->违法违规占用耕地->其他建设
        gdLrLcTotalEntity.setWfqtjs(new BigDecimal(gdLrLcTotalEntity.getWfwgzygdxj()
                - gdLrLcTotalEntity.getWfjtjs()
                - gdLrLcTotalEntity.getWfggfwjcssjs()
                - gdLrLcTotalEntity.getWfyqwpxj()
                - gdLrLcTotalEntity.getWfnfjs()).setScale(2, RoundingMode.HALF_UP).doubleValue()
        );

        //耕地流出->耕地非粮化-小计
        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdflhxj")));
        //耕地流出->耕地非粮化->农村道路
        gdLrLcTotalEntity.setFlncdl(Double.valueOf(jobj.getDouble("flncdl")));
        //耕地流出->耕地非粮化->设施农用地
        gdLrLcTotalEntity.setFlssnyd(Double.valueOf(jobj.getDouble("flssnyd")));
        //耕地流出->耕地非粮化->水库建设
        gdLrLcTotalEntity.setFlskjs(Double.valueOf(jobj.getDouble("flskjs")));
        //耕地流出->耕地非粮化->沟渠建设
        gdLrLcTotalEntity.setFlgqjs(Double.valueOf(jobj.getDouble("flgqjs")));
        //耕地流出->耕地非粮化->变为林地
        gdLrLcTotalEntity.setFlbwld(Double.valueOf(jobj.getDouble("flbwld")));
        //耕地流出->耕地非粮化->变为园地
        gdLrLcTotalEntity.setFlbwyd(Double.valueOf(jobj.getDouble("flbwyd")));
        //耕地流出->耕地非粮化->变为坑塘
        gdLrLcTotalEntity.setFlbwkt(Double.valueOf(jobj.getDouble("flbwkt")));
        //耕地流出->耕地非粮化->变为其他
        gdLrLcTotalEntity.setFlbwqt( new BigDecimal(gdLrLcTotalEntity.getGdflhxj()
                - gdLrLcTotalEntity.getFlncdl()
                - gdLrLcTotalEntity.getFlssnyd()
                - gdLrLcTotalEntity.getFlskjs()
                - gdLrLcTotalEntity.getFlgqjs()
                - gdLrLcTotalEntity.getFlbwld()
                - gdLrLcTotalEntity.getFlbwyd()
                - gdLrLcTotalEntity.getFlbwkt()).setScale(2, RoundingMode.HALF_UP).doubleValue()
               );

        //耕地流入->耕地占补平衡->小计
        gdLrLcTotalEntity.setGdzbphxj(0);
        //耕地流入->耕地占补平衡->土地整理
        gdLrLcTotalEntity.setZbtdzl(0);
        //耕地流入->耕地占补平衡->农村建设用地复垦
        gdLrLcTotalEntity.setZbncjsydfk(0);


        //耕地流入->耕地进出平衡->小计
        gdLrLcTotalEntity.setGdjcphxj(0);
        //耕地流入->耕地进出平衡->林地整治为耕地
        gdLrLcTotalEntity.setJcldzzwgd(0);
        //耕地流入->耕地进出平衡->园地整治为耕地
        gdLrLcTotalEntity.setJcydzzwgd(0);
        //耕地流入->耕地进出平衡->坑塘水面整治为耕地
        gdLrLcTotalEntity.setJcktsmzzwgd(0);
        //耕地流入->耕地进出平衡->其他农用地整治为耕地
        gdLrLcTotalEntity.setJcqtnydzzwgd(0);


        //耕地流入->其他新增->小计
        gdLrLcTotalEntity.setQtxzxj(0);
        //耕地流入->其他新增->其他部门新增耕地
        gdLrLcTotalEntity.setQtbmxzgd(0);
        //耕地流入->其他新增->农民自主开垦耕地
        gdLrLcTotalEntity.setQtnmzzkkgd(0);
        //耕地流入->其他新增->LC耕地的整改
        gdLrLcTotalEntity.setQtlcgddzg(0);

        //合计
        gdLrLcTotalEntity.setHj(gdLrLcTotalEntity.getHfzygdxj()+gdLrLcTotalEntity.getWfwgzygdxj()+gdLrLcTotalEntity.getGdflhxj());

        gdLrLcTotalEntity.setGdlrzj(new BigDecimal(gdLrLcTotalEntity.getQtxzxj()
                + gdLrLcTotalEntity.getGdjcphxj()
                + gdLrLcTotalEntity.getGdzbphxj()).setScale(2, RoundingMode.HALF_UP).doubleValue() );

        gdLrLcTotalEntity.setYdgdzjl(Math.abs(gdLrLcTotalEntity.getGdlrzj())-Math.abs(gdLrLcTotalEntity.getHj()));

    }

    /**
     * 合法占用耕地数据SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getHfzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited, boolean isChildTable) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
          throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        commSql=" f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status >= 10 and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm()+"%' ";
        String isSplitedFilter = "";
        if(!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            // 如果是母图斑（只统计未分割的母图斑）
            commSql += isSplitedFilter;
        }
        //小计
        String hfzygdxjSql = getSelectSql("f_gdzymj","hfzygdxj",tableName) +commSql;
        //城镇及园区建设,条件
        String hfczjyqjcSql= getSelectSql("f_gdzymj","hfczjyqjc",tableName) +commSql+ " and (f_xzyjdl in ('08','09','10','11') or f_xzejdl in ('0701','0702','1301','1303','1304','1306','1309','1311','1313','1401','1402','1403')) ";
        //交通建设,条件
        String jtjsSql=getSelectSql("f_gdzymj","hfjtjs",tableName) +commSql+ " and (f_xzyjdl = '12' or f_sjyjydlx = '12') ";
        //农房建设,条件
        String nfjsSql=getSelectSql("f_gdzymj","hfnfjs",tableName) +commSql+ " and f_xzejdl in ('0703','0704') ";
        //临时用地,条件
        String lsydSql=getSelectSql("f_gdzymj","hflsyd",tableName) +commSql+ " and ( f_xzyjdl = '18' and (f_sjyjydlx != '12' and f_sjejydlx != '1501' )) ";
        //其他建设,条件
        String qtjsSql=getSelectSql("f_gdzymj","hfqtjs",tableName) +commSql+ " and (f_xzejdl in ('1312','1404','1501','1503','1505','1506','1507') or f_sjejydlx = '1501' or f_xzyjdl = '20') ";
        //军事用地，条件
        String jsydSql="";
        //冗余军事用地
        String ryjsydSql="";
        jsydSql=getSelectSql("f_gdzymj","hfjsyd",tableName)+ " f_zglx = '合法占用耕地' and f_rdwgdlc = '是' and f_status >= 10 and f_xzqdmsys = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' " + isSplitedFilter;
        ryjsydSql=getSelectSql("f_gdzymj","hfryjsyd",tableName)+ " f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status >= 10 and f_xzqdmsys = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' " + isSplitedFilter;
        String allSql=hfzygdxjSql + " UNION ALL " + hfczjyqjcSql + " UNION ALL " + jtjsSql +" UNION ALL "+ nfjsSql+" UNION ALL "+lsydSql + " UNION ALL " + jsydSql + " UNION ALL " + ryjsydSql + " UNION ALL " + qtjsSql;
        return allSql;
    }

    /**
     * 违法违规占用耕地SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getWfwgzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited,  boolean isChildTable) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        commSql=" f_zglx = '无手续占用耕地' and f_sfysx = '不具备手续' and f_rdwgdlc = '是' and f_status >= 10  and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm()+"%'";
        String isSplitedFilter = "";
        if(!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            // 如果是母图斑（只统计未分割的母图斑）
            commSql += isSplitedFilter;
        }

        //小计
        String wfwgzygdxj= getSelectSql("f_gdzymj","wfwgzygdxj",tableName) +commSql;


        //交通建设,条件
        String wfjtjsSql= getSelectSql("f_gdzymj","wfjtjs",tableName) +commSql+ " and ( f_xzyjdl = '12' or f_sjyjydlx = '12' ) ";
        //公共服务基础设施建设,条件
        String wfggfwjcssjsSql=getSelectSql("f_gdzymj","wfggfwjcssjs",tableName) +commSql+ " and (f_xzyjdl = '08' or f_xzejdl in ('1301','1303','1304','1306','1309','1313','1403') ) ";
        //园区未批先建,条件
        String wfyqwpxjSql=getSelectSql("f_gdzymj","wfyqwpxj",tableName) +commSql+ " and ( f_xzejdl = '1001' or f_sjejydlx = '1001' )  and f_sfgyyq='是' ";
        //农房建设,条件
        String wfnfjsSql=getSelectSql("f_gdzymj","wfnfjs",tableName) +commSql+ " and  ( f_xzejdl in ('0703','0704') or f_sjejydlx in ('0704','0703')) ";
        //城镇住宅及商业服务
        String wfczzzjsyfw=getSelectSql("f_gdzymj","wfczzzjsyfw",tableName) +commSql+ " and  ( f_xzyjdl = '09' or f_xzyjdl = '11' or f_xzejdl in ('0701','0702') or f_sjyjydlx = '09' or f_sjyjydlx = '11' or f_sjyjydlx in ('0701','0702') ) ";
        //绿化造景,条件
        String wflhzj=getSelectSql("f_gdzymj","wflhzj",tableName) +commSql+ " and  (f_xzejdl in ('1401','1402','1404')  or f_sjyjydlx in ('1401','1402','1404') ) ";
        //采矿用地,条件
        String wfckyd=getSelectSql("f_gdzymj","wfckyd",tableName) +commSql+ " and  (f_xzejdl = '1002' or f_sjejydlx = '1002' ) ";

        //其他建设,条件
        String wfqtjsSql=getSelectSql("f_gdzymj","wfqtjs",tableName) +commSql+ " and (f_xzejdl in ('1311','1312','1503','1505','1506','1507') or f_sjejydlx in ('1311','1312','1503','1505','1506','1507') or f_xzyjdl in ('20') or f_sjejydlx in ('20','26'))  ";

        String allSql=wfwgzygdxj+ " UNION ALL " + wfjtjsSql + " UNION ALL " + wfggfwjcssjsSql +" UNION ALL "+ wfyqwpxjSql + " UNION ALL " +wfnfjsSql + " UNION ALL " + wfqtjsSql + " UNION ALL " + wflhzj + " UNION ALL " + wfckyd + " UNION ALL " + wfczzzjsyfw;


        return allSql;
    }

    /**
     * 耕地非粮化SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdflhSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity, boolean isSplited,  boolean isChildTable) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        commSql=" f_zglx = '耕地非粮化' and f_status >=10  and f_rdwgdlc = '是' and f_xzqdmsys like '" + gdLrLcTotalEntity.getXzqdm()+"%'";

        String isSplitedFilter = "";
        if(!isChildTable && isSplited) {
            isSplitedFilter = " and  (f_issplitted <> '1' or f_issplitted is null) ";
            // 如果是母图斑（只统计未分割的母图斑）
            commSql += isSplitedFilter;
        }

        String gdflhxj= getSelectSql("f_gdzymj","gdflhxj",tableName) +commSql;

        //农村道路,条件
        String flncdlSql= getSelectSql("f_gdzymj","flncdl",tableName) +commSql+ " and f_xzejdl='0601' ";
        //设施农用地,条件
        String flssnydSql=getSelectSql("f_gdzymj","flssnyd",tableName) +commSql+ " and f_xzejdl in ('0602','0603','0604') ";
        //水库建设,条件
        String flskjsSql=getSelectSql("f_gdzymj","flskjs",tableName) +commSql+ " and f_xzejdl='1703' ";
        //沟渠建设,条件
        String flgqjsSql=getSelectSql("f_gdzymj","flgqjs",tableName) +commSql+ " and  f_xzejdl ='1705' ";
        //变为林地,条件
        String flbwldSql=getSelectSql("f_gdzymj","flbwld",tableName) +commSql+ " and f_xzyjdl ='03' ";

        //变为园地,条件
        String flbwydSql= getSelectSql("f_gdzymj","flbwyd",tableName) +commSql+ " and f_xzyjdl ='02' ";
        //变为坑塘,条件
        String flbwktSql=getSelectSql("f_gdzymj","flbwkt",tableName) +commSql+ " and f_xzejdl = '1704' ";
        //变为其他,条件
        String flbwqtSql=getSelectSql("f_gdzymj","flbwqt",tableName) +commSql+ " and f_xzyjdl not in ('02','03') and f_xzejdl not in ('0602','0603','0604','1703','1704','1705') ";

        String allSql= gdflhxj + " UNION ALL "+ flncdlSql + " UNION ALL " + flssnydSql +" UNION ALL "+ flskjsSql+" UNION ALL "+flgqjsSql+" UNION ALL " +flbwldSql+" UNION ALL " +flbwydSql+" UNION ALL " +flbwktSql + " UNION ALL " + flbwqtSql;

        return allSql;
    }



    /**
     * 获取sql select部分
     * @param colName
     * @param sumName
     * @param tableName
     */
    public String getSelectSql(String sumName ,String colName,String tableName){
        String selectSql = "";
        if(this.tableConditionSql.equals("")){
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from "+tableName + " where ";
        }else {
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from ( select tb.* from "+tableName +" as tb " + this.tableConditionSql +") t where ";
        }
        return  selectSql;
    }


    public DataDownloadRecord downloadGdLrLcTotalExcel(TaskQueryParameter parameter, Long userId) {
        String taskId = parameter.getTaskId();
        DataDownloadRecord record = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, userId);
        record.setName("耕地流入流出汇总("+new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())+")");
        dataDownloadRecordService.save(record);

        if (redisTemplate.hasKey(record.getId())) {
            redisTemplate.delete(record.getId());
        }
        redisTemplate.opsForValue().set(record.getId(), JSON.toJSONString(record), 2, TimeUnit.DAYS);

        DownloadParameter attachParameter = new DownloadParameter();
        attachParameter.setTaskId(StringUtils.isNotBlank(taskId) ? taskId : "");
        attachParameter.setTbIds(StringUtils.isNotBlank(parameter.getTbIds()) ? parameter.getTbIds() : "");
        attachParameter.setTbNames("");
        attachParameter.setUserId(userId);
        attachParameter.setCondition(JSONObject.toJSONString(parameter));
        attachParameter.setBizType("statistics");
        attachParameter.setRecordId(StringUtils.isNoneBlank(record.getId()) ? record.getId() : "");
        // 类型为空
        attachParameter.setDownloadType(0);
        attachParameter.setDataType("gdLrLcRecord");
        String parameterString = com.alibaba.fastjson.JSONObject.toJSONString(attachParameter);
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(record.getId());
        taskRecord.setParam(parameterString);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        taskRecord.setStarttime(new Date());
        taskRecord.setState(1);
        taskRecord.setBizId(taskId);
        taskRecord.setUserid(userId);
        taskRecordService.save(taskRecord);
        return record;
    }


    public void runDownloadGdLrLcTotalExcel(TaskRecord taskRecord,DownloadParameter downloadParameter) throws Exception {
        DataDownloadRecord dataDownloadRecord = null;
        try{
            Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
            if (value != null) {
                dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                if (dataDownloadRecord != null) {
                    if(dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)){
                        throw new Exception("用户取消了下载任务");
                    };
                    String condition = downloadParameter.getCondition();
                    TaskQueryParameter parameter = JSONObject.toJavaObject(JSONObject.parseObject(condition),TaskQueryParameter.class);
                    TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(parameter.getTaskId());
                    Pair<String, String> queryParamPair = tskTaskBizService.parseQueryParameter(parameter);
                    String conditionSql = " where "+queryParamPair.getRight();
                    String path = createGdLrLcTotal(tskTaskBiz,parameter.getRegionCode(),parameter.getUserId(),conditionSql,"","","","");
                    File srcFile = new File(path);
                    logger.info("日常任务下载 开始上传到obs " + path);

                    String resultUrl="";
                    // zip文件上传到obs云盘
                    if ("lan".equals(this.applicationType)) {
                        resultUrl= this.uploadFileToDisk(taskRecord.getUserid(), srcFile);
                    } else {
                        resultUrl= uploadFileToCloudDisk(taskRecord.getUserid(), srcFile);
                    }

                    if (dataDownloadRecordService.checkIsUserCanceled(dataDownloadRecord)) {
                        throw new Exception("用户取消了下载任务");
                    }
                    // 计算大小
                    Double fileSize = srcFile.length() / 1024d;
                    dataDownloadRecord.setAttachSize(fileSize);
                    dataDownloadRecord.setUrl(resultUrl);
                    dataDownloadRecord.setEndTime(new Date());
                    dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                    dataDownloadRecordService.save(dataDownloadRecord);
                    srcFile.delete();
                }
            }
        }catch (Exception e){
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecord.setErrorMsg(e.getMessage());
            dataDownloadRecordService.update(dataDownloadRecord);
            throw e;
        }
    }


    /**
     * 上传到云盘
     *
     * @param userId
     * @param
     */
    private String uploadFileToCloudDisk(Long userId, File file) {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        // 上传到obs
        return ossOperatorService.sendObject2Oss(sendObjName, file);
    }

    private String uploadFileToDisk(Long userId, File file) throws Exception {
        String sendObjName = "dailyTask/download/" + userId + "/" + file.getName();
        String resultUrl="";

        if (true) {
            File destFile = new File(this.applicationType, "media/" + file.getName());
            FileUtils.copyFile(file, destFile);
            resultUrl = "media/" + sendObjName;
        } else {
            this.minIOService.addToBucket(sendObjName, file.getAbsolutePath());
            resultUrl = sendObjName;
        }
        return resultUrl;
    }
}
