package com.geoway.landteam.landcloud.service.statistics;


import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.statistics.dto.GdLrLcTotalEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * @author   : lcw
 * @date     : 2022/6/9
 * @des      : 耕地流入流出汇通服务类，用于excel数据汇总
 **/
@Service("GdLrLcTotalService")
public class GdLrLcTotalService {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Value("{project.uploadDir}")
    protected String uploadDir;

    private ExecutorService executor = Executors.newCachedThreadPool();

    @Autowired
    SysConfigRepository configRepository;

    @Autowired
    RegionService regionService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    RedisTemplate redisTemplate;


    //当前table筛选条件sql
    public String tableConditionSql="";

    /**
     * 创建耕地流入流出汇总数据excel模板填充生成任务
     * @param taskId
     */
    public String createGdLrLcTotal(TskTaskBiz tskTaskBiz, String xzqdm, Long userId, String conditionSql, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        this.tableConditionSql = conditionSql;

        TbtskObjectinfo tbtskObjectinfo = null;
        if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
            tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        }
        Boolean isLrlc= false;
//        ExportFileTaskEntity exportFileTaskEntity=new ExportFileTaskEntity();
//        exportFileTaskEntity.setStatus(0);
//        exportFileTaskEntity.setCreatetime(new Date());
//        exportFileTaskEntity.setTaskname("耕地流入流出系统抓取汇总表_"+System.currentTimeMillis());
//        exportFileTaskEntity.setUserid(userId);
//        exportFileTaskDao.save(exportFileTaskEntity);

        // 启动线程进行数据构建
//        Thread thread = new Thread(new Runnable() {
//            @Override
//            public void run() {
        //获取所有行政区信息
        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = regionService.queryAllRegions(provinceCode);

        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有

        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(xzqdm.equals("")||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }
        String path="";
        try {
            List<GdLrLcTotalEntity>  gdLrLcTotalList = new ArrayList<>();
            for (int i = 0 ;i<cRegions.size();i++){
                GdLrLcTotalEntity gdLrLcTotalEntity=new GdLrLcTotalEntity();
                //先从redis读取
                if(redisTemplate.hasKey(tbtskObjectinfo.getfTablename()+"_"+cRegions.get(i).getCode())){
                    gdLrLcTotalEntity=(GdLrLcTotalEntity)redisTemplate.opsForValue().get(tbtskObjectinfo.getfTablename()+"_"+cRegions.get(i).getCode());
                }else {
                    gdLrLcTotalEntity.setXzqdm(cRegions.get(i).getCode());
                    gdLrLcTotalEntity.setXzqmc(cRegions.get(i).getName());
                    getGdLrLcTotalData(tbtskObjectinfo.getfTablename(),gdLrLcTotalEntity,isLrlc);
                    redisTemplate.opsForValue().set(tbtskObjectinfo.getfTablename()+"_"+cRegions.get(i).getCode(),gdLrLcTotalEntity,10, TimeUnit.SECONDS);
                }
                gdLrLcTotalEntity.setOrder(i+1);
                gdLrLcTotalList.add(gdLrLcTotalEntity);
            }
            path= createGdLrLcTotalExcel(gdLrLcTotalList,shhj,shzt,shsjStart,shsjEnd);
//                    exportFileTaskEntity.setStatus(1);
//                    exportFileTaskEntity.setResult("创建成功");
//                    exportFileTaskEntity.setFinishtime(new Date());
//                    exportFileTaskEntity.setFilepath(path);
//                    exportFileTaskDao.save(exportFileTaskEntity);
        } catch (Exception e) { // 设置任务状态为失败
//                    exportFileTaskEntity.setStatus(2);
//                    exportFileTaskEntity.setResult(e.getMessage());
//                    exportFileTaskDao.save(exportFileTaskEntity);
            throw new Exception("导出失败");
        }
//            }
//        });
//
//        executor.execute(thread);
        return path;
    }


    /**
     * 耕地流入流出汇总数据excel模板填充生成
     * @param gdLrLcTotalList
     */
    public String createGdLrLcTotalExcel(List<GdLrLcTotalEntity> gdLrLcTotalList,String shhj,String shzt,String shsjStart,String shsjEnd) throws Exception {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = new StringBuilder()
                .append(pathRoot)
                .append("excel")
                .append(File.separator)
                .append("耕地流入流出系统抓取汇总表模板.xls")
                .toString();
        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append("耕地流入流出系统抓取汇总表_"+System.currentTimeMillis()+".xls")
                .toString();

        try{
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i=0 ;i<gdLrLcTotalList.size();i++){
                Map<String, String> cmap= beanToMap(gdLrLcTotalList.get(i));
                listMap.add(cmap);
            }
            map.put("maplist",listMap);
            map.put("shhj",shhj);
            map.put("shzt","通过");
            map.put("shsjStart",shsjStart);
            map.put("shsjEnd",shsjEnd);

            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
//            EasyExcel.write(ouputPath)
//                    .withTemplate(srcFileName)
//                    .sheet("Sheet1")
//                    .doFill(gdLrLcTotalList);

        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }





    public static Map<String,String> beanToMap(Object object) throws IllegalAccessException {
        Map<String, String> map = new HashMap<String, String>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object).toString());
        }
        return map;
    }

    /**
     * 耕地流入流出汇总数据获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public void getGdLrLcTotalData(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception {
        //合法占用耕地数据sql获取
        String hfzygdSql=this.getHfzygdSql(tableName,gdLrLcTotalEntity,isLrlc);

        //违法违规占用耕地SQL获取
        String wfwgzygdSql=this.getWfwgzygdSql(tableName,gdLrLcTotalEntity,isLrlc);

        //耕地非粮化SQL获取
        String gdflhSql=this.getGdflhSql(tableName,gdLrLcTotalEntity,isLrlc);

        //耕地占补平衡sql获取
        String gdzbphSql=this.getGdzbphSql(tableName,gdLrLcTotalEntity,isLrlc);

        //耕地进出平衡sql获取
        String gdjcphSql=this.getGdjcphSql(tableName,gdLrLcTotalEntity,isLrlc);

        //耕地其他新增sql获取
        String qtxzSql=this.getQtxzSql(tableName,gdLrLcTotalEntity,isLrlc);

        String allSql = hfzygdSql + " UNION ALL " + wfwgzygdSql + " UNION ALL " + gdflhSql +" UNION ALL "+ gdzbphSql+" UNION ALL "+gdjcphSql+" UNION ALL " +qtxzSql;

        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
        JSONObject jobj=new JSONObject();
        for(Map<String,Object> data:result) {
            jobj.put(data.get("name").toString(),data.get("sum"));
        }

        //耕地流出->无手续占用耕地->合法占用耕地->小计
        gdLrLcTotalEntity.setHfzygdxj(Double.valueOf(jobj.getDouble("hfzygdxj"))+ Double.valueOf(jobj.getDouble("hfjsyd")));
        //耕地流出->无手续占用耕地->合法占用耕地->城镇及园区建设
        gdLrLcTotalEntity.setHfczjyqjc(Double.valueOf(jobj.getDouble("hfczjyqjc")));
        //耕地流出->无手续占用耕地->合法占用耕地->交通建设
        gdLrLcTotalEntity.setHfjtjs(Double.valueOf(jobj.getDouble("hfjtjs")));
        //耕地流出->无手续占用耕地->合法占用耕地->农房建设
        gdLrLcTotalEntity.setHflsyd(Double.valueOf(jobj.getDouble("hflsyd")));
        //耕地流出->无手续占用耕地->合法占用耕地->临时用地
        gdLrLcTotalEntity.setHfnfjs(Double.valueOf(jobj.getDouble("hfnfjs")));
        //耕地流出->无手续占用耕地->合法占用耕地->其他建设
//        gdLrLcTotalEntity.setHfqtjs(Double.valueOf(jobj.getDouble("hfqtjs")));
        gdLrLcTotalEntity.setHfqtjs( new BigDecimal(gdLrLcTotalEntity.getHfzygdxj()
                - gdLrLcTotalEntity.getHfczjyqjc()
                - gdLrLcTotalEntity.getHfjtjs()
                - gdLrLcTotalEntity.getHflsyd()
                - gdLrLcTotalEntity.getHfnfjs()
                - Double.valueOf(jobj.getDouble("hfryjsyd"))
                ).setScale(2, RoundingMode.HALF_UP).doubleValue()
        );

        //耕地流出->无手续占用耕地->违法违规占用耕地->小计
        gdLrLcTotalEntity.setWfwgzygdxj(Double.valueOf(jobj.getDouble("wfwgzygdxj")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->交通建设
        gdLrLcTotalEntity.setWfjtjs(Double.valueOf(jobj.getDouble("wfjtjs")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->公共服务基础设施建设
        gdLrLcTotalEntity.setWfggfwjcssjs(Double.valueOf(jobj.getDouble("wfggfwjcssjs")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->园区未批先建
        gdLrLcTotalEntity.setWfyqwpxj(Double.valueOf(jobj.getDouble("wfyqwpxj")));
        //耕地流出->无手续占用耕地->违法违规占用耕地->农房建设
        gdLrLcTotalEntity.setWfnfjs(Double.valueOf(jobj.getDouble("wfnfjs")));

        //耕地流出->无手续占用耕地->违法违规占用耕地->其他建设
        gdLrLcTotalEntity.setWfqtjs(new BigDecimal(gdLrLcTotalEntity.getWfwgzygdxj()
                - gdLrLcTotalEntity.getWfjtjs()
                - gdLrLcTotalEntity.getWfggfwjcssjs()
                - gdLrLcTotalEntity.getWfyqwpxj()
                - gdLrLcTotalEntity.getWfnfjs()).setScale(2, RoundingMode.HALF_UP).doubleValue()
        );

        //耕地流出->耕地非粮化-小计
        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdflhxj")));
        //耕地流出->耕地非粮化->农村道路
        gdLrLcTotalEntity.setFlncdl(Double.valueOf(jobj.getDouble("flncdl")));
        //耕地流出->耕地非粮化->设施农用地
        gdLrLcTotalEntity.setFlssnyd(Double.valueOf(jobj.getDouble("flssnyd")));
        //耕地流出->耕地非粮化->水库建设
        gdLrLcTotalEntity.setFlskjs(Double.valueOf(jobj.getDouble("flskjs")));
        //耕地流出->耕地非粮化->沟渠建设
        gdLrLcTotalEntity.setFlgqjs(Double.valueOf(jobj.getDouble("flgqjs")));
        //耕地流出->耕地非粮化->变为林地
        gdLrLcTotalEntity.setFlbwld(Double.valueOf(jobj.getDouble("flbwld")));
        //耕地流出->耕地非粮化->变为园地
        gdLrLcTotalEntity.setFlbwyd(Double.valueOf(jobj.getDouble("flbwyd")));
        //耕地流出->耕地非粮化->变为坑塘
        gdLrLcTotalEntity.setFlbwkt(Double.valueOf(jobj.getDouble("flbwkt")));
        //耕地流出->耕地非粮化->变为其他
        gdLrLcTotalEntity.setFlbwqt( new BigDecimal(gdLrLcTotalEntity.getGdflhxj()
                - gdLrLcTotalEntity.getFlncdl()
                - gdLrLcTotalEntity.getFlssnyd()
                - gdLrLcTotalEntity.getFlskjs()
                - gdLrLcTotalEntity.getFlgqjs()
                - gdLrLcTotalEntity.getFlbwld()
                - gdLrLcTotalEntity.getFlbwyd()
                - gdLrLcTotalEntity.getFlbwkt()).setScale(2, RoundingMode.HALF_UP).doubleValue()
               );

        //耕地流入->耕地占补平衡->小计
        gdLrLcTotalEntity.setGdzbphxj(Double.valueOf(jobj.getDouble("gdzbphxj")));
        //耕地流入->耕地占补平衡->土地整理
        gdLrLcTotalEntity.setZbtdzl(Double.valueOf(jobj.getDouble("zbtdzl")));
        //耕地流入->耕地占补平衡->农村建设用地复垦
        gdLrLcTotalEntity.setZbncjsydfk(Double.valueOf(jobj.getDouble("zbncjsydfk")));


        //耕地流入->耕地进出平衡->小计
        gdLrLcTotalEntity.setGdjcphxj(Double.valueOf(jobj.getDouble("gdjcphxj")));
        //耕地流入->耕地进出平衡->林地整治为耕地
        gdLrLcTotalEntity.setJcldzzwgd(Double.valueOf(jobj.getDouble("jcldzzwgd")));
        //耕地流入->耕地进出平衡->园地整治为耕地
        gdLrLcTotalEntity.setJcydzzwgd(Double.valueOf(jobj.getDouble("jcydzzwgd")));
        //耕地流入->耕地进出平衡->坑塘水面整治为耕地
        gdLrLcTotalEntity.setJcktsmzzwgd(Double.valueOf(jobj.getDouble("jcktsmzzwgd")));
        //耕地流入->耕地进出平衡->其他农用地整治为耕地
        gdLrLcTotalEntity.setJcqtnydzzwgd(Double.valueOf(jobj.getDouble("jcqtnydzzwgd")));


        //耕地流入->其他新增->小计
        gdLrLcTotalEntity.setQtxzxj(Double.valueOf(jobj.getDouble("qtxzxj")));
        //耕地流入->其他新增->其他部门新增耕地
        gdLrLcTotalEntity.setQtbmxzgd(Double.valueOf(jobj.getDouble("qtbmxzgd")));
        //耕地流入->其他新增->农民自主开垦耕地
        gdLrLcTotalEntity.setQtnmzzkkgd(Double.valueOf(jobj.getDouble("qtnmzzkkgd")));
        //耕地流入->其他新增->LC耕地的整改
        gdLrLcTotalEntity.setQtlcgddzg(Double.valueOf(jobj.getDouble("qtlcgddzg")));

        //合计
        gdLrLcTotalEntity.setHj(gdLrLcTotalEntity.getHfzygdxj()+gdLrLcTotalEntity.getWfwgzygdxj()+gdLrLcTotalEntity.getGdflhxj());

        gdLrLcTotalEntity.setGdlrzj(new BigDecimal(gdLrLcTotalEntity.getQtxzxj()
                + gdLrLcTotalEntity.getGdjcphxj()
                + gdLrLcTotalEntity.getGdzbphxj()).setScale(2, RoundingMode.HALF_UP).doubleValue() );

        gdLrLcTotalEntity.setYdgdzjl(Math.abs(gdLrLcTotalEntity.getGdlrzj())-Math.abs(gdLrLcTotalEntity.getHj()));

    }

    /**
     * 合法占用耕地数据SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getHfzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
          throw new Exception("行政区代码不能为空");
        }

        //共有条件
        String commSql="";
        if(isLrlc){
            commSql=" f_gdldfx = 'LC' and f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"' ";
        }else {
            commSql=" f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"' ";
        }

        //小计
        String hfzygdxjSql = getSelectSql("f_tbmj","hfzygdxj",tableName) +commSql;

        //城镇及园区建设,条件
        String hfczjyqjcSql= getSelectSql("f_tbmj","hfczjyqjc",tableName) +commSql+ " and (f_xzyjdl in ('08','09','10','11') or f_xzejdl in ('0701','0702','1301','1303','1304','1306','1309','1311','1313','1401','1402','1403')) ";
        //交通建设,条件
        String jtjsSql=getSelectSql("f_tbmj","hfjtjs",tableName) +commSql+ " and (f_xzyjdl = '12' or f_sjyjydlx = '12') ";
        //农房建设,条件
        String nfjsSql=getSelectSql("f_tbmj","hfnfjs",tableName) +commSql+ " and f_xzejdl in ('0703','0704') ";
        //临时用地,条件
        String lsydSql=getSelectSql("f_tbmj","hflsyd",tableName) +commSql+ " and ( f_xzyjdl = '18' and (f_sjyjydlx != '12' or f_sjejydlx != '1501' )) ";
        //其他建设,条件
        String qtjsSql=getSelectSql("f_tbmj","hfqtjs",tableName) +commSql+ " and (f_xzejdl in ('1312','1404','1501','1503','1505','1506','1507') or f_sjejydlx = '1501' or f_xzyjdl = '20') ";
        //军事用地，条件
        String jsydSql="";
        //冗余军事用地
        String ryjsydSql="";
        if(isLrlc){
            jsydSql=getSelectSql("f_tbmj","hfjsyd",tableName)+ " f_gdldfx = 'LC' and f_zglx = '合法占用耕地' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' ";
            ryjsydSql=getSelectSql("f_tbmj","hfryjsyd",tableName)+ " f_gdldfx = 'LC' and f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' ";
        }else {
            jsydSql=getSelectSql("f_tbmj","hfjsyd",tableName)+ " f_zglx = '合法占用耕地' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' ";
            ryjsydSql=getSelectSql("f_tbmj","hfryjsyd",tableName)+ " f_zglx = '合法占用耕地' and f_sfysx = '具备手续' and f_rdwgdlc = '是' and f_status = 4 and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'  and  f_xzejdl = '1501' ";
        }

        String allSql=hfzygdxjSql + " UNION ALL " + hfczjyqjcSql + " UNION ALL " + jtjsSql +" UNION ALL "+ nfjsSql+" UNION ALL "+lsydSql + " UNION ALL " + jsydSql + " UNION ALL " + ryjsydSql + " UNION ALL " + qtjsSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//
//        gdLrLcTotalEntity.setHfzygdxj(Double.valueOf(jobj.getDouble("hfzygdxj")))
//        gdLrLcTotalEntity.setHfczjyqjc(Double.valueOf(jobj.getDouble("hfczjyqjc")));
//        gdLrLcTotalEntity.setHfjtjs(Double.valueOf(jobj.getDouble("hfjtjs")));
//        gdLrLcTotalEntity.setHflsyd(Double.valueOf(jobj.getDouble("hflsyd")));
//        gdLrLcTotalEntity.setHfnfjs(Double.valueOf(jobj.getDouble("hfnfjs")));
//        gdLrLcTotalEntity.setHfqtjs(Double.valueOf(jobj.getDouble("hfqtjs")));


//        gdLrLcTotalEntity.setHfzygdxj(gdLrLcTotalEntity.getHfzygdxj()
//                +gdLrLcTotalEntity.getHfjtjs()
//                +gdLrLcTotalEntity.getHflsyd()
//                +gdLrLcTotalEntity.getHfnfjs()+gdLrLcTotalEntity.getHfqtjs());

        return allSql;
    }

    /**
     * 违法违规占用耕地SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getWfwgzygdSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        if(isLrlc){
            commSql=" f_gdldfx = 'LC' and f_zglx = '无手续占用耕地' and f_sfysx = '不具备手续' and f_rdwgdlc = '是' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }else {
            commSql=" f_zglx = '无手续占用耕地' and f_sfysx = '不具备手续' and f_rdwgdlc = '是' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }

        //小计
        String wfwgzygdxj= getSelectSql("f_tbmj","wfwgzygdxj",tableName) +commSql;


        //交通建设,条件
        String wfjtjsSql= getSelectSql("f_tbmj","wfjtjs",tableName) +commSql+ " and ( f_xzyjdl = '12' or f_sjyjydlx = '12' ) ";
        //公共服务基础设施建设,条件
        String wfggfwjcssjsSql=getSelectSql("f_tbmj","wfggfwjcssjs",tableName) +commSql+ " and (f_xzyjdl = '08' or f_xzejdl in ('1301','1303','1304','1306','1309','1313','1403') ) ";
        //园区未批先建,条件
        String wfyqwpxjSql=getSelectSql("f_tbmj","wfyqwpxj",tableName) +commSql+ " and ( f_xzejdl = '1001' or f_sjejydlx = '1001' )  and f_sfgyyq='是' ";
        //农房建设,条件
        String wfnfjsSql=getSelectSql("f_tbmj","wfnfjs",tableName) +commSql+ " and  ( f_xzejdl in ('0703','0704') or f_sjejydlx in ('0704','0703')) ";
        //水工建设,条件
//        String wfsgjsSql=getSelectSql("f_tbmj","wfsgjs",tableName) +commSql+ " and 1 != 1  ";
        //临时用地,条件
//        String wflsydSql=getSelectSql("f_tbmj","wflsyd",tableName) +commSql+ " and 1 != 1  ";
        //光伏用地建设,条件
//        String wfgfydjsSql=getSelectSql("f_tbmj","wfgfydjs",tableName) +commSql+ " and 1 != 1  ";
        //绿化造景,条件
//        String wflhzjSql=getSelectSql("f_tbmj","wflhzj",tableName) +commSql+ " and 1 != 1  ";
        //其他建设,条件
        String wfqtjsSql=getSelectSql("f_tbmj","wfqtjs",tableName) +commSql+ " and (f_xzejdl in ('1311','1312','1503','1505','1506','1507') or f_sjejydlx in ('1311','1312','1503','1505','1506','1507') or f_xzyjdl in ('20') or f_sjejydlx in ('20','26'))  ";

        String allSql=wfwgzygdxj+ " UNION ALL " + wfjtjsSql + " UNION ALL " + wfggfwjcssjsSql +" UNION ALL "+ wfyqwpxjSql + " UNION ALL " +wfnfjsSql + " UNION ALL " + wfqtjsSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//        gdLrLcTotalEntity.setWfwgzygdxj(Double.valueOf(jobj.getDouble("wfwgzygdxj")));
//        gdLrLcTotalEntity.setWfjtjs(Double.valueOf(jobj.getDouble("wfjtjs")));
//        gdLrLcTotalEntity.setWfggfwjcssjs(Double.valueOf(jobj.getDouble("wfggfwjcssjs")));
//        gdLrLcTotalEntity.setWfyqwpxj(Double.valueOf(jobj.getDouble("wfyqwpxj")));


//        gdLrLcTotalEntity.setWfnfjs(Double.valueOf(jobj.getDouble("wfnfjs")));
//        gdLrLcTotalEntity.setWfsgjs(Double.valueOf(jobj.getDouble("wfsgjs")));
//
//        gdLrLcTotalEntity.setWflsyd(Double.valueOf(jobj.getDouble("wflsyd")));
//        gdLrLcTotalEntity.setWfgfydjs(Double.valueOf(jobj.getDouble("wfgfydjs")));
//        gdLrLcTotalEntity.setWflhzj(Double.valueOf(jobj.getDouble("wflhzj")));
//        gdLrLcTotalEntity.setWfqtjs(Double.valueOf(jobj.getDouble("wfqtjs")));

//        gdLrLcTotalEntity.setWfqtjs( gdLrLcTotalEntity.getWfwgzygdxj()
//                - gdLrLcTotalEntity.getWfjtjs()
//                - gdLrLcTotalEntity.getWfggfwjcssjs()
//                - gdLrLcTotalEntity.getWfyqwpxj()
//        );

        return allSql;
    }

    /**
     * 耕地非粮化SQL获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdflhSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        if(isLrlc){
            commSql=" f_gdldfx='LC' and f_zglx = '耕地非粮化' and f_status = 4  and f_rdwgdlc = '是' and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }else {
            commSql=" f_zglx = '耕地非粮化' and f_status = 4  and f_rdwgdlc = '是' and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }
        //小计
        String gdflhxj= getSelectSql("f_tbmj","gdflhxj",tableName) +commSql;

        //农村道路,条件
        String flncdlSql= getSelectSql("f_tbmj","flncdl",tableName) +commSql+ " and f_xzejdl='0601' ";
        //设施农用地,条件
        String flssnydSql=getSelectSql("f_tbmj","flssnyd",tableName) +commSql+ " and f_xzejdl in ('0602','0603','0604') ";
        //水库建设,条件
        String flskjsSql=getSelectSql("f_tbmj","flskjs",tableName) +commSql+ " and f_xzejdl='1703' ";
        //沟渠建设,条件
        String flgqjsSql=getSelectSql("f_tbmj","flgqjs",tableName) +commSql+ " and  f_xzejdl ='1705' ";
        //变为林地,条件
        String flbwldSql=getSelectSql("f_tbmj","flbwld",tableName) +commSql+ " and f_xzyjdl ='03' ";

        //变为园地,条件
        String flbwydSql= getSelectSql("f_tbmj","flbwyd",tableName) +commSql+ " and f_xzyjdl ='02' ";
        //变为坑塘,条件
        String flbwktSql=getSelectSql("f_tbmj","flbwkt",tableName) +commSql+ " and f_xzejdl = '1704' ";
        //变为其他,条件
        String flbwqtSql=getSelectSql("f_tbmj","flbwqt",tableName) +commSql+ " and f_xzyjdl not in ('02','03') and f_xzejdl not in ('0602','0603','0604','1703','1704','1705') ";



        String allSql= gdflhxj + " UNION ALL "+ flncdlSql + " UNION ALL " + flssnydSql +" UNION ALL "+ flskjsSql+" UNION ALL "+flgqjsSql+" UNION ALL " +flbwldSql+" UNION ALL " +flbwydSql+" UNION ALL " +flbwktSql + " UNION ALL " + flbwqtSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdflhxj"));
//        gdLrLcTotalEntity.setFlncdl(Double.valueOf(jobj.getDouble("flncdl")));
//        gdLrLcTotalEntity.setFlssnyd(Double.valueOf(jobj.getDouble("flssnyd")));
//        gdLrLcTotalEntity.setFlskjs(Double.valueOf(jobj.getDouble("flskjs")));
//        gdLrLcTotalEntity.setFlgqjs(Double.valueOf(jobj.getDouble("flgqjs")));
//        gdLrLcTotalEntity.setFlbwld(Double.valueOf(jobj.getDouble("flbwld")));
//
//        gdLrLcTotalEntity.setFlbwyd(Double.valueOf(jobj.getDouble("flbwyd")));
//        gdLrLcTotalEntity.setFlbwkt(Double.valueOf(jobj.getDouble("flbwkt")));

//        gdLrLcTotalEntity.setFlbwqt(gdLrLcTotalEntity.getGdflhxj()
//                - gdLrLcTotalEntity.getFlncdl()
//                - gdLrLcTotalEntity.getFlssnyd()
//                - gdLrLcTotalEntity.getFlskjs()
//                - gdLrLcTotalEntity.getFlgqjs()
//                - gdLrLcTotalEntity.getFlbwld()
//                - gdLrLcTotalEntity.getFlbwyd()
//                - gdLrLcTotalEntity.getFlbwkt()
//               );
        return allSql;
    }

    /**
     * 耕地占补平衡sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdzbphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        if(isLrlc){
            commSql=" f_gdldfx = 'LR' and f_xzgdly = '耕地占补平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }else {
//            commSql="  f_xzgdly = '耕地占补平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
            commSql="  f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";

        }

        //小计
        String gdzbphxj= getSelectSql("f_tbmj","gdzbphxj",tableName) +commSql;

        //土地整理,条件
        String zbtdzlSql= getSelectSql("f_tbmj","zbtdzl",tableName) +commSql+ " and f_xzgdlyej = '土地整理' ";
        //农村建设用地复,条件
        String zbncjsydfkSql=getSelectSql("f_tbmj","zbncjsydfk",tableName) +commSql+ " and f_xzgdlyej = '农村建设用地复垦' ";




        String allSql= gdzbphxj + " UNION ALL "+ zbtdzlSql + " UNION ALL " + zbncjsydfkSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//        gdLrLcTotalEntity.setGdflhxj(Double.valueOf(jobj.getDouble("gdzbphxj"));
//        gdLrLcTotalEntity.setZbtdzl(Double.valueOf(jobj.getDouble("zbtdzl")));
//        gdLrLcTotalEntity.setZbncjsydfk(Double.valueOf(jobj.getDouble("zbncjsydfk")));
        return allSql;
    }

    /**
     * 耕地进出平衡sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdjcphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";

        if(isLrlc){
             commSql=" f_gdldfx = 'LR' and f_xzgdly = '耕地进出平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }else {
             commSql=" f_xzgdly = '耕地进出平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }

        //小计
        String gdjcphxjSql= getSelectSql("f_tbmj","gdjcphxj",tableName) +commSql;

        //林地整治为耕地,条件
        String jcldzzwgdSql= getSelectSql("f_tbmj","jcldzzwgd",tableName) +commSql+ " and f_xzgdlyej = '林地整治为耕地' ";
        //园地整治为耕地,条件
        String jcydzzwgdSql=getSelectSql("f_tbmj","jcydzzwgd",tableName) +commSql+ " and f_xzgdlyej = '园地整治为耕地' ";
        //坑塘水面整治为耕地,条件
        String jcktsmzzwgdSql= getSelectSql("f_tbmj","jcktsmzzwgd",tableName) +commSql+ " and f_xzgdlyej = '坑塘水面整治为耕地' ";
        //其他农用地整治为耕地,条件
        String jcqtnydzzwgdSql=getSelectSql("f_tbmj","jcqtnydzzwgd",tableName) +commSql+ " and f_xzgdlyej = '其他农用地整治为耕地' ";



        String allSql= gdjcphxjSql + " UNION ALL "+ jcldzzwgdSql + " UNION ALL " + jcydzzwgdSql + " UNION ALL " + jcktsmzzwgdSql + " UNION ALL " + jcqtnydzzwgdSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//        gdLrLcTotalEntity.setGdjcphxj(Double.valueOf(jobj.getDouble("gdjcphxj"));
//
//        gdLrLcTotalEntity.setJcldzzwgd(Double.valueOf(jobj.getDouble("jcldzzwgd"));
//        gdLrLcTotalEntity.setJcydzzwgd(Double.valueOf(jobj.getDouble("jcydzzwgd")));
//        gdLrLcTotalEntity.setJcktsmzzwgd(Double.valueOf(jobj.getDouble("jcktsmzzwgd")));
//        gdLrLcTotalEntity.setJcqtnydzzwgd(Double.valueOf(jobj.getDouble("jcqtnydzzwgd")));
        return allSql;
    }

    /**
     * 耕地其他新增sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getQtxzSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity,Boolean isLrlc) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        if(isLrlc){
            commSql=" f_gdldfx = 'LR' and f_xzgdly = '其他新增' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }else {
            commSql=" f_xzgdly = '其他新增' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";
        }
        //小计
        String qtxzxjSql= getSelectSql("f_tbmj","qtxzxj",tableName) +commSql;

        //其他部门新增耕地,条件
        String qtbmxzgdSql= getSelectSql("f_tbmj","qtbmxzgd",tableName) +commSql+ " and f_xzgdlyej = '其他部门新增耕地' ";
        //农民自主开垦耕地,条件
        String qtnmzzkkgdSql=getSelectSql("f_tbmj","qtnmzzkkgd",tableName) +commSql+ " and f_xzgdlyej = '农民自主开垦耕地' ";
        //LC耕地的整改,条件
        String qtlcgddzgSql= getSelectSql("f_tbmj","qtlcgddzg",tableName) +commSql+ " and f_xzgdlyej='耕地整改恢复' ";



        String allSql= qtxzxjSql + " UNION ALL "+ qtbmxzgdSql + " UNION ALL " + qtnmzzkkgdSql + " UNION ALL " + qtlcgddzgSql;
//        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
//        JSONObject jobj=new JSONObject();
//        for(Map<String,Object> data:result) {
//            jobj.put(data.get("name").toString(),data.get("sum"));
//        }
//
//        gdLrLcTotalEntity.setQtxzxj(Double.valueOf(jobj.getDouble("qtxzxj"));
//
//        gdLrLcTotalEntity.setQtbmxzgd(Double.valueOf(jobj.getDouble("qtbmxzgd"));
//        gdLrLcTotalEntity.setQtnmzzkkgd(Double.valueOf(jobj.getDouble("qtnmzzkkgd")));
//        gdLrLcTotalEntity.setQtlcgddzg(Double.valueOf(jobj.getDouble("qtlcgddzg")));
        return allSql;
    }

    /**
     * 获取sql select部分
     * @param colName
     * @param sumName
     * @param tableName
     */
    public String getSelectSql(String sumName ,String colName,String tableName){
        String selectSql = "";
        if(this.tableConditionSql.equals("")){
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from "+tableName + " where ";
        }else {
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from ( select tb.* from "+tableName +" as tb " + this.tableConditionSql +") t where ";
        }
        return  selectSql;
    }

}
