package com.geoway.landteam.landcloud.service.statistics;


import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.statistics.dto.GdLrLcTotalEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/*
 * @author   : lcw
 * @date     : 2022/6/9
 * @des      : 耕地流入汇通服务类，用于excel数据汇总
 **/
@Service("GdLrTotalService")
public class GdLrTotalService {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Value("{project.uploadDir}")
    protected String uploadDir;

    @Autowired
    private SysConfigRepository configRepository;

    @Autowired
    RegionService regionService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    RedisTemplate redisTemplate;




    //当前table筛选条件sql
    public String tableConditionSql="";

    /**
     * 创建耕地流入流出汇总数据excel模板填充生成任务
     * @param
     */
    public String createGdLrLcTotal(TskTaskBiz tskTaskBiz, String xzqdm, Long userId, String conditionSql, String shhj, String shzt, String shsjStart, String shsjEnd) throws Exception {
        this.tableConditionSql = conditionSql;
        TbtskObjectinfo tbtskObjectinfo = null;
        if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
            tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        }

        //获取所有行政区信息
        SysConfig config = configRepository.queryByKey("xzqCode");
        String provinceCode = config.getValue().substring(0, 3) + "%";
        List<Region> result = regionService.queryAllRegions(provinceCode);

        List<Region>  cRegions=new ArrayList<>();
        //获取当前行政区信息，如果为“”，则获取所有

        //排除重庆市(市辖区)：500100，重庆市(县)： 500200
        String includeRegion="500100、500200、500000";
        if(xzqdm.equals("")||xzqdm.equals("500000")){
            for (int i = 0 ;i<result.size();i++){
                if(includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }else {
            for (int i = 0 ;i<result.size();i++){
                if(xzqdm.indexOf(result.get(i).getCode())!=-1&&includeRegion.indexOf(result.get(i).getCode())==-1){
                    cRegions.add(result.get(i));
                }
            }
        }
        String path="";
        try {
            List<GdLrLcTotalEntity>  gdLrLcTotalList = new ArrayList<>();
            for (int i = 0 ;i<cRegions.size();i++){
                GdLrLcTotalEntity gdLrLcTotalEntity=new GdLrLcTotalEntity();
                //先从redis读取
                if(redisTemplate.hasKey(tbtskObjectinfo.getfTablename()+"_LR_"+cRegions.get(i).getCode())){
                    gdLrLcTotalEntity=(GdLrLcTotalEntity)redisTemplate.opsForValue().get(tbtskObjectinfo.getfTablename()+"_LR_"+cRegions.get(i).getCode());
                }else {
                    gdLrLcTotalEntity.setXzqdm(cRegions.get(i).getCode());
                    gdLrLcTotalEntity.setXzqmc(cRegions.get(i).getName());
                    getGdLrLcTotalData(tbtskObjectinfo.getfTablename(),gdLrLcTotalEntity);
                    redisTemplate.opsForValue().set(tbtskObjectinfo.getfTablename()+"_LR_"+cRegions.get(i).getCode(),gdLrLcTotalEntity,10, TimeUnit.SECONDS);
                }
                gdLrLcTotalEntity.setOrder(i+1);
                gdLrLcTotalList.add(gdLrLcTotalEntity);
            }
            path= createGdLrLcTotalExcel(gdLrLcTotalList,shhj,shzt,shsjStart,shsjEnd);
//                    exportFileTaskEntity.setStatus(1);
//                    exportFileTaskEntity.setResult("创建成功");
//                    exportFileTaskEntity.setFinishtime(new Date());
//                    exportFileTaskEntity.setFilepath(path);
//                    exportFileTaskDao.save(exportFileTaskEntity);
        } catch (Exception e) { // 设置任务状态为失败
//                    exportFileTaskEntity.setStatus(2);
//                    exportFileTaskEntity.setResult(e.getMessage());
//                    exportFileTaskDao.save(exportFileTaskEntity);
            throw new Exception("导出失败");
        }
//            }
//        });
//
//        executor.execute(thread);
        return path;
    }


    /**
     * 耕地流入流出汇总数据excel模板填充生成
     * @param gdLrLcTotalList
     */
    public String createGdLrLcTotalExcel(List<GdLrLcTotalEntity> gdLrLcTotalList,String shhj,String shzt,String shsjStart,String shsjEnd) throws Exception {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        String srcFileName = new StringBuilder()
                .append(pathRoot)
                .append("excel")
                .append(File.separator)
                .append("耕地流入流出系统抓取汇总表模板.xls")
                .toString();
        String ouputFile=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel").toString();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append("耕地流入系统抓取汇总表_"+System.currentTimeMillis()+".xls")
                .toString();

        try{
            Map<String, Object> map = new HashMap<String, Object>();
            List<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
            for (int i=0 ;i<gdLrLcTotalList.size();i++){
                Map<String, String> cmap= beanToMap(gdLrLcTotalList.get(i));
                listMap.add(cmap);
            }
            map.put("maplist",listMap);
            map.put("shhj",shhj);
            map.put("shzt","通过");
            map.put("shsjStart",shsjStart);
            map.put("shsjEnd",shsjEnd);

            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            File savefile = new File(ouputFile);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(ouputPath);
            workbook.write(fos);
            fos.close();
//            EasyExcel.write(ouputPath)
//                    .withTemplate(srcFileName)
//                    .sheet("Sheet1")
//                    .doFill(gdLrLcTotalList);

        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }





    public static Map<String,String> beanToMap(Object object) throws IllegalAccessException {
        Map<String, String> map = new HashMap<String, String>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object).toString());
        }
        return map;
    }

    /**
     * 耕地流入流出汇总数据获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public void getGdLrLcTotalData(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception {

        //耕地占补平衡sql获取
        String gdzbphSql=this.getGdzbphSql(tableName,gdLrLcTotalEntity);

        //耕地进出平衡sql获取
        String gdjcphSql=this.getGdjcphSql(tableName,gdLrLcTotalEntity);

        //耕地其他新增sql获取
        String qtxzSql=this.getQtxzSql(tableName,gdLrLcTotalEntity);

        String allSql = gdzbphSql+" UNION ALL "+gdjcphSql+" UNION ALL " +qtxzSql;

        List<Map<String,Object>> result= this.jdbcTemplate.queryForList(allSql);
        JSONObject jobj=new JSONObject();
        for(Map<String,Object> data:result) {
            jobj.put(data.get("name").toString(),data.get("sum"));
        }

        //耕地流出->无手续占用耕地->合法占用耕地->小计
        gdLrLcTotalEntity.setHfzygdxj(0);
        //耕地流出->无手续占用耕地->合法占用耕地->城镇及园区建设
        gdLrLcTotalEntity.setHfczjyqjc(0);
        //耕地流出->无手续占用耕地->合法占用耕地->交通建设
        gdLrLcTotalEntity.setHfjtjs(0);
        //耕地流出->无手续占用耕地->合法占用耕地->农房建设
        gdLrLcTotalEntity.setHflsyd(0);
        //耕地流出->无手续占用耕地->合法占用耕地->临时用地
        gdLrLcTotalEntity.setHfnfjs(0);
        //耕地流出->无手续占用耕地->合法占用耕地->其他建设
//        gdLrLcTotalEntity.setHfqtjs(Double.valueOf(jobj.getDouble("hfqtjs")));
//        gdLrLcTotalEntity.setHfqtjs( new BigDecimal(gdLrLcTotalEntity.getHfzygdxj()
//                - gdLrLcTotalEntity.getHfczjyqjc()
//                - gdLrLcTotalEntity.getHfjtjs()
//                - gdLrLcTotalEntity.getHflsyd()
//                - gdLrLcTotalEntity.getHfnfjs()
//                ).setScale(2, RoundingMode.HALF_UP).doubleValue()
//        );
        gdLrLcTotalEntity.setHfqtjs(0);

        //耕地流出->无手续占用耕地->违法违规占用耕地->小计
        gdLrLcTotalEntity.setWfwgzygdxj(0);
        //耕地流出->无手续占用耕地->违法违规占用耕地->交通建设
        gdLrLcTotalEntity.setWfjtjs(0);
        //耕地流出->无手续占用耕地->违法违规占用耕地->公共服务基础设施建设
        gdLrLcTotalEntity.setWfggfwjcssjs(0);
        //耕地流出->无手续占用耕地->违法违规占用耕地->园区未批先建
        gdLrLcTotalEntity.setWfyqwpxj(0);
        //耕地流出->无手续占用耕地->违法违规占用耕地->农房建设
        gdLrLcTotalEntity.setWfnfjs(0);

        //耕地流出->无手续占用耕地->违法违规占用耕地->其他建设
        gdLrLcTotalEntity.setWfqtjs(0);
//        gdLrLcTotalEntity.setWfqtjs(new BigDecimal(gdLrLcTotalEntity.getWfwgzygdxj()
//                - gdLrLcTotalEntity.getWfjtjs()
//                - gdLrLcTotalEntity.getWfggfwjcssjs()
//                - gdLrLcTotalEntity.getWfyqwpxj()
//                - gdLrLcTotalEntity.getWfnfjs()).setScale(2, RoundingMode.HALF_UP).doubleValue()
//        );

        //耕地流出->耕地非粮化-小计
        gdLrLcTotalEntity.setGdflhxj(0);
        //耕地流出->耕地非粮化->农村道路
        gdLrLcTotalEntity.setFlncdl(0);
        //耕地流出->耕地非粮化->设施农用地
        gdLrLcTotalEntity.setFlssnyd(0);
        //耕地流出->耕地非粮化->水库建设
        gdLrLcTotalEntity.setFlskjs(0);
        //耕地流出->耕地非粮化->沟渠建设
        gdLrLcTotalEntity.setFlgqjs(0);
        //耕地流出->耕地非粮化->变为林地
        gdLrLcTotalEntity.setFlbwld(0);
        //耕地流出->耕地非粮化->变为园地
        gdLrLcTotalEntity.setFlbwyd(0);
        //耕地流出->耕地非粮化->变为坑塘
        gdLrLcTotalEntity.setFlbwkt(0);
        //耕地流出->耕地非粮化->变为其他
        gdLrLcTotalEntity.setFlbwqt(0);

//        gdLrLcTotalEntity.setFlbwqt( new BigDecimal(gdLrLcTotalEntity.getGdflhxj()
//                - gdLrLcTotalEntity.getFlncdl()
//                - gdLrLcTotalEntity.getFlssnyd()
//                - gdLrLcTotalEntity.getFlskjs()
//                - gdLrLcTotalEntity.getFlgqjs()
//                - gdLrLcTotalEntity.getFlbwld()
//                - gdLrLcTotalEntity.getFlbwyd()
//                - gdLrLcTotalEntity.getFlbwkt()).setScale(2, RoundingMode.HALF_UP).doubleValue()
//               );

        //耕地流入->耕地占补平衡->小计
        gdLrLcTotalEntity.setGdzbphxj(Double.valueOf(jobj.getDouble("gdzbphxj")));
        //耕地流入->耕地占补平衡->土地整理
        gdLrLcTotalEntity.setZbtdzl(Double.valueOf(jobj.getDouble("zbtdzl")));
        //耕地流入->耕地占补平衡->农村建设用地复垦
        gdLrLcTotalEntity.setZbncjsydfk(Double.valueOf(jobj.getDouble("zbncjsydfk")));


        //耕地流入->耕地进出平衡->小计
        gdLrLcTotalEntity.setGdjcphxj(Double.valueOf(jobj.getDouble("gdjcphxj")));
        //耕地流入->耕地进出平衡->林地整治为耕地
        gdLrLcTotalEntity.setJcldzzwgd(Double.valueOf(jobj.getDouble("jcldzzwgd")));
        //耕地流入->耕地进出平衡->园地整治为耕地
        gdLrLcTotalEntity.setJcydzzwgd(Double.valueOf(jobj.getDouble("jcydzzwgd")));
        //耕地流入->耕地进出平衡->坑塘水面整治为耕地
        gdLrLcTotalEntity.setJcktsmzzwgd(Double.valueOf(jobj.getDouble("jcktsmzzwgd")));
        //耕地流入->耕地进出平衡->其他农用地整治为耕地
        gdLrLcTotalEntity.setJcqtnydzzwgd(Double.valueOf(jobj.getDouble("jcqtnydzzwgd")));


        //耕地流入->其他新增->小计
        gdLrLcTotalEntity.setQtxzxj(Double.valueOf(jobj.getDouble("qtxzxj")));
        //耕地流入->其他新增->其他部门新增耕地
        gdLrLcTotalEntity.setQtbmxzgd(Double.valueOf(jobj.getDouble("qtbmxzgd")));
        //耕地流入->其他新增->农民自主开垦耕地
        gdLrLcTotalEntity.setQtnmzzkkgd(Double.valueOf(jobj.getDouble("qtnmzzkkgd")));
        //耕地流入->其他新增->LC耕地的整改
        gdLrLcTotalEntity.setQtlcgddzg(Double.valueOf(jobj.getDouble("qtlcgddzg")));

        //合计
        gdLrLcTotalEntity.setHj(gdLrLcTotalEntity.getHfzygdxj()+gdLrLcTotalEntity.getWfwgzygdxj()+gdLrLcTotalEntity.getGdflhxj());

        gdLrLcTotalEntity.setGdlrzj(new BigDecimal(gdLrLcTotalEntity.getQtxzxj()
                + gdLrLcTotalEntity.getGdjcphxj()
                + gdLrLcTotalEntity.getGdzbphxj()).setScale(2, RoundingMode.HALF_UP).doubleValue() );

        gdLrLcTotalEntity.setYdgdzjl(Math.abs(gdLrLcTotalEntity.getGdlrzj())-Math.abs(gdLrLcTotalEntity.getHj()));

    }



    /**
     * 耕地占补平衡sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdzbphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";

        commSql="  f_xzgdly = '耕地占补平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";


        //小计
        String gdzbphxj= getSelectSql("f_tbmj","gdzbphxj",tableName) +commSql;

        //土地整理,条件
        String zbtdzlSql= getSelectSql("f_tbmj","zbtdzl",tableName) +commSql+ " and f_xzgdlyej = '土地整理' ";
        //农村建设用地复,条件
        String zbncjsydfkSql=getSelectSql("f_tbmj","zbncjsydfk",tableName) +commSql+ " and f_xzgdlyej = '农村建设用地复垦' ";




        String allSql= gdzbphxj + " UNION ALL "+ zbtdzlSql + " UNION ALL " + zbncjsydfkSql;
        return allSql;
    }

    /**
     * 耕地进出平衡sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getGdjcphSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        commSql=" f_xzgdly = '耕地进出平衡新增耕地' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";

        //小计
        String gdjcphxjSql= getSelectSql("f_tbmj","gdjcphxj",tableName) +commSql;

        //林地整治为耕地,条件
        String jcldzzwgdSql= getSelectSql("f_tbmj","jcldzzwgd",tableName) +commSql+ " and f_xzgdlyej = '林地整治为耕地' ";
        //园地整治为耕地,条件
        String jcydzzwgdSql=getSelectSql("f_tbmj","jcydzzwgd",tableName) +commSql+ " and f_xzgdlyej = '园地整治为耕地' ";
        //坑塘水面整治为耕地,条件
        String jcktsmzzwgdSql= getSelectSql("f_tbmj","jcktsmzzwgd",tableName) +commSql+ " and f_xzgdlyej = '坑塘水面整治为耕地' ";
        //其他农用地整治为耕地,条件
        String jcqtnydzzwgdSql=getSelectSql("f_tbmj","jcqtnydzzwgd",tableName) +commSql+ " and f_xzgdlyej = '其他农用地整治为耕地' ";



        String allSql= gdjcphxjSql + " UNION ALL "+ jcldzzwgdSql + " UNION ALL " + jcydzzwgdSql + " UNION ALL " + jcktsmzzwgdSql + " UNION ALL " + jcqtnydzzwgdSql;
        return allSql;
    }

    /**
     * 耕地其他新增sql获取
     * @param tableName
     * @param gdLrLcTotalEntity
     */
    public String getQtxzSql(String tableName, GdLrLcTotalEntity gdLrLcTotalEntity) throws Exception{
        if (gdLrLcTotalEntity.getXzqdm()==null){
            throw new Exception("行政区代码不能为空");
        }
        //共有条件
        String commSql="";
        commSql=" f_xzgdly = '其他新增' and f_status = 4  and f_xzqdm = '" + gdLrLcTotalEntity.getXzqdm()+"'";

        //小计
        String qtxzxjSql= getSelectSql("f_tbmj","qtxzxj",tableName) +commSql;

        //其他部门新增耕地,条件
        String qtbmxzgdSql= getSelectSql("f_tbmj","qtbmxzgd",tableName) +commSql+ " and f_xzgdlyej = '其他部门新增耕地' ";
        //农民自主开垦耕地,条件
        String qtnmzzkkgdSql=getSelectSql("f_tbmj","qtnmzzkkgd",tableName) +commSql+ " and f_xzgdlyej = '农民自主开垦耕地' ";
        //LC耕地的整改,条件
        String qtlcgddzgSql= getSelectSql("f_tbmj","qtlcgddzg",tableName) +commSql+ " and f_xzgdlyej='耕地整改恢复' ";



        String allSql= qtxzxjSql + " UNION ALL "+ qtbmxzgdSql + " UNION ALL " + qtnmzzkkgdSql + " UNION ALL " + qtlcgddzgSql;
        return allSql;
    }

    /**
     * 获取sql select部分
     * @param colName
     * @param sumName
     * @param tableName
     */
    public String getSelectSql(String sumName ,String colName,String tableName){
        String selectSql = "";
        if(this.tableConditionSql.equals("")){
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from "+tableName + " where ";
        }else {
            selectSql =" select COALESCE(sum("+sumName+"),0)  as sum, '"+colName+"' as name from ( select tb.* from "+tableName +" as tb " + this.tableConditionSql +") t where ";
        }
        return  selectSql;
    }

}
