package com.geoway.landteam.landcloud.service.statistics;


import com.geoway.landteam.landcloud.core.repository.pub.SysConfigRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service("JdjcStatisticsService")
public class JdjcStatisticsService {

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    SeasonDao seasonDao;

    @Autowired
    private SysConfigRepository configRepository;

    @Autowired
    RegionService regionService;

    @Autowired
    private LogService logService;

    @Autowired
    private  GdLrLcTotalService gdLrLcTotalService;

    private ExecutorService executor = Executors.newCachedThreadPool();

    private GiLoger logger = GwLoger.getLoger(this.getClass());

    /**
     * 获取疑似变化图斑数据
     *
     * @param quarterName
     * @return
     */
    public List<Map<String, Object>> statisticYSTB(String quarterName) {

        return seasonDao.getYsBh(quarterName);
    }

    /**
     * 根据区县名获取疑似变化图斑数据
     *
     * @param quarterName
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> statisticYSTB(String quarterName, String xzqName) {
        return seasonDao.getYsBh(quarterName, xzqName);
    }

    /**
     * 获取疑似违法图斑
     *
     * @param quarterName
     * @return
     */
    public List<Map<String, Object>> statisticYSWF(String quarterName) {
        return seasonDao.getYsWf(quarterName);
    }

    /**
     * 根据区县名获取疑似变化图斑数据
     *
     * @param quarterName
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> statisticYSWF(String quarterName, String xzqName) {
        return seasonDao.getYsWf(quarterName, xzqName);
    }

    /**
     * 获取疑似变化特征分析
     *
     * @param quarterName
     * @return
     */
    public Map<String, Object> statisticsSxsj(String quarterName) {
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> temp = seasonDao.getSxsj(quarterName);
        for (Map<String, Object> item : temp) {
            String key = ((PGobject) item.get("f_sxbh")).getValue();
            if (result.containsKey(key)) {
                Map<String, Object> cur = ((Map<String, Object>) result.get(key));
                long curCount = (Long) cur.get("f_count");
                BigDecimal curArea = ((BigDecimal) cur.get("f_area"));
                long count = (Long) item.get("f_count");
                BigDecimal area = ((BigDecimal) item.get("f_area"));
                item.put("f_count", count + curCount);
                item.put("f_area", curArea.add(area));
                result.put(key, item);
            } else {
                result.put(key, item);
            }
        }
        return result;
    }

    /**
     * 根据区县名称获取疑似变化特性分析数据
     *
     * @param quarterName
     * @param xzqName
     * @return
     */
    public Map<String, Object> statisticsSxsj(String quarterName, String xzqName) {
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> temp = seasonDao.getSxsj(quarterName, xzqName);
        for (Map<String, Object> item : temp) {
            String key = ((PGobject) item.get("f_sxbh")).getValue();
            if (result.containsKey(key)) {
                Map<String, Object> cur = ((Map<String, Object>) result.get(key));
                long curCount = (Long) cur.get("f_count");
                BigDecimal curArea = ((BigDecimal) cur.get("f_area"));
                long count = (Long) item.get("f_count");
                BigDecimal area = ((BigDecimal) item.get("f_area"));
                item.put("f_count", count + curCount);
                item.put("f_area", curArea.add(area));
                result.put(key, item);
            } else {
                result.put(key, item);
            }
        }
        return result;
    }

    /**
     * 获取所有季节名
     *
     * @return
     */
    public List<String> getAllQuarterName() {
        List<String> result = new ArrayList<>();
        result.add("2020年第2季度");
        result.add("2020年第3季度");
        result.add("2020年第4季度");
        result.add("2021年第1季度");
        result.add("2021年第2季度");
        result.add("2021年第3季度");
        return result;
    }

    /**
     * 获取所有季度疑似违法，疑似变化统计
     *
     * @return
     */
    public List<Map<String, Object>> allQuarterSpot() {
        List<Map<String, Object>> resultMap = new ArrayList<>();
        List<String> allQuarterNameList = getAllQuarterName();
        for (String name : allQuarterNameList) {
            Map<String, Object> obj = new HashMap<>();
            Integer yswfCount = seasonDao.getYsWfCount(name);
            Integer ysbhCount = seasonDao.getYsBhCount(name);
            obj.put("yswf", yswfCount);
            obj.put("ysbh", ysbhCount);
            obj.put("quarterName", name);
            resultMap.add(obj);
        }
        return resultMap;

    }

    /**
     * 根据行政区名称获取季度疑似违法，疑似变化统计
     *
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> allQuarterSpot(String xzqName) {
        List<Map<String, Object>> resultMap = new ArrayList<>();
        List<String> allQuarterNameList = getAllQuarterName();
        for (String name : allQuarterNameList) {
            Map<String, Object> obj = new HashMap<>();
            Integer yswfCount = seasonDao.getYsWfCount(name, xzqName);
            Integer ysbhCount = seasonDao.getYsBhCount(name, xzqName);
            obj.put("yswf", yswfCount);
            obj.put("ysbh", ysbhCount);
            obj.put("quarterName", name);
            resultMap.add(obj);
        }
        return resultMap;

    }

    /**
     * 统计疑似违法疑似变化
     *
     * @param quarterName
     * @return
     */
    public Map<String, Integer> quarterSpotStatistics(String quarterName) {
        Map<String, Integer> resultMap = new HashMap<>();
        resultMap.put("ysbh", seasonDao.getYsBhCount(quarterName));
        resultMap.put("yswf", seasonDao.getYsWfCount(quarterName));
        return resultMap;
    }

    /**
     * 根据行政区统计疑似违法疑似变化
     *
     * @param quarterName
     * @param xzqName
     * @return
     */
    public Map<String, Integer> quarterSpotStatistics(String quarterName, String xzqName) {
        Map<String, Integer> resultMap = new HashMap<>();
        resultMap.put("ysbh", seasonDao.getYsBhCount(quarterName, xzqName));
        resultMap.put("yswf", seasonDao.getYsWfCount(quarterName, xzqName));
        return resultMap;
    }

    public Map<String, Object> statisticsQuerterTask(String quarterName) {
        Map<String, Object> resultMap;
        resultMap = seasonDao.getQuerterTask(quarterName);
        return resultMap;
    }

    public Map<String, Object> statisticsQuerterTask(String quarterName, String xzqName) {
        Map<String, Object> resultMap;
        resultMap = seasonDao.getQuerterTask(quarterName, xzqName);
        return resultMap;
    }

    public List<Map<String, Object>> statisticXzqTask(String quarterName) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        List<Map<String, Object>> statusCountList = seasonDao.getAllXzqStatusCount(quarterName);
        List<Map<String, Object>> finishCountList = seasonDao.getFinishXzqStatusCount(quarterName);
        for (int i = 0; i < statusCountList.size(); i++) {
            Map<String, Object> map = new HashMap<>();
            Long sCount = (Long) statusCountList.get(i).get("count");
            ;
            Long fCount;
            Long percent = 0L;
            map.put("xzqmc", statusCountList.get(i).get("xzqmc"));
            if (i < finishCountList.size()) {
                fCount = (Long) statusCountList.get(i).get("count");
                percent = (fCount / sCount) * 100;

            } else {
                fCount = sCount;
                percent = 100L;

            }
            map.put("total", sCount);
            map.put("assigncount", fCount);
            map.put("percent", percent);
            resultList.add(map);
        }
        return resultList;
    }

}
