package com.geoway.landteam.landcloud.service.statistics;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.util.*;

@Component
public class SeasonDao {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    /**
     * 获取季度任务表
     *
     * @param yearSeason
     * @return
     */
    public String getSeasonTaskTable(String yearSeason) {
        String sql = "select f_tablename from tbtsk_objectinfo where " +
                "f_id = (select f_tableid from tbtsk_task_biz where f_name = ?)";
        String taskTable = "";
        try {
            //jdbc查询为空时,使用变量接收会报错
            taskTable = jdbcTemplate.queryForObject(sql, String.class, yearSeason);
        } catch (Exception ignored) {
        }
        return taskTable;
    }


    /**
     * 获取所有疑似变化数据
     *
     * @param yearSeason
     * @return
     */
    public List<Map<String, Object>> getYsBh(String yearSeason) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzqdm as xzqdm, f_xzqmc1 as xzqmc,count(f_xzqmc1) ,sum(f_tbmj) as area  from "
                    + taskTableName + " group by xzqmc,xzqdm order by area DESC";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;
    }

    /**
     * 获取所有疑似变化计数
     *
     * @param yearSeason
     * @return
     */
    public Integer getYsBhCount(String yearSeason) {
        Integer count = 0;
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select count(f_id) from " + taskTableName;
            count = jdbcTemplate.queryForObject(sql, Integer.class);
        }
        return count;
    }

    /**
     * 按行政区名获取疑似变化计数
     *
     * @param yearSeason
     * @param xzqName
     * @return
     */
    public Integer getYsBhCount(String yearSeason, String xzqName) {
        Integer count = 0;
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select count(f_id) from " + taskTableName + " where f_xzqmc1= " + "'" + xzqName + "'";
            count = jdbcTemplate.queryForObject(sql, Integer.class);
        }
        return count;

    }

    /**
     * 获取所有疑似违法计数
     *
     * @param yearSeason
     * @return
     */
    public Integer getYsWfCount(String yearSeason) {
        Integer count = 0;
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select count(f_yswf) from " + taskTableName + " where f_yswf = '1'or f_yswf ='是'";
            count = jdbcTemplate.queryForObject(sql, Integer.class);
        }
        return count;
    }

    /**
     * 根据行政区名获取疑似违法计数
     *
     * @param yearSeason
     * @return
     */
    public Integer getYsWfCount(String yearSeason, String xzqName) {
        Integer count = 0;
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select count(f_yswf) from " + taskTableName + " where f_xzqmc1= " + "'" + xzqName + "'" +
                    " and f_yswf = '1'or f_yswf ='是'";
            count = jdbcTemplate.queryForObject(sql, Integer.class);
        }
        return count;
    }

    /**
     * 根据行政区名获取疑似变化数据
     *
     * @param yearSeason
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> getYsBh(String yearSeason, String xzqName) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzmc as xzqmc,count(f_xzmc) ,sum(f_tbmj) as area  from " + taskTableName
                    + " where f_xzqmc1 ='" + xzqName + "'  group by xzqmc order by area DESC";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;

    }

    /**
     * 获取疑似违法数据
     *
     * @param yearSeason
     * @return
     */
    public List<Map<String, Object>> getYsWf(String yearSeason) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzqmc1 as xzqmc,sum(f_tbmj) as area,count(f_yswf) from "
                    + taskTableName + " where f_yswf = '1'or f_yswf ='是' GROUP BY xzqmc order by area DESC ";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;
    }

    /**
     * 根据行政区名获取疑似违法数据
     *
     * @param yearSeason
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> getYsWf(String yearSeason, String xzqName) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzmc as xzqmc,sum(f_tbmj) as area,count(f_yswf) from "
                    + taskTableName + " where f_yswf = '1'or f_yswf ='是' and f_xzqmc1 ='"
                    + xzqName + "' GROUP BY xzqmc order by area DESC ";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;
    }

    /**
     * 获取疑似变化特征分析数据
     *
     * @param yearSeason
     * @return
     */
    public List<Map<String, Object>> getSxsj(String yearSeason) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String tbmj = "f_tbmj";
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "SELECT DISTINCT(f_qsxyxtz,f_hsxyxtz) as f_sxbh ,count(*) as f_count, sum(" + tbmj +
                    ") as f_area  FROM " + taskTableName + " GROUP BY f_sxbh";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;
    }

    /**
     * 根据行政区获取疑似变化特征分析数据
     *
     * @param yearSeason
     * @param xzqName
     * @return
     */
    public List<Map<String, Object>> getSxsj(String yearSeason, String xzqName) {
        List<Map<String, Object>> resultMap = new LinkedList<>();
        String tbmj = "f_tbmj";
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "SELECT DISTINCT(f_qsxyxtz,f_hsxyxtz) as f_sxbh ,count(*) as f_count, sum(" + tbmj +
                    ") as f_area  FROM " + taskTableName + " where f_xzqmc1='" + xzqName + "' GROUP BY f_sxbh";
            resultMap = jdbcTemplate.queryForList(sql);
        }
        return resultMap;
    }

    public Map<String, Object> getQuerterTask(String yearSeason) {
        Map<String, Object> resultMap = new HashMap<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String ySql = "select count(f_status) from " + taskTableName + " where f_status = '4'";
            String nSql = "select count(f_status) from " + taskTableName + " where f_status != '4'";
            Integer yCount = jdbcTemplate.queryForObject(ySql, Integer.class);
            Integer nCount = jdbcTemplate.queryForObject(nSql, Integer.class);
            resultMap.put("assigned", yCount);
            resultMap.put("unassigned", nCount);
        }
        return resultMap;
    }

    public Map<String, Object> getQuerterTask(String yearSeason, String xzqName) {
        Map<String, Object> resultMap = new HashMap<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String ySql = "select count(f_status) from " + taskTableName + " where f_xzqmc1=" + xzqName + " f_status = '4'";
            String nSql = "select count(f_status) from " + taskTableName + " where f_xzqmc1=" + xzqName + " f_status != '4'";
            Integer yCount = jdbcTemplate.queryForObject(ySql, Integer.class);
            Integer nCount = jdbcTemplate.queryForObject(nSql, Integer.class);
            resultMap.put("assigned", yCount);
            resultMap.put("unassigned", nCount);
        }
        return resultMap;
    }

    public List<Map<String, Object>> getAllXzqStatusCount(String yearSeason) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzqmc1 as xzqmc,count(f_status) from " + taskTableName + " GROUP BY f_xzqmc1 ORDER BY f_xzqmc1";
            resultList = jdbcTemplate.queryForList(sql);
        }
        return resultList;
    }

    public List<Map<String, Object>> getFinishXzqStatusCount(String yearSeason) {
        List<Map<String, Object>> resultList = new ArrayList<>();
        String taskTableName = getSeasonTaskTable(yearSeason);
        if (!taskTableName.equals("")) {
            String sql = "select f_xzqmc1 as xzqmc,count(f_status) from " + taskTableName +
                    " WHERE f_status='4' GROUP BY f_xzqmc1 ORDER BY f_xzqmc1";
            resultList = jdbcTemplate.queryForList(sql);
        }
        return resultList;
    }
}
