package com.geoway.landteam.landcloud.service.statistics.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.dto.EasyUIResponse;
import com.geoway.landteam.landcloud.model.datatransfer.constants.BusiType;
import com.geoway.landteam.landcloud.model.statistics.dto.CommonNum;
import com.geoway.landteam.landcloud.model.statistics.dto.Gztj;
import com.geoway.landteam.landcloud.model.statistics.dto.HeatMap;
import com.geoway.landteam.landcloud.model.statistics.dto.Wyjd;
import com.geoway.landteam.landcloud.service.statistics.CgjcService;
import com.geoway.landteam.landcloud.service.util.ShapeFile2Geo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * Created by licong on 2021/6/1.
 */
@Service
public class CgjcServiceImpl implements CgjcService {

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TskTaskBizRepository tbTaskBizRepository;
    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;

    @Override
    public List<HeatMap> getByWkt(String name, String wkt, Integer num, Double xmin, Double xmax, Double ymin, Double ymax, String isYswt) {
        List<TbtskObjectinfo> tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }

        String queryFieldSql = " f_id,st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as f_shape,f_lon,f_lat";
        String datasql = this.getTableSql(tableList, queryFieldSql, null);
        if(isYswt.equals("1")){
            datasql+="  where f_yswt = '1' ";
        }

        if (!StringUtils.isEmpty(wkt)) {
            datasql = "select * from (" + datasql + ") w";
            datasql += " where ST_Contains( ST_GeometryFromText('" + wkt + "'), f_shape)";
        } else {
            datasql = "select * from (" + datasql + ") w";
            datasql += " where f_lon > " + ymin + " and f_lon < " + ymax + " and f_lat > " + xmin + " and f_lat < " + xmax;
        }
        Long count = this.getCount(datasql);
        Integer clusterNum = 100;
        if (null != num && count >= num) {
            clusterNum = num;
        } else if (count <= 10) {
            clusterNum = Integer.valueOf(count.toString());
        } else if (count < 50) {
            clusterNum = 10;
        } else if (count < 150) {
            clusterNum = 30;
        } else if (count < 250) {
            clusterNum = 50;
        }
        datasql = "SELECT f_lon,f_lat,ST_ClusterKMeans(t1.f_shape, " + clusterNum + ") over () AS cid from (" + datasql + ") t1";

        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(datasql);
        Map<Integer, List<HeatMap>> dataMap = new HashMap<>();
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> obj = list.get(i);
            Integer cid = (Integer) obj.get("cid");
            BigDecimal lon = (BigDecimal) obj.get("f_lon");
            BigDecimal lat = (BigDecimal) obj.get("f_lat");
            HeatMap heatMap = new HeatMap(lon, lat, 0);
            if (dataMap.containsKey(cid)) {
                dataMap.get(cid).add(heatMap);
            } else {
                List<HeatMap> tempList = new ArrayList<>();
                tempList.add(heatMap);
                dataMap.put(cid, tempList);
            }
        }
        List<HeatMap> result = new ArrayList<>();
        for (Map.Entry<Integer, List<HeatMap>> entry : dataMap.entrySet()) {
            List<HeatMap> obj = entry.getValue();
            Integer size = obj.size();
            BigDecimal lon = new BigDecimal(0);
            BigDecimal lat = new BigDecimal(0);
            for (int j = 0; j < obj.size(); j++) {
                lon = lon.add(obj.get(j).getLon());
                lat = lat.add(obj.get(j).getLat());
            }
            lon = lon.divide(new BigDecimal(size), 8, RoundingMode.DOWN);
            lat = lat.divide(new BigDecimal(size), 8, RoundingMode.DOWN);
            HeatMap heatMap = new HeatMap(lon, lat, size);
            result.add(heatMap);
        }
        return result;
    }

    @Override
    public Map<String, Long> getStatisticsByLevel(String name, Integer level,String isYswt) {
        List<TbtskObjectinfo > tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_xzqdmsys ";
        String datasql = this.getTableSql(tableList, queryFieldSql, null);

        if(isYswt.equals("1")){
            datasql+="  where f_yswt = '1' ";
        }

        String length = "7";
        if (level == 2) {
            length = "10";
        }
        datasql = "select substring(f_xzqdmsys, 0,  " + length + ") as code,count(*) as codecount from (" + datasql +
                ") t GROUP BY substring(f_xzqdmsys, 0, " + length + ")";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(datasql);
        Map<String, Long> result = new HashMap<>();
        for (int i = 0; i < dataList.size(); i++) {
            String code = (String) dataList.get(i).get("code");
            Long count = (Long) dataList.get(i).get("codecount");
            result.put(code, count);
        }
        return result;
    }

    @Override
    public EasyUIResponse getStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh,
                                              String xzqmc, String bhlx, String jzqk, String wkt, String ztfx, String zdgkq, String sxws, String xzmc) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            EasyUIResponse response = new EasyUIResponse();
            response.setTotal(0l);
            response.setRows(new ArrayList());
            return response;
        }

        ShapeFile2Geo shapeFile2Geo = new ShapeFile2Geo(this.uploadDir);
        Map<String, Object> map = shapeFile2Geo.parsingShapeFile(request);
        if (map.get("shpfile") != null) {
            wkt = map.get("shpfile").toString();
        }
        List<String> tbbhs = parseExcel(request);
        String sql = this.getSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, true, xzmc);
        Long count = this.getCount(sql);

        Integer offset = pageSize * (page - 1);
        String datasql = "select * from (" + sql + ")t limit " + pageSize + " offset " + offset;
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(datasql);

        if (null != shp && shp && !dataList.isEmpty()) {//返回shape数据得特殊处理，效率问题
            String sql2 = "";
            String ids = "";
            for (int i = 0; i < dataList.size(); i++) {
                ids += "'" + dataList.get(i).get("f_id").toString() + "'";
                if (i != dataList.size() - 1) {
                    ids += ",";
                }
            }
            for (int i = 0; i < tableList.size(); i++) {
                String tablename = (String) tableList.get(i).get("f_tablename");
                String biz = (String) tableList.get(i).get("f_id");
                sql2 += " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_bhlx,f_committime,f_id,f_yswf,f_status,'" + biz + "' as bizid," +
                        " st_astext(f_shape) as shape , '" + tablename + "' as tablename ," +
                        "EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=1) as photo," +
                        "EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=2) as video," +
                        "EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=3) as audio," +
                        "EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='jpg') as dronev," +
                        " EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='mp4') as dronep ";
                sql2 += " FROM " + tablename + " t";
                sql2 += " where f_id in (" + ids + ") ";
                if (i != tableList.size() - 1) {
                    sql2 += " UNION ALL ";
                }
            }
            dataList = this.jdbcTemplate.queryForList(sql2);
        }

        EasyUIResponse response = new EasyUIResponse();
        response.setTotal(count);
        response.setRows(dataList);
        return response;
    }

    @Override
    public EasyUIResponse getYswtStatisticsByPage(HttpServletRequest request, String name, Integer page, Integer pageSize, Boolean shp, String tbbh,
                                                  String xzqmc, String bhlx,String jzqk, String wkt, String ztfx, String zdgkq, String sxws,Integer wtfl,
                                                  String xzmc) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            EasyUIResponse response = new EasyUIResponse();
            response.setTotal(0l);
            response.setRows(new ArrayList());
            return response;
        }

        ShapeFile2Geo shapeFile2Geo = new ShapeFile2Geo(this.uploadDir);
        Map<String, Object> map = shapeFile2Geo.parsingShapeFile(request);
        if (map.get("shpfile") != null) {
            wkt = map.get("shpfile").toString();
        }
        List<String> tbbhs = parseExcel(request);
        String sql = this.getYswtSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, wtfl, xzmc);
        Long count = this.getCount(sql);

        Integer offset = pageSize * (page - 1);
        String datasql = "select * from (" + sql + ")t limit " + pageSize + " offset " + offset;
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(datasql);

        if (null != shp && shp && !dataList.isEmpty()) {//返回shape数据得特殊处理，效率问题
            String sql2 = "";
            String ids = "";
            for (int i = 0; i < dataList.size(); i++) {
                ids += "'" + dataList.get(i).get("f_id").toString() + "'";
                if (i != dataList.size() - 1) {
                    ids += ",";
                }
            }
            for (int i = 0; i < tableList.size(); i++) {
                String tablename = (String) tableList.get(i).get("f_tablename");
                String biz = (String) tableList.get(i).get("f_id");
                sql2 += " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_bhlx,f_committime,f_id,f_yswf,f_status,f_jbntmj,f_sthxzymj,f_zrbhdmj,f_zygdmj,f_xzmc,'" + biz + "' as bizid," +
                        " st_astext(f_shape) as shape , '" + tablename + "' as tablename " ;
                sql2 += " FROM " + tablename + " t";
                sql2 += " where f_id in (" + ids + ") ";
                if (i != tableList.size() - 1) {
                    sql2 += " UNION ALL ";
                }
            }
            dataList = this.jdbcTemplate.queryForList(sql2);
        }

        EasyUIResponse response = new EasyUIResponse();
        response.setTotal(count);
        response.setRows(dataList);
        return response;
    }
    private List<String> parseExcel(HttpServletRequest request) {

        List<String> tbbhs = new ArrayList<>();

        try {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
                Iterator<String> iter = multiRequest.getFileNames();
                while (iter.hasNext()) {
                    MultipartFile multipartFile = multiRequest.getFile((String) iter.next());
                    if (multipartFile != null) {
                        if(!multipartFile.getOriginalFilename().contains("xls")){
                            continue;
                        }
                        File excelFile = null;
                        File dir = new File(uploadDir);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }

                        excelFile = File.createTempFile("tmp", ".xlsm", dir);
                        FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), excelFile);
                        Workbook workbook = null;
                        OutputStream out = null;
                        InputStream is = null;
                        File file = new File(excelFile.getAbsolutePath());
                        InputStream inputStream = new FileInputStream(file);

                        File parentFile = file.getParentFile();
                        if (parentFile != null && (!parentFile.exists())) {
                            parentFile.mkdirs();
                        }

                        //这种方式 Excel 2003/2007/2010 都是可以处理的
                        workbook = WorkbookFactory.create(inputStream);
                        inputStream.close();

                        Sheet sheet = workbook.getSheetAt(0);
                        Row row = sheet.getRow(0);
                        int rowCount = sheet.getPhysicalNumberOfRows();
                        for (int i = 1; i < rowCount; i++) {
                            row = sheet.getRow(i);
                            if (row == null) {
                                continue;
                            }
                            try {
                                Cell cell = row.getCell(0);
                                String cellValue = cell.getStringCellValue();
                                if (StringUtils.isNotBlank(cellValue)) {
                                    tbbhs.add(cellValue);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                        }

                        out = new FileOutputStream(file);
                        workbook.write(out);
                        out.flush();
                        out.close();


                        try {
                            if (excelFile.exists()) {
                                excelFile.delete();
                            }
                        } catch (Exception e) {
                        }

                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }


        return tbbhs;
    }

    @Override
    public List<Map<String, Object>> getDataByWkt(String name, String wkt) {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String sql = "";
        for (int i = 0; i < tableList.size(); i++) {
            String tablename = (String) tableList.get(i).get("f_tablename");
            String biz = (String) tableList.get(i).get("f_id");
            String bizname = (String) tableList.get(i).get("f_name");
            sql += " SELECT f_id as id,st_astext(f_shape) as shape, f_tbbh, f_tbmj, f_status,'" + biz + "' as bizid" +
                    ", '" + bizname + "' as name ,'" + tablename + "' as tablename ";
            sql += " FROM " + tablename;
            if (!StringUtils.isEmpty(wkt)) {
                sql += " where st_contains(ST_GeomFromText('" + wkt + "'),f_shape)";
            }
            if (i != tableList.size() - 1) {
                sql += " UNION ALL ";
            }
        }
        return this.jdbcTemplate.queryForList(sql);
    }

    @Override
    public String getLastSeasion() {
        String lastSeasion = tbTaskBizRepository.getLastSeasion();
        return lastSeasion != null ? lastSeasion : "";
    }

    @Override
    public void downloadAll(HttpServletRequest request,String name, String tbbh, String xzqmc, String bhlx,String jzqk,
                            String wkt, String ztfx, String zdgkq, String sxws, Long userId) throws Exception {
        List<Map<String, Object>> tableList = this.getBizAndTables(name);
        if (tableList.isEmpty()) {
            return;
        }

        List<String> tbbhs = parseExcel(request);
        String bizid = (String) tableList.get(0).get("f_id");

        String sql = this.getSql(tbbh, xzqmc, bhlx, jzqk, wkt, ztfx, zdgkq, sxws, tableList, tbbhs, false, null);
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        if (dataList.size() >= 1000) {
            throw new Exception("不支持大于1000个图斑的成果下载，请联系管理员");
        }
        //目前只支持一个任务的下载
        String tbIds = "";
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            String tbid = (String) obj.get("f_id");
            tbIds += tbid;
            if (i != dataList.size() - 1) {
                tbIds += ",";
            }
        }
        this.dataDownloadDailyTaskService.downloadGeometry(bizid, tbIds, userId, "attach", true, 2);
    }

    private String getSql(String tbbh, String xzqmc, String bhlx,String jzqk, String wkt, String ztfx, String zdgkq, String sxws, List<Map<String, Object>> tableList,
                          List<String> tbbhs, boolean media, String xzmc){
        String sql = "";
        for (int i = 0; i < tableList.size(); i++) {
            String tablename = (String) tableList.get(i).get("f_tablename");
            String biz = (String) tableList.get(i).get("f_id");
            sql += " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_xzqdm,f_bhlx,f_yswf,f_status,f_committime,f_id,'" + biz + "' as bizid ," +
                    "'" + tablename + "' as tablename ";//f_xzqmc1、2020 3季度之前没有f_xzqmc字段
            if (!StringUtils.isEmpty(wkt)) {
                sql += ",st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as center";
            }
            if (!StringUtils.isEmpty(ztfx)) {
                sql += ",f_ztfx";
            }
            if (!StringUtils.isEmpty(sxws)) {
                sql += ",f_sxws";
            }
            if (!StringUtils.isEmpty(zdgkq)) {
                sql += ",f_yjjbntzy,f_sthxzymj,f_zrbhdzym,f_zrbhd_n1 ";
            }
            if(media){
                sql +=  ",EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=1) as photo," +
                        "EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=2) as video," +
                        "EXISTS (SELECT null from tb_app_media m WHERE t.f_id=m.f_galleryid and f_type=3) as audio," +
                        "EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='jpg') as dronev," +
                        " EXISTS (SELECT null from tb_drone d WHERE t.f_id=d.f_jctbid and d.f_format='mp4') as dronep ";
            }
            sql += " FROM " + tablename + " t";//如果数据表为多个时，在这里加where速度更快
            if (i != tableList.size() - 1) {
                sql += " UNION ALL ";
            }
        }
        if (!StringUtils.isEmpty(tbbh) || !StringUtils.isEmpty(xzqmc) || !StringUtils.isEmpty(bhlx) || !StringUtils.isEmpty(ztfx)|| !StringUtils.isEmpty(jzqk)
                || !StringUtils.isEmpty(zdgkq) || !StringUtils.isEmpty(sxws) || !StringUtils.isEmpty(wkt) || !tbbhs.isEmpty()) {
            sql = " select * from (" + sql + ") t2 ";
            boolean isfirst = true;
            if (!StringUtils.isEmpty(tbbh)) {
                sql += " where t2.f_tbbh like '%" + tbbh + "%' ";
                isfirst = false;
            }
            if (!StringUtils.isEmpty(xzqmc)) {
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                    isfirst = false;
                }
//                sql += " t2.f_xzqdm like '%" + xzqmc + "%' ";
                sql+="t2.f_xzqdm in ('"+xzqmc.replace(",","','")+"')";
            }
            if (!StringUtils.isEmpty(bhlx)) {
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                    isfirst = false;
                }
                sql += " t2.f_bhlx = '" + bhlx + "' ";
            }
            if (!StringUtils.isEmpty(wkt)) {
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                    isfirst = false;
                }
                sql += " ST_Contains( ST_GeometryFromText('" + wkt + "'), t2.center)";
            }
            if (!StringUtils.isEmpty(ztfx)) {
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                    isfirst = false;
                }
                sql += " t2.f_ztfx = '" + ztfx + "' ";
            }
            if (!StringUtils.isEmpty(zdgkq)) {
                List<String> tempSql = new ArrayList<>();
                JSONObject params = JSONObject.parseObject(zdgkq);
                String filterCompare = params.getString("filterCompare");
                JSONArray paramsList = params.getJSONArray("list");
                for (Object o : paramsList) {
                    if("1".equals(o.toString())){
                        tempSql.add(" (t2.f_yjjbntzy > 0) ");
                    }else if("2".equals(o.toString())){
                        tempSql.add(" (t2.f_sthxzymj > 0) ");
                    }else if("3".equals(o.toString())){
                        tempSql.add(" (t2.f_zrbhdzym > 0) ");
                    }else if("4".equals(o.toString())){
                        tempSql.add(" (t2.f_zrbhd_n1 is not null) ");
                    }
                }
                if(!tempSql.isEmpty()){
                    if (!isfirst) {
                        sql += " and ";
                    } else {
                        sql += " where ";
                        isfirst = false;
                    }
                    sql += "(" + StringUtils.join(tempSql, filterCompare) + ")";
                }
//                if (!isfirst) {
//                    sql += " and ";
//                } else {
//                    sql += " where ";
//                    isfirst = false;
//                }
//                sql += " t2.f_bhlx = '" + zdgkq + "' ";
            }
            if (!StringUtils.isEmpty(sxws)) {
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                }
                sql += " t2.f_sxws = '" + sxws + "' ";
            }
            if(!tbbhs.isEmpty()){
                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                }
                sql += " t2.f_tbbh in ('" + StringUtils.join(tbbhs, "','") + "') ";
            }
            if(StringUtils.isNotEmpty(jzqk)){

                if (!isfirst) {
                    sql += " and ";
                } else {
                    sql += " where ";
                }

                String[] jzqks = jzqk.split(",");
                List<String> tempSql = new ArrayList<>();
                if(jzqk.contains("0")){
                    tempSql.add(" t2.f_status<4");
                }
                if(jzqk.contains("1")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is null");
                }
                if(jzqk.contains("2")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (not exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) and not exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                if(jzqk.contains("3")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) or exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                sql += " (" +  StringUtils.join(tempSql, " or ") + " ) ";
            }
        }
        return sql;
    }
    private String getYswtSql(String tbbh, String xzqmc, String bhlx,String jzqk, String wkt, String ztfx, String zdgkq, String sxws,
                              List<Map<String, Object>> tableList, List<String> tbbhs, Integer wtfl, String xzmc) {
        String sql = "";
        for (int i = 0; i < tableList.size(); i++) {
            String tablename = (String) tableList.get(i).get("f_tablename");
            String biz = (String) tableList.get(i).get("f_id");
            sql += " SELECT f_tbbh,f_xzqmc1 as f_xzqmc,f_xzqdm,f_bhlx,f_jbntmj,f_sthxzymj,f_zrbhdmj,f_zygdmj,f_xzmc,f_id,f_yswt,'" + biz + "' as bizid ," +
                    "'" + tablename + "' as tablename";//f_xzqmc1、2020 3季度之前没有f_xzqmc字段
            if (!StringUtils.isEmpty(wkt)) {
                sql += ",st_geomfromtext('POINT(' || f_lon || ' ' || f_lat || ')') as center";
            }
            if (!StringUtils.isEmpty(ztfx)) {
                sql += ",f_ztfx";
            }
            if (!StringUtils.isEmpty(sxws)) {
                sql += ",f_sxws";
            }
            if (!StringUtils.isEmpty(zdgkq)) {
                sql += "";
            }
            sql += " FROM " + tablename + " t";//如果数据表为多个时，在这里加where速度更快
            if (i != tableList.size() - 1) {
                sql += " UNION ALL ";
            }
        }
        sql = " select * from (" + sql + ") t2 where t2.f_yswt='1' ";
        if (!StringUtils.isEmpty(tbbh) || !StringUtils.isEmpty(xzqmc) || !StringUtils.isEmpty(bhlx) || !StringUtils.isEmpty(ztfx)|| !StringUtils.isEmpty(jzqk)
                || !StringUtils.isEmpty(zdgkq) || !StringUtils.isEmpty(sxws) || !StringUtils.isEmpty(wkt) || !tbbhs.isEmpty()||wtfl!=null || !StringUtils.isEmpty(xzmc)) {
            if (!StringUtils.isEmpty(tbbh)) {
                sql += " AND t2.f_tbbh like '%" + tbbh + "%' ";
            }
            if (!StringUtils.isEmpty(xzqmc)) {
                sql += " AND (t2.f_xzqdm = '" + xzqmc + "' or t2.f_xzmc like '%" + xzqmc + "%' )";
            }
            if (!StringUtils.isEmpty(xzmc)) {
                sql += " AND t2.f_xzmc like '%" + xzmc + "%'";
            }
            if (!StringUtils.isEmpty(bhlx)) {
                sql += " AND t2.f_bhlx = '" + bhlx + "' ";
            }
            if (!StringUtils.isEmpty(wkt)) {
                sql += " AND ST_Contains( ST_GeometryFromText('" + wkt + "'), t2.center)";
            }
            if (!StringUtils.isEmpty(ztfx)) {
                sql += " AND t2.f_ztfx = '" + ztfx + "' ";
            }
            if (!StringUtils.isEmpty(zdgkq)) {
                List<String> tempSql = new ArrayList<>();
                JSONObject params = JSONObject.parseObject(zdgkq);
                String filterCompare = params.getString("filterCompare");
                JSONArray paramsList = params.getJSONArray("list");
                for (Object o : paramsList) {
                    if("1".equals(o.toString())){
                        tempSql.add(" (t2.f_yjjbntzy > 0) ");
                    }else if("2".equals(o.toString())){
                        tempSql.add(" (t2.f_sthxzymj > 0) ");
                    }else if("3".equals(o.toString())){
                        tempSql.add(" (t2.f_zrbhdzym > 0) ");
                    }else if("4".equals(o.toString())){
                        tempSql.add(" (t2.f_zrbhd_n1 is not null) ");
                    }
                }
                if(!tempSql.isEmpty()){
                    sql += "AND (" + StringUtils.join(tempSql, filterCompare) + ")";
                }
            }
            if (!StringUtils.isEmpty(sxws)) {
                sql += " AND t2.f_sxws = '" + sxws + "' ";
            }
            if (wtfl!=null&&(wtfl & 1) == 1) {
                sql += " AND t2.f_zygdmj > 0 ";
            }
            if (wtfl!=null&&(wtfl & 2) == 2) {
                sql += " AND t2.f_jbntmj > 0 ";
            }
            if (wtfl!=null&&(wtfl & 4) == 4) {
                sql += " AND t2.f_sthxzymj > 0 ";
            }
            if (wtfl!=null&&(wtfl & 8) == 8) {
                sql += " AND t2.f_zrbhdmj > 0 ";
            }
            if(!tbbhs.isEmpty()){
                sql += " AND t2.f_tbbh in ('" + StringUtils.join(tbbhs, "','") + "') ";
            }
            if(StringUtils.isNotEmpty(jzqk)){
                String[] jzqks = jzqk.split(",");
                List<String> tempSql = new ArrayList<>();
                if(jzqk.contains("0")){
                    tempSql.add(" t2.f_status<4");
                }
                if(jzqk.contains("1")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is null");
                }
                if(jzqk.contains("2")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (not exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) and not exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                if(jzqk.contains("3")){
                    tempSql.add(" t2.f_status=4 and t2.f_bhlx is not null and  (exists (select null from tb_app_media m where t2.f_id=m.f_galleryid) or exists (select null from tb_drone d where t2.f_id=d.f_jctbid))");
                }
                sql += " AND (" +  StringUtils.join(tempSql, " or ") + " ) ";
            }
        }
        return sql;
    }

    @Override
    public Gztj getStatistics(String seasons, String xzqdms) {
        List<TbtskObjectinfo > tableList = this.getTablesBySeasons(seasons);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_status,f_cgsh,f_yswf,f_xzqdm ";
        String sql = this.getTableSql(tableList, queryFieldSql, xzqdms);
        //图斑数、提交数、按行政区统计
        String submitSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ") t group by f_status, f_xzqdm";
        List<Map<String, Object>> submitList = this.jdbcTemplate.queryForList(submitSql);

        String queryFieldSql2 = " f_id ";
        String sql2 = this.getTableSql(tableList, queryFieldSql2, xzqdms);
        //多媒体数量
        String mediaSql = "select count(*) as f_sum, f_type from tb_app_media where f_galleryid in (" + sql2 + ") group by f_type";
        List<Map<String, Object>> mediaList = this.jdbcTemplate.queryForList(mediaSql);
        String wrjSql = "select count(*) as f_sum from tb_drone where f_jctbid in (" + sql2 + ")";
        Map wrjMap = this.jdbcTemplate.queryForMap(wrjSql);

        //成果审核情况
        String cgshSql = "select count(*) as f_sum, f_cgsh from (" + sql + ")t group by f_cgsh";
        List<Map<String, Object>> cgshList = this.jdbcTemplate.queryForList(cgshSql);

        //疑似违法
        String yswfSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + this.getTableSql(tableList, queryFieldSql, null) + ")t where f_yswf = '1' or f_yswf = '是' group by f_status, f_xzqdm";
        List<Map<String, Object>> yswfList = this.jdbcTemplate.queryForList(yswfSql);

        //外业数量
        String wysql = "";
        for (int i = 0; i < tableList.size(); i++) {
            String signField = this.getSignField(tableList.get(i).getfTablename());
            String tablename = tableList.get(i).getfTablename();
            wysql += " select count(*) as f_sum,f_xzqdm from " + tablename + " where " + signField +
                    " is not null and " + signField + " != '' ";
            if (!StringUtils.isEmpty(xzqdms)) {
                wysql += " and f_xzqdm in (" + this.getINsql(xzqdms) + ")";
            }
            wysql += " GROUP BY f_xzqdm";
            if (i != tableList.size() - 1) {
                wysql += " UNION ALL ";
            }
        }
        List<Map<String, Object>> wyList = this.jdbcTemplate.queryForList(wysql);

        Long sum = 0l;//图斑总数
        Long submitNum = 0l;//已提交总数
        Long unSubmitNum = 0l;//未提交总数
        Long unSend = 0l;//未下发
        Map<String, Wyjd> wyjdMap = new HashMap<>();//外业统计不过滤行政区
        for (int i = 0; i < submitList.size(); i++) {
            Map<String, Object> obj = submitList.get(i);
            Integer status = (Integer) obj.get("f_status");
            Long f_sum = (Long) obj.get("f_sum");
            String code = (String) obj.get("f_xzqdm");
            sum += f_sum;
            if (4 == status) {
                submitNum += f_sum;
            } else if (2 == status) {
                unSubmitNum += f_sum;
            } else {
                unSend += f_sum;
            }
            if (StringUtils.isEmpty(xzqdms)) {
                this.createWyjd(wyjdMap, status, f_sum, code);
            }
        }
        if (!StringUtils.isEmpty(xzqdms)) {
            String wyjdSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + this.getTableSql(tableList, queryFieldSql, null) + ") t group by f_status, f_xzqdm";
            List<Map<String, Object>> wyjdList = this.jdbcTemplate.queryForList(wyjdSql);
            for (int i = 0; i < wyjdList.size(); i++) {
                Map<String, Object> obj = wyjdList.get(i);
                Integer status = (Integer) obj.get("f_status");
                Long f_sum = (Long) obj.get("f_sum");
                String code = (String) obj.get("f_xzqdm");
                this.createWyjd(wyjdMap, status, f_sum, code);
            }
        }

        Long zp = 0l;//照片
        Long sp = 0l;//视频
        Long yp = 0l;//音频
        Long wrj = (Long) wrjMap.get("f_sum");//无人机
        for (int i = 0; i < mediaList.size(); i++) {
            Map<String, Object> obj = mediaList.get(i);
            Long f_sum = (Long) obj.get("f_sum");
            Integer type = (Integer) obj.get("f_type");
            if (1 == type) {
                zp += f_sum;
            } else if (2 == type) {
                sp += f_sum;
            } else if (3 == type) {
                yp += f_sum;
            }
        }

        List<CommonNum> cgshResultList = new ArrayList<>();
        Long cgshSum = 0l;
        for (int i = 0; i < cgshList.size(); i++) {
            Map<String, Object> obj = cgshList.get(i);
            Long f_sum = (Long) obj.get("f_sum");
            if (null == obj.get("f_cgsh"))
                continue;
            String type = obj.get("f_cgsh").toString();
            cgshSum += f_sum;
            CommonNum cgsh = new CommonNum();
            cgsh.setName(this.getCgshByType(type));
            cgsh.setNum(f_sum);
            cgshResultList.add(cgsh);
        }
        for (int i = 0; i < cgshResultList.size(); i++) {
            Long num = cgshResultList.get(i).getNum();
            BigDecimal percent = BigDecimal.valueOf(num * 100).divide(BigDecimal.valueOf(cgshSum), 2, RoundingMode.DOWN);
            cgshResultList.get(i).setPercent(percent);
        }

        List<Wyjd> wyjdList = new ArrayList<>();
        this.processWyjd(yswfList, wyjdMap);

        Long wySum = 0l;
        for (int i = 0; i < wyList.size(); i++) {
            Map<String, Object> obj = wyList.get(i);
            Long f_sum = (Long) obj.get("f_sum");
            String code = (String) obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = wyjdMap.get(code);
            }
            wyjd.setNum5(f_sum);
            wyjdMap.put(code, wyjd);
            wySum += f_sum;
        }

        this.getPercent(wyjdMap, wyjdList);

        Long cyry = 0l;
        List<CommonNum> cyryList = this.getCyry2(seasons);
        for (int i = 0; i < cyryList.size(); i++) {
            cyry += cyryList.get(i).getNum();
        }

        Gztj gztj = new Gztj();
        gztj.setJctb(sum);
        gztj.setCyry(cyry);
        gztj.setWysl(wySum);
        gztj.setYtj(submitNum);
        gztj.setWtj(unSubmitNum);
        gztj.setWxf(unSend);
        gztj.setZp(zp);
        gztj.setSp(sp);
        gztj.setYp(yp);
        gztj.setWrj(wrj);
        gztj.setCgsh(cgshResultList);
        gztj.setWyjd(wyjdList);
        gztj.setQxcyry(cyryList);
        return gztj;
    }

    private void createWyjd(Map<String, Wyjd> wyjdMap, Integer status, Long f_sum, String code) {
        Wyjd wyjd = new Wyjd();
        if (wyjdMap.containsKey(code)) {
            wyjd = wyjdMap.get(code);
        }
        wyjd.setNum1(wyjd.getNum1() + f_sum);
        if (4 == status) {
            wyjd.setNum2(wyjd.getNum2() + f_sum);
        }
        wyjdMap.put(code, wyjd);
    }

    private void processWyjd(List<Map<String, Object>> yswfList, Map<String, Wyjd> wyjdMap) {
        for (int i = 0; i < yswfList.size(); i++) {
            Map<String, Object> obj = yswfList.get(i);
            Integer status = (Integer) obj.get("f_status");
            Long f_sum = (Long) obj.get("f_sum");
            String code = (String) obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = wyjdMap.get(code);
            }
            if (4 == status) {//已提交
                wyjd.setNum4(f_sum);
            } else {//未提交
                wyjd.setNum3(wyjd.getNum3() + f_sum);
            }
            wyjdMap.put(code, wyjd);
        }
    }

    private void getPercent(Map<String, Wyjd> wyjdMap, List<Wyjd> wyjdList) {
        for (Map.Entry<String, Wyjd> entry : wyjdMap.entrySet()) {
            String code = entry.getKey();
            Wyjd wyjd = entry.getValue();
            wyjd.setXzqdm(code);

            wyjd.setNum3(wyjd.getNum3() + wyjd.getNum4());
            BigDecimal num6;
            if (wyjd.getNum3() == 0) {
                num6 = new BigDecimal(100);
            } else {
                num6 = new BigDecimal(wyjd.getNum4() * 100).divide(new BigDecimal(wyjd.getNum3()), 2, RoundingMode.DOWN);
            }
            BigDecimal num7 = new BigDecimal(wyjd.getNum2() * 100).divide(new BigDecimal(wyjd.getNum1()), 2, RoundingMode.DOWN);
            wyjd.setNum6(num6);
            wyjd.setNum7(num7);
            wyjdList.add(wyjd);
        }
    }

    @Override
    public List<Map<String, Object>> getWyjd(String name) {
        List<TbtskObjectinfo > tableList = this.getTables(name);
        if (tableList.isEmpty()) {
            return null;
        }
        String queryFieldSql = " f_status,f_cgsh,f_yswf,f_xzqmc1 as f_xzqdm ";
        String sql = this.getTableSql(tableList, queryFieldSql, null);
        //图斑数、提交数、按行政区统计
        String submitSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ") t group by f_status, f_xzqdm";
        List<Map<String, Object>> submitList = this.jdbcTemplate.queryForList(submitSql);

        //疑似违法
        String yswfSql = "select count(*) as f_sum, f_status, f_xzqdm from (" + sql + ")t where f_yswf = '1' or f_yswf = '是' group by f_status, f_xzqdm";
        List<Map<String, Object>> yswfList = this.jdbcTemplate.queryForList(yswfSql);

        //外业数量
        String wysql = "";
        String signField = this.getSignField(tableList.get(0).getfTablename());
        for (int i = 0; i < tableList.size(); i++) {
            String tablename = tableList.get(i).getfTablename();
            wysql += " select count(*) as f_sum, f_xzqmc1 as f_xzqdm from " + tablename + " where " + signField +
                    " is not null and " + signField + " != '' GROUP BY f_xzqmc1";
            if (i != tableList.size() - 1) {
                wysql += " UNION ALL ";
            }
        }
        List<Map<String, Object>> wyList = this.jdbcTemplate.queryForList(wysql);

        Map<String, Wyjd> wyjdMap = new HashMap<>();
        for (int i = 0; i < submitList.size(); i++) {
            Map<String, Object> obj = submitList.get(i);
            Integer status = (Integer) obj.get("f_status");
            Long f_sum = (Long) obj.get("f_sum");
            String code = (String) obj.get("f_xzqdm");
            this.createWyjd(wyjdMap, status, f_sum, code);
        }

        List<Wyjd> wyjdList = new ArrayList<>();
        this.processWyjd(yswfList, wyjdMap);

        for (int i = 0; i < wyList.size(); i++) {
            Map<String, Object> obj = wyList.get(i);
            Long f_sum = (Long) obj.get("f_sum");
            String code = (String) obj.get("f_xzqdm");
            Wyjd wyjd = new Wyjd();
            if (wyjdMap.containsKey(code)) {
                wyjd = wyjdMap.get(code);
            }
            wyjd.setNum5(f_sum);
            wyjdMap.put(code, wyjd);
        }

        this.getPercent(wyjdMap, wyjdList);
        List<Map<String, Object>> result = new ArrayList<>();
        for (int i = 0; i < wyjdList.size(); i++) {
            Wyjd temp = wyjdList.get(i);
            Map<String, Object> obj = new HashMap<>();
            obj.put("xzqmc", temp.getXzqdm());
            obj.put("total", temp.getNum1());
            obj.put("assigncount", temp.getNum2());
            obj.put("yswfcount", temp.getNum3());
            obj.put("dwshccount", temp.getNum4());
            obj.put("wyhccount", temp.getNum5());
            obj.put("dwshcpercent", temp.getNum6());
            obj.put("zpercent", temp.getNum7());
            result.add(obj);
        }
        return result;
    }

    private String getTableSql(List<TbtskObjectinfo > list, String queryFieldSql, String xzqdms) {
        String datasql = "";
        for (int i = 0; i < list.size(); i++) {
            String tablename = list.get(i).getfTablename();
            datasql += " SELECT " + queryFieldSql + " FROM " + tablename;
            if (!StringUtils.isEmpty(xzqdms)) {
                datasql += " where f_xzqdm in (" + this.getINsql(xzqdms) + ")";
            }
            if (i != list.size() - 1) {
                datasql += " UNION ALL ";
            }
        }
        return datasql;
    }

    private List<TbtskObjectinfo > getTables(String name) {
        name = name + "%";
        return this.objectinfoRepository.getObjectbyName(name);
    }

    private List<TbtskObjectinfo > getTablesBySeasons(String seasons) {
        return this.objectinfoRepository.getListbyDesc(Arrays.asList(seasons.split(",")), BusiType.JDJC);
    }

    private List<Map<String, Object>> getBizAndTables(String name) {
        name = name + "%";
        String sql = "select t1.f_tablename,t2.f_id,t2.f_name from tbtsk_objectinfo t1, tbtsk_task_biz t2 where t1.f_id = t2.f_tableid and t2.f_name like '" + name + "' and t2.f_isdel is null";
//        if (!StringUtils.isEmpty(xzqmc)) {
//            xzqmc = "%" + xzqmc.substring(0, 2) + "%";
//            sql += " and t2.f_name like '" + xzqmc + "'";
//        }
        return this.jdbcTemplate.queryForList(sql);
    }

    private Long getCount(String sql) {
        String countSql = "select count(*) as num from (" + sql + ")t";
        Map<String, Object> countMap = this.jdbcTemplate.queryForMap(countSql);
        Long count = (Long) countMap.get("num");
        return count;
    }

    /**
     * 获取参与人员，多任务版本
     *
     * @return
     */
    private List<CommonNum> getCyry(String name) {
        name = name + "%";
        List<TskTaskBiz> list = this.tbTaskBizRepository.findLikeName(name);
        String sql = "";
        for (int i = 0; i < list.size(); i++) {
            String[] names = list.get(i).getName().split("-");
            if (names.length < 2)
                continue;
            String regionName = names[1];
            String bizid = list.get(i).getId();
            sql += " select * from (select count(distinct f_userid)::BIGINT as f_sum from tbsys_user_biz2 where f_bizid = '" + bizid +
                    "')t1, (select '" + regionName + "'::text as f_name)t2 ";
            if (i != list.size() - 1) {
                sql += " UNION ALL ";
            }
        }
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        List<CommonNum> resultList = new ArrayList<>();
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            Long num = (Long) obj.get("f_sum");
            String regionName = (String) obj.get("f_name");
            CommonNum commom = new CommonNum();
            commom.setName(regionName);
            commom.setNum(num);
            resultList.add(commom);
        }
        return resultList;
    }

    /**
     * 参与人员情况（前提是数据库中有对应用户），不做行政区划过滤
     * select t3.f_sum,t4.f_regioncode from (select count(*) as f_sum, f_organizationid from
     * (select DISTINCT f_userid from tbsys_user_biz2 where f_bizid = 'a8d7402a-47c5-428f-a0cc-d83c5876bd4e')t1,
     * uis_userorganization t2 where t1.f_userid = t2.f_userid GROUP BY t2.f_organizationid)t3, uis_organization t4 where t4.f_id = t3.f_organizationid;
     *
     * @param seasons
     * @return
     */
    private List<CommonNum> getCyry2(String seasons) {
        String sql = "select t3.f_sum,t4.f_regioncode from (select count(*) as f_sum, f_organizationid from " +
                "(select DISTINCT f_userid from tbsys_user_biz2 where f_bizid in (select f_id from tbtsk_task_biz where f_desc in (" +
                this.getINsql(seasons) + ") and f_busicode = '" + BusiType.JDJC +
                "'))t1, uis_userorganization t2 where t1.f_userid = t2.f_userid GROUP BY t2.f_organizationid)t3," +
                " uis_organization t4 where t4.f_id = t3.f_organizationid;";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        List<CommonNum> resultList = new ArrayList<>();
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            Long num = (Long) obj.get("f_sum");
            String regionName = (String) obj.get("f_regioncode");
            if ("500000".equals(regionName))
                continue;
            CommonNum commom = new CommonNum();
            commom.setName(regionName);
            commom.setNum(num);
            resultList.add(commom);
        }
        return resultList;
    }

    private String getSignField(String tablename) {
        String sql = "select f_fieldname from tbtsk_fields where f_tablename = '" + tablename + "' and f_fieldtype = '10';";
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        return (String) list.get(0).get("f_fieldname");
    }

    /**
     * 旧版（2020第2、3季度存储的是字典）
     *
     * @param key
     * @return
     */
    private String getCgshByType(String key) {
        switch (key) {
            case "1":
                return "核查信息完善";
            case "2":
                return "核查信息不完善";
            case "3":
                return "无核查信息";
            case "4":
                return "核心区非农村道路图斑未举证";
        }
        return key;
    }

    private String getINsql(String data) {
        String[] array = data.split(",");
        String result = "";
        for (int i = 0; i < array.length; i++) {
            result += "'" + array[i] + "'";
            if (i != array.length - 1) {
                result += ",";
            }
        }
        return result;
    }
}
