package com.geoway.landteam.landcloud.service.statistics.impl;

import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.model.statistics.dto.DlgqStatistics;
import com.geoway.landteam.landcloud.service.statistics.DlgqService;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * Created by licong on 2021/9/18.
 */
@Service
public class DlgqServiceImpl implements DlgqService {
    private final Integer TYPE1 = 1;//已提交图斑
    private final Integer TYPE2 = 2;//图斑总数
    private final Integer TYPE3 = 3;//照片数量
    private final Integer TYPE4 = 4;//参与人员数量

    @Value("${project.uploadDir}")
    protected String uploadDir;
    private GiLoger logger = GwLoger.getLoger(DlgqServiceImpl.class);

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public byte[] exportStatistics(String fileName) throws Exception {
        List<Map<String, Object>> tableList = this.getTable();
        String unionSql = this.unionSql(tableList);
        Map<String, DlgqStatistics> resultData = new HashMap<>();
        this.addZydw(resultData, tableList);
        this.sumTb(resultData, unionSql, this.TYPE1);
        this.sumTb(resultData, unionSql, this.TYPE2);
        this.sumMedia(resultData, unionSql);
        this.sumCyry(resultData, unionSql);
        List<Map<String, Object>> excelData = this.process(resultData);
        String col = "xzqmc,tb,tj,zp,cyry,zydw,percent";
        String colName = "区县名称,图斑个数,已提交（作业）图斑数,照片数,参与人员数量,作业单位,总进度（已提交图斑数/图斑个数）（%）";
        String sheetName = "统计表";
        String filePath = ExcelUtil.CreateExcel(excelData, this.uploadDir, fileName, col, colName, sheetName);
        byte[] fileByte= new byte[1024];
        fileByte = FileUtil.readFileByte(filePath);
        return fileByte;
    }

    /**
     * 获取有数据的表
     * @return
     */
    private List<Map<String, Object>> getTable(){
        String sql = "select t1.f_userid,t2.f_tablename from (" +
                "select f_tableid,f_userid from tbtsk_task_biz where f_busicode = 'DLGQJC' and f_isdel is null and f_total > 0 " +
                "  AND f_userid not in (SELECT u.f_userid||'' FROM tbsys_user u LEFT JOIN uis_userorganization uo on u.f_userid=uo.f_userid\n" +
                "LEFT JOIN uis_organization o on o.f_id=uo.f_organizationid\n" +
                "WHERE o.f_name ='重庆市规划和自然资源调查监测院'))t1," +
                " tbtsk_objectinfo t2 where t1.f_tableid = t2.f_id;";
        return this.jdbcTemplate.queryForList(sql);
    }

    /**
     * 初始化结果对象，添加创建任务用户id至作业单位数据
     * @param resultData
     * @param tableList
     */
    private void addZydw(Map<String, DlgqStatistics> resultData, List<Map<String, Object>> tableList){
        for (int i = 0; i < tableList.size(); i++) {
            Map<String, Object> obj = tableList.get(i);
            String userid = (String) obj.get("f_userid");
            String tableName = (String) obj.get("f_tablename");
            List<String> xzqmcList = this.getDictinctXzq(tableName);
            xzqmcList.forEach(item -> {
                DlgqStatistics statistics = null;
                if (resultData.containsKey(item)){
                    statistics = resultData.get(item);
                } else {
                    statistics = new DlgqStatistics(item);
                    resultData.put(item, statistics);
                }
                statistics.getZydw().add(userid);

            });
        }
    }

    /**
     * 数据表中包含行政区数据
     * @param tableName
     * @return
     */
    private List<String> getDictinctXzq(String tableName){
        String sql = "select distinct f_xzqmc1 from " + tableName + " where f_xzqmc1 not in ('重庆市(县)', '沿河土家族自治县', '武胜县', '利川市')";
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        List<String> result = new ArrayList<>();
        data.forEach(item -> {
            String xzqmc = (String) item.get("f_xzqmc1");
            result.add(xzqmc);
        });
        return result;
    }

    private String unionSql(List<Map<String, Object>> tableList) {
        String sql = "";
        for (int i = 0; i < tableList.size(); i++) {
            Map<String, Object> obj = tableList.get(i);
            String tableName = (String) obj.get("f_tablename");
            if (i != 0) {
                sql += " union all";
            }
            sql += " select f_id, f_status, f_xzqmc1, f_userid from " + tableName;
        }
        return sql;
    }

    /**
     * 图斑数量统计
     * @param resultData
     * @param unionSql
     * @param type
     */
    private void sumTb(Map<String, DlgqStatistics> resultData, String unionSql, Integer type){
        String sql = "select count(*) as f_count,f_xzqmc1 from (" + unionSql + ") t ";
        if (this.TYPE1 == type) {
            sql += " where f_status = '4' ";
        }
        sql += " GROUP BY f_xzqmc1";
        this.addData(resultData, sql, type);
    }

    /**
     * 照片统计
     * @param resultData
     * @param unionSql
     */
    private void sumMedia(Map<String, DlgqStatistics> resultData, String unionSql) {
        String sql ="";
        sql += "select count(t2.f_galleryid) as f_count,f_xzqmc1 from (select f_galleryid from tb_app_media where f_galleryid in(select t.f_id from (";
        sql += unionSql;
        sql += ") t where f_status = 4) and f_type = 1 )t2,(";
        sql += unionSql;
        sql += ")t3 where t2.f_galleryid = t3.f_id GROUP BY t3.f_xzqmc1";
        this.addData(resultData, sql, this.TYPE3);
    }

    /**
     * 参与人员
     * @param resultData
     * @param unionSql
     */
    private void sumCyry(Map<String, DlgqStatistics> resultData, String unionSql){
        String sql = "select count(distinct f_userid) as f_count,f_xzqmc1 from (" + unionSql + ") t GROUP BY f_xzqmc1";
        this.addData(resultData, sql, this.TYPE4);
    }

    private void addData(Map<String, DlgqStatistics> resultData, String sql, Integer type) {
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        dataList.forEach(item -> {
            String xzqmc = (String) item.get("f_xzqmc1");
            Long count = (Long) item.get("f_count");
            if (resultData.containsKey(xzqmc)) {
                DlgqStatistics obj = resultData.get(xzqmc);
                if (type == this.TYPE1) {
                    obj.setTj(obj.getTj() + Integer.valueOf(count.toString()));
                } else if (type == this.TYPE2){
                    obj.setTb(obj.getTb() + Integer.valueOf(count.toString()));
                } else if (type == this.TYPE3){
                    obj.setZp(obj.getZp() + Integer.valueOf(count.toString()));
                } else if (type == this.TYPE4){
                    obj.setCyry(obj.getCyry() + Integer.valueOf(count.toString()));
                }
            }
        });
    }

    private List<Map<String, Object>> process(Map<String, DlgqStatistics> resultData){
        List<Map<String, Object>> data = new ArrayList<>();
        resultData.forEach((key, value) -> {
            Map<String, Object> obj = new HashMap<>();
            obj.put("xzqmc", value.getXzqmc());
            obj.put("tb", value.getTb());
            obj.put("tj", value.getTj());
            obj.put("zp", value.getZp());
            obj.put("cyry", value.getCyry());
            obj.put("zydw", this.getZydw(value.getZydw()));
            obj.put("percent", new BigDecimal(value.getTj() * 100).divide(new BigDecimal(value.getTb()),2, RoundingMode.HALF_UP));
            data.add(obj);
        });
        return data;
    }

    private String getZydw(Set<String> userSet) {
        String insql = StringUtils.join(userSet, ",");
        insql = insql.replace(",","','");
        insql = "'" + insql + "'";
        String sql = "select distinct f_name from uis_organization where f_id in (select f_organizationid from uis_userorganization where f_userid in (" +
                insql + "));";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        Set<String> result = new HashSet<>();
        dataList.forEach(item -> {
            result.add((String) item.get("f_name"));
        });
        return StringUtils.join(result, ",");
    }
}
