package com.geoway.landteam.landcloud.service.statistics.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.dao.pub.ViewFxyjDao;
import com.geoway.landteam.landcloud.model.cffx.enm.WtTypeEnum;
import com.geoway.landteam.landcloud.model.cffx.enm.YjStateEnum;
import com.geoway.landteam.landcloud.model.statistics.dto.StaticFxyjYzb;
import com.geoway.landteam.landcloud.model.statistics.entity.StaticFxyjYjbb;
import com.geoway.landteam.landcloud.model.statistics.entity.StaticFxyjYjbb2;
import com.geoway.landteam.landcloud.model.statistics.entity.ViewFxyj;
import com.geoway.landteam.landcloud.repository.pub.StaticFxyjYjbb2Repository;
import com.geoway.landteam.landcloud.repository.pub.StaticFxyjYjbbRepository;
import com.geoway.landteam.landcloud.servface.statistics.StaticFxyjYjbbService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.jgroups.protocols.pbcast.STABLE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

/**
 * @author : tuowei
 * @date : 2023/11/8 11:10
 * @description : TODO
 */
@Service
public class StaticFxyjYjbbServiceImpl implements StaticFxyjYjbbService {

    @Autowired
    StaticFxyjYjbbRepository staticFxyjYjbbRepository;
    @Autowired
    StaticFxyjYjbb2Repository staticFxyjYjbb2Repository;
    @Autowired
    ViewFxyjDao viewFxyjDao;
    @Autowired
    RegionService regionService;
    @Autowired
    JdbcTemplate jdbcTemplate;

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Override
    public void batchSaveStaticFxyjYjbb(List<StaticFxyjYjbb> staticFxyjYjbbList) {
        staticFxyjYjbbRepository.saveAll(staticFxyjYjbbList);
    }

    @Override
    public void batchSaveStaticFxyjYjbb2(List<StaticFxyjYjbb2> staticFxyjYjbbList) {
        staticFxyjYjbb2Repository.saveAll(staticFxyjYjbbList);
    }

    @Override
    public void insertStatisticData() throws Exception {
        Calendar instance = Calendar.getInstance();
        String year = instance.get(Calendar.YEAR) + "";
        List<ViewFxyj> viewListByTime = viewFxyjDao.getViewListByTime(year + "01", year + "12");
        List<StaticFxyjYjbb> result = dealViewToStaticFxyjYjbb(viewListByTime);
        batchSaveStaticFxyjYjbb(result);
    }

    @Override
    public void insertNdtjStatisticData() throws Exception {
        Calendar instance = Calendar.getInstance();
        String year = instance.get(Calendar.YEAR) + "";
        List<ViewFxyj> viewListByTime = viewFxyjDao.getViewListByTime(year + "01", year + "12");
        List<StaticFxyjYjbb2> result = dealViewToStaticFxyjYjbb2(viewListByTime);
        batchSaveStaticFxyjYjbb2(result);
    }

    @Override
    public HashMap<String, Object> getGcpjStatistic(String year) {
        List<StaticFxyjYjbb> collect1 = getGcpjAndYjtxBb(year, "");
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            double sumScore = Double.valueOf(staticFxyjYjbb.getFSumscore());
            if(sumScore >= 74.5) {
                dfx ++;
            } else if(sumScore >= 52.8 && sumScore <= 65) {
                jdfx ++;
            } else if(sumScore >= 48.8 && sumScore <= 52.5) {
                zfx ++;
            } else if(sumScore >= 38.3 && sumScore < 44.8) {
                jgfx ++;
            } else if(sumScore <= 37.5){
                gfx ++;
            }
            i++;
            if(i <=8) {
                staticFxyjYjbb.setColor(YjStateEnum.lv.getCode());
            } else if(i <= 16) {
                staticFxyjYjbb.setColor(YjStateEnum.qing.getCode());
            } else if(i <= 24) {
                staticFxyjYjbb.setColor(YjStateEnum.huang.getCode());
            } else if(i <= 32) {
                staticFxyjYjbb.setColor(YjStateEnum.cheng.getCode());
            } else {
                staticFxyjYjbb.setColor(YjStateEnum.hong.getCode());
            }

        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("gfx",gfx);
        map.put("jgfx",jgfx);
        map.put("zfx",zfx);
        map.put("jdfx",jdfx);
        map.put("dfx",dfx);
        map.put("gcpjAndYjtxBbList",collect1);
        return map;
    }

    @Override
    public HashMap<String, Object>  getYjtxStatistic(String year) {
        List<StaticFxyjYjbb>  gcpjAndYjtxBbList = getGcpjAndYjtxBb(year, "2");
//        List<StaticFxyjYjbb> gcpjAndYjtxBbList = list.stream().sorted((o1, o2) -> {
//            if (Double.valueOf(o1.getFYj()) >= Double.valueOf(o2.getFYj())) {
//                return 1;
//            } else {
//                return -1;
//            }
//        }).collect(Collectors.toList());
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        int i = 0;
        List<Map<String, String>> qxfxqkList = new ArrayList<>();
        for (StaticFxyjYjbb staticFxyjYjbb : gcpjAndYjtxBbList) {
//            String fYj = staticFxyjYjbb.getFYj();
            int fYjtxPm = Integer.parseInt(staticFxyjYjbb.getFYjtxPm());
            String color = "";
            if(fYjtxPm <= 8) {
                color = "5";
                dfx ++;
            } else if(fYjtxPm <= 16) {
                color = "4";
                jdfx ++;
            } else if(fYjtxPm <= 24) {
                color = "3";
                zfx ++;
            } else if(fYjtxPm <= 32) {
                color = "2";
                jgfx ++;
            } else {
                color = "1";
                gfx ++;
            }
            Map<String, String> map = new HashMap<>();
            map.put("xzqdm", staticFxyjYjbb.getFXzqdm());
            map.put("xzqmc", staticFxyjYjbb.getFXzqmc());
            List<String> fxTypeList = new ArrayList<>();
//            String fZgPercent = calculatorFzgPercent(staticFxyjYjbb);
//            if(fYj.equals(staticFxyjYjbb.getFZddxyj())) {
//                fxTypeList.add("重大典型问题");
//            }
//            if(fYj.equals(staticFxyjYjbb.getFFnhyj())) {
//                fxTypeList.add("“非农化”问题");
//            }
//            if(fYj.equals(staticFxyjYjbb.getFYjjbntflhyj())) {
//                fxTypeList.add("永久基本农田“非粮化”问题");
//            }
//            map.put("yjsx", String.join(".", fxTypeList));
            map.put("yjsx", staticFxyjYjbb.getFYjtxYj());
            map.put("color", color);
            map.put("fzgPercent", staticFxyjYjbb.getFYjtxSumyzgpercent());
            qxfxqkList.add(map);
        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("gfx",gfx);
        map.put("jgfx",jgfx);
        map.put("zfx",zfx);
        map.put("jdfx",jdfx);
        map.put("dfx",dfx);
        map.put("qxfxqkList",qxfxqkList);
        return map;
    }

    @Override
    public HashMap<String, Object> getZBStatistic() {
       // List<String> regions = regionService.geCodeByCodeAndVersion(Arrays.asList("500100", "500200"),null);
        String regionSql = " select tr.f_xzqdm ,tr.f_xzqmc  from tb_region tr  where f_pcode in('500100','500200');";
        List<Map<String, Object>> regions = jdbcTemplate.queryForList(regionSql);
        JSONArray results = new JSONArray();
        for(Map<String, Object> region : regions){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("f_xzqdm",region.get("f_xzqdm").toString());
            jsonObject.put("f_xzqmc",region.get("f_xzqmc").toString());
            jsonObject.put("newTbmj",0);
            jsonObject.put("oldTbmj",0);
            jsonObject.put("rate",0);
            jsonObject.put("ypfjsx","");
            results.add(jsonObject);
        }
        //获取日期对应数据
        Date date = new Date();  // 获取当前时间的Date实例
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");  // 定义日期格式
        String year = sdf.format(date);  // 格式化日期
        String sql1 = "select f_xzqdm ,f_xzqmc ,SUBSTRING(f_xfsj,1,4) as f_xfsj,count(1),sum(f_tbmj) as f_tbmj from business_apps_zhjg.view_fxyj  group by f_xzqdm ,f_xzqmc ,SUBSTRING(f_xfsj,1,4) ";
        List<Map<String, Object>> map1s = jdbcTemplate.queryForList(sql1);
        for(Map<String, Object> map : map1s){
            String f_xzqdm = map.get("f_xzqdm").toString();
           // String f_xzqmc = map.get("f_xzqmc").toString();
            String f_xfsj = map.get("f_xfsj").toString();
            Double f_tbmj = Double.parseDouble(map.get("f_tbmj").toString());
            for (int i = 0; i < results.size(); i++) {
                JSONObject jsonObject = results.getJSONObject(i);
                String xzqdm = jsonObject.getString("f_xzqdm");
                if(xzqdm.equals(f_xzqdm)){
                   // jsonObject.put("f_xzqmc",f_xzqmc);
                    if(f_xfsj.equals(year)){
                        jsonObject.put("newTbmj",jsonObject.getDoubleValue("newTbmj") + f_tbmj);
                    }else{
                        jsonObject.put("oldTbmj",jsonObject.getDoubleValue("oldTbmj") + f_tbmj);
                    }
                    double number = (jsonObject.getDoubleValue("oldTbmj") - jsonObject.getDoubleValue("newTbmj"))/jsonObject.getDoubleValue("oldTbmj");
                    jsonObject.put("rate",number);
                }
            }
        }
        //获取
        String sql2 = "select f_ypfjsx,f_xzqdm,count(1) from business_apps_zhjg.view_fxyj  group by f_ypfjsx,f_xzqdm ";
        List<Map<String, Object>> map2s = jdbcTemplate.queryForList(sql2);
        for(Map<String, Object> map : map2s){
            if(map.get("f_ypfjsx") != null){
                String f_xzqdm = map.get("f_xzqdm").toString();
                String f_ypfjsx = map.get("f_ypfjsx").toString();
                String count = map.get("count").toString();
                for (int i = 0; i < results.size(); i++) {
                    JSONObject jsonObject = results.getJSONObject(i);
                    String xzqdm = jsonObject.getString("f_xzqdm");
                    if(xzqdm.equals(f_xzqdm)){
                        jsonObject.put("ypfjsx",StringUtils.isBlank(jsonObject.getString("ypfjsx"))? f_ypfjsx+"("+count+")": jsonObject.getString("ypfjsx")+"、"+f_ypfjsx+"("+count+")");
                    }
                }
            }
        }

        //计算区间指标统计
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        for (int i = 0; i < results.size(); i++) {
            JSONObject jsonObject = results.getJSONObject(i);
            Double rate = jsonObject.getDoubleValue("rate");
            if(rate >= 0.75){
                jgfx++;
                jsonObject.put("color","较高风险");
            }else if(0.75 < rate && rate <= 0.5){
                zfx++;
                jsonObject.put("color","中风险");
            }else if(0.5 < rate && rate <= 0.25){
                jdfx++;
                jsonObject.put("color","较低风险");
            }else if(0.25 < rate && rate <= 0){
                dfx++;
                jsonObject.put("color","低风险");
            }else{
                gfx++;
                jsonObject.put("color","高风险");
            }
         /*   // 创建DecimalFormat对象，指定百分比格式
            DecimalFormat decimalFormat = new DecimalFormat("0.00%");
            // 格式化数字并输出结果
            String formattedNumber = decimalFormat.format(rate);*/
            BigDecimal two11 = new BigDecimal(rate);
            double three11 = two11.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
            jsonObject.put("rate",three11);
        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("gfx",gfx);
        map.put("jgfx",jgfx);
        map.put("zfx",zfx);
        map.put("jdfx",jdfx);
        map.put("dfx",dfx);
        map.put("qjzbqkList",results);
        return map;
    }

    private String calculatorFzgPercent(StaticFxyjYjbb staticFxyjYjbb) {
        int A = Integer.parseInt(staticFxyjYjbb.getFFnhWfwgnum());
        double M1 = Double.parseDouble(staticFxyjYjbb.getFFnhwfwgmj());
        int B = Integer.parseInt(staticFxyjYjbb.getFYjjbntflhWfwgnum());
        double M2 = Double.parseDouble(staticFxyjYjbb.getFYjjbntflhwfwgmj());
        int C = Integer.parseInt(staticFxyjYjbb.getFFnhYzgnum());
        double M3 = Double.parseDouble(staticFxyjYjbb.getFFnhyzgmj());
        int D = Integer.parseInt(staticFxyjYjbb.getFYjjbntflhYzgnum());
        double M4 = Double.parseDouble(staticFxyjYjbb.getFYjjbntflhyzgmj());
        double fnhPercent = 0.0;
        double flhPercent = 0.0;
        if(A != 0) {
            fnhPercent = fnhPercent +  (C / A) * 0.3;
        }
        if(M1 != 0) {
            fnhPercent = fnhPercent + (M3 / M1) * 0.7;
        }

        if(B != 0) {
            flhPercent = flhPercent +  (D / B) * 0.3;
        }
        if(M2 != 0) {
            flhPercent = flhPercent + (M4 / M2) * 0.7;
        }
//        double fnhPercent = (C / A) * 0.3 + (M3 / M1) * 0.7;
//        double flhPercent = (D / B) * 0.3 + (M4 / M2) * 0.7;
        return new BigDecimal ((fnhPercent + flhPercent) / 2).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
    }

    @Override
    public HashMap<String, Object> getNdkhStatistic(String year) {
        List<StaticFxyjYjbb2> collect1 = getNdkhBb(year);
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            double sumScore = Double.valueOf(staticFxyjYjbb2.getFKhdf());
            if(sumScore >= 97.6) {
                dfx ++;
            } else if(sumScore >= 92.8 && sumScore <= 97.1) {
                jdfx ++;
            } else if(sumScore >= 90 && sumScore <= 92.6) {
                zfx ++;
            } else if(sumScore >= 83.7 && sumScore < 89.9) {
                jgfx ++;
            } else if(sumScore <= 83.4){
                gfx ++;
            }
            i ++;
            if(i <=8) {
                staticFxyjYjbb2.setColor(YjStateEnum.lv.getCode());
            } else if(i <= 16) {
                staticFxyjYjbb2.setColor(YjStateEnum.qing.getCode());
            } else if(i <= 24) {
                staticFxyjYjbb2.setColor(YjStateEnum.huang.getCode());
            } else if(i <= 32) {
                staticFxyjYjbb2.setColor(YjStateEnum.cheng.getCode());
            } else {
                staticFxyjYjbb2.setColor(YjStateEnum.hong.getCode());
            }
        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("gfx",gfx);
        map.put("jgfx",jgfx);
        map.put("zfx",zfx);
        map.put("jdfx",jdfx);
        map.put("dfx",dfx);
        map.put("ndkhBbList",collect1);
        return map;
    }


    @Override
    public HashMap<String, Object> getYBZStatistic(String year, boolean isContainSum) {
        List<StaticFxyjYzb> collect1 = getYbzBb(year, isContainSum);
        int gfx = 0;
        int jgfx = 0;
        int zfx = 0;
        int jdfx = 0;
        int dfx = 0;
        for (StaticFxyjYzb staticFxyjYjbb : collect1) {
            int i = staticFxyjYjbb.getPm();
            if(i == 0) {
                continue;
            }
            if(i <=8) {
                dfx ++;
                staticFxyjYjbb.setColor(YjStateEnum.lv.getCode());
            } else if(i <= 16) {
                jdfx ++;
                staticFxyjYjbb.setColor(YjStateEnum.qing.getCode());
            } else if(i <= 24) {
                zfx ++;
                staticFxyjYjbb.setColor(YjStateEnum.huang.getCode());
            } else if(i <= 32) {
                jgfx ++;
                staticFxyjYjbb.setColor(YjStateEnum.cheng.getCode());
            } else {
                gfx ++;
                staticFxyjYjbb.setColor(YjStateEnum.hong.getCode());
            }
        }
        HashMap<String, Object> map = new HashMap<>();
        map.put("gfx",gfx);
        map.put("jgfx",jgfx);
        map.put("zfx",zfx);
        map.put("jdfx",jdfx);
        map.put("dfx",dfx);
        map.put("ybzBbList",collect1);
        return map;
    }

    private List<StaticFxyjYzb> getYbzBb(String selectYear, boolean isContainSum) {
        Calendar instance = Calendar.getInstance();
        int year = instance.get(Calendar.YEAR);
        // 获取增量数据
        List<ViewFxyj> nowData = viewFxyjDao.getViewListByTime(year + "01", year + "12");
        Map<String, List<ViewFxyj>> nowXzqdmAndList = nowData.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        HashMap<String, StaticFxyjYzb> nowMap = new HashMap<>();
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : nowXzqdmAndList.entrySet()) {
            StaticFxyjYzb staticFxyjYzb = new StaticFxyjYzb();
            List<ViewFxyj> value = stringListEntry.getValue();
            List<ViewFxyj> collect = value.stream().filter(u -> "是".equals(u.getFSfwfwgwt())).collect(Collectors.toList());
            int size = collect.size();
            double sum = collect.stream().filter(u -> StringUtils.isNotBlank(u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzqdm(value.get(0).getFXzqdm());
            staticFxyjYzb.setXzqmc(value.get(0).getFXzqmc());
            staticFxyjYzb.setXzwtWtqkNum(size);
            staticFxyjYzb.setXzwtWtqkMj(new BigDecimal(sum).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            List<ViewFxyj> collect2 = value.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            int size2 = collect2.size();
            double sum2 = collect2.stream().filter(u -> StringUtils.isNotBlank(u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzwtWtzgNum(size2);
            staticFxyjYzb.setXzwtWtzgMj(new BigDecimal(sum2).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            nowMap.put(stringListEntry.getKey(), staticFxyjYzb);
        }


        // 获取存量数据 (默认时间为： 197001-去年年终)
        String hisStartTime = "197001";
        String hisEndTime = (year - 1) + "12";
        if(StringUtils.isNotBlank(selectYear)) {
            hisStartTime = selectYear + "01";
            hisEndTime = selectYear + "12";
        }
        List<ViewFxyj> historyData = viewFxyjDao.getViewListByTime(hisStartTime, hisEndTime);
        Map<String, List<ViewFxyj>> hisXzqdmAndList = historyData.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        HashMap<String, StaticFxyjYzb> hisMap = new HashMap<>();
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : hisXzqdmAndList.entrySet()) {
            StaticFxyjYzb staticFxyjYzb = new StaticFxyjYzb();
            List<ViewFxyj> value = stringListEntry.getValue();
            List<ViewFxyj> collect = value.stream().filter(u -> "是".equals(u.getFSfwfwgwt())).collect(Collectors.toList());
            int size = collect.size();
            double sum = collect.stream().filter(u -> StringUtils.isNotBlank(u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzqdm(value.get(0).getFXzqdm());
            staticFxyjYzb.setXzqmc(value.get(0).getFXzqmc());
            staticFxyjYzb.setXzwtWtqkNum(size);
            staticFxyjYzb.setXzwtWtqkMj(new BigDecimal(sum).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            List<ViewFxyj> collect2 = value.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            int size2 = collect2.size();
            double sum2 = collect2.stream().filter(u -> StringUtils.isNotBlank(u.getFGdmj())).mapToDouble(u -> Double.valueOf(u.getFGdmj())).sum();
            staticFxyjYzb.setXzwtWtzgNum(size2);
            staticFxyjYzb.setXzwtWtzgMj(new BigDecimal(sum2).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            hisMap.put(stringListEntry.getKey(), staticFxyjYzb);
        }
        List<StaticFxyjYzb> list = combineNowAndHis(nowMap, hisMap, isContainSum);
        for (StaticFxyjYzb staticFxyjYzb : list) {
            staticFxyjYzb.setXzwtWtzgPercent(staticFxyjYzb.getXzwtWtzgPercent() + "%");
            staticFxyjYzb.setClwtWtzgPercent(staticFxyjYzb.getClwtWtzgPercent() + "%");
            staticFxyjYzb.setPercent(staticFxyjYzb.getPercent() + "%");
        }
        return list;
    }

    private List<StaticFxyjYzb> combineNowAndHis(HashMap<String, StaticFxyjYzb> nowMap, HashMap<String, StaticFxyjYzb> hisMap, boolean isContainSum) {
        Set<String> all = nowMap.keySet();
        Set<String> his = hisMap.keySet();
        his.addAll(all);
        List<StaticFxyjYzb> list = new ArrayList<>();
        for (String s : his) {
            StaticFxyjYzb item = new StaticFxyjYzb();
            StaticFxyjYzb xzwt = nowMap.get(s);
            StaticFxyjYzb clwt = hisMap.get(s);
            if(xzwt != null) {
                item.setXzqdm(xzwt.getXzqdm());
                item.setXzqmc(xzwt.getXzqmc());
                item.setXzwtWtqkNum(xzwt.getXzwtWtqkNum());
                item.setXzwtWtqkMj(StringUtils.isNotBlank(xzwt.getXzwtWtqkMj()) ? xzwt.getXzwtWtqkMj() : "0.0");
                item.setXzwtWtzgNum(xzwt.getXzwtWtzgNum());
                item.setXzwtWtzgMj(StringUtils.isNotBlank(xzwt.getXzwtWtzgMj()) ? xzwt.getXzwtWtzgMj() : "0.0");
            } else {
                item.setXzwtWtqkMj("0.0");
                item.setXzwtWtzgMj("0.0");
            }
            if(clwt != null) {
                item.setXzqdm(clwt.getXzqdm());
                item.setXzqmc(clwt.getXzqmc());
                item.setClwtWtqkNum(clwt.getClwtWtqkNum());
                item.setClwtWtqkMj(StringUtils.isNotBlank(clwt.getClwtWtqkMj()) ? clwt.getClwtWtqkMj() : "0.0");
                item.setClwtWtzgNum(clwt.getClwtWtzgNum());
                item.setClwtWtzgMj(StringUtils.isNotBlank(clwt.getClwtWtzgMj()) ? clwt.getClwtWtzgMj() : "0.0");
            } else {
                item.setClwtWtqkMj("0.0");
                item.setClwtWtzgMj("0.0");
            }
            list.add(item);
        }
        if(isContainSum) {
            int xzNum = list.stream().mapToInt(u -> u.getXzwtWtqkNum()).sum();
            double xzMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getXzwtWtqkMj())).sum();
            int xzZgNum = list.stream().mapToInt(u -> u.getXzwtWtzgNum()).sum();
            double xzZgMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getXzwtWtzgMj())).sum();
            int clNum = list.stream().mapToInt(u -> u.getClwtWtqkNum()).sum();
            double clMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getClwtWtqkMj())).sum();
            int clZgNum = list.stream().mapToInt(u -> u.getClwtWtzgNum()).sum();
            double clZgMj = list.stream().mapToDouble(u -> Double.parseDouble(u.getClwtWtzgMj())).sum();
            StaticFxyjYzb item = new StaticFxyjYzb();
            item.setXzqdm("500000");
            item.setXzqmc("重庆市");
            item.setXzwtWtqkNum(xzNum);
            item.setXzwtWtqkMj(new BigDecimal(xzMj).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            item.setXzwtWtzgNum(xzZgNum);
            item.setXzwtWtzgMj(new BigDecimal(xzZgMj).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            item.setClwtWtqkNum(clNum);
            item.setClwtWtqkMj(new BigDecimal(clMj).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            item.setClwtWtzgNum(clZgNum);
            item.setClwtWtzgMj(new BigDecimal(clZgMj).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            list.add(item);
        }
        // 计算整改率
        list.forEach(u -> {
            // 问题整改率
            int F = u.getXzwtWtzgNum();
            int D = u.getXzwtWtqkNum();
            double G = Double.parseDouble(u.getXzwtWtzgMj());
            double E = Double.parseDouble(u.getXzwtWtqkMj());
            double H = 0;
            if(D == 0 || E == 0) {
                H = 1;
            } else {
                H = (F/D)*0.3+(G/E)*0.7;
            }
            u.setXzwtWtzgPercent(new BigDecimal(H * 100).setScale(2, BigDecimal.ROUND_HALF_UP).toString());

            int K = u.getClwtWtzgNum();
            int I = u.getClwtWtqkNum();
            double L = Double.parseDouble(u.getClwtWtzgMj());
            double J = Double.parseDouble(u.getClwtWtqkMj());
            double M = 0;
            if(I == 0 || J == 0) {
                M = 1;
            } else {
                M = (K/I)*0.3+(L/J)*0.7;
            }
            u.setClwtWtzgPercent(new BigDecimal(M * 100).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
            double percent = H * 0.5+ M * 0.5;
            u.setPercent(new BigDecimal(percent * 100).setScale(2, BigDecimal.ROUND_HALF_UP).toString());
        });

        // 升序排列
        List<StaticFxyjYzb> result = list.stream().sorted((o1, o2) -> {
            if (Double.parseDouble(o1.getPercent()) >=  Double.parseDouble(o2.getPercent())) {
                return 1;
            } else {
                return -1;
            }
        }).collect(Collectors.toList());
        if(isContainSum) {
            // 把重庆市放到第一个
            List<StaticFxyjYzb> collect = result.stream().filter(u -> !u.getXzqdm().equals("500000")).collect(Collectors.toList());
            StaticFxyjYzb cq = result.stream().filter(u -> u.getXzqdm().equals("500000")).collect(Collectors.toList()).get(0);
            collect.add(cq);
            Collections.reverse(collect);
            int i = 0;
            for (StaticFxyjYzb staticFxyjYzb : collect) {
                staticFxyjYzb.setPm(i);
                staticFxyjYzb.setXh(i + "");
                i ++;
            }
            return collect;
        }
        Collections.reverse(list);
        int i = 1;
        for (StaticFxyjYzb staticFxyjYzb : list) {
            staticFxyjYzb.setPm(i);
            staticFxyjYzb.setXh(i + "");
            i ++;
        }
        return list;
    }


    private List<StaticFxyjYjbb2> dealViewToStaticFxyjYjbb2(List<ViewFxyj> viewListByTime) {
        // 处理数据
        viewListByTime.stream().forEach(u -> {
            if(StringUtils.isBlank(u.getFGdmj())) {
                u.setFGdmj("0");
            }
            if(StringUtils.isBlank(u.getFYjjbntmj())) {
                u.setFYjjbntmj("0");
            }
        });
        Map<String, List<ViewFxyj>> collect = viewListByTime.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        List<StaticFxyjYjbb2> result = new ArrayList<>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : collect.entrySet()) {
            List<ViewFxyj> value = stringListEntry.getValue();
            StaticFxyjYjbb2 staticFxyjYjbb = new StaticFxyjYjbb2();
            // 发现问题-重大典型
            List<String> zdwt = WtTypeEnum.getCodeList("zddx");
            List<ViewFxyj> zdwtList = value.stream().filter(u -> zdwt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtZddxmj(String.valueOf(new BigDecimal(zdwtList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFFxwtZddxscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtZddxmj()) * 0.1).setScale(2, BigDecimal.ROUND_HALF_UP)));
            // 发现问题-违法违规
            List<String> wfwg = WtTypeEnum.getCodeList("fnh");
            List<ViewFxyj> wfwgList = value.stream().filter(u -> wfwg.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtWfwgmj(String.valueOf(new BigDecimal(wfwgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFFxwtWfwgscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtWfwgmj()) * 0.05).setScale(2, BigDecimal.ROUND_HALF_UP)));
            // 发现问题-耕地非粮化
            List<String> gdflh = WtTypeEnum.getCodeList("flh");
            List<ViewFxyj> gdflhList = value.stream().filter(u -> gdflh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            staticFxyjYjbb.setFFxwtGdflhmj(String.valueOf(new BigDecimal(gdflhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFFxwtGdflhscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtGdflhmj()) * 0.01).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double fxwtScore = Double.valueOf(staticFxyjYjbb.getFFxwtZddxscore()) +
                    Double.valueOf(staticFxyjYjbb.getFFxwtWfwgscore()) +  Double.valueOf(staticFxyjYjbb.getFFxwtGdflhscore());
            staticFxyjYjbb.setFFxwtScore(String.valueOf(new BigDecimal(fxwtScore).setScale(2, BigDecimal.ROUND_HALF_UP)));

            //  问题整改-重大典型
            List<ViewFxyj> zdwtYzgList = zdwtList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgZddxmj(String.valueOf(new BigDecimal(zdwtYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWtzgZddxscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFWtzgZddxmj()) * 0.08).setScale(2, BigDecimal.ROUND_HALF_UP)));
            //  问题整改-违法违规
            List<ViewFxyj> wfwgYzgList = wfwgList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgWfwgmj(String.valueOf(new BigDecimal(wfwgYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWtzgWfwgscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtWfwgmj()) * 0.04).setScale(2, BigDecimal.ROUND_HALF_UP)));
            //  问题整改-耕地非粮化
            List<ViewFxyj> gdflhYzgList = gdflhList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFWtzgGdflhmj(String.valueOf(new BigDecimal(gdflhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWtzgGdflhscore(String.valueOf(new BigDecimal(Double.valueOf(staticFxyjYjbb.getFFxwtGdflhmj()) * 0.008).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double wtzgScore = Double.valueOf(staticFxyjYjbb.getFWtzgZddxscore()) +
                    Double.valueOf(staticFxyjYjbb.getFWtzgWfwgscore()) + Double.valueOf(staticFxyjYjbb.getFWtzgGdflhscore());
            staticFxyjYjbb.setFWtzgScore(String.valueOf(new BigDecimal(wtzgScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            // 处理基本信息
            staticFxyjYjbb.setFId(UUID.randomUUID().toString());
            staticFxyjYjbb.setFXzqdm(stringListEntry.getKey());
            staticFxyjYjbb.setFXzqmc(value.get(0).getFXzqmc());
            double sumScore = 100 - fxwtScore + wtzgScore;
            staticFxyjYjbb.setFKhdf(String.valueOf(new BigDecimal(sumScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFCreatetime(timestamp);
            result.add(staticFxyjYjbb);
        }
        List<StaticFxyjYjbb2> collect1 = result.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFKhdf()) >= Double.valueOf(o2.getFKhdf())) {
                return -1;
            } else {
                return 1;
            }
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            i ++;
            staticFxyjYjbb2.setFPm(String.valueOf(i));
        }
        return collect1;
    }

    @Override
    public List<StaticFxyjYjbb> getGcpjAndYjtxBb(String year, String type) {
        String time = year + "-12-31 23:59:59";
        List<StaticFxyjYjbb> collect1 = null;
        List<StaticFxyjYjbb> staticFxyjYjbbs = staticFxyjYjbbRepository.queryRecentList(time);
        if("2".equals(type)) {
            collect1 = staticFxyjYjbbs.stream().sorted((o1, o2) -> {
                if (Double.valueOf(o1.getFYjtxPm()) >= Double.valueOf(o2.getFYjtxPm())) {
                    return 1;
                } else {
                    return -1;
                }
            }).collect(Collectors.toList());
        } else {
             collect1 = staticFxyjYjbbs.stream().sorted((o1, o2) -> {
                if (Double.valueOf(o1.getFSumscore()) >= Double.valueOf(o2.getFSumscore())) {
                    return -1;
                } else {
                    return 1;
                }
            }).collect(Collectors.toList());
        }
        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            i ++;
            staticFxyjYjbb.setXh(i + "");
        }
        return collect1;
    }

    @Override
    public List<StaticFxyjYjbb2> getNdkhBb(String year) {
        String time = year + "-12-31 23:59:59";
        List<StaticFxyjYjbb2> staticFxyjYjbbs = staticFxyjYjbb2Repository.queryRecentList(time);
        List<StaticFxyjYjbb2> collect1 = staticFxyjYjbbs.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFKhdf()) >= Double.valueOf(o2.getFKhdf())) {
                return -1;
            } else {
                return 1;
            }
        }).collect(Collectors.toList());
        int i = 0;
        for (StaticFxyjYjbb2 staticFxyjYjbb2 : collect1) {
            i++;
            staticFxyjYjbb2.setXh(i + "");

        }
        return collect1;
    }

    private List<StaticFxyjYjbb> dealViewToStaticFxyjYjbb(List<ViewFxyj> viewListByTime) throws Exception {
        // 处理数据
        viewListByTime.stream().forEach(u -> {
            if(StringUtils.isBlank(u.getFGdmj())) {
                u.setFGdmj("0");
            }
            if(StringUtils.isBlank(u.getFYjjbntmj())) {
                u.setFYjjbntmj("0");
            }
        });
        Map<String, List<ViewFxyj>> collect = viewListByTime.stream().collect(Collectors.groupingBy(ViewFxyj::getFXzqdm));
        List<StaticFxyjYjbb> result = new ArrayList<>();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        for (Map.Entry<String, List<ViewFxyj>> stringListEntry : collect.entrySet()) {
            List<ViewFxyj> value = stringListEntry.getValue();
            StaticFxyjYjbb staticFxyjYjbb = new StaticFxyjYjbb();
            // 处理基本信息
            staticFxyjYjbb.setFId(UUID.randomUUID().toString());
            staticFxyjYjbb.setFXzqdm(stringListEntry.getKey());
            staticFxyjYjbb.setFXzqmc(value.get(0).getFXzqmc());
            // 处理政区重大典型问题
            List<String> zdwt = WtTypeEnum.getCodeList("zddx");
            List<ViewFxyj> zdwtList = value.stream().filter(u -> zdwt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List<ViewFxyj> zdwtYzgList = zdwtList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFZddxnum(String.valueOf(zdwtList.size()));
            staticFxyjYjbb.setFZddxwfwgmj(String.valueOf(new BigDecimal(zdwtList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZddxyzgmj(String.valueOf(new BigDecimal(zdwtYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
//            staticFxyjYjbb.setFZddxyj(YjStateEnum.getYjCodeByMj("fnhmj", Double.valueOf(staticFxyjYjbb.getFZddxwfwgmj())));
            String zddxyj = zdwtList.size() > 0 ? YjStateEnum.hong.getCode() : YjStateEnum.lv.getCode();
            staticFxyjYjbb.setFZddxyj(zddxyj);
            // 处理非农化问题
            List<String> fnh = WtTypeEnum.getCodeList("fnh");
            List<ViewFxyj> fnhList = value.stream().filter(u -> fnh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List<ViewFxyj> fnhYzgList = fnhList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFFnhwfwgmj(String.valueOf(new BigDecimal(fnhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFFnhyzgmj(String.valueOf(new BigDecimal(fnhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFFnhyj(YjStateEnum.getYjCodeByMj("fnhmj", Double.valueOf(staticFxyjYjbb.getFFnhwfwgmj())));
            staticFxyjYjbb.setFFnhWfwgnum(fnhList.size() + "");
            staticFxyjYjbb.setFFnhYzgnum(fnhYzgList.size() + "");
            // 永久基本农田问题
            List<String> flh = WtTypeEnum.getCodeList("flh");
            List<ViewFxyj> flhList = value.stream().filter(u -> flh.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
            List<ViewFxyj> flhYzgList = flhList.stream().filter(u -> StringUtils.isNotBlank(u.getFZglsqk())).collect(Collectors.toList());
            staticFxyjYjbb.setFYjjbntflhwfwgmj(String.valueOf(new BigDecimal(flhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFYjjbntmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFYjjbntflhyzgmj(String.valueOf(new BigDecimal(flhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFYjjbntmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFYjjbntflhyj(YjStateEnum.getYjCodeByMj("yjjbntflhmj", Double.valueOf(staticFxyjYjbb.getFYjjbntflhwfwgmj())));
            staticFxyjYjbb.setFYjjbntflhWfwgnum(flhList.size() + "");
            staticFxyjYjbb.setFYjjbntflhYzgnum(flhYzgList.size() + "");
            // 源头治理评价
            double fnhScore = 25 - (Double.valueOf(staticFxyjYjbb.getFFnhwfwgmj()) * 0.05);
            double flhScore = 25 - (Double.valueOf(staticFxyjYjbb.getFYjjbntflhwfwgmj()) * 0.01);
            double fnhPercent = 0.0;
            if(fnhList.size() == 0) {
                fnhPercent = 0.0;
            } else {
                fnhPercent = fnhYzgList.size() * 1.0 / fnhList.size();
            }
            double flhPercent = 0.0;
            if(flhList.size() == 0) {
                flhPercent = 0.0;
            } else {
                flhPercent = flhYzgList.size() * 1.0 / flhList.size();
            }
            double fnhZgScore = 25 * fnhPercent;
            double flhZgScore = 25 * flhPercent;
            staticFxyjYjbb.setFYtzlpjfnh(String.valueOf(new BigDecimal(fnhScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFYtzlpjyjjbntflh(String.valueOf(new BigDecimal(flhScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfzgpjfnhpercent(String.valueOf(new BigDecimal(fnhPercent).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfzgpjyjjbntflhpercent(String.valueOf(new BigDecimal(flhPercent).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfzgpjfnhscore(String.valueOf(new BigDecimal(fnhZgScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfzgpjyjjbntflhscore(String.valueOf(new BigDecimal(flhZgScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double sumScore = Double.valueOf(staticFxyjYjbb.getFYtzlpjfnh()) + Double.valueOf(staticFxyjYjbb.getFYtzlpjyjjbntflh())
                     + Double.valueOf(staticFxyjYjbb.getFWfzgpjfnhscore()) + Double.valueOf(staticFxyjYjbb.getFWfzgpjyjjbntflhscore());
            staticFxyjYjbb.setFSumscore(String.valueOf(new BigDecimal(sumScore).setScale(2, BigDecimal.ROUND_HALF_UP)));
            String hightPriority = YjStateEnum.getHightPriority(YjStateEnum.getHightPriority(staticFxyjYjbb.getFZddxyj(), staticFxyjYjbb.getFFnhyj()), staticFxyjYjbb.getFYjjbntflhyj());
            staticFxyjYjbb.setFYj(hightPriority);
            staticFxyjYjbb.setFCreatetime(timestamp);
            // 预警提醒 ---------------------------------------------------
            int A = fnhList.size();
            double B = Double.parseDouble(staticFxyjYjbb.getFFnhwfwgmj());
            int C = flhList.size();
            double D = Double.parseDouble((new BigDecimal(flhList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)).toString());
            int I = fnhYzgList.size();
            double J = Double.parseDouble(staticFxyjYjbb.getFFnhyzgmj());
            int K = flhYzgList.size();
            double L = Double.parseDouble((new BigDecimal(flhYzgList.stream().mapToDouble(value1 -> Double.valueOf(value1.getFGdmj())).sum()).setScale(2, BigDecimal.ROUND_HALF_UP)).toString());
            staticFxyjYjbb.setFWfqkXzwtFnhnum(A + "");
            staticFxyjYjbb.setFWfqkXzwtFnhmj(String.valueOf(new BigDecimal(B).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfqkXzwtFlhnum(String.valueOf(new BigDecimal(C).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfqkXzwtFlhmj(String.valueOf(new BigDecimal(D).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtFnhnum(String.valueOf(new BigDecimal(I).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtFnhmj(String.valueOf(new BigDecimal(J).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtFlhnum(String.valueOf(new BigDecimal(K).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtFlhmj(String.valueOf(new BigDecimal(L).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfqkXzwtSumnum(String.valueOf(new BigDecimal((A + C)).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfqkXzwtSummj(String.valueOf(new BigDecimal((B + D)).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtSumnum(String.valueOf(new BigDecimal((I + K)).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFZgqkXzwtSummj(String.valueOf(new BigDecimal((J + L)).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double T = 0.0;
            if((A + C) != 0) {
                T = T + ((I+K)/(A+C))*0.3;
            }
            if((B+D) != 0) {
                T = T + ((J+L)/(B+D)*0.7);
            }
            staticFxyjYjbb.setFZgqkXzwtSumyzgpercent(String.valueOf(new BigDecimal(T).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double fnhyzgPercent = T;
            if(A != 0) {
                fnhyzgPercent = fnhyzgPercent + (I/A)*0.3;
            }
            if(B != 0) {
                fnhyzgPercent = fnhyzgPercent + (J/B)*0.7;
            }
            staticFxyjYjbb.setFZgqkXzwtFnhyzgpercent(String.valueOf(new BigDecimal(fnhyzgPercent).setScale(2, BigDecimal.ROUND_HALF_UP)));
            double flhyzgPercent = 0.0;
            if(C != 0) {
                flhyzgPercent = flhyzgPercent + (K/C)*0.3;
            }
            if(D != 0) {
                flhyzgPercent = flhyzgPercent + (L/D)*0.7;
            }
            staticFxyjYjbb.setFZgqkXzwtFlhyzgpercent(String.valueOf(new BigDecimal(flhyzgPercent).setScale(2, BigDecimal.ROUND_HALF_UP)));
            staticFxyjYjbb.setFWfqkXzwtFlhynmj(staticFxyjYjbb.getFYjjbntflhwfwgmj());
            int F = 0;
            staticFxyjYjbb.setFYjtxSumyzgpercent(String.valueOf(new BigDecimal((T*0.5+F*0.5)).setScale(2, BigDecimal.ROUND_HALF_UP)));
            String yjType = getYjType(value, staticFxyjYjbb);
            staticFxyjYjbb.setFYjtxYj(yjType);
            // xxx  非粮化永农 (用于计算预警提醒字段)
            result.add(staticFxyjYjbb);
        }
        List<StaticFxyjYjbb> collect1 = result.stream().sorted((o1, o2) -> {
            if (Double.valueOf(o1.getFYjtxSumyzgpercent()) >= Double.valueOf(o2.getFYjtxSumyzgpercent())) {
                return -1;
            } else {
                return 1;
            }
        }).collect(Collectors.toList());

        int i = 0;
        for (StaticFxyjYjbb staticFxyjYjbb : collect1) {
            i ++;
            staticFxyjYjbb.setFYjtxPm(i + "");
        }
        return collect1;
    }

    private String getYjType(List<ViewFxyj> value, StaticFxyjYjbb staticFxyjYjbb) {
        String str = "";
        List<String> gywt = WtTypeEnum.getCodeList("yjtxgywt");
        List<ViewFxyj> gywtList = value.stream().filter(u -> gywt.indexOf(u.getFWtlx()) != -1).collect(Collectors.toList());
        if(gywtList != null && gywtList.size() > 0) {
            str += "公园问题("+gywtList.size()+"),";
        }
        double fWfqkXzwtFnhmj = Double.parseDouble(staticFxyjYjbb.getFWfqkXzwtFnhmj());
        if(fWfqkXzwtFnhmj >= 100) {
            str += "“非农化”问题预警（"+fWfqkXzwtFnhmj+"亩）,";
        }
        double fWfqkXzwtFlhynmj = Double.parseDouble(staticFxyjYjbb.getFWfqkXzwtFlhynmj());
        if(fWfqkXzwtFlhynmj >= 350) {
            str += "“非粮化”问题预警（"+fWfqkXzwtFnhmj+"亩）,";
        }
        if(StringUtils.isNotBlank(str)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void main(String[] args) {
        String str = "公园问题,";
        if(StringUtils.isNotBlank(str)) {
            str = str.substring(0, str.length() - 1);
        }
        System.out.println("-----------------");
    }


    @Override
    public void downloadNdkhBbExcel(HttpServletResponse response, String year) throws Exception {
        List<StaticFxyjYjbb2> result = getNdkhBb(year);
        downloadGcpjAndYjtx(response, result, "五色图年度考核报表");
    }

    @Override
    public void downloadYBZBbExcel(HttpServletResponse response, String year) throws Exception {
//        List<StaticFxyjYjbb2> result = getNdkhBb(year);
//        downloadGcpjAndYjtx(response, result, "五色图年度考核报表");
        List<StaticFxyjYzb> ybzBb = getYbzBb(year, true);
        downloadYBZBb(response, ybzBb, "五色图一本账");
    }

    private String downloadYBZBb(HttpServletResponse response, List<StaticFxyjYzb> ybzBb, String fileName) throws Exception {
        StaticFxyjYzb cq = ybzBb.stream().filter(u -> u.getXzqdm().equals("500000")).collect(Collectors.toList()).get(0);
        List<StaticFxyjYzb> list = ybzBb.stream().filter(u -> !u.getXzqdm().equals("500000")).collect(Collectors.toList());


        ClassPathResource wst = new ClassPathResource("/static/excel/"+fileName+".xlsx");
        File wstFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile(wst.getInputStream(), wstFile);
        String srcFileName = wstFile.getAbsolutePath();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append(fileName+ System.currentTimeMillis()+ ".xlsx")
                .toString();
        try{
            // -------------------
            response.setContentType("application/vnd.ms-excel");
            DateFormat  df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String excelfileName = URLEncoder.encode(fileName + "_" + System.currentTimeMillis() , "utf-8");
            response.setHeader("Content-disposition" , "attachment;fileName=" + excelfileName + ".xls");
            OutputStream out = response.getOutputStream();
            // ----------------------------
            Map<String, Object> map = new HashMap<String, Object>();

            map.put("list",list);
            map.put("cqwtnum", cq.getXzwtWtqkNum());
            map.put("cqwtmj", cq.getXzwtWtqkMj());
            map.put("cqzgnum", cq.getXzwtWtzgNum());
            map.put("cqzgmj", cq.getXzwtWtzgMj());
            map.put("cqzgpercent", cq.getXzwtWtzgPercent());
            map.put("cqwtnum2", cq.getClwtWtqkNum());
            map.put("cqwtmj2", cq.getClwtWtqkMj());
            map.put("cqzgnum2", cq.getClwtWtzgNum());
            map.put("cqzgmj2", cq.getClwtWtzgMj());
            map.put("cqzgpercent2", cq.getClwtWtzgPercent());
            map.put("percent", cq.getPercent());
            TemplateExportParams params = new TemplateExportParams(srcFileName);
            params.setColForEach(true);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            workbook.write(out);
        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }

    @Override
    public void downloadGcpjAndYjtxBbExcel(HttpServletResponse response, String year, String type) throws Exception {
        List<StaticFxyjYjbb> result = getGcpjAndYjtxBb(year, type);
        if("2".equals(type)) {
            downloadGcpjAndYjtx(response, result, "五色图预警提醒报表");
        } else {
            for (StaticFxyjYjbb staticFxyjYjbb : result) {
                staticFxyjYjbb.setFYj(YjStateEnum.getByCode(staticFxyjYjbb.getFYj()).getDesc());
                staticFxyjYjbb.setFZddxyj(YjStateEnum.getByCode(staticFxyjYjbb.getFZddxyj()).getDesc());
                staticFxyjYjbb.setFFnhyj(YjStateEnum.getByCode(staticFxyjYjbb.getFFnhyj()).getDesc());
                staticFxyjYjbb.setFYjjbntflhyj(YjStateEnum.getByCode(staticFxyjYjbb.getFYjjbntflhyj()).getDesc());
            }
            downloadGcpjAndYjtx(response, result, "五色图过程评价报表");
        }
    }


    /**
     * 数据excel模板填充生成
     * @param
     */
    public <T> String downloadGcpjAndYjtx(HttpServletResponse response, List<T> staticFxyjYjbbList, String fileName) throws Exception {
        ClassPathResource wst = new ClassPathResource("/static/excel/"+fileName+".xlsx");
        File wstFile = File.createTempFile("template_STSONG_copy", ".xlsx");
        FileUtils.copyInputStreamToFile(wst.getInputStream(), wstFile);
        String srcFileName = wstFile.getAbsolutePath();

        String ouputPath=new StringBuilder()
                .append(uploadDir)
                .append(File.separator)
                .append("excel")
                .append(File.separator)
                .append(fileName+ System.currentTimeMillis()+ ".xlsx")
                .toString();
        try{
            // -------------------
            response.setContentType("application/vnd.ms-excel");
            DateFormat  df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String excelfileName = URLEncoder.encode(fileName + System.currentTimeMillis() , "utf-8");
            response.setHeader("Content-disposition" , "attachment;fileName=" + excelfileName + ".xls");
            OutputStream out = response.getOutputStream();
            // ----------------------------
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("list",staticFxyjYjbbList);
            TemplateExportParams params = new TemplateExportParams(srcFileName);
            Workbook workbook = ExcelExportUtil.exportExcel(params, map);
            workbook.write(out);
        }catch (Exception e){
            e.printStackTrace();
            throw new  Exception(e.getMessage());
        }

        return ouputPath;
    }
}
