package com.geoway.landteam.landcloud.service.suishoupai.impl;


import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.repository.base.AppBasicRepository;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.servface.base.AppBasicService;
import com.geoway.landteam.landcloud.servface.base.dto.AppBasicSimpleInfo;
import com.geoway.landteam.landcloud.servface.suishoupai.JctbService;

/**
 * 创建人: 张俊
 * 创建时间: 2022/6/23 11:44
 * 描述:
 */

@Service
public class JctbServiceImpl implements JctbService {

    @Resource
    AppBasicService appBasicService;

//    @Autowired
//    WorkGroupMemberRepository workGroupMemberRepository;

    @Resource
    Organization2UserRepository organization2UserDao;

    @Autowired
    AppBasicRepository appBasicDao;

//    @Resource
//    LandUserRoleinfoDao landUserRoleDao;

//    @Resource
//    WorkGroupMemberDao workGroupMemberDao;

    // 获取回收站的所有随手拍
    public Page<AppBasic> getMyDeletedList(String userIds, String page, String rows, String filterParam, String sortParam) {

        int start = Integer.valueOf(page) - 1;
        int limit = Integer.valueOf(rows);
        if (StringUtils.isEmpty(filterParam)) {
            filterParam = "";

        }
        if (StringUtils.isEmpty(sortParam)) {
            sortParam = "SORT_deleteTime_DESC";
        }
        filterParam = filterParam + ";Q_isDeleted_N_EQ=1;Q_userid_S_IN=" + userIds;
        Page<AppBasic> basics = appBasicService.getPageByFilter(filterParam, sortParam, start, limit);
        if (basics != null) {
            for (AppBasic basic : basics) {
                String gid = basic.getId();
                basic.setCurMedia(appBasicService.getFirstPhont(gid));
            }
        }
        return basics;
    }

    // 清空回收站
    @Transactional(rollbackFor = Exception.class)
    public int cleanRecycleBin(String userId) throws Exception {
        String sortParam = "SORT_deleteTime_DESC";
        String filterParam = "Q_isDeleted_N_EQ=1;Q_userid_S_IN=" + userId;
        Page<AppBasic> basics = appBasicService.getPageByFilter(filterParam, sortParam, 0, 1000);
        int count = 0;
        if (basics != null) {
            for (AppBasic appBasic : basics) {
                appBasicService.shiftDeleteByIds(appBasic.getId());
                count++;
            }
        }
        return count;
    }

    public Page<AppBasic> getWorkGroupAppBasics(Long userId, String workGroupId, int start, int limit) throws Exception {
        // 是否需要成员校验?
        String sortParam = "SORT_createtime_DESC";
        String filterParam = "Q_isDeleted_N_EQ=0;Q_userid_S_EQ=" + workGroupId;
        return appBasicService.getPageByFilter(filterParam, sortParam, start, limit);
    }


    // 删除工作组中的随手拍
    @Transactional(rollbackFor = Exception.class)
    public int deleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
        checkWorkGroupAdmin(userId, workGroupId);
        // 删除的数量
        return appBasicService.deleteByIds(ids);
    }

    // 恢复工作组中的随手拍
    @Transactional(rollbackFor = Exception.class)
    public int recoverInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
//        if (StringUtils.isEmpty(workGroupId)) {
//            String workGroupIds = StringUtils.join(workGroupMemberDao.queryGroupIdIManage(userId), ',');
//            checkWorkGroupsAdmin(userId, workGroupIds);
//        } else {
//            checkWorkGroupAdmin(userId, workGroupId);
//        }
        return appBasicService.recoverByIds(ids);
    }

    public int shiftDeleteInWorkGroup(Long userId, String workGroupId, String ids) throws Exception {
        checkWorkGroupAdmin(userId, workGroupId);
        return appBasicService.shiftDeleteByIds(ids);
    }

    @Transactional(rollbackFor = Exception.class)
    public int cleanWorkGroupRecycleBin(Long userId) throws Exception {
//        List<String> groupsList = workGroupMemberDao.queryGroupIdIManage(userId);
//        String groupsIds = StringUtils.join(groupsList, ",");
//        return cleanRecycleBin(groupsIds);
        throw new RuntimeException("该方法不做实现 ，应使用cleanWorkGroupRecycleBin(List<String> groupsList)  方法");
    }

    @Transactional(rollbackFor = Exception.class)
    public int cleanWorkGroupRecycleBin(List<String> groupsList) throws Exception {

        String groupsIds = StringUtils.join(groupsList, ",");
        return cleanRecycleBin(groupsIds);
    }

    // 获取工作组回收站的随手拍
    public Page<AppBasic> getWorkGroupDeletedList(Long userId, String page, String rows, String filterParam, String sortParam, String workGroupIds) throws Exception {
//        if (StringUtils.isEmpty(workGroupIds)) {
//            workGroupIds = StringUtils.join(workGroupMemberDao.queryGroupIdIManage(userId), ',');
//        } else {
////            checkWorkGroupsAdmin(userId, workGroupIds);
//        }
        return getMyDeletedList(workGroupIds, page, rows, filterParam, sortParam);
    }

    // 删除单位随手拍
    @Transactional(rollbackFor = Exception.class)
    public int deleteInOrganization(Long userId, String ids) throws Exception {
        checkIdsBelongOrg(userId, ids);
        // 校验用户是否为管理员
        checkLiaison(userId);
        return appBasicService.deleteByIds(ids);
    }

    // 获取单位回收站随手拍列表
    public Page<AppBasic> getOrgDeletedList(Long userId, int start, int limit, String filterParam, String sortParam, String organizationId) {
        // 校验用户是否为管理员
        checkLiaison(userId);
        // 完善单位id
        organizationId = completeOrgId(userId, organizationId);
        filterParam += "Q_isDeleted_N_EQ=1;Q_userid_S_EQ=" + organizationId;
        Page<AppBasic> appBasics = appBasicService.getPageByFilter(filterParam, sortParam, start, limit);
        for (AppBasic appBasic : appBasics) {
            appBasic.setCurMedia(appBasicService.getFirstPhont(appBasic.getId()));
        }
        return appBasics;
    }

    // 恢复单位随手拍
    public int recoverInOrg(Long userId, String ids) throws Exception {
        checkIdsBelongOrg(userId, ids);
        // 校验用户是否为管理员
        checkLiaison(userId);
        return appBasicService.recoverByIds(ids);
    }


    // 校验用户是否是工作组管理员
    protected void checkWorkGroupAdmin(Long userId, String workGroupId) throws Exception {
//        List<WorkGroupMember> list = workGroupMemberDao.getAdmin(workGroupId);
//        boolean flag = false;
//        for (WorkGroupMember member : list) {
//            if (userId.equals(member.getUserId())) {
//                flag = true;
//            }
//        }
//        if (!flag) {
//            throw new RuntimeException("不是工作组管理员");
//        }
    }

    protected void checkWorkGroupsAdmin(Long userId, String workGroupIds) throws Exception {
        String[] workGroups = workGroupIds.split(",");
        for (int i = 0; i < workGroups.length; i++) {
            checkWorkGroupAdmin(userId, workGroups[i]);
        }
    }

    // 校验随手拍是否都属于用户单位
    protected void checkIdsBelongOrg(Long userId, String ids) throws Exception {
        List<Organization2User> list = organization2UserDao.queryByUserId(userId);
        if (list.isEmpty()) {
            throw new RuntimeException("无单位");
        }
        // 单位id
        String organizationId = list.get(0).getOrganizationId();
        // 确认随手拍都属于此单位
        String[] idArr = ids.split(",");
        for (String id : idArr) {
            AppBasic appBasic = appBasicDao.findById(id).orElse(null);
            if (appBasic == null || !organizationId.equals(appBasic.getUserid())) {
                throw new RuntimeException("随手拍id有误");
            }
        }
    }


    public int cleanOrgRecycleBin(Long userId, String organizationId) throws Exception {
        // 校验用户是否为管理员
        checkLiaison(userId);
        // 完善单位id
        organizationId = completeOrgId(userId, organizationId);
        // 清空回收站, 上限1000条
        return cleanRecycleBin(organizationId);
    }

    public int recoverAllInOrg(Long userId, String organizationId) {
        // 校验用户是否为管理员
        checkLiaison(userId);
        // 完善单位id
        organizationId = completeOrgId(userId, organizationId);
        return appBasicDao.recoverAllInOrg(organizationId);
    }

    public int recoverAllInGroup(Long userId) {
//        List<String> workGroups = workGroupMemberDao.queryGroupIdIManage(userId);
//        return appBasicDao.recoverAllInGroup(workGroups);
        throw new RuntimeException("方法暂时未做实现");
    }


    // 若单位id不存在,默认取用户所在单位Id
    private String completeOrgId(Long userId, String organizationId) {
        if (StringUtils.isBlank(organizationId)) {
            List<Organization2User> list = organization2UserDao.queryByUserId(userId);
            if (list.isEmpty()) {
                throw new RuntimeException("用户无单位");
            }
            // 单位id
            return list.get(0).getOrganizationId();
        }
        return organizationId;
    }

    /**
     * 据百度翻译提示 Liaison 是联络人的意思
     *
     * @param userId
     */
    private void checkLiaison(Long userId) {
//        List<String> roleIds = landUserRoleDao.findRoleIdByUserId(userId);
//        if (!roleIds.contains("10020")) {
//            throw new RuntimeException("此操作需要管理员权限");
//        }
    }

    public void updateAppBasic(AppBasicSimpleInfo appBasicSimpleInfo) {
        String appBasicId = appBasicSimpleInfo.getId();
        if (StringUtils.isBlank(appBasicId)) {
            throw new RuntimeException("随手拍id有误");
        }
        AppBasic appBasic = appBasicDao.findById(appBasicId).orElse(null);
        // 拷贝属性, 忽略空值
        BeanUtil.copyProperties(appBasicSimpleInfo, appBasic, BeanUtil.getNullPropertyNames(appBasicSimpleInfo));
        // 更新修改时间
        appBasic.setTime(new Date());
        appBasicDao.save(appBasic);
    }
}
