package com.geoway.landteam.landcloud.service.sync;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
//import com.geoway.land.core.cloud.constants.RedisKeyConstants;
//import com.geoway.land.core.cloud.dao.*;
//import com.geoway.land.core.cloud.domain.*;
//import com.geoway.land.core.cloud.service.DefaultOssOperatorService;
//import com.geoway.land.core.cloud.service.ISysConfigAppDbService;
//import com.geoway.land.core.cloud.service.TskTaskBizService;
//import com.geoway.land.core.cloud.util.Zip4jUtils;
//import com.geoway.land.core.domain.EnumeratorDomain;
//import com.geoway.land.core.domain.EnumeratorValue;
//import com.geoway.land.core.domain.TbtskTaskBiz;
//import com.geoway.land.core.domain.TbtskUserManageArea;
//import com.geoway.land.core.service.EnumeratorDomainService;
//import com.geoway.land.core.service.EnumeratorValueService;
//import com.geoway.land.core.service.TbtskUserManageAreaService;
//import com.geoway.land.core.support.SqlliteConnTool;
//import com.geoway.land.multitask.dao.TbtskFieldsRepository;
//import com.geoway.land.multitask.dao.TskTaskBizRepository;
//import com.geoway.land.multitask.dao.UserBiz2Repository;
//import com.geoway.land.multitask.domain.TbtskFields;
//import com.geoway.land.multitask.domain.TbtskObjectinfo;
//import com.geoway.land.multitask.domain.TskTaskBiz;
//import com.geoway.land.multitask.domain.UserBiz2;
//import com.geoway.land.multitask.service.DataBizService;
//import com.geoway.land.multitask.service.TbtskObjectinfoService;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.repository.user.UserAreaRepository;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtThInfoRepository;
import com.geoway.landteam.landcloud.model.giht.constants.RedisKeyConstants;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtAssign;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtThInfo;
import com.geoway.landteam.landcloud.service.customtask.task.GjhtAssignService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
//import reactor.core.publisher.Flux;

import javax.annotation.Resource;
import java.io.*;
import java.net.*;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Service
public class SynchroService {

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Resource
    DataBizService dataBizService;

    @Autowired
    RedisTemplate redisTemplate;

//    @Autowired
//    TskTaskBizService tskTaskBizService;
    @Resource
    TbtskObjectinfoService tbtskObjectinfoService;

//    @Resource
//    UserBiz2Repository userBiz2Dao;

    @Resource
    TbtskFieldsRepository tbtskFieldsRepository;

    @Autowired
    UserAreaRepository userAreaDao;

    @Resource
    GjhtAssignService gjhtAssignService;

//    @Autowired
//    TbtskUserManageAreaService tbtskUserManageAreaService;
//    @Autowired
//    AppMediaRepository appMediaRepository;

//    @Resource
//    TskTaskBizRepository tskTaskBizRepository;
//    @Autowired
//    TbtskTaskBizRelationRepository tbtskTaskBizRelationDao;
//    @Autowired
//    EnumeratorValueService enumeratorValueService;
//    @Autowired
//    EnumeratorDomainService enumeratorDomainService;
//    @Autowired
//    ISysConfigAppDbService sysConfigAppDbService;

    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;
    @Autowired
    TbGjhtThInfoRepository tbGjhtThInfoRepository;

//    @Autowired
//    DefaultOssOperatorService defaultOssOperatorService;

//    @Value("#{imeSettings['project.uploadDir']}")
    @Value("${project.uploadDir}")
    String uploadDir;

//    @Value("#{imeSettings['gjck.url']}")
    @Value("${gjck.url}")
    protected String gjckUrl;

//    @Value("#{imeSettings['gjck.key']}")
    @Value("${gjck.key}")
    protected String gjckKey;

//    @Value("#{imeSettings['gjck.secret']}")
    @Value("${gjck.secret}")
    protected String gjckSecret;


    //公钥
//    @Value("${hbfzx.keyPublic}")
//    protected String keyPublic;

    //私钥
//    @Value("${hbfzx.keyPrivate}")
//    protected String keyPrivate;

    //证书Base64密文
//    @Value("${hbfzx.certCode}")
//    protected String certCode;

    //国土调查云提供服务地址
//    @Value("${hbfzx.gtUrl}")
//    protected String gtUrl;

    public void getDataSynchro(){
//        queryGjDatas();
    }

    public String getToken() throws Exception{
        String token="";
        try{
            if(redisTemplate.opsForValue().get(RedisKeyConstants.SYNC_TOKEN)!=null){
                token=redisTemplate.opsForValue().get(RedisKeyConstants.SYNC_TOKEN).toString();
                return token;
            }

            String url=gjckUrl+"/mdc/v1/auth/tokenByKey";
            JSONObject result = new JSONObject();
            HttpClient httpClient = HttpClientBuilder.create().build();

            HttpPost httpPost = new HttpPost();
            httpPost.setURI(URI.create(url));
            httpPost.setHeader("Content-Type","application/json");

            JSONObject param=new JSONObject();
            param.put("appKey",gjckKey);
            param.put("appSecret", gjckSecret);
            httpPost.setEntity(new StringEntity(JSONObject.toJSONString(param, SerializerFeature.WriteMapNullValue),"UTF-8"));

            HttpResponse response = httpClient.execute(httpPost);
            String httpEntityContent = getHttpEntityContent(response);
            result = JSONObject.parseObject(httpEntityContent);

            if (result.containsKey("status") && "true".equalsIgnoreCase(result.getString("status"))) {
                JSONObject resData=result.getJSONObject("data");
                String accessToken=resData.getString("accessToken");
                token=accessToken;
                // 成功之后 ，将requestid存储到redis中，过期后则会删除
                redisTemplate.opsForValue().set(RedisKeyConstants.SYNC_TOKEN, accessToken,50, TimeUnit.MINUTES);
            }else{
                System.out.println("获取token出错："+result.getString("msg"));
                throw new Exception("获取token出错："+result.getString("msg"));
            }
        }catch (Exception ex){
            System.out.println("获取token出错："+ex.getMessage());
            throw new Exception("获取token出错:"+ex.getMessage());
        }
        return token;
    }

   /* public void getGjNurl() throws Exception{
        HttpURLConnection httpURLConnection = null;

        String sql="select f_id,f_serverpath from tb_app_media where f_isdr=1 and f_serverpath like '%gtdcy-obs.obs.cn-north-1%' limit 5000";
        List<Map<String,Object>> results=jdbcTemplate.queryForList(sql);

        Long index=0l;
        for(Map<String,Object> result:results){
            index++;
            try{
                String lsId=result.get("f_id").toString();
                String servePath=result.get("f_serverpath").toString();

                String convertUrl=convertUrl(servePath);

                // 统一资源
                URL url = new URL(convertUrl);
                // 连接类的父类，抽象类
                URLConnection urlConnection = url.openConnection();
                // http的连接类
                httpURLConnection = (HttpURLConnection) urlConnection;
                //设置超时
                httpURLConnection.setConnectTimeout(1000 * 60*10);
                //设置请求方式，默认是GET
                httpURLConnection.setRequestMethod("GET");
                // 设置字符编码
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
                httpURLConnection.connect();
                // 文件大小
                int fileLength = httpURLConnection.getContentLength();
                // 控制台打印文件大小
                *//*  logger.info(String.format("%s", "您要下载的文件大小为:", fileLength / (1024 *1024) + "MB"));*//*
                // 建立链接从请求中获取数据
                URLConnection con = url.openConnection();
                File zipFile = null;
                File dir = new File(uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                zipFile = File.createTempFile("tmp", ".jpg", dir);
                FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);


                String obsFilePath = "media/gjImp/" + UUID.randomUUID() +".jpg";
                String fileUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, zipFile);

                sql="update tb_app_media set f_serverpath='"+fileUrl+"' where f_id='"+lsId+"'";
                jdbcTemplate.execute(sql);

                System.out.println("执行成功第"+index+"条，共"+results.size()+"条，成功url为："+fileUrl);
                zipFile.delete();
            }catch (Exception ex){
                System.out.println(ex.getMessage());
            }
        }
    }
*/

   /* public String convertUrl(String url) throws Exception{
        String token=getToken();
        String convertUrl="";

        JSONObject result = new JSONObject();
        HttpClient httpClient = HttpClientBuilder.create().build();

        String reqUrl=gjckUrl+"/mdc/v1/storage/signUrl?url="+url;

        HttpPost httpPost = new HttpPost();
        httpPost.setURI(URI.create(reqUrl));
        httpPost.setHeader("Content-Type","x-www-form-urlencoded");
        httpPost.setHeader("sysToken",token);

        HttpResponse response = httpClient.execute(httpPost);
        String httpEntityContent = getHttpEntityContent(response);
        result = JSONObject.parseObject(httpEntityContent);

        if (result.containsKey("status") && "true".equalsIgnoreCase(result.getString("status"))) {
            convertUrl=result.getString("data");
        }
        return convertUrl;
    }*/


    /**
     * 解析返回接口数据
     * @param response
     * @return
     * @throws Exception
     */
    public static String getHttpEntityContent(HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream is = entity.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String line = br.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            is.close();
            return sb.toString();
        }
        return "";
    }


    /*private void queryGjDatas(){
        try{
            String token=getToken();
            String version="0";

            List<String> rwIds=new ArrayList<>();
//            rwIds.add("WPZFTB");
            rwIds.add("WPZFDKTB");

            for(String bizId:rwIds){
//            if(redisTemplate.opsForValue().get(bizId)!=null){
//                version=redisTemplate.opsForValue().get(bizId).toString();
//            }

                String newVersion="";
                TskTaskBiz taskBiz=tskTaskBizService.findByTaskId(bizId);
                if(taskBiz==null){
                    //当任务为空时，则去拉取创建
                    taskBiz=getTaskStruct(bizId);
                }

                TbtskObjectinfo objectinfo=tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
                String tableName=objectinfo.getfTablename();
                List<TbtskFields> allFields=tbtskFieldsRepository.getTbtskFieldsByTableName(tableName);

                Integer pageNum=1;
                queryDatasByXzqdm(token,bizId,version,tableName,allFields,pageNum,newVersion);
            }
        }catch (Exception ex){
            System.out.println(ex.getMessage());
        }
    }*/

    private void queryDatasByXzqdm(String token, String bizId, String version, String tableName, List<TbtskFields> allFields, Integer pageNum, String newVersion){
        try{
            RestTemplate restTemplate = new RestTemplate();
            String url=gjckUrl+"/mdc/taskData/queryDataByRegion";

            JSONObject result = new JSONObject();
            HttpClient httpClient = HttpClientBuilder.create().build();

            HttpPost httpPost = new HttpPost();
            httpPost.setURI(URI.create(url));
            httpPost.setHeader("sysToken",token);
            httpPost.setHeader("Content-Type","application/json");

            JSONObject param=new JSONObject();
            param.put("bizId",bizId);
            param.put("xzqdm", "220000");
            param.put("pageNum", pageNum);
            param.put("pageSize", "50");
            param.put("version", version);
            httpPost.setEntity(new StringEntity(JSONObject.toJSONString(param, SerializerFeature.WriteMapNullValue),"UTF-8"));

            HttpResponse response = httpClient.execute(httpPost);
            String httpEntityContent = getHttpEntityContent(response);
            result = JSONObject.parseObject(httpEntityContent);


            if (result.containsKey("status") && "true".equalsIgnoreCase(result.getString("status"))) {
                if(pageNum==1){
                    newVersion= String.valueOf(System.currentTimeMillis());
                }

                JSONObject resData=result.getJSONObject("data");
                JSONArray fields=resData.getJSONArray("head");
                JSONArray insertDatas=resData.getJSONArray("body");
                Integer totalNum=resData.getInteger("total");


                //将数据插入库中
                for(int i=0;i<insertDatas.size();i++){
                    JSONArray items=insertDatas.getJSONArray(i);
                    Map insertItem=new HashMap<>();
                    for(int j=0;j<fields.size();j++){
                        String fieldName=fields.getJSONObject(j).getString("code");
                        boolean hasIt=false;
                        for(TbtskFields allField:allFields){
                            if(allField.getfFieldname().equalsIgnoreCase(fieldName)){
                                hasIt=true;
                                break;
                            }
                        }
                        if(hasIt){
                            insertItem.put(fieldName,items.get(j));
                        }
                    }
                    //首先从库里检测是否有，没有则新增
                    String whereSql=" f_id='"+insertItem.get("f_id").toString()+"' ";
                    if(dataBizService.getCount(tableName,whereSql)==0){
                        dataBizService.insertData(tableName,insertItem,"f_shape");
                    }
                }

                //当总数比当前获取数还大时，则继续请求
                if(insertDatas.size()>0&&totalNum>pageNum*50){
                    pageNum++;
                    queryDatasByXzqdm(token,bizId,version,tableName,allFields,pageNum,newVersion);
                }else{
                    // 成功之后 ，将版本号存储到redis中，过期后则会删除
                    redisTemplate.opsForValue().set(bizId, newVersion);
                }
            }else{
                throw new Exception("拉取国家数据出错："+result.getString("msg"));
            }

        }catch (Exception ex){
            System.out.println(ex.getMessage());
        }
    }

    /*public TskTaskBiz getTaskStruct(String bizId) throws Exception{
        String token=getToken();
        TskTaskBiz tskBiz=new TskTaskBiz();

        JSONObject result = new JSONObject();
        HttpClient httpClient = HttpClientBuilder.create().build();

        String url=gjckUrl+"/mdc/taskMeta/queryTaskStruct?bizId="+bizId;
        HttpGet httpGet = new HttpGet();
        httpGet.setURI(URI.create(url));
        httpGet.setHeader("sysToken",token);

        HttpResponse response = httpClient.execute(httpGet);
        String httpEntityContent = getHttpEntityContent(response);
        result = JSONObject.parseObject(httpEntityContent);

        if (result.containsKey("status") && "true".equalsIgnoreCase(result.getString("status"))) {
            String resStr=result.toJSONString();
            JSONObject resData=result.getJSONObject("data");
            tskBiz=addTask(resData,bizId,"164006","220000");
        }else{
            throw new Exception("获取任务结构出错："+result.getString("msg"));
        }
        return tskBiz;
    }*/

//    /**
//     * 创建任务
//     * @param dataDetails
//     * @param bizId
//     */
   /* public TskTaskBiz addTask( JSONObject dataDetails,String bizId,String createUserId,String area) throws Exception{
        String version = dataDetails.getString("version");

        JSONObject bizObj=dataDetails.getJSONObject("biz");
        TskTaskBiz tskBizOld =new TskTaskBiz();
        //构建任务结构
        if(bizObj!=null){
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

            String allowEdit = bizObj.getString("allowEdit");
            String allowNew = bizObj.getString("allowNew");
            String bizName = bizObj.getString("bizName");
            String configArgs = bizObj.getString("configArgs");
            String createTime = bizObj.getString("createTime");
            String endTime = bizObj.getString("endTime");
            String granularity = bizObj.getString("granularity");
            String isApprove = bizObj.getString("isApprove");
            String manualSubmit = bizObj.getString("manualSubmit");
            String matchRegion = bizObj.getString("matchRegion");
            String mode = bizObj.getString("mode");
            String needSign = bizObj.getString("needSign");
            String redoable = bizObj.getString("redoable");
            String regionVersion = bizObj.getString("regionVersion");
            String startTime = bizObj.getString("startTime");


            tskBizOld.setId(bizId);
            tskBizOld.setAllowEdit(allowEdit);
            tskBizOld.setAllowNew(allowNew);
            tskBizOld.setName(bizName);
            if(StringUtils.isNotBlank(createTime)){
                tskBizOld.setCreateTime(df.parse(createTime));
            }else{
                tskBizOld.setCreateTime(new Date());
            }
            tskBizOld.setConfigArgs(configArgs);
            if(StringUtils.isNotBlank(endTime)){
                tskBizOld.setEndTime(df.parse(endTime));
            }
            if(StringUtils.isNotBlank(granularity)){
                tskBizOld.setGranularity(Integer.valueOf(granularity));
            }
            if(StringUtils.isNotBlank(isApprove)){
                tskBizOld.setIsApprove(Integer.valueOf(isApprove));
            }
            if(StringUtils.isNotBlank(mode)){
                tskBizOld.setMode(Integer.valueOf(mode));
            }
            tskBizOld.setNeedSign(needSign);
            if(StringUtils.isNotBlank(redoable)){
                tskBizOld.setRedoAble(Integer.valueOf(redoable));
            }
            tskBizOld.setVersion("2018");
            if(StringUtils.isNotBlank(startTime)){
                tskBizOld.setStartTime(df.parse(startTime));
            }

            tskBizOld.setSource("国家平台");
            tskBizOld.setFinish(1);
            tskBizOld.setClassId(Long.valueOf(1));
            tskBizOld.setStatus("1");
            tskBizOld.setScope("智能管理");
            tskBizOld.setType("2");
            tskBizOld.setUserId(createUserId);
            tskBizOld.setIsPublic(0);

            tskBizOld=tskTaskBizRepository.save(tskBizOld);
        }

        //获取字段信息
        JSONArray fields = dataDetails.getJSONArray("field");
        String shpaField="f_shape";
        for(int i=0;i<fields.size();i++){
            Object meanObj=fields.getJSONObject(i).get("mean");
            if(meanObj!=null&&meanObj.toString().equalsIgnoreCase("shape")){
                shpaField=fields.getJSONObject(i).getString("name");
                break;
            }
        }

        //获取分组信息
        JSONArray groups =dataDetails.getJSONArray("group");

        TskTaskBiz tskBiz=new TskTaskBiz();
        BeanUtils.copyProperties(tskBizOld,tskBiz);
        tskBiz=tskTaskBizService.addOrUpdateTaskNew(tskBiz,fields,groups,version,area);

        //更新字典项值
        JSONArray dics =dataDetails.getJSONArray("dic");
        generateDics(dics);


        //进行任务结构的构建
        if(!tskTaskBizService.generateDb(tskBiz,createUserId)){
            System.out.println("生成任务结构失败！");
        }

        if(userBiz2Dao.findByBizId(tskBiz.getId()).size()==0){
            TbtskUserManageArea manageArea=new TbtskUserManageArea();
            manageArea.setTaskId(bizId);
            manageArea.setRegioncode(area);
            manageArea.setUserId(createUserId);
            manageArea.setLevel(Short.valueOf("1"));
            tbtskUserManageAreaService.insert(manageArea);


            //将用户id进行任务权限的赋值
            UserBiz2 ub2=new UserBiz2();
            ub2.setBizId(tskBiz.getId());
            ub2.setId(UUID.randomUUID().toString());
            ub2.setUserId(Long.valueOf(createUserId));
            ub2.setRole(0);
            userBiz2Dao.save(ub2);

            //任务的分组挂接
            TbtskTaskBizRelation tbtskTaskBizRelations=new TbtskTaskBizRelation();
            tbtskTaskBizRelations.setFId(UUID.randomUUID().toString());
            tbtskTaskBizRelations.setFTableid(tskBiz.getTableId());
            tbtskTaskBizRelations.setFTypecode("16");//固定写入上级任务中
            tbtskTaskBizRelations.setFTaskid(tskBiz.getId());
            tbtskTaskBizRelationDao.save(tbtskTaskBizRelations);
        }

        return tskBiz;
    }*/

    /*private void generateDics(JSONArray dicArray){
        try{
            for (int i = 0; i < dicArray.size(); i++) {
                JSONObject object = dicArray.getJSONObject(i);
                String dicno = object.getString("dicno");
                String dicName = object.getString("dicName");
                JSONArray value = object.getJSONArray("values");
                Long dicnoCode = null;
                //插入字典枚举值
                List<EnumeratorDomain> enumeratorDomains = new ArrayList<>();
                //插入字典值
                Long aLong = enumeratorValueService.queryDicnoByKey(dicno);
                if (aLong == null) {
                    dicnoCode =  jdbcTemplate.queryForObject("select nextval('seq_tbdm_enumeratorvalue_id')", Long .class);
                    EnumeratorValue bean = new EnumeratorValue();
                    bean.setDicno(dicnoCode);
                    bean.setDicname(dicName);
                    bean.setKey(dicno);
                    bean.setDiccodelen(0L);
                    bean.setDictype(0L);
                    bean.setDicdesc(dicName);
                    enumeratorValueService.save(bean);
                }else{
                    dicnoCode = aLong;
                }
                //删除字典枚举
                String insertSql="";
                enumeratorDomainService.deleteByDicno(dicnoCode);
                for (int j = 0; j < value.size(); j++) {
                    JSONObject jsonObject = value.getJSONObject(j);
                    EnumeratorDomain enumeratorDomain = new EnumeratorDomain();
                    Long curId =  jdbcTemplate.queryForObject("select nextval('tbdm_enumeratordomain_new_gid_seq')", Long .class);
                    String code=jsonObject.getString("code");
                    String name=jsonObject.getString("name");
                    Integer pid=jsonObject.getString("pid")!=null?Integer.valueOf(jsonObject.getString("pid")):null;
                    Integer order=jsonObject.getString("order")!=null?jsonObject.getInteger("order"):null;
                    insertSql="insert into tbdm_enumeratordomain values ("+curId+",'"+code+"','"+name+"','"+name+"',"+pid+","+order+","+dicnoCode+",1)";
                    jdbcTemplate.execute(insertSql);
                }
            }
            //更新字典db
            sysConfigAppDbService.insertDbUrl();
        }catch (Exception ex){
            System.out.println(ex.getMessage());
        }
    }*/


    //成果提报方法
    /*public void cgtbTask(String tbid) throws Exception{
        if(redisTemplate.opsForValue().get(tbid)==null){
            return;
        }
        String taskid=redisTemplate.opsForValue().get(tbid).toString();

        TskTaskBiz taskBiz=tskTaskBizService.findByTaskId(taskid);
        TbtskObjectinfo objectinfo=tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());

        String tableName=objectinfo.getfTablename();

        //查询记录
        String sql="select * from "+tableName+" where f_id='"+tbid+"'";
        Map<String,Object> result=jdbcTemplate.queryForMap(sql);
        String fid=result.get("f_id").toString();

        //获取所有的附件集合
        List<AppMedia> medias=appMediaRepository.queryByGid(fid);

        String xzqdm=result.get("f_xzqdm").toString();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


        String jtcbh=result.get("f_jctbbh").toString();
        String path=uploadDir + File.separator + jtcbh;
        File file = new File(path);

        if (!file.isDirectory()) {
            file.mkdirs();
        }

        //构建xml文件
        String xmlPath=path+File.separator+jtcbh+".xml";

        // 2.创建dom对象
        Document document = DocumentHelper.createDocument();

        // 3.添加节点，根据需求添加，这里我只是设置了一个head节点，下面有name和age两个子节点
        Element msg = document.addElement("Message");
        Element head = msg.addElement("Head");

        Element MsgID=head.addElement("MsgID");
        MsgID.setText(jtcbh);
        Element XZQDM=head.addElement("XZQDM");
        XZQDM.setText(xzqdm);
        Element CommitCode=head.addElement("CommitCode");
        CommitCode.setText("100");
        Element DigitalSign=head.addElement("DigitalSign");
        DigitalSign.setText("");
        Element DataTransTime=head.addElement("DataTransTime");
        DataTransTime.setText(df.format(new Date()));

        Element Data = msg.addElement("Data");
        Element ResultTBList = Data.addElement("ResultTBList");
        Element ResultTB = ResultTBList.addElement("ResultTB");
        ResultTB.setAttributeValue("JCBH",jtcbh);
        ResultTB.setAttributeValue("GeoDealType","0");
        ResultTB.setAttributeValue("XFSJ","2023");
        ResultTB.setAttributeValue("SF_SK","0");

        Element DKList = ResultTB.addElement("DKList");
        DKList.setAttributeValue("DKBH",jtcbh);
        Object jcmjObj=result.get("f_jcmj");
        if(jcmjObj!=null){
            DKList.setAttributeValue("DKMJ",jcmjObj.toString());
        }else{
            DKList.setAttributeValue("DKMJ","");
        }
        //农用地面积
        Object dknydObj=result.get("f_dlrdnydm");
        if(dknydObj!=null){
            DKList.setAttributeValue("NYDMJ",dknydObj.toString());
        }else{
            DKList.setAttributeValue("NYDMJ","");
        }
        //耕地面积
        Object gdObj=result.get("f_dlrdgdmj");
        if(gdObj!=null){
            DKList.setAttributeValue("GDMJ",gdObj.toString());
        }else{
            DKList.setAttributeValue("GDMJ","");
        }
        //水田面积
        Object stObj=result.get("f_wsxwp_n1");
        if(stObj!=null){
            DKList.setAttributeValue("STMJ",stObj.toString());
        }else{
            DKList.setAttributeValue("STMJ","");
        }
        //永久基本农田
        Object yjjbntObj=result.get("f_zyjjbntm");
        if(yjjbntObj!=null){
            DKList.setAttributeValue("YJ_JBNTMJ",yjjbntObj.toString());
        }else{
            DKList.setAttributeValue("YJ_JBNTMJ","");
        }
        //生态保护红线
        Object stbhhxObj=result.get("f_zstbhhxm");
        if(stbhhxObj!=null){
            DKList.setAttributeValue("STBHHXMJ",stbhhxObj.toString());
        }else{
            DKList.setAttributeValue("STBHHXMJ","");
        }
        //范围
        String wkt=result.get("f_shape").toString();
        DKList.setAttributeValue("Geometry",wkt);


        //构建地块属性集合
        Element ResultDKList = Data.addElement("ResultDKList");
        Element ResultDK = ResultDKList.addElement("ResultDK");
        Element DKAttributes = ResultDK.addElement("DKAttributes");
        DKAttributes.setAttributeValue("DKBH",jtcbh);
        Element DK_Unit = DKAttributes.addElement("DK_Unit");
        DK_Unit.setText("1");
        Element PDLX = DKAttributes.addElement("PDLX");
        PDLX.setText("1");
        Element DKMJ = DKAttributes.addElement("DKMJ");
        if(jcmjObj!=null){
            DKMJ.setText(jcmjObj.toString());
        }else{
            DKMJ.setText("");
        }
        Element NYDMJ = DKAttributes.addElement("NYDMJ");
        if(dknydObj!=null){
            NYDMJ.setText(dknydObj.toString());
        }else{
            NYDMJ.setText("");
        }
        Element GDMJ = DKAttributes.addElement("GDMJ");
        if(gdObj!=null){
            GDMJ.setText(gdObj.toString());
        }else{
            GDMJ.setText("");
        }
        Element YJ_JBNTMJ = DKAttributes.addElement("YJ_JBNTMJ");
        if(yjjbntObj!=null){
            YJ_JBNTMJ.setText(yjjbntObj.toString());
        }else{
            YJ_JBNTMJ.setText("");
        }
        Element STMJ = DKAttributes.addElement("STMJ");
        if(stObj!=null){
            STMJ.setText(stObj.toString());
        }else{
            STMJ.setText("");
        }
        Element STBHHXMJ = DKAttributes.addElement("STBHHXMJ");
        if(stbhhxObj!=null){
            STBHHXMJ.setText(stbhhxObj.toString());
        }else{
            STBHHXMJ.setText("");
        }
        Element Photo_Count = DKAttributes.addElement("Photo_Count");
        Photo_Count.setText(String.valueOf(medias.size()));
        Element ZMCL_Count = DKAttributes.addElement("ZMCL_Count");
        ZMCL_Count.setText("0");
        Element PW_Count = DKAttributes.addElement("PW_Count");
        PW_Count.setText("0");
        Element UpdateTime = DKAttributes.addElement("UpdateTime");
        Object commitTimeObj=result.get("f_committime");
        if(commitTimeObj!=null){
            UpdateTime.setText(String.valueOf(df.parse(commitTimeObj.toString())));
        }else{
            UpdateTime.setText("");
        }

        Element PDYJ = DKAttributes.addElement("PDYJ");
        PDYJ.setText("无");
        Element JSYDMJ = DKAttributes.addElement("JSYDMJ");
        JSYDMJ.setText("");
        Element WLYDMJ = DKAttributes.addElement("WLYDMJ");
        WLYDMJ.setText("");
        Element XZJD = DKAttributes.addElement("XZJD");  //乡镇街道
        XZJD.setText("");
        Element CUN = DKAttributes.addElement("CUN"); //村
        CUN.setText("");
        Element XXDZ = DKAttributes.addElement("XXDZ"); //详情地址
        XXDZ.setText("");
        Element HF_SJYT = DKAttributes.addElement("HF_SJYT"); //合法用地实际用途
        HF_SJYT.setText("");
        Element HF_JTQX = DKAttributes.addElement("HF_JTQX"); //合法具体情形
        HF_JTQX.setText("");
        Element QT_SJYT = DKAttributes.addElement("QT_SJYT"); //其他用地实际用途
        QT_SJYT.setText("");
        Element SF_LZGDJF = DKAttributes.addElement("SF_LZGDJF"); //是否新增乱占耕地建房
        SF_LZGDJF.setText("");
        Element SF_DPF = DKAttributes.addElement("SF_DPF"); //是否大棚房
        SF_DPF.setText("");
        Element WFQK_SJYT = DKAttributes.addElement("WFQK_SJYT"); //违法实际用途
        WFQK_SJYT.setText("");
        Element WFQK_SF_WHZJ = DKAttributes.addElement("WFQK_SF_WHZJ"); //是否挖湖造景
        WFQK_SF_WHZJ.setText("");
        Element WFQK_WFLX = DKAttributes.addElement("WFQK_WFLX"); //违法类型
        WFQK_WFLX.setText("");
        Element ZGLX = DKAttributes.addElement("ZGLX"); //整改落实情况
        ZGLX.setText("");
        Element YJQK_YJBM = DKAttributes.addElement("YJQK_YJBM"); //移交部门
        YJQK_YJBM.setText("");
        Element SHENG_PDLX = DKAttributes.addElement("SHENG_PDLX"); //省级定性的判定类型
        SHENG_PDLX.setText("");
        Element SHENG_PDYJ = DKAttributes.addElement("SHENG_PDYJ"); //省级定性的判定依据说明
        SHENG_PDYJ.setText("");
        Element SHENG_PDR = DKAttributes.addElement("SHENG_PDR"); //省级定性人姓名
        SHENG_PDR.setText("");
        Element SHENG_PDSJ = DKAttributes.addElement("SHENG_PDSJ"); //省级定性时间
        SHENG_PDSJ.setText("");
        Element SPD_WFLX = DKAttributes.addElement("SPD_WFLX"); //省级定性违法类型
        SPD_WFLX.setText("");
        Element SPD_SF_LZGDJF = DKAttributes.addElement("SPD_SF_LZGDJF"); //省级定性是否新增乱占耕地建房
        SPD_SF_LZGDJF.setText("");
        Element SPD_SF_WHZJ = DKAttributes.addElement("SPD_SF_WHZJ"); //省级定性是否挖湖造景
        SPD_SF_WHZJ.setText("");
        Element SPD_SF_DPF = DKAttributes.addElement("SPD_SF_DPF"); //省级定性是否大棚房
        SPD_SF_DPF.setText("");
        Element SPD_SF_JJXM = DKAttributes.addElement("SPD_SF_JJXM"); //省级定性是否“基金项目”
        SPD_SF_JJXM.setText("");
        Element SPD_SF_FZYQ = DKAttributes.addElement("SPD_SF_FZYQ"); //省级定性是否因防疫和防治重大疫情需要建设的医疗卫生设施
        SPD_SF_FZYQ.setText("");
        Element SPD_SF_BZXZF = DKAttributes.addElement("SPD_SF_BZXZF"); //省级定性是否保障性安居住房
        SPD_SF_BZXZF.setText("");
        Element SHI_PDLX = DKAttributes.addElement("SHI_PDLX"); //市级定性的判定类型
        SHI_PDLX.setText("");
        Element SHI_PDR = DKAttributes.addElement("SHI_PDR"); //市级定性人姓名
        SHI_PDR.setText("");
        Element SHI_PDSJ = DKAttributes.addElement("SHI_PDSJ"); //市级定性时间
        SHI_PDSJ.setText("");
        Element TBR = DKAttributes.addElement("TBR"); //填表人姓名
        TBR.setText("");
        Element TBSJ = DKAttributes.addElement("TBSJ"); //填表时间
        TBSJ.setText("");
        Element SHENG_SHJG = DKAttributes.addElement("SHENG_SHJG"); //省级审核结果
        SHENG_SHJG.setText("");
        Element SHENG_SHYJ = DKAttributes.addElement("SHENG_SHYJ"); //省级审核意见
        SHENG_SHYJ.setText("");
        Element SHENG_SHR = DKAttributes.addElement("SHENG_SHR"); //省级审核人姓名
        SHENG_SHR.setText("");
        Element SHENG_SHSJ = DKAttributes.addElement("SHENG_SHSJ"); //省级审核时间
        SHENG_SHSJ.setText("");
        Element SHI_SHJG = DKAttributes.addElement("SHI_SHJG"); //市级审核结果
        SHI_SHJG.setText("");
        Element SHI_SHYJ = DKAttributes.addElement("SHI_SHYJ"); //市级审核意见
        SHI_SHYJ.setText("");
        Element SHI_SHR = DKAttributes.addElement("SHI_SHR"); //市级审核人姓名
        SHI_SHR.setText("");
        Element SHI_SHSJ = DKAttributes.addElement("SHI_SHSJ"); //市级审核时间
        SHI_SHSJ.setText("");
        Element WFXW_BH = DKAttributes.addElement("WFXW_BH"); //违法行为编号
        WFXW_BH.setText("");
        Element XMLX = DKAttributes.addElement("XMLX"); //项目类型
        XMLX.setText("");
        Element XMMC = DKAttributes.addElement("XMMC"); //项目名称
        XMMC.setText("");
        Element XMZT = DKAttributes.addElement("XMZT"); //项目主体
        XMZT.setText("");
        Element LXPZJG = DKAttributes.addElement("LXPZJG"); //立项批准机关
        LXPZJG.setText("");
        Element LXPZWH = DKAttributes.addElement("LXPZWH"); //立项批准文号
        LXPZWH.setText("");
        Element SF_FZYQ = DKAttributes.addElement("SF_FZYQ"); //是否因防疫和防治重大疫情需要建设的医疗卫生设施
        SF_FZYQ.setText("");
        Element SF_BZXZF = DKAttributes.addElement("SF_BZXZF"); //是否保障性安居住房
        SF_BZXZF.setText("");
        Element SF_JJXM = DKAttributes.addElement("SF_JJXM"); //是否“基金项目”
        SF_JJXM.setText("");
        Element CLFS = DKAttributes.addElement("CLFS"); //处理方式
        CLFS.setText("");
        Element LABH = DKAttributes.addElement("LABH"); //立案编号
        LABH.setText("");
        Element SHENG_HCYJ = DKAttributes.addElement("SHENG_HCYJ"); //省外业核查意见
        SHENG_HCYJ.setText("");
        Element SHENG_HCR = DKAttributes.addElement("SHENG_HCR"); //省外业核查人
        SHENG_HCR.setText("");
        Element SHENG_HCSJ = DKAttributes.addElement("SHENG_HCSJ"); //省外业核查时间
        SHENG_HCSJ.setText("");
        Element CCFGS_SHYJ = DKAttributes.addElement("CCFGS_SHYJ"); //拆除复耕省内业审核意见
        CCFGS_SHYJ.setText("");
        Element CCFGS_SHR = DKAttributes.addElement("CCFGS_SHR"); //拆除复耕省内业审核人
        CCFGS_SHR.setText("");
        Element CCFGS_SHSJ = DKAttributes.addElement("CCFGS_SHSJ"); //拆除复耕省内业审核时间
        CCFGS_SHSJ.setText("");
        Element  CCFGS_HCYJ = DKAttributes.addElement("CCFGS_HCYJ"); //拆除复耕省外业核查意见
        CCFGS_HCYJ.setText("");
        Element  CCFGS_HCR = DKAttributes.addElement("CCFGS_HCR"); //拆除复耕省外业核查人
        CCFGS_HCR.setText("");
        Element  CCFGS_HCSJ = DKAttributes.addElement("CCFGS_HCSJ"); //拆除复耕省外业核查时间
        CCFGS_HCSJ.setText("");

        //批文属性信息
        Element PWList = ResultDK.addElement("PWList");
        Element  PW = PWList.addElement("PW"); //
        PW.setText("");



        // 4、格式化模板
        //OutputFormat format = OutputFormat.createCompactFormat();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");

        // 5、生成xml文件
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            XMLWriter writer = new XMLWriter(out, format);
            writer.write(document);
            writer.close();
        } catch (IOException e) {
            System.out.println("生成xml文件失败。文件名");
        }

        // 6、生成的XML文件
        // 7、利用文件输出流输出到文件， 文件输出到了您的项目根目录下了
        try (FileOutputStream fos = new FileOutputStream(xmlPath)) {
            fos.write(out.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }

    }*/


    //成果下载解析
    public void analysisTask(String assignUrl) throws Exception{
        HttpURLConnection httpURLConnection = null;
        TbGjhtAssign assign=tbGjhtAssignRepository.findLastUrl(assignUrl);
        if(assign.getSfcl()!=null&&assign.getSfcl()==1){
            System.out.println("当前记录最新内容已完成解析，无需再次操作！");
            return;
        }
        String xfUrl=assign.getUrl();
        String zipPsw=assign.getZip_pwd();

        URL url = new URL(xfUrl);
        // 连接类的父类，抽象类
        URLConnection urlConnection = url.openConnection();
        // http的连接类
        httpURLConnection = (HttpURLConnection) urlConnection;
        //设置超时
        httpURLConnection.setConnectTimeout(1000 * 60*10);
        //设置请求方式，默认是GET
        httpURLConnection.setRequestMethod("GET");
        // 设置字符编码
        httpURLConnection.setRequestProperty("Charset", "UTF-8");
        // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
        httpURLConnection.connect();

        // 建立链接从请求中获取数据
        File zipFile = null;
        File dir = new File(uploadDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        zipFile = File.createTempFile("tmp", ".zip", dir);
        FileUtils.copyInputStreamToFile(httpURLConnection.getInputStream(), zipFile);
        String zipName = zipFile.getAbsolutePath();
        String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
        Zip4jUtils.unzip(zipName, unzipFileDir, zipPsw);

        //获取所有的字段
        String sql="select * from tb_gjht_fieldmapping";
        List<Map<String,Object>> fieldMappings=jdbcTemplate.queryForList(sql);

        //进行db数据解析
        Integer num=analysisWpdb(unzipFileDir,fieldMappings,assign);
        assign.setSfcl(1);
        assign.setClsj(new Date());


        String errmsg="";
        Integer gjjg=0;
//        try{
//            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//            //回调国家接口进行信息反馈
//            System.out.println("开发获取token");
//
//            String token=getToken();
//            System.out.println("获取token正常："+token);
//
//            String gjurl=gjckUrl+"/mdc/v1/wpzf/feedBack";
//            JSONObject result = new JSONObject();
//            HttpClient httpClient = HttpClientBuilder.create().build();
//
//            HttpPost httpPost = new HttpPost();
//            httpPost.setURI(URI.create(gjurl));
//            httpPost.setHeader("Content-Type","application/json");
//            httpPost.setHeader("sysToken",token);
//
//            JSONObject param=new JSONObject();
//            param.put("xzqdm",assign.getXzqdm());
//            param.put("code", assign.getCode());
//            param.put("status", 1);
//            param.put("zgs", num);
////            param.put("jssj", df.format(new Date()));
//            param.put("rksj", df.format(new Date()));
//            httpPost.setEntity(new StringEntity(JSONObject.toJSONString(param, SerializerFeature.WriteMapNullValue),"UTF-8"));
//
//            HttpResponse response = httpClient.execute(httpPost);
//            String httpEntityContent = getHttpEntityContent(response);
//            result = JSONObject.parseObject(httpEntityContent);
//
//            if (result.containsKey("status") && "0".equalsIgnoreCase(result.getString("status"))) {
//                gjjg=1;
//                errmsg="成功";
//            }else{
//                errmsg="反馈国家接口出错："+result.getString("msg");
//                gjjg=2;
//            }
//            System.out.println(xfUrl+"反馈国家结果："+errmsg);
//        }catch (Exception ex){
//            System.out.println("调用国家接口报错了："+ex.getMessage());
//        }


        try {

            if(StringUtils.isBlank(gjhtAssignService.getKeyPublic()) || StringUtils.isBlank(gjhtAssignService.getKeyPrivate())
                    || StringUtils.isBlank(gjhtAssignService.getGtUrl()) ){
                System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
                return;
            }

            //创建 SM2
            SM2 sm2 = new SM2(gjhtAssignService.getKeyPrivate(), gjhtAssignService.getKeyPublic());
            //使用R|S裸格式，不使用ASN1(R|S)格式
            sm2.usePlainEncoding();
            //产生SM4随机密钥
            byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

            // 获取 平台身份认证Token
            String token = gjhtAssignService.getToken(sm2);
            if(StringUtils.isBlank(token)){
                return;
            }
            // 获取 数据加密秘钥密文
            String secret = gjhtAssignService.getSecret(sm2,sm4Key);
            if(StringUtils.isBlank(secret)){
                return;
            }

            Map<String,String> headerMap = new HashMap<>();
            headerMap.put("x-lc-secret",secret);
            headerMap.put("x-lc-token", token);

            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            StringBuilder dataBuilder = new StringBuilder();
            dataBuilder.append("\"code\"").append(":").append("\""+assign.getCode()+"\"");
            dataBuilder.append("\"regioncode\"").append(":").append("\""+assign.getXzqdm()+"\"");
            dataBuilder.append("\"hash\"").append(":").append("\""+assign.getMd5()+"\"");
            dataBuilder.append("\"count\"").append(":").append("\""+num+"\"");
            dataBuilder.append("\"entrytime\"").append(":").append("\""+df.format(new Date())+"\"");
            dataBuilder.append("\"status\"").append(":").append("1");
            dataBuilder.append("\"message\"").append(":").append("入库成功");

            String dataEncrypt = gjhtAssignService.getEncrypt(dataBuilder.toString(), sm4Key);
            //        《附录5 分中心业务数据协同标准》文档中 调用-数据订阅/更新
            cn.hutool.http.HttpResponse httpResponse = HttpUtil.createPost(gjhtAssignService.getGtUrl()+"/DataExchange/feedback").addHeaders(headerMap).body("{"+dataEncrypt+"}").execute();

            if(ObjectUtils.isEmpty(httpResponse)){
                return;
            }
            String result = httpResponse.body();
            String xLcSecret = httpResponse.header("x-lc-secret");
            // 返回调用的数据结果
            JSONObject resultJsonObject = JSONObject.parseObject(result);
            String rssultSecretData = "";

            if(ObjectUtils.isNotEmpty(resultJsonObject)){
                if(ObjectUtils.isNotEmpty(resultJsonObject.get("code")) && resultJsonObject.get("code").toString().equals("200")){
                    if(ObjectUtils.isNotEmpty(resultJsonObject.get("data"))){
                        rssultSecretData = resultJsonObject.get("data").toString();
                    }
                }
            }

            if(StringUtils.isNotBlank(xLcSecret) && StringUtils.isNotBlank(rssultSecretData)){
                //获取 数据解密。
                String data = gjhtAssignService.getDecrypt(sm2,rssultSecretData,xLcSecret);
                if(StringUtils.isNotBlank(xLcSecret)){
                    resultJsonObject.put("data","{"+data+"}");
                }
                System.out.println("data = " + data);
            }

        } catch (Exception e){
            e.printStackTrace();;

        }

        assign.setGjjg(gjjg);
        assign.setGjmsg(errmsg);
        assign.setGjsj(new Date());
        assign.setClgs(num);

        tbGjhtAssignRepository.save(assign);
    }

//    @Transactional
    public Integer analysisWpdb(String filePath,List<Map<String,Object>> fieldMappings,TbGjhtAssign assign) throws Exception{

        URL url = null;
        File file = null;
        file = new File(filePath);
        File[] content = file.listFiles();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".db")) {
                url = content[j].toURI().toURL();
                break;
            }
        }

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(url.toString());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;

        String sql = "select * from wpzftb";
        rs = statement.executeQuery(sql);
        String inserTableName="";

       Integer num=0;

       List<String> tbbsms=new ArrayList<>();

        while (rs.next()) {
            //分别检测各个字段值
            Map inserMap=new HashMap();
            String xzqdmVal="";
            for(Map<String,Object> fieldMapping:fieldMappings){
                String fieldName=fieldMapping.get("f_fieldname").toString();
                Object glField=fieldMapping.get("f_glfieldname");
                String fieldType=fieldMapping.get("f_fieldtype").toString();

                String glFieldName="";
                if(glField==null){
                    String glfieldid=fieldMapping.get("f_glfieldid").toString();
//                    TbtskFields curField=tbtskFieldsRepository.findOne(glfieldid);
//                    TbtskFields curField = tbtskFieldsRepository.getReferenceById(glfieldid);
                    TbtskFields curField = tbtskFieldsRepository.getOne(glfieldid);
                    glFieldName=curField.getfFieldname();
                    if(StringUtils.isBlank(inserTableName)){
                        inserTableName=curField.getfTablename();
                    }
                }else{
                    glFieldName=glField.toString();
                }

                Object valObj=null;
                try{
                    valObj=rs.getObject(fieldName);
                    if(fieldName.equalsIgnoreCase("tbbsm")){
                        if(tbbsms.indexOf(valObj.toString())<0){
                            tbbsms.add(valObj.toString());
                        }
                    }
                }catch (Exception ex){
                    continue;
                }

                if(valObj==null){
                    continue;
                }
                if(fieldType.equalsIgnoreCase("1")||fieldType.equalsIgnoreCase("2")){
                   inserMap.put(glFieldName,valObj.toString());
                }else if(fieldType.equalsIgnoreCase("3")||fieldType.equalsIgnoreCase("7")){
                    inserMap.put(glFieldName,Double.valueOf(valObj.toString()));
                }else if(fieldType.equalsIgnoreCase("9")){
                    inserMap.put(glFieldName,valObj.toString());
                }else if(fieldType.equalsIgnoreCase("8")){
                    inserMap.put(glFieldName,Integer.valueOf(valObj.toString()));
                }
                if(StringUtils.isBlank(xzqdmVal)&&fieldName.indexOf("xzqdm")>-1){
                    xzqdmVal=valObj.toString();
                }
            }
            if(inserMap.containsKey("f_shape") && inserMap.get("f_shape") != null && !inserMap.get("f_shape").toString().contains("SRID=4490")) {
                inserMap.put("f_shape", "SRID=4490;" + inserMap.get("f_shape"));
            }
            if(!inserMap.containsKey("f_createtime") || inserMap.get("f_createtime") != null) {
                Date date = new Date();
//                inserMap.put("f_createtime", date.getTime() / 1000);
                inserMap.put("f_createtime", date.getTime());
            }
            //根据tbbsm值获取库中是否有记录
            String tbbsm=inserMap.get("f_tbbh").toString();
            List<Map> items=dataBizService.queryDataBySql("select f_id from "+inserTableName+" where f_id='"+tbbsm+"'");

            inserMap.put("f_id",tbbsm);
            if(xzqdmVal.length()==6){
                xzqdmVal=xzqdmVal+"000000";
            }else if(xzqdmVal.length()==9){
                xzqdmVal=xzqdmVal+"000";
            }
            inserMap.put("f_xzqdmsys",xzqdmVal);
            inserMap.put("f_xzqdm",xzqdmVal.substring(0,6));

            if(items.size()==0){
                inserMap.put("f_status",1);
                dataBizService.insertData(inserTableName,inserMap,"f_shape");
            }else{
                dataBizService.updateData(inserTableName,inserMap," f_id='"+tbbsm+"'");
            }

            num++;
            System.out.println("当前包"+assign.getUrl()+",下发时间"+assign.getXfsj()+",共"+assign.getNum()+"条数据，已处理"+num+"条");
        }

        //查询图斑标识码下所有的关联套合记录
//        List<TbGjhtThInfo> thInfos=tbGjhtThInfoRepository.queryByTbbsms(tbbsms);

        //存储叠加信息表，首先检测表是否存在
        boolean djbExist=SqlliteConnTool.isTableExists(statement,"wpzftb_thpwinfo");
        if(djbExist){
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql = "select * from wpzftb_thpwinfo";
            rs = statement.executeQuery(sql);
            while (rs.next()) {
                String sign="";
                if(rs.getObject("sign")!=null){
                    sign=rs.getString("sign");
                }

                String tbbsm="";
                if(rs.getObject("tbbsm")!=null){
                    tbbsm=rs.getString("tbbsm");
                }

                String jcbh="";
                if(rs.getObject("jcbh")!=null){
                    jcbh=rs.getString("jcbh");
                }

                TbGjhtThInfo tbInfo=new TbGjhtThInfo();
                List<TbGjhtThInfo> items=tbGjhtThInfoRepository.queryByParams(tbbsm,jcbh,sign);
                if(items.size()>0){
                    tbInfo=items.get(0);
                }else{
                    tbInfo.setId(UUID.randomUUID().toString());
                    tbInfo.setTbbsm(tbbsm);
                    tbInfo.setJcbh(jcbh);
                }

                if(rs.getObject("tbbsm")!=null){
                    tbInfo.setTbbsm(rs.getString("tbbsm"));
                }
                if(rs.getObject("jcbh")!=null){
                    tbInfo.setJcbh(rs.getString("jcbh"));
                }
                if(rs.getObject("pzwh")!=null){
                    tbInfo.setPzwh(rs.getString("pzwh"));
                }
                if(rs.getObject("pzsj")!=null){
                    String pzsjStr=rs.getString("pzsj");
                    tbInfo.setPzsj(df.parse(pzsjStr));
                }
                if(rs.getObject("pzmj")!=null){
                    tbInfo.setPzmj(rs.getDouble("pzmj"));
                }
                if(rs.getObject("pznydmj")!=null){
                    tbInfo.setPznydmj(rs.getDouble("pznydmj"));
                }
                if(rs.getObject("pzgdmj")!=null){
                    tbInfo.setPzgdmj(rs.getDouble("pzgdmj"));
                }
                if(rs.getObject("pzyjjbntmj")!=null){
                    tbInfo.setPzyjjbntmj(rs.getDouble("pzyjjbntmj"));
                }
                if(rs.getObject("pwlx")!=null){
                    tbInfo.setPwejlx(rs.getString("pwlx"));
                }
                if(rs.getObject("pwejlx")!=null){
                    tbInfo.setPwejlx(rs.getString("pwejlx"));
                }
                if(rs.getObject("xmmc")!=null){
                    tbInfo.setXmmc(rs.getString("xmmc"));
                }
                if(rs.getObject("pzjsydmj")!=null){
                    tbInfo.setPzjsydmj(rs.getDouble("pzjsydmj"));
                }
                if(rs.getObject("pzwlymj")!=null){
                    tbInfo.setPzwlymj(rs.getDouble("pzwlymj"));
                }
                tbInfo.setSign(sign);
                tbGjhtThInfoRepository.save(tbInfo);
            }
        }
        // 关闭连接并删除缓存文件
        connPool.closeAll(connection,statement,rs);
        return num;
    }


}
