package com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.NjWwInteractionHandle;


import com.csvreader.CsvReader;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.BizAreaRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.constants.UpResultErrorEnum;
import com.geoway.landteam.customtask.task.entity.BizArea;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.sysinteraction.constant.SysInteractionTaskConstant;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionFieldMap;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysinteractionWwAnalyseMap;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionFieldMapRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionWwAnalyseMapRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionReceiveInterface;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.WKBReader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;


/*
 * @author   : lcw
 * @date     : 2022/7/7
 * @des      : 南京万维系统接收类实现
 **/
@Service
public class NjWwInteractionReceive implements InteractionReceiveInterface {

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    TbtskFieldsService tbtskFieldsService;

    @Autowired
    SysInteractionFieldMapRepository sysInteractionFieldMapRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    BizAreaRepository bizAreaRepository;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    DataBizService dataBizService;

    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;

    @Autowired
    SysInteractionWwAnalyseMapRepository sysInteractionWwAnalyseMapRepository;

    @Autowired
    RegionService regionService;

    private Boolean isAuthentication=false;

    public int allline=0; //统计总条数
    public int maxSql= 150; //每次发送sql，最大数据条数

    public int updateLine=0; //统计更新条数
    public int addLine=0;  //统计添加条数
    /*
     * @des      : 鉴定权限默认实现
     **/
    @Override
    public Boolean authentication() throws Exception {
        return isAuthentication;
    }

    /*
     * @des      : 接收推送过来的数据
     * @object   ： 信息对象，不同的任务代号可能不同，自己实现相关功能
     * @taskCode ： 任务代号
     **/
    @Override
    public Boolean handleReceiveData(Object object, String taskCode) throws Exception {
        if(taskCode.equals(SysInteractionTaskConstant.wwTaskHandleDataReceive)){
            TbSysInteractionRecord tbSysInteractionRecord =(TbSysInteractionRecord) object;
            return handleWwDataReceiveTask(tbSysInteractionRecord);
        }
        return false;
    }

    /*
     * @des      : 处理万维推送过来处理后的csv数据
     * @TbSysInteractionRecord ：
     **/
    public boolean handleWwDataReceiveTask(TbSysInteractionRecord tbSysInteractionRecord) throws Exception {
        this.allline=0; //统计总条数
        this.updateLine=0; //统计更新条数
        this.addLine=0;  //统计添加条数
        //获取任务信息
        TskTaskBiz tbtskTaskBiz=  tskTaskBizService.findByTaskId(tbSysInteractionRecord.getTaskid());
        //获取任务table信息
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tbtskTaskBiz.getTableId());
        //获取table表名
        String tableName = tbtskObjectinfo.getfTablename();
        //获取table字段信息
        List<TbtskFields> fields = tbtskFieldsService.getAllFieldsByTableID(tbtskTaskBiz.getTableId());
        //获取字段映射信息
        List<TbSysInteractionFieldMap>   tbSysInteractionFieldMaps=   sysInteractionFieldMapRepository.getSysInteractionFieldMapByTaskCode(tbSysInteractionRecord.getTaskcode());
        //获取可更新字段
        Map<String,Object> effectField=  getEffectField(fields,tbSysInteractionFieldMaps);

        List<BizArea> bizAreas = bizAreaRepository.findByBizId(tbtskTaskBiz.getId());
        Set<String> areaCodes = bizAreas.stream().map(BizArea::getArea).collect(Collectors.toSet());
        if (areaCodes.size() <= 0) {
            SysConfig xzqCode = sysConfigService.findOne("xzqCode");
            areaCodes.add(xzqCode.getValue());
        }

        // 第一参数：读取文件的路径 第二个参数：分隔符 第三个参数：字符集
        JSONObject cJson= JSONObject.parseObject(tbSysInteractionRecord.getContent());
        CsvReader csvReader = new CsvReader(cJson.getString("文件地址"), ',', Charset.forName("UTF-8"));

        // 这行不要是为了从表头的下一行读，也就是过滤表头
        csvReader.readHeaders();
        String[] headers=csvReader.getHeaders();
        Map<String,Integer> hIndex=new HashMap<>();
        for (int i=0;i<headers.length;i++){
            hIndex.put(headers[i],i);
        }

        int cline=0;
        Map<String,String[]> dataCache = new HashMap<>();
        String tbids="";
        // 读取每行的内容
        while (csvReader.readRecord()) {
            cline++;
            allline++;
            if(cline<maxSql){
                dataCache.put(csvReader.get("tbid"),csvReader.getValues());
                tbids+="'"+csvReader.get("tbid")+"',";
            }else {
                tbids = tbids.substring(0,tbids.length()-1);
                addOrUpdate(dataCache,tbids,tableName,hIndex,tbtskTaskBiz,tbtskObjectinfo,effectField,"101",fields,areaCodes);
                cline = 0;
                tbids="";
                dataCache.clear();
                System.gc();
            }
        }
        if(tbids.length()!=0){
            tbids = tbids.substring(0,tbids.length()-1);
        }
        if(dataCache.size()!=0){
            addOrUpdate(dataCache,tbids,tableName,hIndex,tbtskTaskBiz,tbtskObjectinfo,effectField,"101",fields,areaCodes);
        }
        tbSysInteractionRecord.setStatus(1);
        cJson.put("总图斑数",this.allline);
        cJson.put("更新图斑",this.updateLine);
        cJson.put("添加图斑",this.addLine);
        tbSysInteractionRecord.setContent(cJson.toString());
        tbSysInteractionRecord.setBackresult("导入数据成功！！");
        sysInteractionRecordRepository.save(tbSysInteractionRecord);
        tbtskTaskBiz.setAllCount(this.allline);
        tskTaskBizService.save(tbtskTaskBiz);
        return true;
    }
    public void addOrUpdate(Map<String,String[]> dataCache,String tbids,String tablename,Map<String,Integer> hIndex,TskTaskBiz tskTaskBiz, TbtskObjectinfo table,Map<String,Object> effectField, String userId, List<TbtskFields> allFields,Set<String> areaCodes) throws Exception {
        List<Map<String, Object>> addDataCacheList = new ArrayList<>();
        List<Map<String, Object>> updateDataCacheList = new ArrayList<>();
        //获取表格已存在的图斑id
        String filterSql=" SELECT array_to_string(array_agg(a.f_id),',') as existids FROM ( SELECT f_id , 1 AS group " +
                "   FROM  " + tablename +
                "   WHERE  f_id in (" + tbids +")" +
                "   ) a GROUP BY a.group;";
        String existids="";
        try{
            Map<String,Object> existidsMap=  jdbcTemplate.queryForMap(filterSql);
            existids=existidsMap.get("existids").toString();
        }catch (Exception e){

        }

        //查询万维数据tagListJson映射关系
        List<TbSysinteractionWwAnalyseMap> wwAnalyseMapList =  sysInteractionWwAnalyseMapRepository.getWwAnalyseFieldMapByTemplateid(tskTaskBiz.getTemplateId());

        Map<String,TbSysinteractionWwAnalyseMap> wwAnalyseMap = new HashMap<>();
        wwAnalyseMapList.stream().forEach(obj->{
            wwAnalyseMap.put(obj.getSupertag(),obj);
        });

        for (String key : dataCache.keySet()){
            if(existids.indexOf(key)!=-1){
                updateDataCacheList.add(getUpdateData(effectField,hIndex,table,allFields,dataCache.get(key),wwAnalyseMap));
            }else {
                addDataCacheList.add(getInsertData(hIndex,tskTaskBiz,  table,dataCache.get(key), effectField,userId, allFields,areaCodes,wwAnalyseMap));
            }
        }
        if(addDataCacheList.size()!=0){
            dataBizService.insertDatasBatch(tablename, addDataCacheList, "f_shape");
            this.addLine+=addDataCacheList.size();
        }
        if(updateDataCacheList.size()!=0){
            dataBizService.updateDataBatch(tablename,updateDataCacheList);
            this.updateLine+=updateDataCacheList.size();
        }

    }
    //获取有效字段
    public Map<String,Object> getEffectField(List<TbtskFields> fields,List<TbSysInteractionFieldMap>   tbSysInteractionFieldMaps){
        Map<String,Object>  effectFields=new HashMap<>();
        for (int i=0;i<tbSysInteractionFieldMaps.size();i++){
            TbSysInteractionFieldMap cTbSysInteractionFieldMap=tbSysInteractionFieldMaps.get(i);
            if(cTbSysInteractionFieldMap.getMapfield()==null||cTbSysInteractionFieldMap.getMapfield()==""){
                continue;
            }
            String[] cMapfield= cTbSysInteractionFieldMap.getMapfield().split(",");
            for(int j=0;j<cMapfield.length;j++){
                int finalJ = j;
                //是否与数据库字段匹配
                if(fields.stream().anyMatch(f->f.getfFieldname().equals(cMapfield[finalJ]))){
                    effectFields.put(cMapfield[finalJ],cTbSysInteractionFieldMap);
                }
            }
        }
        return effectFields;
    }

    public Map<String, Object>  getUpdateData(Map<String,Object> effectField,Map<String,Integer> hIndex,TbtskObjectinfo table,List<TbtskFields> allFields,String[] rows ,Map<String,TbSysinteractionWwAnalyseMap> wwAnalyseMap) throws Exception {
        HashMap<String, Object> map = new HashMap<>();
        String fieldName = "";
        String fieldType = "";
        String alias = "";

        //获取万维tagListJson字段信息
        Map<String,String> tagMap =getTagListJosnMap(rows, hIndex, wwAnalyseMap);
//        if(jsonArray.size()!=0){
//            jsonArray.forEach(json->{
//                JSONObject jsonObj = JSONObject.parseObject(json.toString());
//                TbSysinteractionWwAnalyseMap tbSysinteractionWwAnalyseMap= wwAnalyseMap.get(jsonObj.getString("superTag"));
//                if(tbSysinteractionWwAnalyseMap!=null){
//                    //type为1表示压占面积类分析
//                    if(tbSysinteractionWwAnalyseMap.getType().equals("1")){
//                        //tagType为0表示没有压盖面积
//                        if(jsonObj.getString("tagType").equals("0")){
//                            tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(),"0");
//                        }else {
//                            tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(),jsonObj.getString("areaTotal"));
//                        }
//                    }else if(tbSysinteractionWwAnalyseMap.getType().equals("2")){//type为2表示合法性类分析
//                        tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(),jsonObj.getString("tag"));
//                    }
//                }
//            });
//        }
        for (TbtskFields field : allFields) {
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType(fieldType);
            if (effectField.get(fieldName)!=null){
                TbSysInteractionFieldMap tbSysInteractionFieldMap= (TbSysInteractionFieldMap) effectField.get(fieldName);
                addDatatoMap(map,rows[hIndex.get(tbSysInteractionFieldMap.getField())], fieldType,fieldName, alias, field.getfNullable(), field.getfOrder(), null);
            }else if(tagMap.get(fieldName)!=null){
                addDatatoMap(map,tagMap.get(fieldName), fieldType,fieldName, alias, field.getfNullable(), field.getfOrder(), null);
            }

        }
        return map;
    }
    public Map<String, Object> getInsertData(Map<String,Integer> hIndex,TskTaskBiz tskTaskBiz, TbtskObjectinfo table,String[] rows , Map<String,Object> effectField, String userId, List<TbtskFields> allFields,Set<String> areaCodes,Map<String,TbSysinteractionWwAnalyseMap> wwAnalyseMap) throws Exception {
        HashMap<String, Object> map = new HashMap<>();
        List<String> fieldDefault = new ArrayList<>();
        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Integer outWork = -1;
        StringBuilder stringBuilder = new StringBuilder();
        String ismy = "f_ismy";
        //插入数据
        for (TbtskFields field : allFields) {
            if ("f_ismycreate".equals(field.getfFieldname())) {
                ismy = "f_ismycreate";
            }
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            String dValue=null ;
            try{
                dValue=JSONObject.parseObject(field.getfDefaultvalue()).getString("value");

            }catch (Exception e){

            }

            fieldType = TskTaskBizDBUtil.getDBType(fieldType);

            alias = field.getfAlias();
            outWork = field.getfIsOutwork();
            if (fieldName.equals("f_lat") || fieldName.equals("f_lon")) {
                continue;
            }

            if (fieldName.equals("f_lat_b") || fieldName.equals("f_lon_b")) {
                continue;
            }

            if (fieldName.equals("f_lat_g") || fieldName.equals("f_lon_g")) {
                continue;
            }

            if (fieldName.equals("f_shape1")) {
                continue;
            }
            if (table.getfTableversion() == 3 && field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue()
            )) {
                fieldDefault.add(fieldName);
            }
            map.put(fieldName, dValue);
            boolean isOut = (field.getfFieldInnerOuterSys() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD;

            Map<String,String> tagMap =getTagListJosnMap(rows, hIndex, wwAnalyseMap);

            if (effectField.get(fieldName)!=null){
                TbSysInteractionFieldMap tbSysInteractionFieldMap= (TbSysInteractionFieldMap) effectField.get(fieldName);
                addDatatoMap(map,rows[hIndex.get(tbSysInteractionFieldMap.getField())], fieldType,fieldName, alias, isOut ? 1 : field.getfNullable(), field.getfOrder(), dValue);
            }else if(tagMap.get(fieldName)!=null){
                addDatatoMap(map,tagMap.get(fieldName), fieldType,fieldName, alias, field.getfNullable(), field.getfOrder(), null);
            }else {
                addDatatoMap(map,null, fieldType,fieldName, alias, isOut ? 1 : field.getfNullable(), field.getfOrder(), dValue);
            }
        }
//        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_id",rows[hIndex.get("tbid")]);
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", userId);
        map.put("f_shape", map.get("f_shape"));
        map.put(ismy, "0");

        if (map.containsKey("f_xzqdm") && StringUtils.isNotBlank((String) map.get("f_xzqdm"))) {
            String xzqdm = (String) map.get("f_xzqdm");
            Map<String, Object> result = new HashMap<>();
            result.put("xzqdm", xzqdm);


            // 行政区范围不在任务定义的范围则不加入
//            if (!XzqdmUtil.xzqdmInAreaCodes(areaCodes, xzqdm)) {
//                result.put("xzqdm", xzqdm);
//                result.put("type", UpResultEnum.ERROR);
//                result.put("error", UpResultErrorEnum.NOT_IN_AREA);
//                // 错误信息记录
//                StringBuilder stringBuilder1 = new StringBuilder();
//                result.put("errorInfo", stringBuilder1.toString());
//                return result;
//            }
//            // 数据的xzqdm要和任务粒度需保持一致，不一致则不加入
//            if (tskTaskBiz.getGranularity() != null) {
//                String xzqdmCode = (String) map.get("f_xzqdm");
//                if ((tskTaskBiz.getGranularity() == 3 && xzqdmCode.length() != 6)
//                        || (tskTaskBiz.getGranularity() == 3 && xzqdmCode.length() == 6 && xzqdmCode.endsWith("00"))  //县级
//                        || (tskTaskBiz.getGranularity() == 4 && xzqdmCode.length() != 9) //乡镇级
//                        || (tskTaskBiz.getGranularity() == 5 && xzqdmCode.length() != 12)) { //村级
//                    Map<String, Object> result1 = new HashMap<>();
//                    result1.put("xzqdm", xzqdmCode);
//                    result1.put("type", UpResultEnum.ERROR);
//                    result1.put("error", UpResultErrorEnum.XZQDM__MISMATCH_TASKGRANULARITY);
//                    // 错误信息记录
//                    StringBuilder stringBuilder1 = new StringBuilder();
//                    result.put("errorInfo", stringBuilder1.toString());
//                    return result1;
//                }
//            }
            //Map area = dataBizService.selectByID("uis_region", "f_code", xzqdm);
            // todo xzqdm获取xzqmc，不再重复查询
          /*  String name = tskTaskBizService.getXzqmcByXzqdm(xzqdm);*//*regionService.getName(xzqdm);*/
            String name = regionService.getName(xzqdm);
            if (StringUtils.isNotBlank(name)) {
                map.put("f_xzqmc1", name);
                if (map.containsKey("f_xzqmc") && StringUtils.isEmpty((String) map.get("f_xzqmc"))) {
                    map.put("f_xzqmc", name);
                }
            }

            // 默认赋上村级政区代码
            List<TbtskFields> sysFields = allFields.stream().filter(t -> "f_xzqdmsys".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
            if (sysFields != null && sysFields.size() > 0) {
                map.put("f_xzqdmsys", xzqdm + "000000");//导入时默认赋值，导入完成后再通过图斑范围查询村级行政区代码
            }

            return map;
        } else {
            Map<String, Object> result = new HashMap<>();
            result.put("type", UpResultEnum.ERROR);
            result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
            return result;
        }
    }

    void addDatatoMap(Map map, String value, String fieldType, String fieldName, String rname,
                      Integer nullable, Integer order, String defaultValue) throws Exception {
        DecimalFormat format = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar":
                String value1 = value;
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    String tmp1 = value;
                    if (tmp1 == null  || "".equals(tmp1)) {
                        if (order != null && nullable == 0) {
                            throw new Exception(rname + "不能为空");
                        } else {
                            /*  map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Double.valueOf(defaultValue));*/
                            map.put(fieldName, defaultValue);
                        }
                    } else {
                        Double value2 = Double.valueOf(tmp1);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                String tmp2 = value;
                if (tmp2 == null  || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "不能为空");
                    } else {
                        /* map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Integer.valueOf(defaultValue));*/
                        map.put(fieldName, defaultValue);
                    }
                } else {
                    Integer value3 = Integer.valueOf(tmp2);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                String tmp3 = value;
                if (tmp3 == null  || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "不能为空");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    try {
                        DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = df.parse(tmp3);
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    } catch (java.text.ParseException e) {
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                        LocalDateTime localDateTime = LocalDateTime.parse(tmp3, df);
                        Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    }
                }
                break;
            case "text":
                String value2 = value;
                if (value2 == null || "null".equals(value2.toLowerCase()) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        throw new Exception(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "geometry":
                if(value!=null){
                    WKBReader reader = new WKBReader();
                    Geometry geo = reader.read(WKBReader.hexToBytes(value));
                    if ("f_shape".equalsIgnoreCase(fieldName)) {
                        if (geo == null) {
                            break;
                        } else {
                            map.put(fieldName, WKTUtil.geomToWkt(geo));
                            /*map.put("f_shape1", WKTUtil.geomToWkt(geo));*/
                            Point point = geo.getCentroid();
                            if (point != null) {
                                map.put("f_lat", format.format(point.getY()));
                                map.put("f_lon", format.format(point.getX()));
                            } else {
                                map.put("f_lat", "0.0");
                                map.put("f_lon", "0.0");
                            }
                        }

                } else if ("f_shape_g".equalsIgnoreCase(fieldName)) {
                    // google
                    /*Geometry geometry_g = convertGeometry(geo, 1);
                    map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                    Point point_g = geometry_g.getCentroid();
                    if (point_g != null) {
                        map.put("f_lat_g", format.format(point_g.getY()));
                        map.put("f_lon_g", format.format(point_g.getX()));
                    } else {
                        map.put("f_lat_g", "0.0");
                        map.put("f_lon_g", "0.0");
                    }*/
                } else if ("f_shape_b".equalsIgnoreCase(fieldName)) {
                    // baidu
                    /*Geometry geometry_b = convertGeometry(geo, 2);
                    map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                    Point point_b = geometry_b.getCentroid();
                    if (point_b != null) {
                        map.put("f_lat_b", format.format(point_b.getY()));
                        map.put("f_lon_b", format.format(point_b.getX()));
                    } else {
                        map.put("f_lat_b", "0.0");
                        map.put("f_lon_b", "0.0");
                    }*/
                }}
               else{
                  map.put(fieldName, value);
               }
                break;
            default:
                break;
        }
    }


    //生成更新sql模板
//    public String getUpdateSqlTem(Map<String,Object> effectField,String tablename){
//        String updateSql= "UPDATE "+tablename+" SET ";
//        for (String key : effectField.keySet()) {
//            TbSysInteractionFieldMap tbSysInteractionFieldMap = (TbSysInteractionFieldMap) effectField.get(key);
//            updateSql+=key+" = "+tbSysInteractionFieldMap.getField()+"_value,";
//        }
//        //除去最后一个”,“
//        updateSql = updateSql.substring(0,updateSql.length()-1);
//        updateSql+=" where f_id = 'f_id_value'";
//        return updateSql;
//    }

    //生成插入sql模板
//    public String getInsertSqlTem(Map<String,Object> effectField,String tablename){
//        String insertSql= "INSERT INTO "+tablename+" ";
//        String filedList="(";
//        String valueList="(";
//        for (String key : effectField.keySet()) {
//            TbSysInteractionFieldMap tbSysInteractionFieldMap = (TbSysInteractionFieldMap) effectField.get(key);
//            filedList+=("'"+key+"',");
//            valueList+=("'"+tbSysInteractionFieldMap.getField()+"_value',");
////            switch (tbSysInteractionFieldMap.getValuetype()){
////                case "varchar":{
////                    valueList+=("'"+tbSysInteractionFieldMap.getField()+"_value',");
////                }
////                case "number":{
////                    valueList+=tbSysInteractionFieldMap.getField()+"_value,";
////                }
////                case "shape":{
////                    valueList+=("'"+tbSysInteractionFieldMap.getField()+"_value',");
////                }
////            }
//        }
//        //除去最后一个”,“
//        filedList = filedList.substring(0,filedList.length()-1)+")";
//        valueList = valueList.substring(0,valueList.length()-1)+")";
//
//        insertSql+=filedList+" VALUES "+valueList;
//        return insertSql;
//    }

    //获取万维tagListJson字段，映射字段及映射值
    public Map<String,String> getTagListJosnMap(String[] rows,Map<String,Integer> hIndex,Map<String,TbSysinteractionWwAnalyseMap> wwAnalyseMap){
        String jsonStr = rows[hIndex.get("tagListJson")].replaceAll("\\|",",");
        JSONArray jsonArray = JSONArray.parseArray(jsonStr);
        Map<String,String> tagMap = new HashMap<>();
        if(jsonArray.size()!=0){
            jsonArray.forEach(json->{
                JSONObject jsonObj = JSONObject.parseObject(json.toString());
                TbSysinteractionWwAnalyseMap tbSysinteractionWwAnalyseMap= wwAnalyseMap.get(jsonObj.getString("superTag"));
                if(tbSysinteractionWwAnalyseMap!=null){
                        //tagType为0表示取areaTotal
                        if(jsonObj.getString("tagType").equals("0")){
                            tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(),jsonObj.getString("areaTotal"));
                        }else {
                            tagMap.put(tbSysinteractionWwAnalyseMap.getMapfield(),jsonObj.getString("tag"));
                        }

                }
            });
        }
        return tagMap;
    }

}
