package com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.NjWwInteractionHandle;


import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionSubmitInterface;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Map;


/*
 * @author   : lcw
 * @date     : 2022/7/7
 * @des      : 南京万维系统推送实现
 **/
@Service
public class NjWwInteractionSubmit implements InteractionSubmitInterface {

    private Boolean  hasAuthentication = true;

    private String token = null;
    /*
     * @des      : 获取推送权限方法默认实现
     **/
    @Override
    public Boolean getAuthentication() throws Exception {
        this.token="1";
        return hasAuthentication;
    }


    @Override
    public String sendDataWithAuthentication(String url, String type, Map<String,String> data) throws Exception {
        if(type.equals("post")){
           return  this.httppost(url,JSONObject.toJSONString(data));
        }

        if (type.equals("get")){
           return this.httpget(url);
        }

        return "目前仅支持post/get请求类型";
    }

    //http get请求封装，主要填冲鉴权信息
    public String httpget(String url) throws Exception {

        //判断是否拥有权限
//        if (!hasAuthentication){
//            this.getAuthentication();
//        }

        //填充鉴权信息
//        if(url.indexOf("&")!=-1){
//            url+=("&token="+this.token);
//        }else {
//            url+=("?token="+this.token);
//        }
        CloseableHttpClient client = null;
        HttpGet get = new HttpGet(url);

        client =  HttpClients.createDefault();
        HttpResponse response = null;
        response = client.execute(get);
        return IOUtils.toString(response.getEntity().getContent(), "utf-8");
    }

    //http post请求封装，主要填冲鉴权信息
    public  String httppost(String url, String requestParams) throws IOException {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        StringEntity postingString = new StringEntity(requestParams,
                "utf-8");
        postingString.setContentType("application/json");
        post.setEntity(postingString);
        client =  HttpClients.createDefault();
        HttpResponse response = null;
        response = client.execute(post);
        return IOUtils.toString(response.getEntity().getContent(), "utf-8");
    }
}
