package com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle;


import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.NjWwInteractionHandle.NjWwSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.NjYgInteractionHandle.NjYgSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.AbstractSysInteractionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * @author   : lcw
 * @date     : 2022/7/18
 * @des      : 系统交互工厂创造器/生成器类，传递系统代号获取相应工厂类
 **/

@Component
public class SysInteractionProducer {
        @Autowired
        NjYgSysInteractionFactory njYgSysInteractionFactory;
        @Autowired
        NjWwSysInteractionFactory njWwSysInteractionFactory;

        public AbstractSysInteractionFactory getFactory(String companyCode){
            //获取南京遥感系统交互工厂类
            if(companyCode.equalsIgnoreCase("NJYG")){
                return njYgSysInteractionFactory;
            }else if(companyCode.equalsIgnoreCase("NJWW")){//获取南京万维系统交互工厂类
                return njWwSysInteractionFactory;
            }
            throw new RuntimeException("未找到与"+companyCode+"系统交互工厂类");
        }
}

