package com.geoway.landteam.landcloud.service.sysinteraction;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.sysinteraction.constant.SysInteractionCompanyConstant;
import com.geoway.landteam.landcloud.model.sysinteraction.constant.SysInteractionTaskConstant;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbCompanyInteractionInfo;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.repository.sysinteraction.CompanyInteractionInfoRepository;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.AbstractSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionSubmitInterface;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
/*
 * @author   : lcw
 * @date     : 2022/7/18
 * @des      : 南京系统交互服务类
 **/

@Service
public class NjSysInteractionService {

    private String taskcode = SysInteractionTaskConstant.taskInfoCommit; //任务代码

    @Autowired
    CompanyInteractionInfoRepository companyInteractionInfoRepository;

    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;

    @Autowired
    SysInteractionProducer sysInteractionProducer;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    /**
     * 可缓存的线程池
     */
    private ExecutorService executor = Executors.newCachedThreadPool();

    //采用后台线程运行推送任务，不影响主线程运行
    public String sendTaskWithBack(final TskTaskBiz tskTaskBiz, final Boolean isCreate, final String businame, String pm, final String mediaConfig){

        // 启动线程进行数据构建
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                sendTaskInfo(tskTaskBiz,isCreate,businame,pm,mediaConfig);
            }
        });
        //触发：thread
        executor.execute(thread);
        return "开始推送信息";
    }


    //推送任务信息
    public void sendTaskInfo(TskTaskBiz tskTaskBiz, Boolean isCreate,String businame,String pm,String mediaConfig){

        Map<String,String> sendData=this.getHandleData(tskTaskBiz,businame,mediaConfig);

        //获取需要推送的系统
       TbCompanyInteractionInfo tbCompanyInteractionInfo;
        //pm为0，只下发遥感，为1，下发万维
        if(pm.equals("0")){
            tbCompanyInteractionInfo = this.companyInteractionInfoRepository.getByTaskCode(taskcode, SysInteractionCompanyConstant.NJYG);
        }else {
            tbCompanyInteractionInfo = this.companyInteractionInfoRepository.getByTaskCode(taskcode, SysInteractionCompanyConstant.NJWW);
        }

        //新建推送信息记录类
        TbSysInteractionRecord tbSysInteractionRecord= new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setContent(JSONObject.toJSONString(sendData));
        tbSysInteractionRecord.setTaskid(tskTaskBiz.getId());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        try{
            //获取交互系统的工厂类
            AbstractSysInteractionFactory abstractSysInteractionFactory= sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            //获取当前工厂类推送信息实现类
            InteractionSubmitInterface interactionSubmitInterface= abstractSysInteractionFactory.createInteractionSubmit();
            //权限鉴定
            interactionSubmitInterface.getAuthentication();
            //发起推送
            String response =  interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(),"post",sendData);
            //状态置为已响应
            tbSysInteractionRecord.setStatus(1);
            //存入响应数据
            tbSysInteractionRecord.setBackresult(response);
            //响应时间
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }catch (Exception e){
            e.printStackTrace();
            //状态置为失败
            tbSysInteractionRecord.setStatus(0);
            //记录报错信息
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }


    }

    //处理推送数据
    public Map<String,String> getHandleData(TskTaskBiz tskTaskBiz,String businame,String mediaConfig){
        Map<String,String> data= new HashMap<String, String>();
        JSONObject config= JSONObject.parseObject(tskTaskBiz.getConfigArgs());
        JSONObject njConfig = config.getJSONObject("njConfig");

        //任务id
        data.put("taskid",tskTaskBiz.getId());
        //任务名称
        data.put("taskname",tskTaskBiz.getName());
        //创建时间
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        data.put("createtime",sdf3.format(tskTaskBiz.getCreateTime()));
        //所属业务
        data.put("busicode",tskTaskBiz.getClassId().toString());

        String flowid=null;
        String flowname=null;
        if(mediaConfig!=null&&!mediaConfig.equals("")){
            JSONObject json=JSONObject.parseObject(mediaConfig);
            flowid=json.getString("flowid");
            flowname=json.getString("flowname");
        }

        //流程id
        data.put("flowid",flowid);
        //流程name
        data.put("flowname",flowname);

        //业务名称
        data.put("type",businame);
        //监测周期
        data.put("jczq",njConfig.getString("jczq"));
        //监测批次
        data.put("jcpc",njConfig.getString("jcpc"));
        //前时相影相名称
        data.put("qsxyxname",njConfig.getString("qsxyxname"));
        //后时相影相名称
        data.put("hsxyxname",njConfig.getString("hsxyxname"));
        //任务年份
        data.put("year",njConfig.getString("year"));
        //前时相影相id
        data.put("qsxyxid",njConfig.getString("qsxyxid"));
        //后时相影相id
        data.put("hsxyxid",njConfig.getString("hsxyxid"));
        //前时相影相ImageDirectory
        data.put("qsxyxImageDirectory",njConfig.getString("qsxyxImageDirectory"));
        //后时相影相ImageDirectory
        data.put("hsxyxImageDirectory",njConfig.getString("hsxyxImageDirectory"));

        return data;
    }

    //获取遥感影像列表
    public void getYgImageList(){
        TbCompanyInteractionInfo tbCompanyInteractionInfo= companyInteractionInfoRepository.getByTaskCode(SysInteractionTaskConstant.ygImageListReceive,SysInteractionCompanyConstant.NJYG);
        //新建推送信息记录类
        TbSysInteractionRecord tbSysInteractionRecord= new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        try{
            //获取交互系统的工厂类
            AbstractSysInteractionFactory abstractSysInteractionFactory= sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            //获取当前工厂类推送信息实现类
            InteractionSubmitInterface interactionSubmitInterface= abstractSysInteractionFactory.createInteractionSubmit();
            //权限鉴定
            interactionSubmitInterface.getAuthentication();
            //发起推送
            String response =  interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(),"get",null);
            //状态置为已响应
            tbSysInteractionRecord.setStatus(1);
            //存入响应数据
            tbSysInteractionRecord.setBackresult(response);
            //响应时间
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }catch (Exception e){
            //状态置为失败
            tbSysInteractionRecord.setStatus(0);
            //记录报错信息
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }

    }

    //获取遥感工作流列表
    public void getYgFlowList(){
        TbCompanyInteractionInfo tbCompanyInteractionInfo= companyInteractionInfoRepository.getByTaskCode(SysInteractionTaskConstant.ygFlowListReceive,SysInteractionCompanyConstant.NJYG);
        //新建推送信息记录类
        TbSysInteractionRecord tbSysInteractionRecord= new TbSysInteractionRecord();
        tbSysInteractionRecord.setCompanycode(tbCompanyInteractionInfo.getCompanycode());
        tbSysInteractionRecord.setCreatetime(new Date());
        tbSysInteractionRecord.setType(1);
        tbSysInteractionRecord.setTaskcode(tbCompanyInteractionInfo.getTaskcode());
        tbSysInteractionRecord = this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        try{
            //获取交互系统的工厂类
            AbstractSysInteractionFactory abstractSysInteractionFactory= sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            //获取当前工厂类推送信息实现类
            InteractionSubmitInterface interactionSubmitInterface= abstractSysInteractionFactory.createInteractionSubmit();
            //权限鉴定
            interactionSubmitInterface.getAuthentication();
            //发起推送
            String response =  interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(),"get",null);
            //状态置为已响应
            tbSysInteractionRecord.setStatus(1);
            //存入响应数据
            tbSysInteractionRecord.setBackresult(response);
            //响应时间
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }catch (Exception e){
            //状态置为失败
            tbSysInteractionRecord.setStatus(0);
            //记录报错信息
            tbSysInteractionRecord.setBackresult(e.getMessage());
            tbSysInteractionRecord.setResponsetime(new Date());
            this.sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }

    }

    //获取遥感任务进程状态
    public String getYgFlowState(String processId) {
//        TskTaskBiz tskTaskBiz= tskTaskBizService.findByTaskId(taskId);
//        String flowSql="SELECT f_media_config  FROM tbtsk_task_biz_application_group where f_busicode = '"+tskTaskBiz.getBusicode()+"'";
//        Map<String,Object> config= jdbcTemplate.queryForMap(flowSql);
//        JSONObject configJson=JSONObject.parseObject(config.get("f_media_config").toString());
//        configJson.getString("flowid");
//        TbSysInteractionRecord tbSysInteractionRecord = this.sysInteractionRecordRepository.getLastOkRecordByTaskCodeAndTaskid(SysInteractionTaskConstant.taskInfoCommit,taskId);
//        if(tbSysInteractionRecord == null){
//            throw new RuntimeException("未找到当前任务推送成功记录！！！");
//        }
        TbCompanyInteractionInfo tbCompanyInteractionInfo= companyInteractionInfoRepository.getByTaskCode(SysInteractionTaskConstant.ygFlowStateReceive,SysInteractionCompanyConstant.NJYG);
        String response =null;
        try{
            //获取交互系统的工厂类
            AbstractSysInteractionFactory abstractSysInteractionFactory= sysInteractionProducer.getFactory(tbCompanyInteractionInfo.getCompanycode());
            //获取当前工厂类推送信息实现类
            InteractionSubmitInterface interactionSubmitInterface= abstractSysInteractionFactory.createInteractionSubmit();
            //权限鉴定
            interactionSubmitInterface.getAuthentication();
            //发起推送
            Map<String,String> data = new HashMap<>();
            data.put("processId",processId);
            response =  interactionSubmitInterface.sendDataWithAuthentication(tbCompanyInteractionInfo.getSysurl(),"get",data);
        }catch (Exception e){
           e.printStackTrace();
           throw new RuntimeException(e.getMessage());
        }
        return response;
    }

}
