package com.geoway.landteam.landcloud.service.sysinteraction;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.sysinteraction.constant.SysInteractionCompanyConstant;
import com.geoway.landteam.landcloud.model.sysinteraction.constant.SysInteractionTaskConstant;
import com.geoway.landteam.landcloud.model.sysinteraction.entity.TbSysInteractionRecord;
import com.geoway.landteam.landcloud.repository.sysinteraction.SysInteractionRecordRepository;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.AbstractSysInteractionFactory;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionFactory.InteractionReceiveInterface;
import com.geoway.landteam.landcloud.service.sysinteraction.InteractionHandle.SysInteractionProducer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/*
 * @author   : lcw
 * @date     : 2022/7/18
 * @des      : 南京系统系统信息接收服务类
 **/

@Service
public class SysInteractionReceiveService {

    @Value("${project.uploadDir}")
    protected  String tempDir;

    @Autowired
    SysInteractionRecordRepository sysInteractionRecordRepository;

    @Autowired
    SysInteractionProducer sysInteractionProducer;


    //接收遥感影像信息
//    public BaseObjectResponse receiveYgImageList(HttpServletRequest request, String imageList){
//        BaseObjectResponse response = new BaseObjectResponse();
//        TbSysInteractionRecord  tbSysInteractionRecord = new TbSysInteractionRecord();
//        try {
//            //获取交互系统的工厂类
//            AbstractSysInteractionFactory abstractSysInteractionFactory= SysInteractionProducer.getFactory(SysInteractionCompanyConstant.NJYG);
//            //获取当前工厂类接收信息实现类
//            InteractionReceiveInterface interactionReceiveInterface=abstractSysInteractionFactory.createInteractionReceive();
//            //鉴定权限
//            if(!interactionReceiveInterface.authentication()){
//                throw new RuntimeException("权限鉴定失败");
//            }
//            tbSysInteractionRecord.setCompanycode("NJYG");
//            tbSysInteractionRecord.setContent(imageList);
//            tbSysInteractionRecord.setType(2);
//            //遥感影像接收任务
//            tbSysInteractionRecord.setTaskcode(SysInteractionTaskConstant.ygImageListReceive);
//            tbSysInteractionRecord.setCreatetime(new Date());
//            response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
//            response.setData("ok");
//            tbSysInteractionRecord.setBackresult(response.toString());
//            sysInteractionRecordRepository.save(tbSysInteractionRecord);
//        }catch (Exception e){
//            response.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
//            response.setMessage(e.getMessage());
//            tbSysInteractionRecord.setStatus(0);
//            tbSysInteractionRecord.setBackresult(e.getMessage());
//            sysInteractionRecordRepository.save(tbSysInteractionRecord);
//        }
//        return response;
//    }

    public String uploadTemfile(MultipartFile file, String taskId) throws Exception{
        //新建接收信息记录类
        TbSysInteractionRecord tbSysInteractionRecord= new TbSysInteractionRecord();
        //任务代号
        tbSysInteractionRecord.setTaskcode(SysInteractionTaskConstant.wwTaskHandleDataReceive);
        //创建时间
        tbSysInteractionRecord.setCreatetime(new Date());
        //设置交互系统公司代码
        tbSysInteractionRecord.setCompanycode(SysInteractionCompanyConstant.NJWW);
        //任务类型设为2,其他系统推送
        tbSysInteractionRecord.setType(2);
        //设置作用任务id
        tbSysInteractionRecord.setTaskid(taskId);
        sysInteractionRecordRepository.save(tbSysInteractionRecord);

        try{
            Map<String,String> newFileInfo=uploadToLocal(file);
            //上传文件地址
            JSONObject content=new JSONObject();
            content.put("文件名",newFileInfo.get("filename"));
            content.put("文件地址",newFileInfo.get("newFileUrl"));
            content.put("文件大小",newFileInfo.get("filesize"));

            tbSysInteractionRecord.setContent(content.toString());
            //接收状态
            tbSysInteractionRecord.setStatus(1);
            tbSysInteractionRecord.setBackresult("上传文件成功,正在解析...");
            sysInteractionRecordRepository.save(tbSysInteractionRecord);
            //获取交互系统的工厂类
            AbstractSysInteractionFactory abstractSysInteractionFactory= sysInteractionProducer.getFactory(SysInteractionCompanyConstant.NJWW);
            //获取当前工厂类接收信息实现类
            InteractionReceiveInterface interactionReceiveInterface= abstractSysInteractionFactory.createInteractionReceive();
            //权限鉴定
            interactionReceiveInterface.authentication();
            interactionReceiveInterface.handleReceiveData(tbSysInteractionRecord,SysInteractionTaskConstant.wwTaskHandleDataReceive);
        }catch (Exception e){
            e.printStackTrace();
            tbSysInteractionRecord.setStatus(0);
            tbSysInteractionRecord.setBackresult(e.getMessage());
            sysInteractionRecordRepository.save(tbSysInteractionRecord);
        }

        return "传输数据完成";
    }

    public  Map<String,String> uploadToLocal(MultipartFile file) throws Exception {
        if(file.isEmpty()){
            throw new Exception("文件为空");
        }
        //获取文件名
        String filename=file.getOriginalFilename();
        //获取文件大小
        Long filesize=file.getSize();
        Calendar now = Calendar.getInstance();
        //设置新文件名，加上时间戳防止文件覆盖
        String newFileName= System.currentTimeMillis()+"_"+filename;
        //获取当前日期，当作父目录
        String dayDir=now.get(Calendar.YEAR)+"_"+(now.get(Calendar.MONTH) + 1)+"_"+now.get(Calendar.DAY_OF_MONTH);
        String newFileUrl=tempDir+"/sysinteraction/"+SysInteractionCompanyConstant.NJWW+"/"+dayDir;
        File newFileDir=new File(newFileUrl);
        //监测是否存在目录
        if(!newFileDir.exists()){
            newFileDir.mkdirs();
        }
        try{
            File newFile=new File(newFileDir,newFileName);
            InputStream isWithBuff=file.getInputStream();
            FileOutputStream fosWithBuff=new FileOutputStream(newFile);
            int n;//保存返回读取到的字节数， 一次8192个字节，当不够时就是实际读取到的字节数
            byte[] buff=new byte[8*1024];//8kib的缓冲字节数组
            while((n=isWithBuff.read(buff))!=-1) {
                fosWithBuff.write(buff, 0, n);
            }
            isWithBuff.close();
            fosWithBuff.close();
//            file.transferTo(newFile);
        }catch (IllegalStateException e){
            e.printStackTrace();
        }catch (IOException e){
            e.printStackTrace();
        }


        Map<String,String> map = new HashMap <>();
        //文件大小
        map.put("filesize",filesize.toString());
        //上传文件名
        map.put("filename",filename);
        //新文件名
        map.put("newFilename",newFileName);
        //上传父目录
        map.put("newFileUrl",newFileDir.getAbsolutePath()+"/"+newFileName);

        return map;
    }

}
