package com.geoway.landteam.landcloud.service.taskStatisticalDay;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskBiz;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayDao;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayResultDao;
import com.geoway.landteam.landcloud.dao.taskStatisticalDay.TaskStatisticalDayWjDao;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDay;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDayResult;
import com.geoway.landteam.landcloud.model.taskStatisticalDay.entity.TaskStatisticalDayWj;
import com.geoway.landteam.landcloud.service.util.ExceptionUtil;
import com.geoway.landteam.landcloud.service.util.excel.EnumTextLocation;
import com.geoway.landteam.landcloud.service.util.excel.ExcelColData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelRowData;
import com.geoway.landteam.landcloud.service.util.excel.ExcelUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import jxl.write.WriteException;
import netscape.javascript.JSObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MTaskStatisticalDayService {
    private final GiLoger logger = GwLoger.getLoger(MTaskStatisticalDayService.class);
    @Value("${project.tempDir}")
    String tempDir;

    @Resource
    TaskStatisticalDayWjDao taskStatisticalDayWjDao;
    @Resource
    TaskStatisticalDayDao taskStatisticalDayDao;

    @Resource
    TaskStatisticalDayResultDao taskStatisticalDayResultDao;
    @Autowired
    TskTaskBizService tskTaskBizService;

    @Resource
    JdbcTemplate jdbcTemplate;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    public List<TaskStatisticalDay> getNeedDayStatistical()
    {
        return taskStatisticalDayDao.gwSearchAll();
    }

    public JSONObject getDayStatisticalPage(String taskId,Integer page,Integer size)
    {
        if(StringUtils.isBlank(taskId))
        {
            taskId=null;
        }
        Integer totalCount = taskStatisticalDayResultDao.countForPage(taskId);
        List<TaskStatisticalDayResult>results = new ArrayList<>();
        if(totalCount>0)
        {
            Integer offset = (page - 1)*size;
            results = taskStatisticalDayResultDao.selectByPage(taskId,offset,size);
            for(TaskStatisticalDayResult result:results)
            {
                result.setUrlDetail(temporarySignedUrlService.getTemporarySignedUrl(null,result.getUrlDetail(),null));

                result.setUrlHz(temporarySignedUrlService.getTemporarySignedUrl(null,result.getUrlHz(),null));
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("totalCount",totalCount);
        jsonObject.put("data",results);
        return jsonObject;
    }

    public void statistical(TaskStatisticalDay taskStatisticalDay)
    {

        TskTaskBiz task = tskTaskBizService.findByTaskId(taskStatisticalDay.getTaskId());
        if(task==null)
        {
            return;
        }
        TbtskObjectinfo objectinfo = tskTaskBizService.getTableByTableId(task.getTableId());
        if(objectinfo==null)
        {
            return;
        }
        try {
            JSONObject json = JSONObject.parseObject(taskStatisticalDay.getConfig());
            String dkmjField = json.getString("dkmjField");
            String gdmjField = json.getString("gdmjField");
            String dkbhField = json.getString("dkbhField");
            String jbntmjField = json.getString("jbntmjField");
            String sjhfxpdField = json.getString("sjhfxpdField");
            String zglsqkField = json.getString("zglsqkField");
            String sjrdzgqkField = json.getString("sjrdzgqkField");
            String sjzgqkpdField = json.getString("sjzgqkpdField");

            String cityEndTime = json.getString("cityEndTime");
            String provinceEndTime = json.getString("provinceEndTime");

            String tablename = objectinfo.getfTablename();
            String childTable = objectinfo.getSplitTableName();
            Calendar calendar = Calendar.getInstance();

            Date today = calendar.getTime();

            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String todayEndTime = df.format(today) + " " + cityEndTime;
            calendar.add(Calendar.DAY_OF_MONTH, -1);
            Date yestoday = calendar.getTime();
            String yestodayStartTime = df.format(yestoday) + " " + cityEndTime;
            String provinceTodayEndTime = df.format(today) + " " + provinceEndTime;
            df = new SimpleDateFormat("MM月dd日");
            String todayStr  =df.format(today);
            String yestodayStr = df.format(yestoday);
            df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date  provinceTodayEndTimeT=  df.parse(provinceTodayEndTime);
            df = new SimpleDateFormat("yyyy");
            String year = df.format(today);

            TaskStatisticalDayResult seo = new TaskStatisticalDayResult();
            seo.setTaskId(taskStatisticalDay.getTaskId());
            seo.setTime(yestodayStartTime+"-"+todayEndTime);
            List<TaskStatisticalDayResult>exist = taskStatisticalDayResultDao.gwSearch(seo);
            if(exist!=null&&!exist.isEmpty())
            {
                return;
            }
            List<Map<String, Object>> maps = null;
            if(StringUtils.isBlank(objectinfo.getSplitTableName()))
            {
                String sql=String.format("with t1 as (select distinct(f_tbid) as f_tbid from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n" +
                        "     t2 as (select '审核已通过' as f_type,f_tbid,f_approve_time as f_time from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t3 as (select '审核未通过' as f_type,f_tbid,f_reject_time as f_time from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t4 as (select * from (select f_type,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and %s group by f_xzqdmcounty),\n" +
                        "     t6 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核已通过') and %s group by f_xzqdmcounty),\n" +
                        "     t7 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核未通过') and %s group by f_xzqdmcounty),\n" +
                        "     t8 as (select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and %s group by f_xzqdmcounty),\n" +
                        "     t9 as (select f_xzqdm as f_xdm,f_xzqmc as f_xmc,f_pcode as f_sdm from tb_region where f_level = 3 and f_version in(select f_version from tbtsk_task_biz where f_id = '6b496e7b-d668-4302-bb24-7179d42c3f4c' )),\n" +
                        "     t10 as (select t9.f_xdm,t9.f_xmc,t9.f_sdm,tr.f_xzqmc as f_smc from t9 left join tb_region tr on t9.f_sdm = tr.f_xzqdm)\n" +
                        "     select t10.f_smc,t10.f_xdm,t10.f_xmc,\n" +
                        "     t5.f_count as f_count_hj,t5.f_dkmj as f_dkmj_hj,t5.f_gdmj as f_gdmj_hj,\n" +
                        "     t6.f_count as f_count_ws,t6.f_dkmj as f_dkmj_ws,t6.f_gdmj as f_gdmj_ws,\n" +
                        "     t7.f_count as f_count_pass,t7.f_dkmj as f_dkmj_pass,t7.f_gdmj as f_gdmj_pass,\n" +
                        "     t8.f_count as f_count_reject,t8.f_dkmj as f_dkmj_reject,t8.f_gdmj as f_gdmj_reject\n" +
                        "     from t10\n" +
                        "     left join t5 on t10.f_xdm = t5.f_xzqdmcounty\n" +
                        "     left join t6 on t10.f_xdm = t6.f_xzqdmcounty\n" +
                        "     left join t7 on t10.f_xdm = t7.f_xzqdmcounty\n" +
                        "     left join t8 on t10.f_xdm = t8.f_xzqdmcounty\n" +
                        "     order by t10.f_sdm,f_xdm",task.getId(),yestodayStartTime,todayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime, dkmjField,gdmjField,tablename, "f_sjhfxpd like '%违法%'",dkmjField,gdmjField,tablename,"f_sjhfxpd like '%违法%'",dkmjField,gdmjField,tablename,"f_sjhfxpd like '%违法%'",dkmjField,gdmjField,tablename,"f_sjhfxpd like '%违法%'");
                maps = jdbcTemplate.queryForList(sql);
            }
            else
            {
                String sql=String.format("with t1 as (select distinct(f_tbid) as f_tbid from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n" +
                        "     t2 as (select '审核已通过' as f_type,f_tbid,f_approve_time as f_time from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t3 as (select '审核未通过' as f_type,f_tbid,f_reject_time as f_time from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t4 as (select * from (select f_type,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n" +
                        "            union all\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1)  and %s group by f_xzqdmcounty\n" +
                        "            ) t5_a group by f_xzqdmcounty\n" +
                        "            ),\n" +
                        "     t6 as  (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n" +
                        "             select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核已通过') and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n" +
                        "             union all\n" +
                        "             select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核已通过')  and %s group by f_xzqdmcounty\n" +
                        "             )t6_a group by f_xzqdmcounty\n" +
                        "             ),\n" +
                        "     t7 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核未通过') and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n" +
                        "            union all\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t4 where f_type = '审核未通过') and %s group by f_xzqdmcounty\n" +
                        "            )t7_a group by f_xzqdmcounty\n" +
                        "            ),\n" +
                        "     t8 as (select f_xzqdmcounty,sum(f_count) as f_count,sum(f_dkmj) as f_dkmj,sum(f_gdmj) as f_gdmj from (\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and f_id not in (select f_xmid from %s) and %s group by f_xzqdmcounty\n" +
                        "            union all\n" +
                        "            select f_xzqdmcounty,count(*) as f_count,sum(%s) as f_dkmj,sum(%s) as f_gdmj from %s where f_id in (select f_tbid from t1) and f_id not in (select f_tbid from t4 ) and %s group by f_xzqdmcounty\n" +
                        "            )t8_a group by f_xzqdmcounty\n" +
                        "            ),\n" +
                        "     t9 as (select f_xzqdm as f_xdm,f_xzqmc as f_xmc,f_pcode as f_sdm from tb_region where f_level = 3 and f_version in(select f_version from tbtsk_task_biz where f_id = '%s' )),\n" +
                        "     t10 as (select t9.f_xdm,t9.f_xmc,t9.f_sdm,tr.f_xzqmc as f_smc from t9 left join tb_region tr on t9.f_sdm = tr.f_xzqdm)\n" +
                        "     select t10.f_smc,t10.f_xdm,t10.f_xmc,\n" +
                        "     t5.f_count as f_count_hj,t5.f_dkmj as f_dkmj_hj,t5.f_gdmj as f_gdmj_hj,\n"+
                        "     t6.f_count as f_count_pass,t6.f_dkmj as f_dkmj_pass,t6.f_gdmj as f_gdmj_pass,\n"+
                        "     t7.f_count as f_count_reject,t7.f_dkmj as f_dkmj_reject,t7.f_gdmj as f_gdmj_reject,\n"+
                        "     t8.f_count as f_count_ws,t8.f_dkmj as f_dkmj_ws,t8.f_gdmj as f_gdmj_ws\n"+
                        "     from t10\n" +
                        "     left join t5 on t10.f_xdm = t5.f_xzqdmcounty\n" +
                        "     left join t6 on t10.f_xdm = t6.f_xzqdmcounty\n" +
                        "     left join t7 on t10.f_xdm = t7.f_xzqdmcounty\n" +
                        "     left join t8 on t10.f_xdm = t8.f_xzqdmcounty\n" +
                        "     order by t10.f_sdm,f_xdm\n" +
                        "     ",task.getId(),yestodayStartTime,todayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,dkmjField,gdmjField,tablename,childTable, sjhfxpdField +" like '%违法%'",dkmjField,gdmjField,childTable,sjhfxpdField +" = '违法'",dkmjField,gdmjField,tablename,childTable,sjhfxpdField +" like '%违法%'",dkmjField,gdmjField,childTable,sjhfxpdField +" = '违法'",dkmjField,gdmjField,tablename,childTable,sjhfxpdField +" like '%违法%'",dkmjField,gdmjField,childTable,sjhfxpdField +" = '违法'",dkmjField,gdmjField,tablename,childTable,sjhfxpdField +" like '%违法%'",dkmjField,gdmjField,childTable,sjhfxpdField +" = '违法'",task.getId());
                maps = jdbcTemplate.queryForList(sql);
            }

            List<Map<String, Object>> mapDetails=null;
            String configFields = dkbhField+","+dkmjField+","+gdmjField+","+jbntmjField+","+sjhfxpdField+","+zglsqkField+","+sjrdzgqkField+","+sjzgqkpdField;
            if(StringUtils.isBlank(objectinfo.getSplitTableName()))
            {
                String sql=String.format("with t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n" +
                        "     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n" +
                        "     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1) and %s),\n" +
                        "     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '审核已通过' when 'unpass' then '审核未通过' else '未审核' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n" +
                        "     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm) tt  order by tt.f_xzqdmcity,tt.f_xzqdmcounty,f_approve\n" +
                        "     ",task.getId(),yestodayStartTime,todayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,configFields, tablename,sjhfxpdField +" like '%违法%'");
                mapDetails = jdbcTemplate.queryForList(sql);
            }
            else
            {
                String sql=String.format("with t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_approve_time >= '%s' and f_approve_time <= '%s'),\n" +
                        "     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n" +
                        "     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_approve_time >= '%s' and f_approve_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_reject_time >= '%s' and f_reject_time <= '%s' and f_tbid in (select f_tbid from t1)),\n" +
                        "     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (\n" +
                        "           select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1) and f_id not in (select f_xmid from %s) and %s\n" +
                        "           union all\n" +
                        "           select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1) and %s\n" +
                        "           ),\n" +
                        "     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '审核已通过' when 'unpass' then '审核未通过' else '未审核' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n" +
                        "     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm) tt  order by tt.f_xzqdmcity,tt.f_xzqdmcounty,f_approve\n"+
                        "     ",task.getId(),yestodayStartTime,todayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,task.getId(),yestodayStartTime,provinceTodayEndTime,configFields,tablename,childTable,sjhfxpdField+" like '%违法%'",configFields,childTable,sjhfxpdField+" = '违法'");
                mapDetails = jdbcTemplate.queryForList(sql);
            }
            List<Map<String, Object>> mapWjs = null;
            if(StringUtils.isBlank(objectinfo.getSplitTableName()))
            {
                String sql=String.format(" with t as (select f_tbid,f_wj_time from tb_task_statistical_day_wj where f_task_id = '%s'),\n" +
                        "     t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n" +
                        "     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1)),\n" +
                        "     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '审核已通过' when 'unpass' then '审核未通过' else '未审核' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n" +
                        "     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity,t.f_wj_Time from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm left join t on t6.f_id = t.f_tbid) tt order by tt.f_wj_Time, tt.f_xzqdmcity,tt.f_xzqdmcounty,tt.f_approve\n" +
                        "     ",task.getId(),task.getId(),task.getId(),task.getId(),configFields,tablename);
                mapWjs = jdbcTemplate.queryForList(sql);
            }
            else
            {
                String sql=String.format("with t as (select f_tbid,f_wj_time from tb_task_statistical_day_wj where f_task_id = '%s'),\n" +
                        "     t0 as (select f_tbid,f_approve_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='市级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t1 as (select * from (select f_tbid,f_approve_time, row_number() over(partition by f_tbid order by f_tbid,f_approve_time desc) as f_rnum  from t0) t1s where f_rnum = 1),\n" +
                        "     t2 as (select 'pass' as f_approve, f_tbid,f_approve_time as f_time  from tbtsk_approve_record tar where f_taskid = '%s' and f_stepname  ='省级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t3 as (select 'unpass' as f_approve,f_tbid,f_reject_time as f_time  from tbtsk_reject_record trr  where f_taskid = '%s' and f_stepname  ='省级审核' and f_tbid in (select f_tbid from t)),\n" +
                        "     t4 as (select * from (select f_approve,f_tbid,f_time,row_number() over(partition by f_tbid order by f_tbid,f_time desc) as f_rnum from (select * from t2 union all select * from t3) tt  ) ss where f_rnum = 1),\n" +
                        "     t5 as (\n" +
                        "            select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1) and f_id not in(select f_xmid from %s)\n" +
                        "            union all\n" +
                        "            select substring(f_xzqdmcounty,1,4)||'00' as f_xzqdmcity,f_xzqdmcounty,f_id,%s, case f_review_stage when 101 then '省级已审核' when 97 then '省级待审核' else '省级待审核' end as f_state from %s where f_id in (select f_tbid from t1)\n" +
                        "            ),\n" +
                        "     t6 as (select t5.*,t1.f_approve_time as f_city_time,case t4.f_approve when 'pass' then '审核已通过' when 'unpass' then '审核未通过' else '未审核' end f_approve,t4.f_time as f_province_time from t5 left join t1 on t5.f_id = t1.f_tbid left join t4 on t5.f_id = t4.f_tbid)\n" +
                        "     select * from (select t6.*,tr.f_xzqmc as f_xzqmccounty,tr1.f_xzqmc as f_xzqmccity,t.f_wj_Time from t6 left join tb_region tr on t6.f_xzqdmcounty = tr.f_xzqdm left join tb_region tr1 on t6.f_xzqdmcity = tr1.f_xzqdm left join t on t6.f_id = t.f_tbid) tt order by tt.f_wj_Time, tt.f_xzqdmcity,tt.f_xzqdmcounty,tt.f_approve\n" +
                        "    ",task.getId(),task.getId(),task.getId(),task.getId(),configFields,tablename,childTable,configFields,childTable);
                mapWjs = jdbcTemplate.queryForList(sql);
            }

            List<tempInfo> tempInfos = getTempInfo(maps);
            String hzb = getHZB(tempInfos, task, todayStr, yestodayStr,year);
            String detail = getDetail(mapDetails,mapWjs,task,dkbhField,dkmjField,gdmjField,jbntmjField,sjhfxpdField,zglsqkField,sjrdzgqkField,sjzgqkpdField,provinceTodayEndTimeT);

            String urlHz=null;
            String urlDetail = null;
            File hzFile = new File(hzb);
            if(hzFile.exists())
            {
                String sendObj = "taskStatisticalDay/"+task+"/市级报送整改图斑省级审核进度情况统计表（"+yestodayStr+"-"+todayStr+"）.xlsx";
                urlHz = defaultOssOperatorService.sendObject2Oss(sendObj,hzFile);
                hzFile.delete();
            }
            File detailFile = new File(detail);
            if(detailFile.exists())
            {
                String sendObj = "taskStatisticalDay/"+task+"/市级报送整改图斑省级审核进度情况清单明细表（"+yestodayStr+"-"+todayStr+"）.xlsx";
                urlDetail = defaultOssOperatorService.sendObject2Oss(sendObj,detailFile);
                detailFile.delete();
            }
            TaskStatisticalDayResult dayResult = new TaskStatisticalDayResult();
            dayResult.setTaskId(task.getId());
            dayResult.setUrlHz(urlHz);
            dayResult.setUrlDetail(urlDetail);
            dayResult.setCreateTime(new Date());
            dayResult.setId(UUID.randomUUID().toString());
            dayResult.setTimeEnd(provinceTodayEndTime);
            dayResult.setTime(yestodayStartTime+"-"+todayEndTime);
            taskStatisticalDayResultDao.gwAccess(dayResult);

        }
        catch (Exception ex)
        {
            logger.error("日结统计失败"+ExceptionUtil.getErrorString(ex));
        }
    }
    private List<tempInfo>getTempInfo(List<Map<String,Object>>maps)
    {
        if(maps==null||maps.isEmpty())
            return null;
        List<tempInfo>results = new ArrayList<>();
        for(Map map:maps)
        {
            String smc = map.get("f_smc")!=null?map.get("f_smc").toString():"";
            String xdm = map.get("f_xdm")!=null?map.get("f_xdm").toString():"";
            String xmc = map.get("f_xmc")!=null?map.get("f_xmc").toString():"";
            Integer countHj = map.get("f_count_hj")!=null?Integer.parseInt(map.get("f_count_hj").toString()):0;
            BigDecimal  dkmjHj = getBigDecimal(map,"f_dkmj_hj");;//map.get("f_dkmj_hj")!=null?Double.parseDouble(map.get("f_dkmj_hj").toString()):0d;
            BigDecimal  gdmjHj = getBigDecimal(map,"f_gdmj_hj");;//map.get("f_gdmj_hj")!=null?Double.parseDouble(map.get("f_gdmj_hj").toString()):0d;

            Integer countWs = map.get("f_count_ws")!=null?Integer.parseInt(map.get("f_count_ws").toString()):0;
            BigDecimal  dkmjWs = getBigDecimal(map,"f_dkmj_ws");//map.get("f_dkmj_ws")!=null?Double.parseDouble(map.get("f_dkmj_ws").toString()):0d;
            BigDecimal  gdmjWs = getBigDecimal(map,"f_gdmj_ws");//map.get("f_gdmj_ws")!=null?Double.parseDouble(map.get("f_gdmj_ws").toString()):0d;

            Integer countPass = map.get("f_count_pass")!=null?Integer.parseInt(map.get("f_count_pass").toString()):0;
            BigDecimal  dkmjPass = getBigDecimal(map,"f_dkmj_pass");//map.get("f_dkmj_pass")!=null?Double.parseDouble(map.get("f_dkmj_pass").toString()):0d;
            BigDecimal  gdmjPass = getBigDecimal(map,"f_gdmj_pass");//map.get("f_gdmj_pass")!=null?Double.parseDouble(map.get("f_gdmj_pass").toString()):0d;

            Integer countUnPass = map.get("f_count_reject")!=null?Integer.parseInt(map.get("f_count_reject").toString()):0;
            BigDecimal  dkmjUnPass = getBigDecimal(map,"f_dkmj_reject");//map.get("f_dkmj_reject")!=null?Double.parseDouble(map.get("f_dkmj_reject").toString()):0d;
            BigDecimal  gdmjUnPass = getBigDecimal(map,"f_gdmj_reject");// map.get("f_gdmj_reject")!=null?Double.parseDouble(map.get("f_gdmj_reject").toString()):0d;
            tempInfo tempInfo  = new tempInfo();
            tempInfo.setSmc(smc);
            tempInfo.setXdm(xdm);
            tempInfo.setXmc(xmc);
            tempInfo.setCountHj(countHj);
            tempInfo.setDkmjHj(dkmjHj);
            tempInfo.setGdmjHj(gdmjHj);
            tempInfo.setCountWs(countWs);
            tempInfo.setDkmjWs(dkmjWs);
            tempInfo.setGdmjWs(gdmjWs);
            tempInfo.setCountPass(countPass);
            tempInfo.setDkmjPass(dkmjPass);
            tempInfo.setGdmjPass(gdmjPass);
            tempInfo.setCountUnPass(countUnPass);
            tempInfo.setDkmjUnPass(dkmjUnPass);
            tempInfo.setGdmjUnPass(gdmjUnPass);
            results.add(tempInfo);

        }
        return results;
    }

    private String getHZB(List<tempInfo>tempInfos, TskTaskBiz task,String todayStr,String yestodayStr,String year) throws Exception {

        List<ExcelRowData> rows = new ArrayList<>();

        SXSSFWorkbook excelWorkBook = ExcelUtil.CreateSXSSExcel();
        Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, "进度情况统计表");
        List<Integer> colWidth = new ArrayList<>();
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);
        colWidth.add(15);

        for (int i = 0; i < colWidth.size(); i++) {
            excelSheet.setColumnWidth(i, colWidth.get(i) * 200);
        }
        int rowIndex = 0;


        String titleStr= year+"年新增违法用地市级报送整改图斑省级审核进度情况统计表（"+yestodayStr+"-"+todayStr+")";
        ExcelColData title = new ExcelColData();
        title.setMergeCell(true);
        title.setBold(true);
        title.setValue(titleStr);
        title.setFontSize(20);
        title.setStartRow(0);
        title.setEndRow(0);
        title.setStartCol(0);
        title.setEndCol(14);
        title.setTextLocation(EnumTextLocation.middle);
        title.setColIndex(0);
        List<ExcelColData>row1 = new ArrayList<>();
        row1.add(title);
        ExcelRowData excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(row1);
        excelRow1.setRowIndex(rowIndex);
        rows.add(excelRow1);
        rowIndex++;

        //ExcelUtil.write(excelSheet,rows);
        //rows.clear();

        ExcelColData colHeader1 = new ExcelColData();
        colHeader1.setMergeCell(true);
        colHeader1.setBold(false);
        colHeader1.setValue("市级名称");
        colHeader1.setFontSize(10);
        colHeader1.setStartRow(1);
        colHeader1.setEndRow(2);
        colHeader1.setStartCol(0);
        colHeader1.setEndCol(0);
        colHeader1.setTextLocation(EnumTextLocation.middle);
        colHeader1.setColIndex(0);

        ExcelColData colHeader2 = new ExcelColData();
        colHeader2.setMergeCell(true);
        colHeader2.setBold(false);
        colHeader2.setValue("行政代码");
        colHeader2.setFontSize(10);
        colHeader2.setStartRow(1);
        colHeader2.setEndRow(2);
        colHeader2.setStartCol(1);
        colHeader2.setEndCol(1);
        colHeader2.setTextLocation(EnumTextLocation.middle);
        colHeader2.setColIndex(1);

        ExcelColData colHeader3 = new ExcelColData();
        colHeader3.setMergeCell(true);
        colHeader3.setBold(false);
        colHeader3.setValue("县名称");
        colHeader3.setFontSize(10);
        colHeader3.setStartRow(1);
        colHeader3.setEndRow(2);
        colHeader3.setStartCol(2);
        colHeader3.setEndCol(2);
        colHeader3.setTextLocation(EnumTextLocation.middle);
        colHeader3.setColIndex(2);

        ExcelColData colHeader4 = new ExcelColData();
        colHeader4.setMergeCell(true);
        colHeader4.setBold(false);
        colHeader4.setValue("合计");
        colHeader4.setFontSize(10);
        colHeader4.setStartRow(1);
        colHeader4.setEndRow(1);
        colHeader4.setStartCol(3);
        colHeader4.setEndCol(5);
        colHeader4.setTextLocation(EnumTextLocation.middle);
        colHeader4.setColIndex(3);

        ExcelColData colHeader5 = new ExcelColData();
        colHeader5.setMergeCell(true);
        colHeader5.setBold(false);
        colHeader5.setValue("审核未通过");
        colHeader5.setFontSize(10);
        colHeader5.setStartRow(1);
        colHeader5.setEndRow(1);
        colHeader5.setStartCol(6);
        colHeader5.setEndCol(8);
        colHeader5.setTextLocation(EnumTextLocation.middle);
        colHeader5.setColIndex(6);

        ExcelColData colHeader6 = new ExcelColData();
        colHeader6.setMergeCell(true);
        colHeader6.setBold(false);
        colHeader6.setValue("审核通过");
        colHeader6.setFontSize(10);
        colHeader6.setStartRow(1);
        colHeader6.setEndRow(1);
        colHeader6.setStartCol(9);
        colHeader6.setEndCol(11);
        colHeader6.setTextLocation(EnumTextLocation.middle);
        colHeader6.setColIndex(9);

        ExcelColData colHeader7 = new ExcelColData();
        colHeader7.setMergeCell(true);
        colHeader7.setBold(false);
        colHeader7.setValue("未审核");
        colHeader7.setFontSize(10);
        colHeader7.setStartRow(1);
        colHeader7.setEndRow(1);
        colHeader7.setStartCol(12);
        colHeader7.setEndCol(14);
        colHeader7.setTextLocation(EnumTextLocation.middle);
        colHeader7.setColIndex(12);

        List<ExcelColData>cols = new ArrayList<>();
        cols.add(colHeader1);
        cols.add(colHeader2);
        cols.add(colHeader3);
        cols.add(colHeader4);
        cols.add(colHeader5);
        cols.add(colHeader6);
        cols.add(colHeader7);
        ExcelRowData excelRowHeader = new ExcelRowData();
        excelRowHeader.setColDataList(cols);
        excelRowHeader.setRowIndex(rowIndex);
        rows.add(excelRowHeader);
        rowIndex++;

        //ExcelUtil.write(excelSheet,rows);
        //rows.clear();

        /*
        ExcelColData colHeader_1 = new ExcelColData();
        colHeader_1.setMergeCell(true);
        colHeader_1.setBold(false);
        colHeader_1.setValue("市级名称");
        colHeader_1.setFontSize(10);
        colHeader_1.setStartRow(1);
        colHeader_1.setEndRow(2);
        colHeader_1.setStartCol(0);
        colHeader_1.setEndCol(0);
        colHeader_1.setTextLocation(EnumTextLocation.middle);
        colHeader_1.setColIndex(0);

        ExcelColData colHeader_2 = new ExcelColData();
        colHeader_2.setMergeCell(true);
        colHeader_2.setBold(false);
        colHeader_2.setValue("行政代码");
        colHeader_2.setFontSize(10);
        colHeader_2.setStartRow(1);
        colHeader_2.setEndRow(2);
        colHeader_2.setStartCol(1);
        colHeader_2.setEndCol(1);
        colHeader_2.setTextLocation(EnumTextLocation.middle);
        colHeader_2.setColIndex(1);

        ExcelColData colHeader_3 = new ExcelColData();
        colHeader_3.setMergeCell(true);
        colHeader_3.setBold(false);
        colHeader_3.setValue("县名称");
        colHeader_3.setFontSize(10);
        colHeader_3.setStartRow(1);
        colHeader_3.setEndRow(2);
        colHeader_3.setStartCol(2);
        colHeader_3.setEndCol(2);
        colHeader_3.setTextLocation(EnumTextLocation.middle);
        colHeader_3.setColIndex(2);
        */

        ExcelColData colHeader_4 = new ExcelColData();
        colHeader_4.setMergeCell(false);
        colHeader_4.setBold(false);
        colHeader_4.setValue("个数");
        colHeader_4.setFontSize(10);
        colHeader_4.setStartRow(2);
        colHeader_4.setEndRow(2);
        colHeader_4.setStartCol(3);
        colHeader_4.setEndCol(3);
        colHeader_4.setTextLocation(EnumTextLocation.middle);
        colHeader_4.setColIndex(3);

        ExcelColData colHeader_5 = new ExcelColData();
        colHeader_5.setMergeCell(false);
        colHeader_5.setBold(false);
        colHeader_5.setValue("面积");
        colHeader_5.setFontSize(10);
        colHeader_5.setStartRow(2);
        colHeader_5.setEndRow(2);
        colHeader_5.setStartCol(4);
        colHeader_5.setEndCol(4);
        colHeader_5.setTextLocation(EnumTextLocation.middle);
        colHeader_5.setColIndex(4);

        ExcelColData colHeader_6 = new ExcelColData();
        colHeader_6.setMergeCell(false);
        colHeader_6.setBold(false);
        colHeader_6.setValue("耕地");
        colHeader_6.setFontSize(10);
        colHeader_6.setStartRow(2);
        colHeader_6.setEndRow(2);
        colHeader_6.setStartCol(5);
        colHeader_6.setEndCol(5);
        colHeader_6.setTextLocation(EnumTextLocation.middle);
        colHeader_6.setColIndex(5);


        ExcelColData colHeader_7 = new ExcelColData();
        colHeader_7.setMergeCell(false);
        colHeader_7.setBold(false);
        colHeader_7.setValue("个数");
        colHeader_7.setFontSize(10);
        colHeader_7.setStartRow(2);
        colHeader_7.setEndRow(2);
        colHeader_7.setStartCol(6);
        colHeader_7.setEndCol(6);
        colHeader_7.setTextLocation(EnumTextLocation.middle);
        colHeader_7.setColIndex(6);

        ExcelColData colHeader_8 = new ExcelColData();
        colHeader_8.setMergeCell(false);
        colHeader_8.setBold(false);
        colHeader_8.setValue("面积");
        colHeader_8.setFontSize(10);
        colHeader_8.setStartRow(2);
        colHeader_8.setEndRow(2);
        colHeader_8.setStartCol(7);
        colHeader_8.setEndCol(7);
        colHeader_8.setTextLocation(EnumTextLocation.middle);
        colHeader_8.setColIndex(7);

        ExcelColData colHeader_9 = new ExcelColData();
        colHeader_9.setMergeCell(false);
        colHeader_9.setBold(false);
        colHeader_9.setValue("耕地");
        colHeader_9.setFontSize(10);
        colHeader_9.setStartRow(2);
        colHeader_9.setEndRow(2);
        colHeader_9.setStartCol(8);
        colHeader_9.setEndCol(8);
        colHeader_9.setTextLocation(EnumTextLocation.middle);
        colHeader_9.setColIndex(8);

        ExcelColData colHeader_10 = new ExcelColData();
        colHeader_10.setMergeCell(false);
        colHeader_10.setBold(false);
        colHeader_10.setValue("个数");
        colHeader_10.setFontSize(10);
        colHeader_10.setStartRow(2);
        colHeader_10.setEndRow(2);
        colHeader_10.setStartCol(9);
        colHeader_10.setEndCol(9);
        colHeader_10.setTextLocation(EnumTextLocation.middle);
        colHeader_10.setColIndex(9);

        ExcelColData colHeader_11 = new ExcelColData();
        colHeader_11.setMergeCell(false);
        colHeader_11.setBold(false);
        colHeader_11.setValue("面积");
        colHeader_11.setFontSize(10);
        colHeader_11.setStartRow(2);
        colHeader_11.setEndRow(2);
        colHeader_11.setStartCol(10);
        colHeader_11.setEndCol(10);
        colHeader_11.setTextLocation(EnumTextLocation.middle);
        colHeader_11.setColIndex(10);

        ExcelColData colHeader_12 = new ExcelColData();
        colHeader_12.setMergeCell(false);
        colHeader_12.setBold(false);
        colHeader_12.setValue("耕地");
        colHeader_12.setFontSize(10);
        colHeader_12.setStartRow(2);
        colHeader_12.setEndRow(2);
        colHeader_12.setStartCol(11);
        colHeader_12.setEndCol(11);
        colHeader_12.setTextLocation(EnumTextLocation.middle);
        colHeader_12.setColIndex(11);

        ExcelColData colHeader_13 = new ExcelColData();
        colHeader_13.setMergeCell(false);
        colHeader_13.setBold(false);
        colHeader_13.setValue("个数");
        colHeader_13.setFontSize(10);
        colHeader_13.setStartRow(2);
        colHeader_13.setEndRow(2);
        colHeader_13.setStartCol(12);
        colHeader_13.setEndCol(12);
        colHeader_13.setTextLocation(EnumTextLocation.middle);
        colHeader_13.setColIndex(12);

        ExcelColData colHeader_14 = new ExcelColData();
        colHeader_14.setMergeCell(false);
        colHeader_14.setBold(false);
        colHeader_14.setValue("面积");
        colHeader_14.setFontSize(10);
        colHeader_14.setStartRow(2);
        colHeader_14.setEndRow(2);
        colHeader_14.setStartCol(13);
        colHeader_14.setEndCol(13);
        colHeader_14.setTextLocation(EnumTextLocation.middle);
        colHeader_14.setColIndex(13);

        ExcelColData colHeader_15 = new ExcelColData();
        colHeader_15.setMergeCell(false);
        colHeader_15.setBold(false);
        colHeader_15.setValue("耕地");
        colHeader_15.setFontSize(10);
        colHeader_15.setStartRow(2);
        colHeader_15.setEndRow(2);
        colHeader_15.setStartCol(14);
        colHeader_15.setEndCol(14);
        colHeader_15.setTextLocation(EnumTextLocation.middle);
        colHeader_15.setColIndex(14);

        List<ExcelColData>headers = new ArrayList<>();
        //headers.add(colHeader_1);
        //headers.add(colHeader_2);
        //headers.add(colHeader_3);
        headers.add(colHeader_4);
        headers.add(colHeader_5);
        headers.add(colHeader_6);
        headers.add(colHeader_7);
        headers.add(colHeader_8);
        headers.add(colHeader_9);
        headers.add(colHeader_10);
        headers.add(colHeader_11);
        headers.add(colHeader_12);
        headers.add(colHeader_13);
        headers.add(colHeader_14);
        headers.add(colHeader_15);

        ExcelRowData excelRowHeader2 = new ExcelRowData();
        excelRowHeader2.setColDataList(headers);
        excelRowHeader2.setRowIndex(rowIndex);
        rows.add(excelRowHeader2);
        rowIndex++;

        //ExcelUtil.write(excelSheet,rows);
        //rows.clear();

        if(tempInfos!=null&&!tempInfos.isEmpty())
        {
            Integer countHj = tempInfos.stream().mapToInt(t->t.countHj).sum();
            Integer countUnPass = tempInfos.stream().mapToInt(t->t.countUnPass).sum();
            Integer countPass = tempInfos.stream().mapToInt(t->t.countPass).sum();
            Integer countWs = tempInfos.stream().mapToInt(t->t.countWs).sum();

            BigDecimal dkmjHj = sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjHj).collect(Collectors.toList()));
            BigDecimal dkmjUnPass = sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjUnPass).collect(Collectors.toList()));
            BigDecimal dkmjPass = sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjPass).collect(Collectors.toList()));
            BigDecimal dkmjWs = sumBigDecimalList(tempInfos.stream().map(tempInfo::getDkmjWs).collect(Collectors.toList()));

            BigDecimal gdmjHj = sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjHj).collect(Collectors.toList()));
            BigDecimal gdmjUnPass = sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjUnPass).collect(Collectors.toList()));
            BigDecimal gdmjPass = sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjPass).collect(Collectors.toList()));
            BigDecimal gdmjWs = sumBigDecimalList(tempInfos.stream().map(tempInfo::getGdmjWs).collect(Collectors.toList()));


            ExcelColData zj = new ExcelColData();
            zj.setMergeCell(true);
            zj.setBold(true);
            zj.setValue("总计");
            zj.setFontSize(11);
            zj.setStartRow(rowIndex);
            zj.setEndRow(rowIndex);
            zj.setStartCol(0);
            zj.setEndCol(2);
            zj.setTextLocation(EnumTextLocation.middle);
            zj.setColIndex(0);


            List<ExcelColData>zjCells = new ArrayList<>();
            zjCells.add(zj);

            List<Object>objs = new ArrayList<>();
            objs.add(countHj);
            objs.add(dkmjHj);
            objs.add(gdmjHj);
            objs.add(countUnPass);
            objs.add(dkmjUnPass);
            objs.add(gdmjUnPass);
            objs.add(countPass);
            objs.add(dkmjPass);
            objs.add(gdmjPass);
            objs.add(countWs);
            objs.add(dkmjWs);
            objs.add(gdmjWs);
            int colIndex = 3;
            for(Object obj:objs)
            {
                ExcelColData c = new ExcelColData();
                c.setMergeCell(false);
                c.setBold(true);
                c.setValue(obj.toString());
                c.setFontSize(11);
                c.setStartRow(rowIndex);
                c.setEndRow(rowIndex);
                c.setStartCol(colIndex);
                c.setEndCol(colIndex);
                c.setTextLocation(EnumTextLocation.middle);
                c.setColIndex(colIndex);
                colIndex++;
                zjCells.add(c);
            }
            ExcelRowData excelRowZj = new ExcelRowData();
            excelRowZj.setColDataList(zjCells);
            excelRowZj.setRowIndex(rowIndex);
            rows.add(excelRowZj);
            rowIndex++;

            //ExcelUtil.write(excelSheet,rows);
            //rows.clear();


           Map<String,List<tempInfo>>mapTemps = tempInfos.stream().collect(Collectors.groupingBy(tempInfo::getSmc,LinkedHashMap::new,Collectors.toList()));
           int xh=0;
           for(Map.Entry<String,List<tempInfo>>map:mapTemps.entrySet())
           {

               boolean mark=false;
               xh++;
               List<tempInfo>temps = map.getValue();
               for(tempInfo t:temps)
               {
                   colIndex=0;
                   objs.clear();
                   objs.add(xh+map.getKey());
                   objs.add(t.getXdm());
                   objs.add(t.getXmc());
                   objs.add(t.getCountHj());
                   objs.add(t.getDkmjHj());
                   objs.add(t.getGdmjHj());
                   objs.add(t.getCountUnPass());
                   objs.add(t.getDkmjUnPass());
                   objs.add(t.getGdmjUnPass());
                   objs.add(t.getCountPass());
                   objs.add(t.getDkmjPass());
                   objs.add(t.getGdmjPass());
                   objs.add(t.getCountWs());
                   objs.add(t.getDkmjWs());
                   objs.add(t.getGdmjWs());
                   List<ExcelColData>cells = new ArrayList<>();
                   int i=0;
                   for(Object obj:objs)
                   {
                       i++;
                       if(i==1&&!mark)
                       {
                           mark=true;
                           ExcelColData c = new ExcelColData();
                           c.setMergeCell(temps.size()>1);
                           c.setBold(false);
                           c.setValue(obj.toString());
                           c.setFontSize(11);
                           c.setStartRow(rowIndex);
                           c.setEndRow(temps.size()+rowIndex-1);
                           c.setStartCol(colIndex);
                           c.setEndCol(colIndex);
                           c.setTextLocation(EnumTextLocation.middle);
                           c.setColIndex(colIndex);
                           cells.add(c);
                       }
                       else {
                           ExcelColData c = new ExcelColData();
                           c.setMergeCell(false);
                           c.setBold(false);
                           c.setValue(obj.toString());
                           c.setFontSize(11);
                           c.setStartRow(rowIndex);
                           c.setEndRow(rowIndex);
                           c.setStartCol(colIndex);
                           c.setEndCol(colIndex);
                           c.setTextLocation(EnumTextLocation.middle);
                           c.setColIndex(colIndex);

                           cells.add(c);
                       }
                       colIndex++;
                   }
                   ExcelRowData excelRow = new ExcelRowData();
                   excelRow.setColDataList(cells);
                   excelRow.setRowIndex(rowIndex);
                   rows.add(excelRow);
                   rowIndex++;
               }

               //ExcelUtil.write(excelSheet,rows);
               //rows.clear();

               countHj = temps.stream().mapToInt(t->t.countHj).sum();
               countUnPass = temps.stream().mapToInt(t->t.countUnPass).sum();
               countPass = temps.stream().mapToInt(t->t.countPass).sum();
               countWs = temps.stream().mapToInt(t->t.countWs).sum();

               dkmjHj = sumBigDecimalList(temps.stream().map(tempInfo::getDkmjHj).collect(Collectors.toList()));
               dkmjUnPass = sumBigDecimalList(temps.stream().map(tempInfo::getDkmjUnPass).collect(Collectors.toList()));
               dkmjPass = sumBigDecimalList(temps.stream().map(tempInfo::getDkmjPass).collect(Collectors.toList()));
               dkmjWs = sumBigDecimalList(temps.stream().map(tempInfo::getDkmjWs).collect(Collectors.toList()));

               gdmjHj = sumBigDecimalList(temps.stream().map(tempInfo::getGdmjHj).collect(Collectors.toList()));
               gdmjUnPass = sumBigDecimalList(temps.stream().map(tempInfo::getGdmjUnPass).collect(Collectors.toList()));
               gdmjPass = sumBigDecimalList(temps.stream().map(tempInfo::getGdmjPass).collect(Collectors.toList()));
               gdmjWs = sumBigDecimalList(temps.stream().map(tempInfo::getGdmjWs).collect(Collectors.toList()));


               objs.clear();
               objs.add(xh+map.getKey()+" 汇总");
               objs.add(countHj);
               objs.add(dkmjHj);
               objs.add(gdmjHj);
               objs.add(countUnPass);
               objs.add(dkmjUnPass);
               objs.add(gdmjUnPass);
               objs.add(countPass);
               objs.add(dkmjPass);
               objs.add(gdmjPass);
               objs.add(countWs);
               objs.add(dkmjWs);
               objs.add(gdmjWs);
               colIndex = 3;
               List<ExcelColData>cells = new ArrayList<>();
               int i=0;
               for(Object obj:objs)
               {
                   i++;
                   if(i==1)
                   {
                       ExcelColData c = new ExcelColData();
                       c.setMergeCell(true);
                       c.setBold(true);
                       c.setValue(obj.toString());
                       c.setFontSize(11);
                       c.setStartRow(rowIndex);
                       c.setEndRow(rowIndex);
                       c.setStartCol(0);
                       c.setEndCol(2);
                       c.setTextLocation(EnumTextLocation.middle);
                       c.setColIndex(0);
                       cells.add(c);
                   }
                   else {
                       ExcelColData c = new ExcelColData();
                       c.setMergeCell(false);
                       c.setBold(true);
                       c.setValue(obj.toString());
                       c.setFontSize(11);
                       c.setStartRow(rowIndex);
                       c.setEndRow(rowIndex);
                       c.setStartCol(colIndex);
                       c.setEndCol(colIndex);
                       c.setTextLocation(EnumTextLocation.middle);
                       c.setColIndex(colIndex);
                       colIndex++;
                       cells.add(c);
                   }
               }
               ExcelRowData excelRow = new ExcelRowData();
               excelRow.setColDataList(cells);
               excelRow.setRowIndex(rowIndex);
               rows.add(excelRow);
               rowIndex++;

               //ExcelUtil.write(excelSheet,rows);
               //rows.clear();
           }
        }
        ExcelUtil.write(excelSheet, rows);
        rows.clear();
        String report = tempDir + File.separator + task.getId()+"_"+System.currentTimeMillis()+ ".xlsx";
        FileOutputStream os = null;
        try {
            File file = new File(report);
            os = new FileOutputStream(file);
            excelWorkBook.write(os);
        }
        catch (Exception ex)
        {
            logger.error("保存excel到本地异常"+ ExceptionUtil.getErrorString(ex));
        }
        finally {
            if(os!=null)
            {
                os.close();
            }
            if(excelWorkBook!=null) {
                excelWorkBook.close();
            }
        }
        return report;
    }

    private String getDetail(List<Map<String,Object>>maps,List<Map<String,Object>>mapWj,TskTaskBiz task,String dkbhField,String dkmjField,String gdmjField,String yjjbntmjField,String sjhfxpdField,String qxzgqkField,String sjrdzgqkField,String sjrdzgbzField,Date wjTime) throws Exception
    {
        List<ExcelRowData> rows = new ArrayList<>();


        SXSSFWorkbook excelWorkBook = ExcelUtil.CreateSXSSExcel();
        Sheet excelSheet = ExcelUtil.createSheet(excelWorkBook, "当天");
        List<Integer> colWidth = new ArrayList<>();
        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(40);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(60);

        for (int i = 0; i < colWidth.size(); i++) {
            excelSheet.setColumnWidth(i, colWidth.get(i) * 200);
        }
        int rowIndex = 0;
        int colIndex = 0;
        List<String>headers = new ArrayList<>();
        headers.add("市级代码");
        headers.add("市级名称");
        headers.add("县级代码");
        headers.add("县级名称");
        headers.add("地块编号");
        headers.add("面积（亩）");
        headers.add("耕地（亩）");
        headers.add("基本农田（亩）");
        headers.add("省级合法性判定");
        headers.add("区县整改情况");
        headers.add("通过情况标记");
        headers.add("省级认定整改情况");
        headers.add("市级审核通过时间");
        headers.add("省级审核处理时间");
        headers.add("图斑状态");
        headers.add("审核意见（省级认定整改备注）");
        List<ExcelColData> row1 = new ArrayList<>();
        for(String h:headers) {
            ExcelColData title = new ExcelColData();
            title.setMergeCell(false);
            title.setBold(false);
            title.setValue(h);
            title.setFontSize(10);
            title.setStartRow(rowIndex);
            title.setEndRow(rowIndex);
            title.setStartCol(colIndex);
            title.setEndCol(colIndex);
            title.setTextLocation(EnumTextLocation.middle);
            title.setColIndex(colIndex);
            colIndex++;
            row1.add(title);
        }
        ExcelRowData excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(row1);
        excelRow1.setRowIndex(rowIndex);
        rows.add(excelRow1);

        rowIndex++;
        List<TaskStatisticalDayWj>wjs = new ArrayList<>();
        Date now = new Date();

        for(Map map:maps)
        {
            colIndex=0;
            List<String>cells = new ArrayList<>();
            String id = getString(map,"f_id");
            String approve =getString(map,"f_approve");
            if("未审核".equals(approve)) {
                TaskStatisticalDayWj wj = new TaskStatisticalDayWj();
                wj.setTaskId(task.getId());
                wj.setTbid(id);
                long count = taskStatisticalDayWjDao.gwSearchCount(wj);
                if (count == 0) {

                    wj.setId(UUID.randomUUID().toString());
                    wj.setCreateTime(now);
                    wj.setWjTime(wjTime);
                    wjs.add(wj);
                }
            }


            cells.add(getString(map,"f_xzqdmcity"));
            cells.add(getString(map,"f_xzqmccity"));
            cells.add(getString(map,"f_xzqdmcounty"));
            cells.add(getString(map,"f_xzqmccounty"));
            cells.add(getString(map,dkbhField));
            cells.add(getString(map,dkmjField));
            cells.add(getString(map,gdmjField));
            cells.add(getString(map,yjjbntmjField));
            cells.add(getString(map,sjhfxpdField));
            cells.add(getString(map,qxzgqkField));
            cells.add(approve);
            cells.add(getString(map,sjrdzgqkField));
            cells.add(getString(map,"f_city_time"));
            cells.add(getString(map,"f_province_time"));
            cells.add(getString(map,"f_state"));
            cells.add(getString(map,sjrdzgbzField));
            List<ExcelColData> row2 = new ArrayList<>();
            for(String h:cells) {
                ExcelColData title = new ExcelColData();
                title.setMergeCell(false);
                title.setBold(false);
                title.setValue(h);
                title.setFontSize(10);
                title.setStartRow(rowIndex);
                title.setEndRow(rowIndex);
                title.setStartCol(colIndex);
                title.setEndCol(colIndex);
                title.setTextLocation(EnumTextLocation.middle);
                title.setColIndex(colIndex);
                if(h.equals("未审核"))
                {
                    title.setColor(HSSFColor.HSSFColorPredefined.LIGHT_YELLOW.getIndex());
                }
                colIndex++;
                row2.add(title);
            }
            ExcelRowData excelRow2 = new ExcelRowData();
            excelRow2.setColDataList(row2);
            excelRow2.setRowIndex(rowIndex);
            rows.add(excelRow2);
            rowIndex++;

        }
        if(!wjs.isEmpty())
        {
            taskStatisticalDayWjDao.insertBatch(wjs);
        }
        ExcelUtil.write(excelSheet,rows);
        rows.clear();


        colWidth.clear();
        Sheet excelWj = ExcelUtil.createSheet(excelWorkBook, "历史未结");

        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(20);
        colWidth.add(40);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(30);
        colWidth.add(60);
        colWidth.add(30);
        for (int i = 0; i < colWidth.size(); i++) {
            excelWj.setColumnWidth(i, colWidth.get(i) * 200);
        }
        rowIndex = 0;
        colIndex = 0;
        headers.clear();

        headers.add("市级代码");
        headers.add("市级名称");
        headers.add("县级代码");
        headers.add("县级名称");
        headers.add("地块编号");
        headers.add("面积（亩）");
        headers.add("耕地（亩）");
        headers.add("基本农田（亩）");
        headers.add("省级合法性判定");
        headers.add("区县整改情况");
        headers.add("通过情况标记");
        headers.add("省级认定整改情况");
        headers.add("市级审核通过时间");
        headers.add("省级审核处理时间");
        headers.add("图斑状态");
        headers.add("审核意见（省级认定整改备注）");
        headers.add("剩余情况");
        row1.clear();
        for(String h:headers) {
            ExcelColData title = new ExcelColData();
            title.setMergeCell(false);
            title.setBold(false);
            title.setValue(h);
            title.setFontSize(10);
            title.setStartRow(rowIndex);
            title.setEndRow(rowIndex);
            title.setStartCol(colIndex);
            title.setEndCol(colIndex);
            title.setTextLocation(EnumTextLocation.middle);
            title.setColIndex(colIndex);
            colIndex++;
            row1.add(title);
        }
        excelRow1 = new ExcelRowData();
        excelRow1.setColDataList(row1);
        excelRow1.setRowIndex(rowIndex);
        rows.add(excelRow1);

        rowIndex++;

        for(Map map:mapWj)
        {
            colIndex=0;
            List<String>cells = new ArrayList<>();
            cells.add(getString(map,"f_xzqdmcity"));
            cells.add(getString(map,"f_xzqmccity"));
            cells.add(getString(map,"f_xzqdmcounty"));
            cells.add(getString(map,"f_xzqmccounty"));
            cells.add(getString(map,dkbhField));
            cells.add(getString(map,dkmjField));
            cells.add(getString(map,gdmjField));
            cells.add(getString(map,yjjbntmjField));
            cells.add(getString(map,sjhfxpdField));
            cells.add(getString(map,qxzgqkField));
            cells.add(getString(map,"f_approve"));
            cells.add(getString(map,sjrdzgqkField));
            cells.add(getString(map,"f_city_time"));
            cells.add(getString(map,"f_province_time"));
            cells.add(getString(map,"f_state"));
            cells.add(getString(map,sjrdzgbzField));
            cells.add(getString(map,"f_wj_time"));
            List<ExcelColData> row2 = new ArrayList<>();
            for(String h:cells) {
                ExcelColData title = new ExcelColData();
                title.setMergeCell(false);
                title.setBold(false);
                title.setValue(h);
                title.setFontSize(10);
                title.setStartRow(rowIndex);
                title.setEndRow(rowIndex);
                title.setStartCol(colIndex);
                title.setEndCol(colIndex);
                title.setTextLocation(EnumTextLocation.middle);
                title.setColIndex(colIndex);
                colIndex++;
                row2.add(title);
            }
            ExcelRowData excelRow2 = new ExcelRowData();
            excelRow2.setColDataList(row2);
            excelRow2.setRowIndex(rowIndex);
            rows.add(excelRow2);
            rowIndex++;
        }
        ExcelUtil.write(excelWj,rows);
        rows.clear();



        String report = tempDir + File.separator + task.getId()+"_"+System.currentTimeMillis()+ ".xlsx";
        FileOutputStream os = null;
        try {
            File file = new File(report);
            os = new FileOutputStream(file);
            excelWorkBook.write(os);
        }
        catch (Exception ex)
        {
            logger.error("保存excel到本地异常"+ ExceptionUtil.getErrorString(ex));
        }
        finally {
            if(os!=null)
            {
                os.close();
            }
            if(excelWorkBook!=null) {
                excelWorkBook.close();
            }
        }
        return report;
    }
    private class tempInfo
    {
        private String smc;
        private String xdm;
        private String xmc;

        private Integer countHj;
        private BigDecimal dkmjHj;
        private BigDecimal gdmjHj;


        private Integer countWs;
        private BigDecimal dkmjWs;
        private BigDecimal gdmjWs;

        private Integer countPass;
        private BigDecimal dkmjPass;
        private BigDecimal gdmjPass;


        private Integer countUnPass;
        private BigDecimal dkmjUnPass;
        private BigDecimal gdmjUnPass;

        public String getSmc() {
            return smc;
        }

        public void setSmc(String smc) {
            this.smc = smc;
        }

        public String getXdm() {
            return xdm;
        }

        public void setXdm(String xdm) {
            this.xdm = xdm;
        }

        public String getXmc() {
            return xmc;
        }

        public void setXmc(String xmc) {
            this.xmc = xmc;
        }

        public Integer getCountHj() {
            return countHj;
        }

        public void setCountHj(Integer countHj) {
            this.countHj = countHj;
        }

        public BigDecimal getDkmjHj() {
            return dkmjHj;
        }

        public void setDkmjHj(BigDecimal dkmjHj) {
            this.dkmjHj = dkmjHj;
        }

        public BigDecimal getGdmjHj() {
            return gdmjHj;
        }

        public void setGdmjHj(BigDecimal gdmjHj) {
            this.gdmjHj = gdmjHj;
        }

        public Integer getCountWs() {
            return countWs;
        }

        public void setCountWs(Integer countWs) {
            this.countWs = countWs;
        }

        public BigDecimal getDkmjWs() {
            return dkmjWs;
        }

        public void setDkmjWs(BigDecimal dkmjWs) {
            this.dkmjWs = dkmjWs;
        }

        public BigDecimal getGdmjWs() {
            return gdmjWs;
        }

        public void setGdmjWs(BigDecimal gdmjWs) {
            this.gdmjWs = gdmjWs;
        }

        public Integer getCountPass() {
            return countPass;
        }

        public void setCountPass(Integer countPass) {
            this.countPass = countPass;
        }

        public BigDecimal getDkmjPass() {
            return dkmjPass;
        }

        public void setDkmjPass(BigDecimal dkmjPass) {
            this.dkmjPass = dkmjPass;
        }

        public BigDecimal getGdmjPass() {
            return gdmjPass;
        }

        public void setGdmjPass(BigDecimal gdmjPass) {
            this.gdmjPass = gdmjPass;
        }

        public Integer getCountUnPass() {
            return countUnPass;
        }

        public void setCountUnPass(Integer countUnPass) {
            this.countUnPass = countUnPass;
        }

        public BigDecimal getDkmjUnPass() {
            return dkmjUnPass;
        }

        public void setDkmjUnPass(BigDecimal dkmjUnPass) {
            this.dkmjUnPass = dkmjUnPass;
        }

        public BigDecimal getGdmjUnPass() {
            return gdmjUnPass;
        }

        public void setGdmjUnPass(BigDecimal gdmjUnPass) {
            this.gdmjUnPass = gdmjUnPass;
        }
    }
    private String getString(Map map,String key)
    {
       return map.get(key)!=null?map.get(key).toString():"";
    }
    private BigDecimal getBigDecimal(Map map,String key)
    {
        String v = map.get(key)!=null?map.get(key).toString():"0";
        BigDecimal decimal = new BigDecimal(v);
        return decimal;
    }
    public static BigDecimal sumBigDecimalList(List<BigDecimal> list) {
        BigDecimal sum = BigDecimal.ZERO;
        for (BigDecimal number : list) {
            sum = sum.add(number);
        }
        return sum;
    }
}
