package com.geoway.landteam.landcloud.service.thirddata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.servface.datacq.OutworkProofService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * FileName: GtzzService.java
 * Author:   leo
 * Date:     2021/11/5 17:14
 * Description:
 */
@Service
public class GtzzDataService {


    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private OutworkProofService outworkService;

    private List<String> whiteList = new ArrayList<String>(){{
        add("bsm");
        add("sddl");
        add("bgfw");
        add("dsfzw");
        add("sdzkbz");
    }};
    private List<String> blackList = new ArrayList<String>(){{
    }};

    public Map<String, Object> getGtzzData(String bizid, String bsm){
        Map<String, Object> result = new HashMap<>();
        TskTaskBiz biz = tskTaskBizService.getTskTaskBizById(bizid);
        TbtskObjectinfo object= tbtskObjectinfoService.getObjectbyID(biz.getTableId());

        Map<String, Object> map = dataBizService.selectByID(object.getfTablename(), "f_bsm", "'"+bsm+"'");
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        String tbid = "";
        while (iterator.hasNext()){
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            if("f_id".equals(key)){
                tbid = (String) next.getValue();
            }
            if(key.startsWith("f_")){
                key = key.substring(2);
            }
            if(!whiteList.isEmpty()){
                if(whiteList.contains(key)){
                    result.put(key, next.getValue());
                }
            }else if(!blackList.isEmpty()){
                if(!blackList.contains(key)){
                    result.put(key, next.getValue());
                }
            }
        }
        List<String> list = new ArrayList<>();
        list.add(tbid);
        List<AppMedia> medias = outworkService.getMediaList(list);
        JSONArray jsonArray = new JSONArray();
        for(AppMedia media : medias){
            JSONObject json = new JSONObject();
            json.put("url", media.getServerpath());
            json.put("time",media.getTime());
            json.put("lon",media.getLon());
            json.put("lat",media.getLat());
            json.put("type",media.getType());
            json.put("azimuth",media.getAzimuth());
            json.put("pitch",media.getPitch());
            jsonArray.add(json);
        }
        result.put("medias",jsonArray);
        return result;

    }
}