package com.geoway.landteam.landcloud.service.thirddata;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.TbAttachFile;
import com.geoway.landteam.landcloud.repository.pub.AttachFileRepository;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * FileName: TbAttachFileService.java
 * Author:   author
 * Date:     2020/9/15 19:54
 * Description:
 */
@Service("tbAttachFileService")
public class TbAttachFileService {

    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Value("${project.import.media}")
    protected String mediaFolder;
    @Value("${project.applicationType}")
    protected String applicationType;

    @Autowired
    AttachFileRepository attachFileRepository;

    @Autowired
    private DefaultOssOperatorService stsService;

    public TbAttachFile findByTaskIdAndTbId(String taskId, String tbId) {
        return attachFileRepository.findByTaskIdAndTbId(taskId, tbId);
    }


    public TbAttachFile findOne(String id) {

        return attachFileRepository.findById(id).orElse(null);
    }

    public void deletById(String id){
        attachFileRepository.deleteById(id);
    }

    public TbAttachFile findByTaskId(String taskId) {
        return attachFileRepository.findByTaskId(taskId);
    }


    public List<String> uploadTaskFile(HttpServletRequest request, String taskId, String tbId, Long userId, int level) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> result = new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile multipartFile = multiRequest.getFile(iter.next());
                if (multipartFile != null) {
                    String multipartFileName = multipartFile.getOriginalFilename();
                    File zipFile = null;
                    File dir = new File(uploadDir + "/attachfile");
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }

                    //zipFile = File.createTempFile("tmp", multipartFileName.substring(multipartFileName.lastIndexOf("."), multipartFileName.length()), dir);
                    zipFile = new File(dir + "/" + multipartFileName);
                    FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), zipFile);
                    String zipName = zipFile.getAbsolutePath();

                    String url = this.uploadFileToCloudDisk(userId, zipName, multipartFileName);
                    /*String url = zipName;*/
                        //删除
                    FileUtils.deleteQuietly(zipFile);

                    TbAttachFile attachFile;
                    if (level == 0) {
                        attachFile = this.findByTaskId(taskId);
                    } else {
                        attachFile = this.findByTaskIdAndTbId(taskId, tbId);
                    }

                    String fileName = multipartFileName;
                    Integer type = getFileType(fileName);
                    if (type > 2) {
                        throw new RuntimeException("不支持文件类型");
                    }
                    if (attachFile != null) {
                        attachFile.setFileName(fileName);
                        attachFile.setType(type);
                        attachFile.setUrl(url);

                    } else {
                        attachFile = new TbAttachFile(
                                taskId, tbId, url, fileName, new Date(), userId, type, level
                        );
                    }
                    attachFileRepository.save(attachFile);
                }
            }
        }
        return result;
    }

    private Integer getFileType(String fileName) {

        String subfix = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();

        String img = "bmp,jpg,png,gif,svg,raw,webp,jpeg";
        String zip = "zip,rar";
        String pdf = "pdf";


        if (img.contains(subfix)) {
            return 0;
        } else if (pdf.contains(subfix)) {
            return 1;
        } else if (zip.contains(subfix)) {
            return 2;
        }else{
            return 3;
        }

    }


    /**
     * 上传到云盘
     *
     * @param userId
     * @param filePath
     * @param fileName
     * @return
     */
    public String uploadFileToCloudDisk(Long userId, String filePath, String fileName) throws IOException {
        if ("lan".equals(this.applicationType)) {
            String newMediaPath = this.mediaFolder + File.separator + "media" + File.separator + "attachFile"+ File.separator + userId;
            File file = new File(newMediaPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            FileUtil.copyFile(filePath, newMediaPath + File.separator + fileName);
            return File.separator + "attachFile"+ File.separator + userId + File.separator + fileName;
        } else {
            String sendObjName = "attachfile/upload/" + userId + "/" + fileName;
            // 上传到obs
            String resultUrl = stsService.sendObject2Oss(sendObjName, filePath);
            return resultUrl;
        }
    }

    public List<String> uploadMultiTaskFile(HttpServletRequest request, String bizId, String tbId, Long userId, int level) throws Exception{
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<String> result = new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile multipartFile = multiRequest.getFile(iter.next());
                if (multipartFile != null) {
                    String multipartFileName = multipartFile.getOriginalFilename();
                    File zipFile = null;
                    File dir = new File(uploadDir + "/attachfile");
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }

                    //zipFile = File.createTempFile("tmp", multipartFileName.substring(multipartFileName.lastIndexOf("."), multipartFileName.length()), dir);
                    zipFile = new File(dir + "/" + multipartFileName);
                    FileUtils.copyInputStreamToFile(multipartFile.getInputStream(), zipFile);
                    String zipName = zipFile.getAbsolutePath();
                    String url = this.uploadFileToCloudDisk(userId, zipName, multipartFileName);
                    /*String url = zipName;*/
                    //删除
                    FileUtils.deleteQuietly(zipFile);

                    TbAttachFile attachFile = new TbAttachFile();
                    Integer type = getFileType(multipartFileName);

                    attachFile = new TbAttachFile(
                            bizId, tbId, url, multipartFileName, new Date(), userId, type, level
                    );
                    attachFileRepository.save(attachFile);
                }
            }
        }
        return result;
    }

    public List<TbAttachFile> findMultiByTaskIdAndTbId(String bizId, String tbId) {
        return attachFileRepository.findMultiByTaskIdAndTbId(bizId, tbId);
    }

    public String getPathById(String id) {
        TbAttachFile file = this.attachFileRepository.findById(id).orElse(null);
        if (file == null){
            return null;
        }
        String path = file.getUrl();
        return this.mediaFolder + path;
    }
}