package com.geoway.landteam.landcloud.service.thirddata.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.servface.thirddata.ThirdDataImportService;
import com.geoway.landteam.landcloud.service.thirddata.template.AbstractThirdDataImportTemplate;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.locationtech.jts.geom.Geometry;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * Created by hanhaitao on 2021/12/8.
 */

//策略工厂的类型名称
@Service(ThirdDataImportService.SERVICE_PREFIX + "GTZZ_YDFK")
public class GtzzYdfkImportServiceImpl extends AbstractThirdDataImportTemplate {

    GiLoger logger = GwLoger.getLoger(GtzzYdfkImportServiceImpl.class);


    private final static String APPLICATIONCODE = "GZZZ_YDFK";
    private final  static String TASK_NAME_PATTERN = "农村建设用地复垦项目";
    private String taskId;
    private String tbid;

    @Override
    public TbtskApplicationApi getApplicationConfig() {
        return null;
    }

    @Override
    public String getTaskId() {
        return  taskId;
    }

    @Override
    public String getTbid() {
        return tbid;
    }

    @Override
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public void setTbid(String tbid) {
        this.tbid = tbid;
    }

    @Override
    protected  String[] getApiConfig()throws Exception{
        return ApiNameType.gtzz_ydfk;
    }
    @Override
    public String getApplicationCode() {
        return APPLICATIONCODE;
    }

    @Override
    protected void customFieldFormat(JSONObject data, Map<String, Object> map) throws Exception {

    }

    @Override
    public JSONArray formatData(String jsonStr, TbtskApplicationApi applicationApi) throws Exception {
        jsonStr = jsonStr.trim().replaceAll("^\\{","[{").replaceAll("\\}$","}]");
        JSONArray array = JSONArray.parseArray(jsonStr);
        JSONArray result = new JSONArray();
        for (int i = 0; i < array.size(); i++) {
            JSONObject object = array.getJSONObject(i);
            JSONObject json = object.getJSONObject("properties");
            Geometry geometry = GeoUtils.geojsonToGeom(object.toJSONString());
            json.put("shape",geometry.toString());
            result.add(json);
        }
        return result;
    }

    @Override
    public String createTaskName(JSONObject data) {
        String xzqmc =  data.getString("行政区名称");
        int year = new Date().getYear();
        return String.valueOf(year + 1900) + "年" + xzqmc + TASK_NAME_PATTERN;
    }

    @Override
    public Long getUserId(JSONObject data) {
        return 1015L;
    }

    @Override
    public String getXzqdm(JSONObject data) {
        return data.getString("行政区代码");
    }
//    private String queryExistTaskId(ConfigClass config){
//        return queryExistTaskId(2021,"","");
//    }
}
