package com.geoway.landteam.landcloud.service.thirddata.impl;

import com.geoway.landteam.landcloud.service.thirddata.utils.SqlUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportMessageService;
import com.geoway.landteam.landcloud.servface.thirddata.KflyRcxcService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.*;

/**
 * 日常巡查任务无f_xmid字段，将父图斑f_id赋值到f_xmid
 * Created by licong on 2022/4/26.
 */
@Service
public class KflyRcxcServiceImpl implements KflyRcxcService {

   /* @Value("#{imeSettings['project.minioModel']}")*/
    @Value("${project.minioModel:}")
    protected String minioModel;
 /*   @Value("#{imeSettings['project.mediaUrlPrefix']}")*/
    @Value("${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private ExportDataService exportDataService;
  /*  @Autowired
    private TbtskTaskBizRepository bizRepository;*/
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TaskResouceService taskResouceService;
    /*@Autowired
    private MinIOService minIOService;*/
    @Autowired
    private LogService logService;
    @Autowired
    private ImportMessageService importMessageService;

    /**
     * 内网下发
     * @param parentId
     */
    public void sign(String parentId) throws Exception {
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        //关联数据
//        Boolean hasXmid = this.hasXmid(parentTableObj.getfTablename(), parentId);
//        if (!hasXmid)
            this.findChild(parentTableObj.getfTablename(), childTableObj.getfTablename(), parentId);
        //1，复制数据到下发表
        this.copyData(toParentTableObj.getfTablename(), parentTableObj.getfTablename(), parentId);
        //修改下发表主键
        Map<String, String> parentIdMap = this.changeId(toParentTableObj.getfTablename(), parentId, null);
        List<String> childIds = this.getChildId(parentTableObj.getfTablename(), parentId, childTableObj.getfTablename());
        if (null != childIds && !childIds.isEmpty()) {
            this.copyData(toChildTableObj.getfTablename(), childTableObj.getfTablename(), StringUtils.join(childIds, ","));
            this.changeId(toChildTableObj.getfTablename(), StringUtils.join(childIds, ","), parentIdMap.get(parentId));
        }

      /*  //3，下发数据
        TbtskTaskBiz task = this.bizRepository(toParentTableObj.getfId());
        ExportDataThread thread = new ExportDataThread(this.exportDataService, task.getId(), parentIdMap.get(parentId), null, false);
        this.threadPoolTaskExecutor.execute(thread);*/
    }

    /**
     * 如果f_xmid为空，则没有关联过数据
     * @param parentTable
     * @param parentId
     * @return
     */
    private Boolean hasXmid(String parentTable, String parentId){
        String sql = "select f_id from " + parentTable + " where f_id = '" + parentId + "' and f_xmid is null";
        List data = this.jdbcTemplate.queryForList(sql);
        if (data.isEmpty())
            return true;
        else
            return false;
    }

    /**
     * 通过母图斑范围查找子图斑，并关联，内网表关联
     */
    private void findChild(String parentTable, String childTable, String parentId){
        String xmidsql = "update " + parentTable + " set f_xmid = f_id where f_id = '" + parentId + "' and f_xmid is null";
        this.jdbcTemplate.execute(xmidsql);
        String sql = "update " + childTable + " t1 set f_xmid = t2.f_id from " + parentTable + " t2 where ST_Contains(t2.f_shape, t1.f_shape) and t1.f_xmid is null";
        this.jdbcTemplate.execute(sql);
    }

    /**
     * 复制数据
     * @param toTable
     * @param fromTable
     * @param fromIds
     */
    private void copyData(String toTable, String fromTable, String fromIds){
        String sql = "insert into " + toTable + " select * from " + fromTable + " where f_id in (" + SqlUtil.getInSql(fromIds) + ")";
        this.jdbcTemplate.execute(sql);
    }

    /**
     * 修改主键，避免二次下发时复制数据错误
     * 同时更新创建时间，该时间可作为下发时间使用
     * @param tablename
     * @param ids
     * @param parentid
     * @return
     */
    private Map<String, String> changeId(String tablename, String ids, String parentid){
        Map<String, String> resultMap = new HashMap<>();
        List<String> oldIdList = Arrays.asList(ids.split(","));
        Long time = System.currentTimeMillis();
        oldIdList.forEach(obj -> {
            String newId = UUID.randomUUID().toString();
            String sql = "";
            if (StringUtils.isEmpty(parentid)) {
                sql = "update " + tablename + " set f_id = '" + newId + "', f_xmid = '" + newId + "', f_createtime = '" + time + "' where f_id  = '" + obj + "' ;";
            } else {
                sql = "update " + tablename + " set f_id = '" + newId + "', f_xmid = '" + parentid + "', f_createtime = '" + time + "' where f_id  = '" + obj + "' ;";
            }
            this.jdbcTemplate.execute(sql);
            resultMap.put(obj, newId);
        });
        return resultMap;
    }

    /**
     * 获取主表关联的子表数据主键
     * @param parentTablename
     * @param parentId
     * @param childTablename
     * @return
     */
    private List<String> getChildId(String parentTablename, String parentId, String childTablename) {
        String sql = "select f_id from " + childTablename + " where f_xmid = '" + parentId + "'";
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        if (list.isEmpty())
            return null;
        List<String> result = new ArrayList<>();
        list.forEach(obj -> {
            result.add((String) obj.get("f_id"));
        });
        return result;
    }
    /**
     * 获取日常巡查列表
     * @param page
     * @param size
     * @return
     */
    public List<Map<String, Object>> queryRcxcList(Integer page,Integer size,String whereSQL){
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        //关联数据
        String sql = "select * from (select a.f_id as id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,MAX(b.f_createtime) as f_createtime,count(b.f_jsztlx) AS xccs,a.f_xmid,MAX(b.f_jsztlx) as jsztlx,MAX(b.f_jsztdm) as f_jsztdm,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx from " + parentTableObj.getfTablename() + " a left join " + toParentTableObj.getfTablename() + " b on a.f_dzjgh = b.f_dzjgh GROUP BY id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,a.f_xmid,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx order by a.f_xmid) foo"+whereSQL+" limit "+size+" offset "+page*size;
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        return data;
    }
    /**
     * 根据id获取日常巡查基本信息
     * @return
     */
    public Map<String, Object> queryDataById(String id){
        Map<String, Object> result = new HashMap<>();
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        //关联数据
        String sql = "select * from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map<String, Object> baseData = this.jdbcTemplate.queryForMap(sql);
        //关联数据
        String shpSql = "select st_astext(f_shape) as shape from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map<String, Object> shpData = this.jdbcTemplate.queryForMap(shpSql);
        baseData.remove("f_shape");
        result.put("base",baseData);
        result.put("shape",shpData);
        Object dzjgh = baseData.get("f_dzjgh");
        Object xmid = baseData.get("f_xmid");
        System.out.println(dzjgh);
        if(xmid!=null){
            String dzjghStr = dzjgh.toString();
            //楼栋信息
            String ldSql = "select f_bjbh,f_dh,f_gcxkzh,f_qfrq,f_jsdw,f_wh,f_cs from " + childTableObj.getfTablename() + " where f_xmid = '" + xmid.toString() + "'";
            List<Map<String, Object>> ldData = this.jdbcTemplate.queryForList(ldSql);
            //建设巡查信息
            String jsxcSql = "select * from " + toParentTableObj.getfTablename() + " where f_dzjgh = '" + dzjghStr + "'";
            List<Map<String, Object>> jsxcData = this.jdbcTemplate.queryForList(jsxcSql);
            for(Map<String, Object> jsxcitem : jsxcData){
                //附件信息
                List<Map<String, Object>> zpList = queryFileById(jsxcitem.get("f_id").toString(),".jpg");
                jsxcitem.put("xczp",zpList);
                List<Map<String, Object>> spList = queryFileById(jsxcitem.get("f_id").toString(),".mp4");
                jsxcitem.put("xcsp",spList);
            }
            if(jsxcData.size()>0) {
                //楼栋巡查信息
                String chXmid = jsxcData.get(0).get("f_xmid").toString();
                String ldxcSql = "select * from " + toChildTableObj.getfTablename() + " where f_xmid = '" + chXmid + "'";
                List<Map<String, Object>> ldxcData = this.jdbcTemplate.queryForList(ldxcSql);
                for(Map<String, Object> ldxcitem : ldxcData){
                    List<Map<String, Object>> zpList = queryFileById(ldxcitem.get("f_id").toString(),".jpg");
                    ldxcitem.put("xczp",zpList);
                    List<Map<String, Object>> spList = queryFileById(ldxcitem.get("f_id").toString(),".mp4");
                    ldxcitem.put("xcsp",spList);
                }
                for (Map<String, Object> item : ldxcData) {
                    item.remove("f_shape");
                }
                result.put("ldxc",ldxcData);
            }
            for(Map<String, Object> item:jsxcData){
                item.remove("f_shape");
            }
            result.put("ld",ldData);
            result.put("jsxc",jsxcData);
        }
        return result;
    }


    /**
     * 根据id获取流转所需信息
     * @return
     */
    public JSONArray queryCirculationDataById(String id){
        JSONArray result = new JSONArray();
        JSONObject object0 = new JSONObject();
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        //关联数据
        String sql = "select * from " + parentTableObj.getfTablename() + " where f_id = '" + id + "'";
        Map<String, Object> baseData = this.jdbcTemplate.queryForMap(sql);
        baseData.remove("f_shape");
        Object dzjgh = baseData.get("f_dzjgh");
        Object xmid = baseData.get("f_xmid");
        System.out.println(dzjgh);
        if(xmid!=null){
            String dzjghStr = dzjgh.toString();
            //建设巡查信息
            String jsxcSql = "select * from " + toParentTableObj.getfTablename() + " where f_dzjgh = '" + dzjghStr + "' order by f_createtime desc limit 1";
            List<Map<String, Object>> jsxcData = this.jdbcTemplate.queryForList(jsxcSql);
            for(Map<String, Object> item:jsxcData){
                item.remove("f_shape");
                object0.put("data",JSONObject.parse(item.toString()));
            }
            result.add(object0);
            if(jsxcData.size()>0) {
                JSONObject objectld = new JSONObject();
                //楼栋巡查信息
                String chXmid = jsxcData.get(0).get("f_xmid").toString();
                String ldxcSql = "select * from " + toChildTableObj.getfTablename() + " where f_xmid = '" + chXmid + "'";
                List<Map<String, Object>> ldxcData = this.jdbcTemplate.queryForList(ldxcSql);
                for (Map<String, Object> item : ldxcData) {
                    item.remove("f_shape");
                    objectld.put("data",JSONObject.parse(item.toString()));
                    result.add(objectld);
                }
            }
        }
        return result;
    }

    /**
     * 根据id获取日常巡查附件信息
     * @return
     */
    public List<Map<String, Object>> queryFileById(String id,String type){
        String sql = "select * from tb_app_media where f_galleryid = '" + id + "' and f_serverpath like '%"+type+"'";
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        for(Map<String, Object> item:data){
            String path = item.get("f_serverpath").toString();
            item.put("id","1");
            item.put("serverpath","http://10.201.98.67:8090/"+path);
            item.put("username",item.get("f_username"));
            item.put("azimuth",item.get("f_azimuth"));
            item.put("time",item.get("f_time"));
            item.put("lat",item.get("f_lat"));
            item.put("lon",item.get("f_lon"));
            item.put("tablename",item.get("f_tablename"));

        }

        return data;
    }

    /**
     * 获取日常巡查数量
     * @return
     */
    public Long queryRcxcCount(String whereSQL){
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        //关联数据
        String sql = "select count(*) from (select a.f_id as id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,MAX(b.f_createtime) as f_createtime,count(b.f_jsztlx) AS xccs,a.f_xmid,MAX(b.f_jsztlx) as jsztlx,MAX(b.f_jsztdm) as f_jsztdm,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx from " + parentTableObj.getfTablename() + " a left join " + toParentTableObj.getfTablename() + " b on a.f_dzjgh = b.f_dzjgh GROUP BY id,a.f_dzjgh,a.f_xmmc,a.f_tdmj,a.f_srr,a.f_ydkgsj,a.f_xmid,a.f_sm,a.f_htbh,a.f_xzqdmsys,a.f_xmlx order by a.f_xmid) foo"+whereSQL;
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);

        return Long.valueOf(data.get(0).get("count").toString());
    }

    /**
     * 更新审核数据
     * @return
     */
    public void updateAudit(JSONArray arr){
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        //原始数据表
        TbtskObjectinfo parentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getTableid());
        TbtskObjectinfo childTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getTableid());
        //下发数据表
        TbtskObjectinfo toParentTableObj = this.objectinfoRepository.gwSearchByPK(parentApi.getAssigntotask());
        TbtskObjectinfo toChildTableObj = this.objectinfoRepository.gwSearchByPK(childApi.getAssigntotask());
        for(int i=0;i<arr.size();i++){
            JSONObject object = arr.getJSONObject(i);
            JSONObject obj = object.getJSONObject("data");
            String type = object.getString("type");
            String tableName = "";
            if(type.equals("jsztxc")){
                tableName = toParentTableObj.getfTablename();
            }else if(type.equals("ldxc")){
                tableName = toChildTableObj.getfTablename();
            }
            if(tableName.equals("")){
                return;
            }
            String sql = "update " + tableName + " set ";
            Iterator<String> iterator = (Iterator<String>) obj.keySet();
            while(iterator.hasNext()){
                String key = iterator.next();
                String value = obj.getString(key);
                if(key.contains("f_")&&!key.endsWith("sj")&&!key.endsWith("time")&&value!=null&&!value.equals("null")){
                    sql += key + " = '" + value + "',";
                }
            }
            sql = sql.substring(0,sql.length()-1) + " where f_id = '"+obj.get("f_id")+"'";
            int row = this.jdbcTemplate.update(sql);
            System.out.println(row);
        }

    }

    /**
     * 流转巡查数据
     * @return
     */
    public void resultCirculation(JSONArray arr){
        TbtskApplicationApi parentApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_gdxx[0], ApiNameType.kfly_gdxx[1]);
        TbtskApplicationApi childApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.kfly_jsydghxkz_zjl[0], ApiNameType.kfly_jsydghxkz_zjl[1]);
        String send = parentApi.getSend();
        if (StringUtils.isEmpty(send))//是否需要推送
            return;
        com.alibaba.fastjson.JSONObject sendConfig = com.alibaba.fastjson.JSONObject.parseObject(send);
        String configTableId = parentApi.getTableid();//查询关联数据需要使用，部分数据有多次外业的情况下，外网推送的任务objectinfo对应着api表的assigntotask字段
        Map<String, String> parentMapping = this.getFieldMapping(configTableId);
        Map<String, String> childMapping = this.getFieldMapping(childApi.getTableid());
        if (null == parentMapping)
            return;
        com.alibaba.fastjson.JSONArray sendArray = new com.alibaba.fastjson.JSONArray();
        com.alibaba.fastjson.JSONObject pObj = new com.alibaba.fastjson.JSONObject();
        JSONArray chidrenArray=new JSONArray();
        for(int i=0;i<arr.size();i++){
            JSONObject object = arr.getJSONObject(i);
            JSONObject tableObj = object.getJSONObject("data");
            if(i==0) {
                try {
                    pObj = this.getSendData(tableObj, parentMapping, sendConfig);
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }else{
                try {
                    chidrenArray.add(this.getSendData(tableObj, childMapping, sendConfig));
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        pObj.put("children", chidrenArray);
        sendArray.add(pObj);
        for (int i = 0; i < sendArray.size(); i++) {
            com.alibaba.fastjson.JSONObject sendObj = sendArray.getJSONObject(i);
            importMessageService.sendMessageByConfig(sendConfig, sendObj);
        }

    }

    private Map<String, String> getFieldMapping(String tableid){
        Map<String, String> mapping = null;
        try {
            mapping = this.taskResouceService.getFiledMap(tableid, "1");
        } catch (Exception e) {
            //没有映射不处理
            return null;
        }
        return mapping;
    }

//    private com.alibaba.fastjson.JSONArray sendData(String parentTablename,Map<String, String> fieldMapping, com.alibaba.fastjson.JSONObject sendConfig) throws SQLException {
//        com.alibaba.fastjson.JSONArray resultArray = new com.alibaba.fastjson.JSONArray();
//        String sql = "select * from " + parentTablename;
//        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
//        ResultSetInfo result = connTool.doQuery(sql);
//        ResultSet rs = result.getResultSet();
//            com.alibaba.fastjson.JSONObject obj = this.getSendData(rs, fieldMapping, sendConfig);
//            if (org.apache.commons.lang.StringUtils.isEmpty(childTableid)) {//有子表
//                List<TbtskApplicationApi> apiList = this.tbtskApplicationApiDao.queryByTableOrAssign(childTableid);
//                if (apiList.isEmpty())
//                    continue;
//                TbtskApplicationApi api = apiList.get(0);
//                String configTableId = api.getTableid();//查询关联数据需要使用，部分数据有多次外业的情况下，外网推送的任务objectinfo对应着api表的assigntotask字段
//                Map<String, String> childMapping = this.getFieldMapping(configTableId);
//                if (null == childMapping)
//                    continue;
//                com.alibaba.fastjson.JSONArray childObj = this.sendData(childMapping, sendConfig);
//                obj.put("children", childObj);
//            }
//            resultArray.add(obj);
//        return resultArray;
//    }

    /**
     * 生成结果json数据
     * @param obj
     * @param fieldMapping
     * @param sendConfig
     * @return
     * @throws SQLException
     */
    private com.alibaba.fastjson.JSONObject getSendData(JSONObject obj, Map<String, String> fieldMapping, com.alibaba.fastjson.JSONObject sendConfig)  throws SQLException {
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject();
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            if(!entry.getKey().equals("f_shape")) {
                result.put(entry.getValue(), obj.getString(entry.getKey()));
            }
        }
        if (sendConfig.containsKey("hasShp") && sendConfig.getBoolean("hasShp")) {//是否返回shp数据
            String shpType = sendConfig.getString("shpType");
            if ("wkt".equals(shpType)) {
                result.put("shape", obj.getString("f_shape"));
            }
        }
        if (sendConfig.containsKey("hasMedia") && sendConfig.getBoolean("hasMedia")) {//是否返回照片数据
            String f_id = obj.getString("f_id");
            com.alibaba.fastjson.JSONArray mediaArray = this.getMediaArray(f_id, sendConfig);
            result.put("media", mediaArray);
        }
        return result;
    }

    /**
     * 生成结果照片数据
     * @param f_id
     * @param sendConfig
     * @return
     * @throws SQLException
     */
    private com.alibaba.fastjson.JSONArray getMediaArray(String f_id, com.alibaba.fastjson.JSONObject sendConfig) throws SQLException {//返回数据相同
        com.alibaba.fastjson.JSONArray result = new com.alibaba.fastjson.JSONArray();
        String sql = "select * from tb_app_media where f_galleryid = '" + f_id + "'";
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        String[] fields = sendConfig.getString("mediaFields").split(",");//需要返回的字段配置，包含f_
        for(Map<String, Object> item:data){
            com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
            for (int i = 0; i < fields.length; i++) {
                String fieldname = fields[i];
                if ("f_serverpath".equals(fieldname)) {//返回内网地址，代码同ImportDbServiceImpl getInsertValue方法
                    String path = item.get(fieldname).toString();
                    String[] pathArray = path.split("media");
                    String resultPath = "";
                    if (pathArray.length !=2) {
                        resultPath = path ;
                    } else {
                        if ("true".equals(this.minioModel)) {
                           /* resultPath = this.minIOService.getHeaderUrl() + "/gtdcy" + "/media" + pathArray[1];*/
                        } else {
                            resultPath = this.mediaUrlPrefix + "/media" + pathArray[1];
                        }
                    }
                    obj.put("serverpath", resultPath);
                } else {
                    obj.put(fieldname.split("f_")[1], item.get(fieldname).toString());
                }
            }
            result.add(obj);
        }
        return result;
    }
}
