package com.geoway.landteam.landcloud.service.thirddata.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.servface.thirddata.Processable;
import com.geoway.landteam.landcloud.servface.thirddata.ThirdDataImportService;
import com.geoway.landteam.landcloud.service.thirddata.template.AbstractThirdDataImportTemplate;
import com.geoway.landteam.landcloud.service.thirddata.utils.ThreadLocalUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service(ThirdDataImportService.SERVICE_PREFIX + "TJS_TDJY")
public class TjsTdjyImportImpl extends AbstractThirdDataImportTemplate implements Processable {
    private final static String APPLICATIONCODE = "TJS_TDJY";
    @Override
    protected String getApplicationCode() {
        return APPLICATIONCODE;
    }

    @Override
    protected String[] getApiConfig() throws Exception {
        return ApiNameType.tjs_tdjy;
    }

    @Override
    protected void customFieldFormat(JSONObject data, Map<String, Object> map) throws Exception {
        String xzqdm = data.getString("xzqdm");
        String xzqmc = data.getString("xzqmc");
        map.put("f_xzqmc_n2",xzqmc);
        map.put("f_xzqdm_n5",xzqdm);
        return;
    }

    @Override
    protected void  exportData(String ids, TbtskApplicationApi applicationApi)throws Exception{

    }
    @Override
    public void setTaskId(String taskId) {
        ThreadLocalUtils.set("taskId",taskId);
    }

    @Override
    public void setTbid(String tbid) {
        ThreadLocalUtils.set("tbid",tbid);
    }

    @Override
    public String createTaskName(JSONObject data) {
        throw new RuntimeException("不能创建任务");
    }

    @Override
    public Long getUserId(JSONObject data) {
        return 1015L;
    }

    @Override
    public String getXzqdm(JSONObject data) {
        return data.getString("行政区代码");
    }

    @Override
    public TbtskApplicationApi getApplicationConfig() {
        return null;
    }

    @Override
    public String getTaskId() {
        return ThreadLocalUtils.get("taskId");
    }

    @Override
    public String getTbid() {
        return ThreadLocalUtils.get("tbid");
    }
}
