package com.geoway.landteam.landcloud.service.thirddata.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskBusiCodeApater2_0Service;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.thirddata.Processable;
import com.geoway.landteam.landcloud.servface.thirddata.TaskAndTbIdSetter;
import com.geoway.landteam.landcloud.servface.thirddata.TaskCreatable;
import com.geoway.landteam.landcloud.servface.thirddata.ThirdDataImportService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskTemplateService;
import com.geoway.landteam.landcloud.service.thirddata.Exception.FilterForbiddenException;
import com.geoway.landteam.landcloud.service.thirddata.utils.BysxzUtil;
import com.github.pagehelper.util.StringUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;

/**
 * Created by hanhaitao on 2021/12/8.
 *
 * 国土整治大类解析的抽象模板类
 *
 * importData 中定义解析流程，实现细节通过继承该类实现，
 * 工厂类中注册该类时使用实现类的类名。
 */
public abstract class AbstractThirdDataImportTemplate implements ThirdDataImportService,TaskAndTbIdSetter,TaskCreatable, Processable {

    private  static final GiLoger logger = GwLoger.getLoger(AbstractThirdDataImportTemplate.class);

    //抽象类中的字段不能直接Autowired，通过setter实现注入
    protected TbtskApplicationApiRepository tbtskApplicationApiDao;
    protected TaskResouceService taskResouceService;
    protected DataBizService dataBizService;
    protected TbtskFieldsRepository tbtskFieldsRepository;
    protected TbtskObjectinfoService tbtskObjectinfoService;
    protected TskTaskBizRepository bizDao;
    protected ExportDataService exportDataService;
    protected TbtskTemplateRepository tbtskTemplateRepository;
    protected TskTaskBizRepository tskTaskBizRepository;
    protected TskTaskBizService tskTaskBizService;
    protected MTbtskTemplateService templateCQService;
    protected UserBiz2Repository userBiz2Repository;
    protected LandUserService landUserService;
    protected SysConfigService sysConfigService;
    protected TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service;

    @Autowired
    public void setTbtskTemplateRepository(TbtskTemplateRepository tbtskTemplateRepository) {
        this.tbtskTemplateRepository = tbtskTemplateRepository;
    }
    @Autowired
    public void setTskTaskBizRepository(TskTaskBizRepository tskTaskBizRepository) {
        this.tskTaskBizRepository = tskTaskBizRepository;
    }
    @Autowired
    public void setTskTaskBizService(TskTaskBizService tskTaskBizService) {
        this.tskTaskBizService = tskTaskBizService;
    }
    @Autowired
    public void setTemplateCQService(MTbtskTemplateService templateCQService) {
        this.templateCQService = templateCQService;
    }
    @Autowired
    public void setUserBiz2Repository(UserBiz2Repository userBiz2Repository) {
        this.userBiz2Repository = userBiz2Repository;
    }
    @Autowired
    public void setLandUserService(LandUserService landUserService) {
        this.landUserService = landUserService;
    }
    @Autowired
    public final void setTbtskApplicationApiDao(TbtskApplicationApiRepository tbtskApplicationApiDao) {
        this.tbtskApplicationApiDao = tbtskApplicationApiDao;
    }
    @Autowired
    public void setTaskResouceService(TaskResouceService taskResouceService) {
        this.taskResouceService = taskResouceService;
    }
    @Autowired
    public void setDataBizService(DataBizService dataBizService) {
        this.dataBizService = dataBizService;
    }
    @Autowired
    public void setTbtskFieldsRepository(TbtskFieldsRepository tbtskFieldsRepository) {
        this.tbtskFieldsRepository = tbtskFieldsRepository;
    }
    @Autowired
    public void setTbtskObjectinfoService(TbtskObjectinfoService tbtskObjectinfoService) {
        this.tbtskObjectinfoService = tbtskObjectinfoService;
    }
    @Autowired
    public void setBizDao(TskTaskBizRepository bizDao) {
        this.bizDao = bizDao;
    }
    @Autowired
    public void setExportDataService(ExportDataService exportDataService) {
        this.exportDataService = exportDataService;
    }
    @Autowired
    public void setSysConfigService(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }
    @Autowired
    public void setTaskBusiCodeApater2_0Service(TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service) {
        this.taskBusiCodeApater2_0Service = taskBusiCodeApater2_0Service;
    }

    protected  TbtskApplicationApi applicationApi;

    protected abstract   String getApplicationCode() ;
    //抽象方法多态获取配置
    protected abstract String[] getApiConfig()throws Exception;


    //多态创建任务
    //TODO 创建taskCreator与任务解耦
    @Transactional
    protected void createTask(JSONObject data,TbtskApplicationApi applicationApi)throws Exception{

        String objectid = applicationApi.getTableid();
        TbtskTemplate template = tbtskTemplateRepository.getByTableId(objectid);
        Assert.notNull(template,"未找到任务模板");
        String templateId = template.getId();
        String applicationcode = getApplicationCode();
        String xzqdm = getXzqdm(data);
        Assert.isTrue(xzqdm.length() >= 6,"行政区代码异常");
        xzqdm = xzqdm.substring(0,6);
        Assert.state(!xzqdm.endsWith("00"),"行政区级别非区县级");
        String name = createTaskName(data);
        Long userId = applicationApi.getAdmin();
        Boolean newRow = false;
        String id = queryExistTaskId(xzqdm,templateId);
        TskTaskBiz tskTaskBiz = new TskTaskBiz();
        if (!StringUtil.isEmpty(id)) {
            tskTaskBiz = tskTaskBizService.findByTaskId(id);
            this.setTaskId(tskTaskBiz.getId());
            tskTaskBiz.setIsDel(0);
            return;
        } else {
            // 新创建
            newRow = true;
            tskTaskBiz.setType("2");
            tskTaskBiz.setFinish(0);
            tskTaskBiz.setCreateTime(new Date());
            tskTaskBiz.setIsPublic(0);
            tskTaskBiz.setTotal(0);
            tskTaskBiz.setAssignCount(0);
            tskTaskBiz.setStatus("1");
            /*tskTaskBiz.setScope("智能管理");*/
        }
        Boolean unique = !tskTaskBizService.checkTaskName(name, tskTaskBiz.getId(),"");
        Assert.isTrue(unique,"任务名称重复");
        tskTaskBiz.setSource("");
        tskTaskBiz.setName(name);
        int year = new Date().getYear();
        tskTaskBiz.setStartTime(new Date(year,0,1));
        tskTaskBiz.setEndTime(new Date(year + 1,0,1));
        tskTaskBiz.setUserId(userId.toString());

        tskTaskBiz.setGranularity(3);
        tskTaskBiz.setMode(1);

        Long classId = this.taskBusiCodeApater2_0Service.getClassIdByCode(applicationcode);
        if (StringUtils.isNotEmpty(applicationcode) && classId != null) {
            tskTaskBiz.setClassId(classId);
        }
        //tskTaskBizService.save(tskTaskBiz, regions);
        tskTaskBiz = tskTaskBizService.save(tskTaskBiz);
        //保存模板
        //List<String> areaCodes = landUserService.queryUserAreas(userId);
        //Assert.notEmpty(areaCodes,"当前用户行政区域未设置");
        if (StringUtils.isNotEmpty(templateId)) {
            tskTaskBiz.setAllowNew("1");
            tskTaskBiz.setNeedSign("1");
            tskTaskBiz.setAllowEdit("1");
            tskTaskBiz.setRedoAble(1);
            tskTaskBiz.setPicConfig("");
            tskTaskBiz.setPicIsDefault(1);
            this.templateCQService.instantiateTemplate(tskTaskBiz, templateId);
            tskTaskBiz = tskTaskBizService.saveRegions(tskTaskBiz, xzqdm);
            tskTaskBizService.finishCreateTsk(tskTaskBiz, userId);
        }

        // 新创建
        if (newRow) {
            // 任务授权给创建者
            UserBiz2 ub = new UserBiz2();
            ub.setUserId(userId);
            ub.setBizId(tskTaskBiz.getId());
            ub.setRole(0);
            userBiz2Repository.save(ub);
            this.exportDataService.export(tskTaskBiz.getId(), null, false, false, null, null, null);
        }
        this.setTaskId(tskTaskBiz.getId());
    }

    /**
     * 可多态格式化字段,此处为默认实现，可继承重写该方法改变逻辑
     */
    protected abstract void customFieldFormat(JSONObject data,Map<String, Object> map)throws Exception;

    /**
     * 可多态过滤数据权限,此处为默认实现，可继承重写该方法改变逻辑
     */
    public void authorize() throws FilterForbiddenException, Exception {
        if(false) throw  new FilterForbiddenException("数据导入权限受限");
    }

    /**
     * 可多态多态预处理数据(如下载json、格式转换等),此处为默认实现，可继承重写该方法改变逻辑
     */
    public String pretreatData(String data,TbtskApplicationApi applicationApi)throws Exception{
        return data;
    }

    /**
     * 可多态格式化json串,此处为默认实现，可继承重写该方法改变逻辑
     */
    public JSONArray formatData(String jsonStr,TbtskApplicationApi applicationApi)throws Exception{
        //jsonStr如果是json则转为jsonArray
        jsonStr =  jsonStr.trim().replaceAll("^\\{","[{").replaceAll("\\}$","}]");
        return  JSONArray.parseArray(jsonStr);
    }

    /**
     * 可多态获取api配置,此处为默认实现，可继承重写该方法改变逻辑
     */
    public TbtskApplicationApi getConfig()throws Exception{

        if(applicationApi!= null) {
            return  applicationApi;
        }
        //多态
        String namespace = getApiConfig()[0];
        String apiname = getApiConfig()[1];
        TbtskApplicationApi api = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (api == null) {
            throw new Exception("获取关联配置失败");
        }
        return  api;
    }

    //抽象方法多态保存数据
    protected String saveData(JSONArray array,TbtskApplicationApi applicationApi) throws Exception{
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.size(); i++) {
            JSONObject object = array.getJSONObject(i);
            String fid = saveOneData(object,applicationApi);
            if (!"".equals(fid)) {
                if (sb.length() == 0) {
                    sb.append(fid);
                } else {
                    sb.append(",").append(fid);
                }
            }
        }
        this.setTbid(sb.toString());
        return sb.toString();
    }

    /*
     *多态导出数据
     */
    protected void exportData(String ids,TbtskApplicationApi applicationApi)throws Exception{
        if (!"".equals(ids)) {
            TskTaskBiz task = this.bizDao.getByTableId(getTableInfo(applicationApi).getfId());
            this.exportDataService.export(task.getId(), ids, false, false, null, IdentityType.WYDC, null);
        }
    }

    protected void resolveSystemField(Map map,String id){
        if (map != null) {
            map.put("f_id", id);
            map.put("f_status", "1");
            map.put("f_createtime", System.currentTimeMillis() + "");
            map.put("f_userid", applicationApi.getAdmin());
            String xzqdmsys = (String)map.get("f_xzqdmsys");
            if(map.containsKey("f_xzqdm") && StringUtils.isBlank(xzqdmsys)){
                String xzqdm = (String)map.get("f_xzqdm");
                map.put("f_xzqdmsys",xzqdm + "000000");
            }

        }
    }
    @Override
    public final void importData(String jsonStr) throws FilterForbiddenException, Exception{
        //多态处理核心方法
        authorize();
        applicationApi = getConfig();
        jsonStr = pretreatData(jsonStr,applicationApi);
        JSONArray jsonArr = formatData(jsonStr,applicationApi);
        String ids = saveData(jsonArr,applicationApi);
        exportData(ids,applicationApi);
    }

    private void reflectFields(JSONObject object, Map<String, String> mapping, List<TbtskFields> allFields, HashMap<String, Object> map, Map data) throws Exception {
        List<String> list = new ArrayList<>();
        allFields.forEach(e->list.add(e.getfFieldname()));
        for (TbtskFields field : allFields) {
            String fieldName = field.getfFieldname();
            String fieldType = field.getfFieldtype();
            Integer outWork = field.getfIsOutwork();
            String type = TskTaskBizDBUtil.getDBType(fieldType);
            Integer nullable ;
            if (null == outWork) {
                nullable = field.getfNullable();
            } else {
                nullable = outWork == 1 ? 1 : field.getfNullable();
            }
            Integer order = field.getfOrder();

            if(mapping.containsKey(fieldName)){
                String str =  mapping.get(fieldName);
                if(StringUtils.isNotEmpty(str)){
                    BysxzUtil.addDatatoMap(map, type, str, fieldName, nullable, order, object);
                    continue;
                }
            }
            if (data == null) {
                if("f_index".equalsIgnoreCase(fieldName)){
                    continue;
                }
                if (fieldName.equals("f_lat") || fieldName.equals("f_lon")) {
                    continue;
                }
                String value = field.getfDefaultvalue();
                if (type.equals(TskTaskBizDBUtil.getDBType("5"))) {//Timestamp特殊处理
                    value = null;
                }
                map.put(fieldName, value);
                BysxzUtil.addDatatoMap(map, type, fieldName, fieldName, nullable, order, object);
            }
        }
    }

    private String saveOneData(JSONObject object,TbtskApplicationApi applicationApi) throws Exception{
        String tableid = applicationApi.getTableid();
        if( 1 == Optional.ofNullable(applicationApi.getAutoCreate()).orElse(0)){
            createTask(object,applicationApi);
        }else{
            TskTaskBiz biz = tskTaskBizService.findByTableId(tableid);
            this.setTaskId(biz.getId());
        }
        Map<String, String> mapping = taskResouceService.getFiledMap(tableid);

        TbtskObjectinfo table = getTableInfo(applicationApi);
        List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();
        HashMap<String, Object> map = new HashMap<>();
        Map dataMap = null;
        if (!StringUtils.isEmpty(primary)) {
            dataMap = dataBizService.selectByID(table.getfTablename(), primary, "'" + object.getString(mapping.get(primary)) + "'");
        }
        String f_id = "";
        //插入数据
        this.reflectFields(object, mapping, allFields, map, dataMap);
        if (dataMap == null){
            if (map.containsKey("tbid") && map.get("tbid") !=null && !StringUtils.isEmpty(map.get("tbid").toString())) {
                f_id = map.get("tbid").toString();
            }else if (map.containsKey("f_id") && map.get("f_id") !=null && !StringUtils.isEmpty(map.get("f_id").toString())) {
                f_id = map.get("f_id").toString();
            } else {
                f_id = UUID.randomUUID().toString();
            }
        }else{
            f_id = (String) dataMap.get("f_id");
            if (object.containsKey("sendto") && !StringUtils.isEmpty(object.getString("sendto")) && mapping.containsKey("f_sendto")) {
                map.put("f_sendto", object.getString("sendto"));
            }
        }
        //TODO 定制字段
        customFieldFormat(object, map);
        if (dataMap == null) {
            resolveSystemField(map,f_id);
            dataBizService.insertData(table.getfTablename(), map, "f_shape");
        } else {
            dataBizService.updateData(table.getfTablename(), map, primary + "='" + object.getString(mapping.get(primary)) + "'");
        }
        return f_id;
    }

    private TbtskObjectinfo getTableInfo(TbtskApplicationApi applicationApi){
        if(1 == Optional.ofNullable(applicationApi.getAutoCreate()).orElse(0)){
            Assert.notNull(this.getTaskId() );
            TskTaskBiz biz = bizDao.findById(this.getTaskId()).orElseThrow(RuntimeException::new);
            return tbtskObjectinfoService.getObjectByTableId(biz.getTableId());
        }
        return tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
    }

    private String queryExistTaskId(String xzqdm, String templateId) throws Exception{
        Date currentDate = new Date();
        return tskTaskBizRepository.findBizByYearXzqAndTemplate(currentDate,xzqdm,templateId);
    }

    @Override
    public String getData(String source) {
        return null;
    }

    @Override
    public String formatData(String String) {
        return null;
    }

}
