package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import com.dps.GPSUtil.GPSInfo;
import com.dps.GPSUtil.GPSUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.*;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import static java.sql.Types.NULL;

/**
 * Created by licong on 2020/10/12.
 */
public class BysxzUtil {

    private static GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);

    public static void addDatatoMap(Map map, String fieldType, String rname, String fieldName, Integer nullable, Integer order, JSONObject object) throws Exception {
        DecimalFormat format   = new DecimalFormat("######0.0000000");
        switch (fieldType) {
            case "varchar":
                String value1 = getStrValue(object, rname);
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, "");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    String tmp1 = getStrValue(object, rname);
                    if (tmp1 == null || isMessyCode(tmp1) || "".equals(tmp1)) {
                        if (order != null && nullable == 0) {
                            map.put(fieldName, 0.0);
                        } else {
                            map.put(fieldName, NULL);
                        }
                    } else {
                        Double value2 = Double.valueOf(tmp1);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                String tmp2 = getStrValue(object, rname);
                if (tmp2 == null || isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, 0);
                    } else {
                        map.put(fieldName, NULL);
                    }
                } else {
                    Integer value3 = Integer.valueOf(tmp2);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                String tmp3 = getStrValue(object, rname);
                if (tmp3 == null || isMessyCode(tmp3) || "".equals(tmp3) || "0".equals(tmp3)) {
                    map.put(fieldName, null);
                } else {
                    DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = df.parse(tmp3);
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                break;
            case "text":
                String value2 = getStrValue(object, rname);
                if (value2 == null || "null".equals(value2.toLowerCase()) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        map.put(fieldName, "");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "geometry":
                String wkt = getStrValue(object, rname);
                if (StringUtils.isEmpty(wkt)) {
                    map.put(fieldName, null);
                    break;
                }
                Geometry geo = (Geometry) WKTUtil.wktToGeom(getStrValue(object, rname));
                if ("f_shape".equalsIgnoreCase(fieldName)) {
                    if (geo == null) {
                        break;
                    } else {
                        map.put(fieldName, WKTUtil.geomToWkt(geo));
                        map.put("f_shape1", WKTUtil.geomToWkt(geo));
                        Point point = geo.getCentroid();
                        if (point != null) {
                            map.put("f_lat", format.format(point.getY()));
                            map.put("f_lon", format.format(point.getX()));
                        } else {
                            map.put("f_lat", "0.0");
                            map.put("f_lon", "0.0");
                        }
                    }
                } else if ("f_shape_g".equalsIgnoreCase(fieldName)) {
                    // google
                    Geometry geometry_g = convertGeometry(geo, 1);
                    map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                    Point point_g = geometry_g.getCentroid();
                    if (point_g != null) {
                        map.put("f_lat_g", format.format(point_g.getY()));
                        map.put("f_lon_g", format.format(point_g.getX()));
                    } else {
                        map.put("f_lat_g", "0.0");
                        map.put("f_lon_g", "0.0");
                    }
                } else if ("f_shape_b".equalsIgnoreCase(fieldName)) {
                    // baidu
                    Geometry geometry_b = convertGeometry(geo, 2);
                    map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                    Point point_b = geometry_b.getCentroid();
                    if (point_b != null) {
                        map.put("f_lat_b", format.format(point_b.getY()));
                        map.put("f_lon_b", format.format(point_b.getX()));
                    } else {
                        map.put("f_lat_b", "0.0");
                        map.put("f_lon_b", "0.0");
                    }
                }
                break;
            default:
                break;
        }
    }

    public static String getStrValue(JSONObject obj, String fieldName) {
        String val = "";
        try {
            if (obj != null && !obj.equals("")) {
                val = obj.getString(fieldName);
            }
        } catch (Exception ex) {
        }
        return val;
    }
    // 判断是否为乱码
    public static boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            // 当从Unicode编码向某个字符集转换时，如果在该字符集中没有对应的编码，则得到0x3f（即问号字符?）
            // 从其他字符集向Unicode编码转换时，如果这个二进制数在该字符集中没有标识任何的字符，则得到的结果是0xfffd
            if ((int) c == 0xfffd) {
                // 存在乱码
                return true;
            }
        }
        return false;
    }

    private static Geometry convertGeometry(Geometry geometry, int type) {
        Geometry result = null;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon) geometry;
            Polygon[] garray = new Polygon[multiPolygon.getNumGeometries()];
            for (int i = 0; i < multiPolygon.getNumGeometries(); i++) {
                Polygon polygon = (Polygon) multiPolygon.getGeometryN(i);
                garray[i] = convertPolygon(polygon, type);
            }

            result = geometryFactory.createMultiPolygon(garray);
        } else if (geometry instanceof Geometry) {
            result = convertPolygon(geometry, type);
        }
        return result;
    }

    private static Polygon convertPolygon(Geometry geometry, int type) {
        Coordinate coords[] = new Coordinate[geometry.getCoordinates().length];
        if (geometry instanceof Polygon) {
            Polygon pg = (Polygon) geometry;

            // 外环
            LineString exteriorRing = pg.getExteriorRing();
            LinearRing lineString = convertLineString(exteriorRing, type);

            // 内环
            LinearRing[] holes = new LinearRing[pg.getNumInteriorRing()];
            for (int i = 0; i < pg.getNumInteriorRing(); i++) {
                LineString interiorRingN = pg.getInteriorRingN(i);

                LinearRing lineString1 = convertLineString(interiorRingN, type);
                holes[i] = lineString1;
            }

            Polygon polygon = geometryFactory.createPolygon(lineString, holes);
            return polygon;
        }

        return null;
    }

    private static LinearRing convertLineString(LineString geometry, int type) {
        Coordinate coords[] = new Coordinate[geometry.getCoordinates().length];
        for (int i = 0; i < geometry.getCoordinates().length; i++) {
            if (type == 1) {
                // wgs84 转 gcj02
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            } else if (type == 2) {
                // wgs84 转 bd09
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                gpsInfo = GPSUtil.GCJ02_To_BD09(gpsInfo.GetLat(), gpsInfo.GetLon());
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            }
        }

        return geometryFactory.createLinearRing(coords);
    }
}
