package com.geoway.landteam.landcloud.service.thirddata.utils;

/*import net.sf.json.JSONArray;
import net.sf.json.JSONObject;*/

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.geojson.GeoJSON;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by licong on 2020/10/25.
 */
public class GeoUtils {

    public static GiLoger logger = GwLoger.getLoger(GeoUtils.class);
    public static Geometry geojsonToGeom(String geojson) throws Exception{
        GeometryJSON geometryJSON = new GeometryJSON(8);
        Geometry geometry = geometryJSON.read(geojson);
        return geometry;
    }
    public static Geometry geojson2Geom(String geojson) throws Exception{

        FeatureJSON fjson_15 = new FeatureJSON(new GeometryJSON(8));
        FeatureCollection featureCollection = fjson_15.readFeatureCollection(geojson);
//        SimpleFeatureType simpleFeatureType = (SimpleFeatureType) featureCollection.getSchema();
        OutputStream ostream = new ByteArrayOutputStream();
        GeoJSON.write(featureCollection, ostream);

        SimpleFeatureIterator iterator = (SimpleFeatureIterator) featureCollection.features();
        List<Polygon> geometriesList = new ArrayList<>();
        while (iterator.hasNext()) {
            SimpleFeature simpleFeature = iterator.next();
            Polygon geom = (Polygon) simpleFeature.getDefaultGeometry();
            geometriesList.add(geom);
        }
        if (geometriesList.isEmpty()) {
            return null;
        } else if (geometriesList.size() == 1) {
            return geometriesList.get(0);
        } else {
            GeometryFactory factory = new GeometryFactory();
            Polygon[] geometries = new Polygon[geometriesList.size()];
            for (int i = 0; i < geometriesList.size(); i++) {
                geometries[i] = geometriesList.get(i);
            }
            MultiPolygon multiPolygon = new MultiPolygon(geometries, factory);
            iterator.close();
            return multiPolygon;
        }
    }
    /*geojson转geometrys，合并为一个geometry，并转换为4490坐标系,默认坐标反转*/
    public static Geometry geojson2Geom4490(String geojson) throws Exception{
        return geojson2Geom4490(geojson,true);
    }
    /*geojson转geometrys，合并为一个geometry，并转换为4490坐标系*/
    public static Geometry geojson2Geom4490(String geojson,boolean revert) throws Exception{
        List<Geometry> geoms = geojson2Geoms4490(geojson,revert);
        List<Polygon> geometriesList = new ArrayList<>();
        for(Geometry geometry : geoms){
            Polygon geom = (Polygon) geometry;
            geometriesList.add(geom);
        }
        if (geometriesList.isEmpty()) {
            return null;
        } else if (geometriesList.size() == 1) {
            return geometriesList.get(0);
        } else {
            GeometryFactory factory = new GeometryFactory();
            Polygon[] geometries = new Polygon[geometriesList.size()];
            for (int i = 0; i < geometriesList.size(); i++) {
                geometries[i] = geometriesList.get(i);
            }
            MultiPolygon multiPolygon = new MultiPolygon(geometries, factory);
            return multiPolygon;
        }
    }
    //geojson FeatureCollection类型转Geometrys
    public static  List<Geometry> geojson2Geoms(String geojson) throws Exception{
        List<Geometry> geoms = new ArrayList<>();
        FeatureJSON fjson_15 = new FeatureJSON(new GeometryJSON(8));
        FeatureCollection featureCollection = fjson_15.readFeatureCollection(geojson);
        OutputStream ostream = new ByteArrayOutputStream();
        GeoJSON.write(featureCollection, ostream);

        SimpleFeatureIterator iterator = (SimpleFeatureIterator) featureCollection.features();
        while (iterator.hasNext()){
            SimpleFeature simpleFeature = iterator.next();
            Geometry geom = (Geometry) simpleFeature.getDefaultGeometry();
            geoms.add(geom);
        }
        iterator.close();
        return geoms;
    }
    /*geojson转geometrys，并转为4490坐标系,默认坐标反转*/
    public static List<Geometry> geojson2Geoms4490(String geojson) throws Exception{
        return geojson2Geoms4490(geojson,true);
    }
    /*geojson转geometrys，并转为4490坐标系*/
    public static List<Geometry> geojson2Geoms4490(String geojson,boolean revert) throws Exception {
        Map<String, Object> geojsonMap = JSONObject.parseObject(geojson, Map.class);
        String crs = "EPSG:4490";//默认的坐标系
        String rex = "epsg.*([1-9]*?)";
        Pattern pattern = Pattern.compile(rex);
        if (geojsonMap.containsKey("crs") && null != geojsonMap.get("crs")) {
            Map<String,Object> crsMap = (Map<String,Object>) geojsonMap.get("crs");
            //获取crs
            String EPSG = ((Map<String,String>)crsMap.get("properties")).get("name").toLowerCase();
            Matcher matcher = pattern.matcher(EPSG);
            if(matcher.find()){
                crs = "EPSG:"+matcher.group().replaceAll("[^0-9]","");
            }
            if(!crs.equals("EPSG:4490")){
                JSONObject obj =JSONObject.parseObject(geojson);
                if(obj.getString("features")!= null){
                    JSONArray feas = obj.getJSONArray("features");
                   for(int i=0;i<feas.size();i++){
                       JSONObject feaobj=feas.getJSONObject(i);
                       if(feaobj.getString("geometry")!=null){
                           JSONObject geoObj = feaobj.getJSONObject("geometry");
                            if(geoObj.containsKey("type")){
                                String type = geoObj.getString("type");
                                if(type.equals("Polygon")){
                                    JSONArray coordinates = geoObj.getJSONArray("coordinates");//[[[x,y],[xy]],]
                                    if(revert) {
                                        JSONArray coordinatesf = reverCoordinates(coordinates);
                                        geoObj.put("coordinates",coordinatesf);
                                    }else{
                                        geoObj.put("coordinates",coordinates);
                                    }
                                }
                            }
                       }
                   }
                   geojson = obj.toJSONString();
                }
            }
        }
        List<Geometry> geoms = geojson2Geoms(geojson);
        List<Geometry> newgeoms = new ArrayList<>();
        for(Geometry geom : geoms){
           if(!crs.equals("EPSG:4490")){//如果原始数据不是2000，则需要转换
               MathTransform transform_1 = CRS.findMathTransform(CRS.decode(crs), CRS.decode("EPSG:4490"),true);
               geom = JTS.transform(geom, transform_1);
               String geojsonzh = getgeojson(geom);
               JSONObject obj =JSONObject.parseObject(geojsonzh);
               JSONArray coordinates = obj.getJSONArray("coordinates");//[[[x,y],[xy]],]
               if(revert) {
                   JSONArray coordinatesf = reverCoordinates(coordinates);
                   obj.put("coordinates",coordinatesf);
               }else{
                   obj.put("coordinates",coordinates);
               }
               geojsonzh = obj.toJSONString();
               geom = geojsonToGeom(geojsonzh);
           }
           newgeoms.add(geom);
        }
        return newgeoms;
    }
    /*反转x,y*/
    public static JSONArray reverCoordinates(JSONArray coordinates){
        JSONArray coordinatesf = new JSONArray();
        for(int m=0;m<coordinates.size();m++){
            JSONArray coordinate = coordinates.getJSONArray(m);
            JSONArray coordinatef = new JSONArray();
            for(int n=0;n<coordinate.size();n++){
                JSONArray point = coordinate.getJSONArray(n);
                JSONArray pointf = new JSONArray();
                pointf.add(0,point.getBigDecimal(1));
                pointf.add(1,point.getBigDecimal(0));
                coordinatef.add(pointf);
            }
            coordinatesf.add(coordinatef);
        }
        return coordinatesf;
    }
    /*geometry转geojson*/
    public static String getgeojson(Geometry geometry) throws IOException {
        String geojson = "";
        StringWriter writer = new StringWriter();
        GeometryJSON g = new GeometryJSON(15);
        g.write(geometry, writer);
        geojson = writer.toString();
        return geojson;
    }
    public static List<Geometry> geojson2Geom4496(String geojson) throws Exception {
        Map<String, Object> geojsonMap = JSONObject.parseObject(geojson, Map.class);
        String crs = "EPSG:4490";//默认的坐标系
        String rex = "epsg.*([1-9]*?)";
        Pattern pattern = Pattern.compile(rex);
        if (geojsonMap.containsKey("crs") && null != geojsonMap.get("crs")) {
            Map<String,Object> crsMap = (Map<String,Object>) geojsonMap.get("crs");
            //获取crs
            String EPSG = ((Map<String,String>)crsMap.get("properties")).get("name").toLowerCase();
            Matcher matcher = pattern.matcher(EPSG);
            if(matcher.find()){
                crs = "EPSG:"+matcher.group().replaceAll("[^0-9]","");
            }
        }
        List<Geometry> geoms = geojson2Geoms(geojson);
        List<Geometry> newgeoms = new ArrayList<>();
        for(Geometry geom : geoms){
            boolean geographicFlag = true;//是不是地理坐标系 默认是
            if(geom.getCentroid() != null){
                double centerX = geom.getCentroid().getX();
                NumberFormat nf = NumberFormat.getInstance();
                nf.setGroupingUsed(false);
                String xstr = nf.format(centerX);
                if(xstr.indexOf(".")>-1)
                    xstr = xstr.substring(0,xstr.indexOf("."));
                int X = Integer.parseInt(xstr);
                if(X > 180 || X < -180){
                    geographicFlag = false;
                }
            }
            //地理坐标系才转坐标系
            if(geographicFlag){
                MathTransform transform_1 = CRS.findMathTransform(CRS.decode(crs), CRS.decode("EPSG:4496"),true);
                geom = JTS.transform(geom, transform_1);
            }
            newgeoms.add(geom);
        }
        return newgeoms;
    }

    /**
     * geometry转4496
     * @param geom
     * @return
     * @throws FactoryException
     * @throws TransformException
     */
    public static Geometry getAreaGeometry(Geometry geom) throws FactoryException, TransformException {
        String crs = "EPSG:4490";//默认的坐标系
        MathTransform transform_1 = CRS.findMathTransform(CRS.decode(crs), CRS.decode("EPSG:4496"),true);
        geom = JTS.transform(geom, transform_1);
        return geom;
    }

    /**
     * 获取坐标系
     * @param lon 经纬度
     * @param zoning
     * @return
     */
    public static Integer getCrsByLon(Double lon, Integer zoning) {
        Integer zoningNum = (int) ((lon + 1.5)/3);
        Integer crsId;
        if(zoning == 3){
            crsId = 4513 + zoningNum - 25;
        }else {
            crsId = 4491 + zoningNum - 25;
        }
        return  crsId;
    }

    public static Geometry geoTransform(Geometry geom, String fromCrsWkt, String toCrs) throws FactoryException, TransformException {
        MathTransform transform_1 = CRS.findMathTransform(CRS.parseWKT(fromCrsWkt), CRS.decode(toCrs),true);
        geom = JTS.transform(geom, transform_1);
        return geom;
    }
}
