package com.geoway.landteam.landcloud.service.thirddata.utils;


import org.locationtech.jts.geom.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GeometryClockwiseUtil {
    public static Geometry EnclockwiseGeometry(Geometry geom){
        Geometry geometry;
        //调整坐标串为顺时针
        if("multipolygon".equalsIgnoreCase(geom.getGeometryType())){
            Polygon[] polygons = new Polygon[geom.getNumGeometries()];
            for(int j = 0;j < polygons.length;j++ ){
                polygons[j] = clockwiseSortPolygonCoords((Polygon) geom.getGeometryN(j));
            }
            geometry = new GeometryFactory(new PrecisionModel(),4490).createMultiPolygon(polygons);
        }else if("polygon".equalsIgnoreCase(geom.getGeometryType())){
            geometry = clockwiseSortPolygonCoords((Polygon) geom);
        }else{
            geometry = geom;
        }
        return geometry;
    }
    /**
     * 将polygon的坐标序列转为顺时针排列，
     * @param poly  普通Polygon
     * @return 坐标序列顺时针排序的Polygon
     */
    public static Polygon clockwiseSortPolygonCoords(Polygon poly){
        Coordinate[] coordinates = poly.getCoordinates();
        List<Coordinate> lc =new ArrayList(Arrays.asList(coordinates));
        if(!lc.get(lc.size()-1).equals2D(lc.get(0))) {
            lc.set(lc.size()-1,lc.get(0));
        }
        //不是顺时针则反转序列
        if(!ringIsClockwise(coordinates)) Collections.reverse(lc);
        coordinates = lc.toArray(coordinates);
        return new GeometryFactory(new PrecisionModel(), 4490).createPolygon(coordinates);
    }
    //根据质心确定两个点的顺时针逆时针关系,a在b的顺时针(需要转换)方向返回false，
    public static Boolean coordCmp(Coordinate a, Coordinate b, Coordinate center)
    {
        //向量OA和向量OB的叉积
        double det = (a.x - center.x) * (b.y - center.y) - (b.x - center.x) * (a.y - center.x);
        return det <= 0;
    }

    //判断坐标串是顺时针
    public static boolean ringIsClockwise(Coordinate[] rings){
        double total = 0.0d;
        Coordinate pt1 = null;
        Coordinate pt2 = null;
        for(int i=0; i< rings.length - 1; i++){
            pt1 = rings[i];
            pt2 = rings[i + 1];
            total += (pt2.x - pt1.x)*  (pt2.y + pt1.y);
        }
        return total>=0;
    }
}
