package com.geoway.landteam.landcloud.service.thirddata.utils;

import org.apache.http.Consts;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

import java.nio.charset.CodingErrorAction;

/**
 * Created by zhuyuchen on 2021/10/12.
 */
public class HttpClientPool {
    private final static int GET_MAP_MAX_CONN = 200;
    private final static int GET_MAP_MAX_ROUTE_CONN = 10;
    // 连接池最大连接数
    private final static int MAX_CONN = 200;
    // 每个路由最大连接数
    private final static int MAX_ROUTE_CONN = 20;
    // 连接池
    private static PoolingHttpClientConnectionManager httpConnectionManager;
    private static CloseableHttpClient httpClient;

    static {
        httpConnectionManager = new PoolingHttpClientConnectionManager();
        httpConnectionManager.setMaxTotal(MAX_CONN);
        httpConnectionManager.setDefaultMaxPerRoute(MAX_ROUTE_CONN);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        httpConnectionManager.setDefaultConnectionConfig(connectionConfig);
    }

    public static synchronized CloseableHttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = HttpClients.custom().setConnectionManager(httpConnectionManager).build();
        }
        return httpClient;
    }

    public static synchronized CloseableHttpClient buildHttpClient(int conn, int routeConn) {
        CloseableHttpClient httpClient = null;
        PoolingHttpClientConnectionManager getMapHttpConnectionManager = new PoolingHttpClientConnectionManager();
        getMapHttpConnectionManager.setMaxTotal(conn);
        getMapHttpConnectionManager.setDefaultMaxPerRoute(routeConn);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        getMapHttpConnectionManager.setDefaultConnectionConfig(connectionConfig);
        httpClient = HttpClients.custom().setConnectionManager(getMapHttpConnectionManager).build();
        return httpClient;
    }

    /**
     * 根据参数生成同步http池
     *
     * @param conn        最大连接数
     * @param routeConn   每个路由最大并发数
     * @param soTimeout   超时设置（ms)
     * @param soKeepAlive 是否保持常连接，默认为true
     * @return
     */
    public static synchronized CloseableHttpClient buildHttpClientByParm(int conn, int routeConn, int soTimeout, boolean soKeepAlive) {
        CloseableHttpClient httpClient = null;
        PoolingHttpClientConnectionManager getMapHttpConnectionManager = new PoolingHttpClientConnectionManager();
        getMapHttpConnectionManager.setMaxTotal(conn);
        getMapHttpConnectionManager.setDefaultMaxPerRoute(routeConn);
        //设置socket连接参数
        getMapHttpConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(soTimeout).setSoKeepAlive(soKeepAlive).build());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).build();
        getMapHttpConnectionManager.setDefaultConnectionConfig(connectionConfig);
        httpClient = HttpClients.custom().setConnectionManager(getMapHttpConnectionManager).build();
        return httpClient;
    }
}
