package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Component
public class HttpConnectionUtilCQ {
/*	@Value("#{imeSettings['security.keyStoreFile']}")*/
	@Value("${security.keyStoreFile:}")
	public void setKeyStoreFile(String keyStoreFile) {
		HttpConnectionUtilCQ.keyStoreFile = keyStoreFile;
	}

	/*@Value("#{imeSettings['security.keyStorePassWord']}")*/
	@Value("${security.keyStorePassWord:}")
	public void setKeyStorePass(String keyStorePass) {
		HttpConnectionUtilCQ.keyStorePass = keyStorePass;
	}

	private static String keyStoreFile;
	private static String keyStorePass;

	public static String AccessUrl(String url,String postString) throws IOException {
		String result = null;
		HttpURLConnection conn = null;
		OutputStream os = null;
		InputStream is = null;
		try {
			URL postUrl = new URL(url);
			conn = (HttpURLConnection) postUrl.openConnection();
			conn.setRequestMethod("POST");
			conn.setDoOutput(true);
			conn.setDoInput(true);
			conn.setUseCaches(false);
			conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
			conn.setConnectTimeout(30000);
			conn.setReadTimeout(300000);
			os = conn.getOutputStream();
			os.write(postString.getBytes("utf-8")); // 往远程URL传递参数
			os.flush();
			int code = conn.getResponseCode();
			conn.getHeaderFields();
			conn.getContentLength();
			if (code == 200) {//返回成功
				is = conn.getInputStream();
				BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
				String line;
				StringBuffer buffer = new StringBuffer();
				while ((line = reader.readLine()) != null) {
					buffer.append(line);
				}
				result = buffer.toString();
			} else {
				is = conn.getErrorStream();
				BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
				String line;
				StringBuffer buffer = new StringBuffer();
				while ((line = reader.readLine()) != null) {
					buffer.append(line);
				}
				throw new IOException(buffer.toString());
			}
		}catch (Exception e){
			throw e;
		}finally {
			if(os != null){
				os.close();
			}
			if(is != null){
				is.close();
			}
		}
		JSONObject json = new JSONObject();
		json.put("message",postString);
		json.put("result",result);
		return json.toJSONString();
	}

	public static String doPostFormdata(String url, Map<String, String> data) throws Exception {
		return doPostFormdata(url, data, null, null, null);
	}

	public static String doPostFormdata(String url, Map<String, String> data, Map<String, String> header) throws Exception {
		return doPostFormdata(url, data, header, null, null);
	}

	public static String doPostFormdata(String url, Map<String, String> data, Map<String, String> header, File file, String filekey) throws Exception {
		//header
		HttpHeaders requestHeaders = new HttpHeaders();
		if (null != header) {
			Iterator<Map.Entry<String, String>> it = header.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry<String, String> entry = it.next();
				requestHeaders.add(entry.getKey(), entry.getValue());
			}
		}
		//body
		MultiValueMap<String, Object> requestBody = new LinkedMultiValueMap<>();
		if (null != data) {
			Iterator<Map.Entry<String, String>> it = data.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry<String, String> entry = it.next();
				requestBody.add(entry.getKey(), entry.getValue());
			}
		}
		if (null != file) {
			FileSystemResource resource = new FileSystemResource(file);
			requestBody.add(filekey, resource);
		}

		//HttpEntity
		HttpEntity<MultiValueMap> requestEntity = new HttpEntity<MultiValueMap>(requestBody, requestHeaders);
		RestTemplate restTemplate = new RestTemplate();
		//post
		ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, requestEntity, String.class);
		return responseEntity.getBody();
	}

	public static String doPostJson(String url, String json, Map<String, String> header) throws Exception{
		TrustManager[] tm = { new MyX509TrustManager(keyStoreFile,keyStorePass) };
		SSLContext sslContext = SSLContext.getInstance("TLS");
		sslContext.init(null, tm, new java.security.SecureRandom());

		HttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session)->{return  true;}).setSslcontext(sslContext).build();
//		CloseableHttpClient httpclient = HttpClientBuilder.create().build();
		HttpPost post = new HttpPost(url);
		String result = null;
		try {
			if (null != header) {
				Iterator<Map.Entry<String, String>> it = header.entrySet().iterator();
				while (it.hasNext()) {
					Map.Entry<String, String> entry = it.next();
					post.setHeader(entry.getKey(), entry.getValue());
				}
			}

//			StringEntity s = new StringEntity(json);
//			s.setContentEncoding("UTF-8");
//			s.setContentType("application/json");//发送json数据需要设置contentType
//			post.setEntity(s);
			ByteArrayEntity entity = new ByteArrayEntity(json.getBytes("UTF-8"));
			entity.setContentType("application/json");
			post.setEntity(entity);
			HttpResponse res = client.execute(post);
			if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
				result = EntityUtils.toString(res.getEntity());// 返回json格式：
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return result;
	}
	public static String postFormDataHttps(String url, Map<String, String> data) throws Exception{
		return postFormDataHttps(url,data,null);
	}
	public static String postFormDataHttps(String url, Map<String, String> data,Map<String, String> header) throws Exception{
		// 创建SSLContext对象，并使用我们指定的信任管理器初始化
		TrustManager[] tm = { new MyX509TrustManager(keyStoreFile,keyStorePass) };
//		TrustManager[] tm = { new MyX509TrustManager("C:/jdk1.8.0_144/jre/lib/security/cacerts","changeit") };
		SSLContext sslContext = SSLContext.getInstance("TLS");
		sslContext.init(null, tm, new java.security.SecureRandom());

		HttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session)->{return  true;}).setSslcontext(sslContext).build();
		HttpPost post = new HttpPost(url);

		if (null != header) {
			Iterator<Map.Entry<String, String>> it = header.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry<String, String> entry = it.next();
				post.addHeader(entry.getKey(), entry.getValue());
			}
		}

		List<NameValuePair> params = new ArrayList<>();
		if (null != data){
			Iterator iterator = data.entrySet().iterator();
			while(iterator.hasNext()){
				Map.Entry<String,String> entry = (Map.Entry<String,String>)iterator.next();
				params.add(new BasicNameValuePair(entry.getKey(),entry.getValue()));
			}
		}
		if(params.size() > 0){
			UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params,"UTF-8");
			post.setEntity(entity);
		}
		HttpResponse response = client.execute(post);
		if(response != null && response.getStatusLine().getStatusCode() == 200){
			return EntityUtils.toString(response.getEntity());
		}
		throw new Exception("Https Response Failed :" +  response.getStatusLine().getStatusCode());
	}
	public static String postMultipartHttps( String url, Map<String, String> data,Map<String, String> header ,File file, String filekey) throws Exception {
		// 创建SSLContext对象，并使用我们指定的信任管理器初始化
		TrustManager[] tm = {new MyX509TrustManager(keyStoreFile, keyStorePass)};
		SSLContext sslContext = SSLContext.getInstance("TLS");
		sslContext.init(null, tm, new java.security.SecureRandom());

		HttpClient client = HttpClients.custom().setSSLHostnameVerifier((host, session) -> {
			return true;
		}).setSslcontext(sslContext).build();
		HttpPost post = new HttpPost(url);

		if (null != header) {
			Iterator<Map.Entry<String, String>> it = header.entrySet().iterator();
			while (it.hasNext()) {
				Map.Entry<String, String> entry = it.next();
				post.addHeader(entry.getKey(), entry.getValue());
			}
		}

		MultipartEntityBuilder entity = MultipartEntityBuilder.create();
		entity.setCharset(Charset.forName("UTF-8"));

		if (null != data) {
			Iterator iterator = data.entrySet().iterator();
			while (iterator.hasNext()) {
				Map.Entry<String, String> entry = (Map.Entry<String, String>) iterator.next();
				entity.addTextBody(entry.getKey(), entry.getValue());
			}
		}
		if (file != null) {
			entity.addPart(filekey, new FileBody(file, ContentType.APPLICATION_OCTET_STREAM));
		}
		org.apache.http.HttpEntity httpEntity = entity.build();
		post.setEntity(httpEntity);
		HttpResponse response = client.execute(post);

		if (response != null && response.getStatusLine().getStatusCode() == 200) {
			return EntityUtils.toString(response.getEntity());
		}
		throw new Exception("Https Response Failed :" + response.getStatusLine().getStatusCode());
	}
}
