package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.Map;

public class HttpUtil {

    public static final String CONTENT_TYPE_JSON_CHARSET_UTF8 = "application/json;charset=utf-8";
    public static final String CHARSET_UTF8 = "UTF-8";

    public static String JsonPostInvoke(String url, String jsonString)
            throws Exception {
//        System.out.println("post方式提交json数据开始......");
        // http客户端
        HttpClient httpClient = buildHttpClient(false);
        // post请求
        HttpPost method = new HttpPost(url);
        if (StringUtils.isNotBlank(jsonString)) {
            // 参数实体
            StringEntity entity = new StringEntity(jsonString, CHARSET_UTF8);//解决中文乱码问题
            entity.setContentEncoding(CHARSET_UTF8);
            entity.setContentType(CONTENT_TYPE_JSON_CHARSET_UTF8);
            method.setEntity(entity);
        }
        // 执行响应操作
        HttpResponse result = httpClient.execute(method);
        // 请求结束，返回结果
        String data = EntityUtils.toString(result.getEntity());
//        System.out.println(data);
//        System.out.println("post方式提交json数据结束......");
        method.releaseConnection();
        return data;
    }

    public static String sentFormPost(String url, JSONObject jsonObject) throws IOException {
        //绑定表单传递请求头
        String param = "";
        if (null !=jsonObject &&!jsonObject.isEmpty()){     //遍历JSONObject
            for (Map.Entry entry : jsonObject.entrySet()) {
                param = param+"&"+entry.getKey()+"="+entry.getValue();
            }
        }
        StringEntity httpEntity = new StringEntity(param, ContentType.create("application/x-www-form-urlencoded", "utf-8"));
        HttpPost post = new HttpPost(url);
        post.setEntity(httpEntity);
        post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");//设置通用请求头
        String result = executeRequest(post,null);
        return result;
    }

    public static String executeRequest(HttpRequestBase httpUriRequest, HttpContext context) {
        String result = "";
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(false);
        try {
            // 执行响应操作
            CloseableHttpResponse response = httpClient.execute(httpUriRequest, context);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                //返回结果
                result = EntityUtils.toString(entity, "UTF-8");
                entity.getContent().close();
            }
            response.close();
        } catch (ClientProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            httpUriRequest.releaseConnection();
        }
        return result;
    }


    public static String GetInvoke(String url) throws Exception {
        // http客户端
        HttpClient httpClient = buildHttpClient(false);
        // GET请求
        HttpGet method = new HttpGet(url);
        // 执行响应操作
        HttpResponse result = httpClient.execute(method);
        // 请求结束，返回结果
        String data = EntityUtils.toString(result.getEntity());
        method.releaseConnection();
        return data;
    }
    /**
     * 创建HttpClient
     *
     * @param isMultiThread
     * @return
     */
    public static CloseableHttpClient buildHttpClient(boolean isMultiThread) {
        CloseableHttpClient client;
        if (isMultiThread)
            client = HttpClientBuilder.create().setConnectionManager(new PoolingHttpClientConnectionManager()).build();
        else
            client = HttpClientBuilder.create().build();
        // 设置代理服务器地址和端口
        // client.getHostConfiguration().setProxy("proxy_host_addr",proxy_port);
        return client;
    }
}
