package com.geoway.landteam.landcloud.service.thirddata.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.locationtech.jts.geom.Geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author Waves
 * @Date 2023/9/9
 * @Description
 **/
public class JinAoGeoJsonUtil {

    public static Geometry rings2Geometry(String jaJson) throws Exception {
        String json = rings2geojson(jaJson);
        return GeoUtils.geojson2Geom(json);
    }
    public static String rings2geojson(String jaJson){
        Map geoMap = rings2geomap(jaJson);
        return new JSONObject(geoMap).toString();
    }
    public static Map rings2geomap(String jaJson){
        Map geoMap = new HashMap();
        try {
            List geoFs = new ArrayList();
            geoMap.put("type", "FeatureCollection");
            Map jaMap = (Map) JSON.parse(jaJson);
            Map geoF = new HashMap();
            geoF.put("type", "Feature");
            geoF.put("properties", new HashMap<>());
            geoF.put("geometry", geoPoly(jaMap));
            geoFs.add(geoF);
            geoMap.put("features", geoFs);
        }catch (Exception e){
            e.printStackTrace();
        }
        return geoMap;
    }

    public static Map geoPoly(Map<String, Object> geometry){
        Map geo = new HashMap();
        List<List<List<Number>>> rings = (List<List<List<Number>>>) geometry.get("rings");
        if(rings.size()==1){
            geo.put("type", "Polygon");
            geo.put("coordinates", rings);
        }else{
            List<List<List<List<Number>>>> coords = new ArrayList();
            String type = "";
            int len = coords.size() - 1;
            for(int i=0; i< rings.size(); i++){
                if(ringIsClockwise( rings.get(i))){
                    List<List<List<Number>>> item = new ArrayList<>();
                    item.add(rings.get(i));
                    coords.add(item);
                    len++;
                }else{
                    coords.get(len).add(rings.get(i));
                }
            }
            if(coords.size() == 1){
                type="Polygon";
            }else{
                type="MultiPolygon";
            }
            geo.put("type", type);
            geo.put("coordinates",coords.size()==1?coords.get(0): coords);
        }
        return geo;
    }
    public static boolean ringIsClockwise(List<List<Number>> rings){
        double total = 0.0d;
        List<Number> pt1 = null;
        List<Number> pt2 = null;
        for(int i=0; i< rings.size()-1; i++){
            pt1 = rings.get(i);
            pt2 = rings.get(i+1);
            total += (pt2.get(0).doubleValue() - pt1.get(0).doubleValue())*  (pt2.get(1).doubleValue() + pt1.get(1).doubleValue());
        }
        return total>=0;
    }
}
